/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.customactivity.activityrating;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.metadata.activity.model.CaseActivity;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ActivityRatingCallbackUtil {
    private static final String JAXB_CONTEXT = "oracle.bpm.casemgmt.metadata.activity.model";

    public static boolean registerActivity() {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)ActivityRatingCallbackUtil.class.getName(), (String)"registerActivity", (String)"Register  activity rating activity invoked");
        CaseActivity activityRatingActivity = null;
        try {
            IBPMContext ctx = InternalBPMContext.getInternalBPMContext();
            if (!ActivityRatingCallbackUtil.isActivityRegistered(ctx) && (activityRatingActivity = ActivityRatingCallbackUtil.getActivityRatingActivity()) != null) {
                ICaseService caseActivityService = ActivityRatingCallbackUtil.getCaseService();
                caseActivityService.registerCaseActivity(ctx, activityRatingActivity);
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)ActivityRatingCallbackUtil.class.getName(), (String)"registerActivity", (String)"Activity rating activity definition successfully registered..");
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static CaseActivity unmarshal(InputStream inputStream) throws JAXBException, IOException {
        try {
            DOMParser p = new DOMParser();
            p.retainCDATASection(true);
            p.parse(inputStream);
            XMLDocument doc = p.getDocument();
            JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_CONTEXT);
            return (CaseActivity)jaxbContext.createUnmarshaller().unmarshal((Node)doc);
        }
        catch (XMLParseException e) {
            throw new JAXBException((Throwable)e);
        }
        catch (SAXException e) {
            throw new JAXBException((Throwable)e);
        }
    }

    private static ICaseService getCaseService() {
        return BPMServiceClientFactory.getInstance((String)"REMOTE", null, null).getCaseManagementServiceClient().getCaseService();
    }

    private static boolean isActivityRegistered(IBPMContext ctx) throws CaseServiceException {
        ArrayList<String> values = new ArrayList<String>();
        values.add("http://xmlns.oracle.com/bpm/case/activity/ActivityRatingActivityDefinition");
        List activityDefnList = ActivityRatingCallbackUtil.getCaseService().listCaseActivityDefinition(ctx, ICaseMetadataService.SEARCH_TYPE_ENUM.ACTIVITY_DEFINITION_ID, values);
        if (activityDefnList != null && activityDefnList.size() == 1) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)ActivityRatingCallbackUtil.class.getName(), (String)"registerActivity", (String)"Activity Rating activity definition already registered..");
            return true;
        }
        return false;
    }

    private static CaseActivity getActivityRatingActivity() throws CaseServiceException {
        CaseActivity caseActivity = null;
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        InputStream is = classLoader.getResourceAsStream("oracle/bpm/casemgmt/customactivity/activityrating/ActivityRatingActivity.caseactivity");
        if (is == null) {
            return null;
        }
        try {
            caseActivity = ActivityRatingCallbackUtil.unmarshal(is);
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)ActivityRatingCallbackUtil.class.getName(), (String)"getActivityRatingActivity", (String)"Error in ActivityRatingActivity", (Throwable)e);
        }
        return caseActivity;
    }
}

