/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.customactivity.activityrating;

import java.util.Map;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.IInternalCaseService;
import oracle.bpm.casemgmt.caseactivity.ICaseActivityCallback;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ActivityRatingCallback
implements ICaseActivityCallback {
    public static final String activityName = "AddDiscount";

    public String initiate(IBPMContext context, CaseIdentifier caseIdentifier, String activityMetadataId, Map<String, Object> payload) {
        String caseId = null;
        try {
            caseId = this.getCaseId(caseIdentifier);
        }
        catch (Exception e1) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"initiate", (String)"Error in getting case id from case identifier", (Throwable)e1);
        }
        this.debugLog("initiate", "Activity Rating activity initiated for case:" + caseId);
        String activityInstanceId = CaseServiceUtil.getGUID();
        try {
            Element statusElement;
            String status;
            NodeList list2;
            String dataString;
            Document document;
            NodeList list;
            ICaseService service = ServicesLocator.getCaseService();
            CaseData caseData = service.getCaseDataByName(context, caseIdentifier, "customerStatus");
            if (caseData != null && (list = (document = XMLUtil.parseDocument((String)(dataString = caseData.getData()))).getElementsByTagName("customerStatus")) != null && list.getLength() > 0 && (list2 = document.getElementsByTagName("status")) != null && list2.getLength() > 0 && (status = (statusElement = (Element)list2.item(0)).getTextContent()) != null) {
                IInternalCaseService intSvc = ServicesLocator.getInternalCaseService();
                String caseActivityMetadataId = intSvc.getCaseActivityDefinitionId(caseId, activityName);
                if (status.equalsIgnoreCase("PLATINUM")) {
                    service.markActivityRelevance(context, caseIdentifier, caseActivityMetadataId, ICaseConstants.ActivityRelevance.HIGH);
                } else if (status.equalsIgnoreCase("GOLD")) {
                    service.markActivityRelevance(context, caseIdentifier, caseActivityMetadataId, ICaseConstants.ActivityRelevance.NORMAL);
                }
            }
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"initiate", (String)"Error in invoking activity rating case activity", (Throwable)e);
        }
        this.debugLog("initiate", "Returning activity rating activity instance id:" + activityInstanceId);
        return activityInstanceId;
    }

    private String getCaseId(CaseIdentifier caseIdentifier) throws BPMException, CaseServiceException {
        IBPMContext context = InternalBPMContext.getInternalBPMContext();
        Case caseInstance = ServicesLocator.getInternalCaseService().getCase(context, caseIdentifier, null);
        return caseInstance.getCaseId();
    }

    private void debugLog(String method, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)method, (String)message);
    }
}

