/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.client.forms.servlet;

import java.util.HashMap;
import java.util.Map;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpm.casemgmt.client.forms.model.CaseTaskFlows;
import oracle.bpm.casemgmt.client.forms.servlet.CaseFormServlet;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import weblogic.application.ApplicationException;
import weblogic.application.ApplicationLifecycleEvent;
import weblogic.application.ApplicationLifecycleListener;
import weblogic.application.DeploymentOperationType;

public class TFLifecycleListener
extends ApplicationLifecycleListener {
    public static final int DEPLOYED = -1;
    public static final int DEPLOY = 1;
    public static final int REDEPLOY = 2;
    public static final int UNSET = -2;
    static int phase = -2;
    static Map<String, String> warDeployedMap = new HashMap<String, String>();
    static Map<String, CaseTaskFlows> caseTaskFlowsMap = new HashMap<String, CaseTaskFlows>();
    static String rootContext = null;
    static String COMPONENT_NAME = "TFLifecycleListener";
    static String CLASS_NAME = "oracle.bpm.casemgmt.client.forms.servlet.TFLifecycleListener";

    public static void setCaseTaskFlows(CaseTaskFlows taskFlows, String contextPath) {
        caseTaskFlowsMap.put(contextPath, taskFlows);
    }

    public static void setContextPath(String context) {
        rootContext = context;
    }

    public void preStart(ApplicationLifecycleEvent p1) throws ApplicationException {
        super.preStart(p1);
        DeploymentOperationType operation = p1.getDeploymentOperation();
        this.debugLog("preStart", "deployment operation is " + operation);
        if (operation == null) {
            phase = -1;
            return;
        }
        if (operation.equals((Object)DeploymentOperationType.DEPLOY) || operation.equals((Object)DeploymentOperationType.ACTIVATE)) {
            phase = 1;
        } else if (operation.equals((Object)DeploymentOperationType.REDEPLOY)) {
            phase = 2;
        }
        this.debugLog("preStart", "Setting the deployment phase as " + phase);
    }

    public void postStop(ApplicationLifecycleEvent p1) throws ApplicationException {
        super.postStop(p1);
        if (p1 == null) {
            return;
        }
        DeploymentOperationType operation = p1.getDeploymentOperation();
        if (operation == null) {
            return;
        }
        if (operation.equals((Object)DeploymentOperationType.REMOVE)) {
            this.debugLog("postStop", "De-registering Task Form application on undeploy.");
            for (String rootContext : caseTaskFlowsMap.keySet()) {
                CaseTaskFlows caseTaskFlows = caseTaskFlowsMap.get(rootContext);
                this.debugLog("postStop", "Undeploying taskflow with context root: " + rootContext);
                try {
                    CaseFormServlet.unregister(caseTaskFlows, rootContext);
                }
                catch (WorkflowException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            caseTaskFlowsMap = new HashMap<String, CaseTaskFlows>();
        }
    }

    private void debugLog(String methodName, String message) {
        String msg = "ClassName:" + CLASS_NAME + "\n" + "MethodName:" + methodName + "\n" + "Message:\n" + message + "\n";
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)msg);
    }
}

