/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.client.forms.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.ServicesLogger;
import oracle.bpel.services.common.util.Jaxb20ContextFactory;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.client.worklist.util.TaskFlowPropsUtil;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.client.forms.model.CaseTaskFlowType;
import oracle.bpm.casemgmt.client.forms.model.CaseTaskFlows;
import oracle.bpm.casemgmt.client.forms.model.TaskFlowServerType;
import oracle.bpm.casemgmt.client.forms.servlet.CaseFormDeployerThread;
import oracle.bpm.casemgmt.client.forms.servlet.TFLifecycleListener;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.CaseServiceLocator;
import oracle.bpm.casemgmt.metadata.casedisplay.model.ObjectFactory;
import oracle.bpm.casemgmt.metadata.casedisplay.model.TCaseDisplayInfo;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.ServerPlatformSupportFactory;

public class CaseFormServlet
extends HttpServlet {
    private String contextPath = "";
    private boolean isDebugLog = false;
    private CaseTaskFlows mCaseTaskFlows = null;
    private StringBuffer message_buf = null;
    private ServletConfig mServletConfig = null;
    private static ICaseService caseService = null;
    private static final String CONTENT_TYPE = "text/html; charset=US-ASCII";
    private static final String CLASS_NAME = "oracle.bpm.casemgmt.client.forms.servlet.CaseFormServlet";
    private static final String CASE_TASK_FLOW_XML = "caseTaskflow.xml";
    private static final Properties _props = new Properties();
    private static final String COMPONENT_NAME = "CaseTaskFormServlet";
    private static Unmarshaller unMarshaller;
    private static Marshaller marshaller;

    public static void unregister(CaseTaskFlows caseTaskFlows, String contextPath) throws WorkflowException, Exception {
        try {
            if (TaskFlowPropsUtil.isWeblogicServer()) {
                String[] serverInfo = CaseFormServlet.getHttpServerInfo(caseTaskFlows);
                ServicesLogger.log((int)19, (String)COMPONENT_NAME, (int)ServicesLogger.SERVICESLOGGER_DEBUG, (String)CLASS_NAME, (String)"unregister", (String)("Removing casedisplay entry:\nContext path = " + contextPath + "\nHostname = " + serverInfo[0] + "\nHttp port = " + serverInfo[1] + "\nHttps port = " + serverInfo[2]));
                HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
                properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "REMOTE");
                BPMServiceClientFactory factory = BPMServiceClientFactory.getInstance(properties, null, null);
                IWorkflowServiceClient m_wfsvc = factory.getWorkflowServiceClient();
                ITaskQueryService queryService = m_wfsvc.getTaskQueryService();
                IBPMContext ctx = (IBPMContext)CaseFormServlet.getInternalWorkflowContext();
                if (ctx == null) {
                    throw new Exception("Could not get WorkflowContext.\nPlease task display entries for context path = " + contextPath + "using EM");
                }
                ICaseService caseMetadataService = CaseFormServlet.getCaseService();
                for (CaseTaskFlowType caseFlow : caseTaskFlows.getCaseTaskFlow()) {
                    String applicationName = caseTaskFlows.getApplicationName();
                    String compositeAppName = caseTaskFlows.getCompositeAppName();
                    String[] httpInfo = CaseFormServlet.getHttpServerInfo(caseTaskFlows);
                    String taskFlowID = caseFlow.getTaskFlowId();
                    String taskFlowFileName = caseFlow.getTaskFlowFileName();
                    String taskDetailJsp = caseFlow.getTaskDetailJsp();
                    String taskFlowFormName = caseFlow.getTaskFlowFormName();
                    String taskFlowURI = null;
                    String caseDefinitionNamespace = caseFlow.getCaseDefinitionNamespace();
                    String caseArtifactName = caseFlow.getCaseItemName();
                    String compositeVersion = caseFlow.getCompositeVersion();
                    String partitionName = caseTaskFlows.getPartitionName();
                    String activityDefId = caseFlow.getCaseDefinitionId();
                    ICaseMetadataService.FORM_TYPE formType = null;
                    formType = activityDefId != null ? ICaseMetadataService.FORM_TYPE.CASEACTIVITYFORM : ICaseMetadataService.FORM_TYPE.CASEDATAFORM;
                    taskFlowURI = taskDetailJsp != null && !taskDetailJsp.trim().equals("") ? contextPath + "/" + taskDetailJsp : contextPath + "/faces/adf.task-flow?_id=" + taskFlowID + "&_document=" + taskFlowFileName;
                    TCaseDisplayInfo caseDisplayInfo = new ObjectFactory().createTCaseDisplayInfo();
                    ArrayList infoList = new ArrayList(1);
                    caseDisplayInfo.setApplicationName(applicationName);
                    caseDisplayInfo.setUri(taskFlowURI);
                    caseDisplayInfo.setHostname(httpInfo[0]);
                    caseDisplayInfo.setHttpPort(httpInfo[1]);
                    caseDisplayInfo.setHttpsPort(httpInfo[2]);
                    caseDisplayInfo.setFormName(taskFlowFormName);
                    try {
                        caseMetadataService.unregisterCaseForm(ctx, caseDisplayInfo);
                    }
                    catch (CaseServiceException e) {
                        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.WARNING, (String)("Task Flow is not unregistered due to " + e.getMessage()));
                        e.printStackTrace();
                    }
                }
            } else {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.WARNING, (String)"Task Flow is not unregistered when undeployed on Websphere Platform.");
            }
        }
        catch (Exception exc) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)"Error while unregistering task flow ");
            exc.printStackTrace();
        }
    }

    public static boolean isWeblogicServer() {
        try {
            ServerPlatformSupport platform = ServerPlatformSupportFactory.getInstance();
            return platform.isWebLogic();
        }
        catch (Exception upe) {
            if (ServicesLogger.canLog((int)19, (int)ServicesLogger.SERVICESLOGGER_DEBUG)) {
                ServicesLogger.log((int)19, (String)"Worklist", (int)ServicesLogger.SERVICESLOGGER_DEBUG, (String)"oracle.bpel.services.workflow.client.worklist.util.TaskFlowPropsUtil", (String)"isWeblogicServer", (String)"JRF layer could not determine the platform, assuming weblogic.");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createCaseTaskflowFileFromZipFile(File zFile) throws Exception {
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        ZipFile zipFile = null;
        File caseTaskFlowXmlFile = null;
        try {
            String caseTaskflowFileName = CASE_TASK_FLOW_XML;
            File classesParentDir = zFile.getParentFile().getParentFile();
            caseTaskFlowXmlFile = new File(classesParentDir, caseTaskflowFileName);
            if (!caseTaskFlowXmlFile.exists()) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("createTaskFlowFileFromZipFile :Zar file name is " + zFile.getAbsolutePath()));
                zipFile = new ZipFile(zFile);
                ZipEntry zipEntry = zipFile.getEntry(caseTaskflowFileName);
                inputStream = zipFile.getInputStream(zipEntry);
                outputStream = new FileOutputStream(caseTaskFlowXmlFile);
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("createTaskFlowFileFromZipFile : creating file " + caseTaskFlowXmlFile.getAbsolutePath()));
                int nchars = 0;
                byte[] bytes = new byte[8192];
                while ((nchars = inputStream.read(bytes)) != -1) {
                    outputStream.write(bytes, 0, nchars);
                }
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exc) {}
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception exc) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exc) {}
        }
        return caseTaskFlowXmlFile;
    }

    public static ICaseService getCaseService() {
        if (caseService == null) {
            caseService = CaseServiceLocator.getCaseService();
        }
        return caseService;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.contextPath = config.getServletContext().getContextPath();
        boolean success = false;
        try {
            this.isDebugLog = CaseLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG);
            this.message_buf = new StringBuffer();
            this.debugLog("init", "the context path is " + this.contextPath);
            this.debugLog("init", "the lifecycle phase is " + TFLifecycleListener.phase);
            URL xmlFileURL = config.getServletContext().getResource("/WEB-INF/classes/caseTaskflow.xml");
            String taskflowFileStr = xmlFileURL.toString();
            if (TFLifecycleListener.phase == 1 || TFLifecycleListener.phase == 2 || TFLifecycleListener.phase == -2) {
                this.debugLog("init", "map value is " + TFLifecycleListener.warDeployedMap.get(taskflowFileStr));
                if (TFLifecycleListener.warDeployedMap.get(taskflowFileStr) == null || TFLifecycleListener.warDeployedMap.get(taskflowFileStr) == "false") {
                    this.registerTaskFlowWithCase(config);
                    success = true;
                    TFLifecycleListener.warDeployedMap.put(taskflowFileStr, "true");
                    this.debugLog("init", "map value after  is " + TFLifecycleListener.warDeployedMap.get(taskflowFileStr));
                    System.out.println(this.message_buf.toString());
                }
            }
        }
        catch (Exception exc) {
            throw new ServletException((Throwable)exc);
        }
        finally {
            if (!success && !this.isDebugLog) {
                System.out.println(this.message_buf.toString());
            }
        }
    }

    public void destroy() {
        if (CaseFormServlet.isWeblogicServer()) {
            if (this.mCaseTaskFlows == null) {
                try {
                    this.contextPath = super.getServletConfig().getServletContext().getContextPath();
                    URL xmlFileURL = super.getServletConfig().getServletContext().getResource("/WEB-INF/classes/caseTaskflow.xml");
                    if (xmlFileURL == null) {
                        this.debugLog("destroy", "couldnot locate case taskflow xml");
                    }
                    this.debugLog("destroy", "TaskFlow UnRegistration: caseTaskflow.xml         url is: " + xmlFileURL.toURI());
                    File caseTaskFlowXmlFile = null;
                    String xmlURLString = xmlFileURL.toString();
                    if (xmlURLString.startsWith("zip:")) {
                        if (xmlURLString.contains("!")) {
                            xmlURLString = xmlURLString.substring(0, xmlURLString.indexOf("!"));
                        }
                        File zFile = new File(xmlURLString.replaceAll("zip:", ""));
                        caseTaskFlowXmlFile = CaseFormServlet.createCaseTaskflowFileFromZipFile(zFile);
                    } else {
                        caseTaskFlowXmlFile = new File(TaskFlowPropsUtil.getURI((URL)xmlFileURL));
                    }
                    this.debugLog("destroy", "Case Form UnRegistration - Reading caseTaskFlow.xml");
                    this.mCaseTaskFlows = (CaseTaskFlows)unMarshaller.unmarshal(caseTaskFlowXmlFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            TFLifecycleListener.setCaseTaskFlows(this.mCaseTaskFlows, this.contextPath);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType(CONTENT_TYPE);
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>CaseFormServlet</title></head>");
        out.println("<body>");
        out.println("<p>The servlet has received a GET. This is the reply.</p>");
        out.println("</body></html>");
        out.close();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType(CONTENT_TYPE);
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>CaseFormServlet</title></head>");
        out.println("<body>");
        out.println("<p>The servlet has received a POST. This is the reply.</p>");
        out.println("</body></html>");
        out.close();
    }

    private static String[] getHttpServerInfo(CaseTaskFlows caseTaskFlows) throws Exception {
        String hostName = null;
        String httpPort = null;
        String httpsPort = null;
        TaskFlowServerType taskFlowServer = caseTaskFlows.getTaskFlowServer();
        if (taskFlowServer != null) {
            hostName = taskFlowServer.getHostName();
            httpPort = taskFlowServer.getHttpPort();
            httpsPort = taskFlowServer.getHttpsPort();
        }
        if (hostName == null || hostName.trim().equals("")) {
            String[] serverInfo = TaskFlowPropsUtil.getServerInfo((String)"http");
            hostName = serverInfo[0];
            httpPort = serverInfo[1];
            httpsPort = serverInfo[2];
        }
        if (hostName == null || hostName.trim().equals("localhost")) {
            if (ServicesLogger.canLog((int)19, (int)ServicesLogger.SERVICESLOGGER_DEBUG)) {
                ServicesLogger.log((int)19, (String)COMPONENT_NAME, (int)ServicesLogger.SERVICESLOGGER_DEBUG, (String)CLASS_NAME, (String)"", (String)"Could not determine the hostname portname, using the localhost as the server.");
            }
            InetAddress localHost = InetAddress.getLocalHost();
            hostName = localHost.getCanonicalHostName();
        }
        String[] httpInfo = new String[]{hostName, httpPort, httpsPort};
        if (ServicesLogger.canLog((int)19, (int)ServicesLogger.SERVICESLOGGER_DEBUG)) {
            ServicesLogger.log((int)19, (String)COMPONENT_NAME, (int)ServicesLogger.SERVICESLOGGER_DEBUG, (String)CLASS_NAME, (String)("Detected server hostname as = " + hostName), (String)(" httpPort as = " + httpPort + " https port as " + httpsPort));
        }
        return httpInfo;
    }

    private static IWorkflowContext getInternalWorkflowContext() throws WorkflowException {
        try {
            IWorkflowContext wfCtx = (IWorkflowContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    IWorkflowContext ctx = VerificationService.createInternalWorkflowContext();
                    return ctx;
                }
            });
            return wfCtx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof WorkflowException) {
                throw (WorkflowException)((Object)orgEx);
            }
            throw new WorkflowException((Throwable)pae);
        }
    }

    private void registerTaskFlowWithCase(ServletConfig config) throws ServletException {
        String methodName = "registerTaskFlowWithCase";
        this.debugLog(methodName, "****Using caseTaskflow.xml *****");
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            this.debugLog(methodName, "TaskFlow Registration: begin");
            boolean deployed = false;
            String noCaseTaskFlowErrorMsg = "Task Flow deployment did not complete successfully. 'CaseFormServlet' servlet requires a valid caseTaskflow.xml to complete task flow registration. File caseTaskflow.xml could not be located in the task flow application.";
            List propertyList = null;
            URL xmlFileURL = config.getServletContext().getResource("/WEB-INF/classes/caseTaskflow.xml");
            if (xmlFileURL == null) {
                this.debugLog(methodName, noCaseTaskFlowErrorMsg);
                throw new Exception(noCaseTaskFlowErrorMsg);
            }
            this.debugLog(methodName, "TaskFlow Registration: caseTaskflow.xml         url is: " + xmlFileURL.toURI());
            File caseTaskFlowXmlFile = null;
            String xmlURLString = xmlFileURL.toString();
            if (xmlURLString.startsWith("zip:")) {
                if (xmlURLString.contains("!")) {
                    xmlURLString = xmlURLString.substring(0, xmlURLString.indexOf("!"));
                }
                File zFile = new File(xmlURLString.replaceAll("zip:", ""));
                caseTaskFlowXmlFile = CaseFormServlet.createCaseTaskflowFileFromZipFile(zFile);
            } else {
                caseTaskFlowXmlFile = new File(TaskFlowPropsUtil.getURI((URL)xmlFileURL));
            }
            this.debugLog(methodName, "Case Form Registration - Reading caseTaskFlow.xml");
            this.mCaseTaskFlows = (CaseTaskFlows)unMarshaller.unmarshal(caseTaskFlowXmlFile);
            String applicationName = this.mCaseTaskFlows.getApplicationName();
            this.debugLog(methodName, "Case Form Registration: applicationName is " + applicationName);
            deployed = this.mCaseTaskFlows.isCaseTaskFlowDeploy();
            propertyList = this.mCaseTaskFlows.getProperty();
            this.debugLog(methodName, "Case Form Registration: deployed attribute value is " + deployed);
            if (!deployed) {
                String[] httpInfo = CaseFormServlet.getHttpServerInfo(this.mCaseTaskFlows);
                this.debugLog(methodName, "Case Form Registration: http info is ");
                StringBuffer httpInfoBuf = new StringBuffer();
                for (int i = 0; i < httpInfo.length; ++i) {
                    httpInfoBuf.append(httpInfo[i] + ", ");
                }
                this.debugLog(methodName, httpInfoBuf.toString());
                CaseFormDeployerThread object = new CaseFormDeployerThread(this.mCaseTaskFlows, httpInfo, this.contextPath, caseTaskFlowXmlFile, propertyList, this.message_buf);
                Thread thread = new Thread(object);
                thread.start();
            }
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exc) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exc) {}
            }
        }
        this.debugLog(methodName, "Case Form Registration: end");
    }

    private void debugLog(String methodName, String message) {
        String msg = "ClassName:oracle.bpm.casemgmt.client.forms.servlet.CaseFormServlet\nMethodName:" + methodName + "\n" + "Message:\n" + message + "\n";
        if (this.isDebugLog) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)msg);
        } else {
            this.message_buf.append(msg);
        }
    }

    static {
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = Jaxb20ContextFactory.getJAXBContext((String)"oracle.bpm.casemgmt.client.forms.model");
            unMarshaller = jaxbContext.createUnmarshaller();
            marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }
}

