/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.client.forms.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.ServicesLogger;
import oracle.bpel.services.common.util.Jaxb20ContextFactory;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.client.forms.model.CasePropertyType;
import oracle.bpm.casemgmt.client.forms.model.CaseTaskFlowType;
import oracle.bpm.casemgmt.client.forms.model.CaseTaskFlows;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.CaseServiceLocator;
import oracle.bpm.casemgmt.metadata.casedisplay.model.ObjectFactory;
import oracle.bpm.casemgmt.metadata.casedisplay.model.TCaseDisplayInfo;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseFormDeployerThread
implements Runnable {
    private boolean isDebugLog = false;
    private CaseTaskFlows mCaseTaskFlows = null;
    private String mContextPath = null;
    private StringBuffer message_buf = null;
    private String[] mHTTPInfo = null;
    private String mPartitionName = null;
    private List<CasePropertyType> mPropertyList = null;
    private File mTaskFlowXmlFile = null;
    private static final String CLASS_NAME = "oracle.bpm.casemgmt.client.forms.servlet.CaseFormDeployerThread";
    private static final String COMPONENT_NAME = "CaseFormTaskFlow";
    private static ICaseService caseService;
    private static Marshaller marshaller;

    public CaseFormDeployerThread(CaseTaskFlows caseTaskFlow, String[] httpInfo, String contextPath, File file, List<CasePropertyType> properties, StringBuffer msgBuf) {
        this.mCaseTaskFlows = caseTaskFlow;
        this.mHTTPInfo = httpInfo;
        this.mContextPath = contextPath;
        this.mTaskFlowXmlFile = file;
        this.mPropertyList = properties;
        this.message_buf = msgBuf;
        String partitionName = caseTaskFlow.getPartitionName();
        if (partitionName != null && !partitionName.trim().equals("")) {
            this.mPartitionName = partitionName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String methodName = "run";
        this.debugLog(methodName, "Case Form Registration: begin");
        try {
            this.debugLog(methodName, "Start of thread to deploy/register task flow");
            this.registerTaskFlowWithCase();
            this.debugLog(methodName, "End of thread to deploy/register task flow");
        }
        catch (Throwable exc) {
            this.errorLog(methodName, "Error registering case form taskflows:\n", exc);
        }
        finally {
            this.mCaseTaskFlows = null;
            this.mHTTPInfo = null;
            this.mContextPath = null;
            this.mTaskFlowXmlFile = null;
            this.mPropertyList = null;
        }
        this.debugLog(methodName, "Case Form Registration: end");
    }

    public ICaseService getCaseService() {
        if (caseService == null) {
            caseService = CaseServiceLocator.getCaseService();
        }
        return caseService;
    }

    protected void registerTaskFlowWithCase() throws Exception {
        String methodName = "registerTaskFlowWithCase";
        this.debugLog(methodName, "Case form Registration: begin");
        this.debugLog(methodName, "****Using caseTaskflow.xml *****");
        FileOutputStream outputStream = null;
        try {
            String applicationName = this.mCaseTaskFlows.getApplicationName();
            String lookupType = "REMOTE";
            String compositeAppName = this.mCaseTaskFlows.getCompositeAppName();
            if (compositeAppName != null && !compositeAppName.equals("")) {
                this.debugLog(methodName, "Case form Registration: compositeName is " + compositeAppName);
            }
            List taskflows = this.mCaseTaskFlows.getCaseTaskFlow();
            this.debugLog(methodName, "Case form Registration: " + taskflows.size() + " taskflow found");
            int taskflowsSize = taskflows.size();
            int numFailedDeployments = 0;
            block13: for (int i = 0; i < taskflowsSize; ++i) {
                CaseTaskFlowType caseTaskFlow = (CaseTaskFlowType)taskflows.get(i);
                String taskFlowID = caseTaskFlow.getTaskFlowId();
                String taskFlowFileName = caseTaskFlow.getTaskFlowFileName();
                String taskDetailJsp = caseTaskFlow.getTaskDetailJsp();
                String caseDefinitionId = caseTaskFlow.getCaseDefinitionId();
                String compositeVersion = caseTaskFlow.getCompositeVersion();
                String caseDefinitionNamespace = caseTaskFlow.getCaseDefinitionNamespace();
                String taskFlowFormName = caseTaskFlow.getTaskFlowFormName();
                String taskFlowURI = null;
                String caseArtifactName = caseTaskFlow.getCaseItemName();
                String partitionName = this.mCaseTaskFlows.getPartitionName();
                String activityDefId = caseTaskFlow.getCaseDefinitionId();
                ICaseMetadataService.FORM_TYPE formType = null;
                formType = activityDefId != null ? ICaseMetadataService.FORM_TYPE.CASEACTIVITYFORM : ICaseMetadataService.FORM_TYPE.CASEDATAFORM;
                taskFlowURI = taskDetailJsp != null && !taskDetailJsp.trim().equals("") ? this.mContextPath + "/" + taskDetailJsp : this.mContextPath + "/faces/adf.task-flow?_id=" + taskFlowID + "&_document=" + taskFlowFileName;
                this.debugLog(methodName, "Case form Registration: Taskflow found with:\n ****Application Name = " + applicationName + "******\n" + "****Case DN = " + caseDefinitionId + "******\n" + "****Composite version = " + compositeVersion + "******\n" + "****Case DN namespace = " + caseDefinitionNamespace + "******\n" + "****Task Flow File Name = " + taskFlowFileName + "******\n" + "****Task Flow URI = " + taskFlowURI + "******\n" + "****Host name = " + this.mHTTPInfo[0] + "******\n" + "****Task Flow Form Name = " + taskFlowFormName + "******\n");
                this.debugLog(methodName, "****Application Name = " + applicationName + "******" + "****Task DN = " + caseDefinitionId + "******" + "****Composite version = " + compositeVersion + "******" + "****Task DN namespace = " + caseDefinitionNamespace + "******" + "****Task Flow File Name = " + taskFlowFileName + "******" + "****Task Flow URI = " + taskFlowURI + "******" + "****Host name = " + this.mHTTPInfo[0] + "******" + "****Task Flow Form Name = " + taskFlowFormName + "******");
                ICaseService caseMetadataService = this.getCaseService();
                TCaseDisplayInfo caseDisplayInfo = new ObjectFactory().createTCaseDisplayInfo();
                ArrayList<TCaseDisplayInfo> infoList = new ArrayList<TCaseDisplayInfo>(1);
                caseDisplayInfo.setApplicationName(applicationName);
                caseDisplayInfo.setUri(taskFlowURI);
                caseDisplayInfo.setHostname(this.mHTTPInfo[0]);
                caseDisplayInfo.setHttpPort(this.mHTTPInfo[1]);
                caseDisplayInfo.setHttpsPort(this.mHTTPInfo[2]);
                caseDisplayInfo.setFormName(taskFlowFormName);
                infoList.add(caseDisplayInfo);
                IBPMContext ctx = (IBPMContext)this.getInternalWorkflowContext();
                boolean success = true;
                try {
                    caseMetadataService.registerCaseDisplayForm(ctx, caseDefinitionNamespace, caseArtifactName, compositeVersion, partitionName, infoList, formType);
                }
                catch (Exception e) {
                    success = false;
                }
                long waitMilliSeconds = 10000L;
                if (ctx != null) {
                    int j = 0;
                    int retry_limit = 12;
                    while (true & !success) {
                        try {
                            this.debugLog(methodName, "CaseTaskFlow Registration calling TaskFlowPropsUtil.setTaskDisplayInfo - iteration-" + j);
                            caseMetadataService.registerCaseDisplayForm(ctx, caseDefinitionNamespace, caseArtifactName, compositeVersion, partitionName, infoList, formType);
                            this.debugLog(methodName, "TaskFlow Registration: Taskflow registered successfully forlookuptype=" + compositeVersion + ", compositeAppName=" + compositeAppName + ", taskDefinitionName=" + caseDefinitionNamespace + ", formName =" + taskFlowFormName + ", partitionName=" + this.mPartitionName);
                            success = true;
                            continue block13;
                        }
                        catch (Exception exc) {
                            this.debugLog(methodName, "TaskFlow Registration: TaskFlowDeployerThread.registerTaskFlowWithTask - Error while setting task display, this can happen with app loading issue, trying to load for " + j);
                            ServicesLogger.log((int)19, (int)ServicesLogger.SERVICESLOGGER_WARNING, (String)("Error while setting task display, this can happen with app loading issue, trying to load for " + j));
                            if (j == retry_limit) {
                                this.debugLog(methodName, "TaskFlow Registration: Task Flow deployment did not complete successfully for taskflow id = " + taskFlowID);
                                ServicesLogger.log((int)19, (int)ServicesLogger.SERVICESLOGGER_WARNING, (String)("Task Flow deployment did not complete successfully for taskflow id = " + taskFlowID));
                                if (taskflowsSize > 1) {
                                    ++numFailedDeployments;
                                    continue block13;
                                }
                                throw exc;
                            }
                            ++j;
                            Thread.sleep(waitMilliSeconds);
                            waitMilliSeconds *= 2L;
                        }
                    }
                    continue;
                }
                this.debugLog(methodName, "TaskFlow Registration: TaskFlowDeployerThread.registerTaskFlowWithTask - Task Flow deployment did not complete successfully. Soa-admin credentials required to register the task flow was not found. Ensure that the soa admin credentials have been seeded in the server correctly.");
                ServicesLogger.log((int)19, (int)ServicesLogger.SERVICESLOGGER_WARNING, (String)"Task Flow deployment did not complete successfully. Soa-admin credentials required to register the task flow was not found. Ensure that the soa admin credentials have been seeded in the server correctly.");
                this.mCaseTaskFlows.setCaseTaskFlowDeploy(Boolean.valueOf(false));
                break;
            }
            if (taskflowsSize > 0 && numFailedDeployments < taskflowsSize) {
                if (numFailedDeployments > 0) {
                    this.debugLog(methodName, "Registration failed for " + numFailedDeployments + " taskflows. Register using EM or redeploy the application");
                }
                this.mCaseTaskFlows.setCaseTaskFlowDeploy(Boolean.valueOf(true));
            } else if (taskflowsSize > 0) {
                this.debugLog(methodName, "TaskFlow Registration: All taskflow registration failed. Register using EM or restart application/server to reattempt registration.");
                this.mCaseTaskFlows.setCaseTaskFlowDeploy(Boolean.valueOf(false));
            }
            Marshaller m = marshaller;
            m.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
            outputStream = new FileOutputStream(this.mTaskFlowXmlFile);
            m.marshal((Object)this.mCaseTaskFlows, (OutputStream)outputStream);
            outputStream.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exc) {}
            }
        }
        this.debugLog(methodName, "TaskFlow Registration: TaskFlowDeployerThread.registerTaskFlowWithTask - end");
    }

    private IWorkflowContext getInternalWorkflowContext() throws WorkflowException {
        try {
            IWorkflowContext wfCtx = (IWorkflowContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    IWorkflowContext ctx = VerificationService.createInternalWorkflowContext();
                    return ctx;
                }
            });
            return wfCtx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof WorkflowException) {
                throw (WorkflowException)((Object)orgEx);
            }
            throw new WorkflowException((Throwable)pae);
        }
    }

    private void errorLog(String methodName, String message, Throwable t) {
        String msg = "ClassName:oracle.bpm.casemgmt.client.forms.servlet.CaseFormDeployerThread\nMethodName:" + methodName + "\n" + "Message:\n" + message + "\n";
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)methodName, (String)msg, (Throwable)t);
    }

    private void debugLog(String methodName, String message) {
        String msg = "ClassName:oracle.bpm.casemgmt.client.forms.servlet.CaseFormDeployerThread\nMethodName:" + methodName + "\n" + "Message:\n" + message + "\n";
        if (this.isDebugLog) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)msg);
        } else {
            this.message_buf.append(msg);
        }
    }

    static {
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = Jaxb20ContextFactory.getJAXBContext((String)"oracle.bpm.casemgmt.client.forms.model");
            marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }
}

