/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.caserule;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.caserule.CaseActionClassFilter;
import oracle.bpm.casemgmt.caserule.CaseBaseDictionaryFinder;
import oracle.bpm.casemgmt.caserule.CaseMgmtDictionaryHandler;
import oracle.bpm.casemgmt.caserule.IECARuleProcessor;
import oracle.bpm.casemgmt.caserule.model.CaseRule;
import oracle.bpm.casemgmt.common.exception.CaseExceptionUtil;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.casemgmt.persistence.model.CaseHeader;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.casemgmt.util.XMLUtil;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.classloader.util.ClassLoaderUtilities;
import oracle.fabric.composite.model.ComponentModel;
import oracle.rules.rl.ObjectFilter;
import oracle.rules.rl.RuleSession;
import oracle.rules.rl.extensions.pool.PoolableObject;
import oracle.rules.rl.extensions.pool.RuleSessionPool;
import oracle.rules.sdk2.decisionpoint.DecisionPointDictionaryFinder;
import oracle.rules.sdk2.dictionary.DictionaryFinder;
import oracle.rules.sdk2.dictionary.RuleDictionary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ECARuleProcessor
implements IECARuleProcessor {
    private Map<String, RuleSessionPool> ruleSessionPoolCache = new HashMap<String, RuleSessionPool>();
    private static final String CLASS_NAME = "ECARuleProcessor";
    private static final String HTTP_STR = "http://";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List invokeRule(IBPMContext ctx, CaseEvent caseEvent) throws CaseServiceException {
        List list;
        String METHODNAME = "invokeRule";
        this.debugLog("invokeRule", "Rule being invoked for case ID = " + caseEvent.getCaseId());
        try {
            this.debugLog("invokeRule", "Case Event Details :" + caseEvent.toString());
        }
        catch (Exception ex) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"invokeRule", (String)"CaseEvent.toString() throw this exception", (Throwable)ex);
        }
        Case cas = this.getCase(ctx, caseEvent);
        try {
            this.debugLog("invokeRule", "Case Details :" + cas.toString());
        }
        catch (Exception ex) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"invokeRule", (String)"Case.toString() throw this exception", (Throwable)ex);
        }
        CaseHeader caseheader = cas.getCaseHeader();
        String namespace = caseheader.getCaseNamespace();
        String caseName = caseheader.getApplicationName();
        this.debugLog("invokeRule", "Rule being invoked for case namespace = " + namespace);
        CaseRule caseRule = null;
        InputStream is = null;
        RuleDictionary dictionary = null;
        ArrayList warnings = new ArrayList();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ArrayList arrayList = new ArrayList();
        InputStreamReader reader = null;
        List<CaseData> caseDataList = this.getCaseData(ctx, caseEvent);
        try {
            caseRule = ServicesLocator.getCaseRulePersistance().findActiveCaseDictionary(namespace, null);
            is = new ByteArrayInputStream(caseRule.getDictionary());
            reader = new InputStreamReader(is, "UTF-8");
            dictionary = RuleDictionary.readDictionary((Reader)reader, (DictionaryFinder)new CaseBaseDictionaryFinder((DictionaryFinder)new DecisionPointDictionaryFinder(), null));
            dictionary.update(warnings);
            ComponentModel compModel = ServicesLocator.getCaseSE().getCaseComponentModel(caseheader.getCaseDefinitionId());
            ClassLoader parentCl = compModel.getComposite().getCompositeClassloader().getDelegateLoader().getParent();
            String version = caseRule.getVersion().toString();
            this.debugLog("invokeRule", "Rule version = " + version);
            File[] jaxbClassPath = new File[]{new CaseMgmtDictionaryHandler(compModel).getJAXBClassesLocation()};
            this.debugLog("invokeRule", "jaxb class path for executing rule " + jaxbClassPath[0].getAbsolutePath());
            this.setClassLoaderForAssert(this.removeProtocol(namespace), version, parentCl, jaxbClassPath);
            Map<String, String> namespaceToPackage = ServicesLocator.getCaseRuleMDSUtil().getPackageNameForNamespace(compModel, dictionary);
            this.debugLog("invokeRule", "Namespace to Package for caseId " + caseEvent.getCaseId() + " is " + namespaceToPackage);
            List<Object> assertList = this.unmarshalCaseData(namespaceToPackage, caseDataList);
            assertList.add(cas);
            assertList.add(caseEvent);
            list = this.executeRule(dictionary, assertList, namespace);
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        catch (Exception e) {
            try {
                CaseServiceException cse = new CaseServiceException(73610, new Object[]{caseName}, (Throwable)e);
                new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(ctx, null));
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"invokeRule", (Throwable)cse);
                throw cse;
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (reader == null) throw throwable;
                    reader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    CaseServiceException cse = new CaseServiceException(73610, new Object[]{caseName}, (Throwable)e2);
                    new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(ctx, null));
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"invokeRule", (Throwable)cse);
                    throw cse;
                }
            }
        }
        try {
            if (is != null) {
                is.close();
            }
            if (reader == null) return list;
            reader.close();
            return list;
        }
        catch (IOException e) {
            CaseServiceException cse = new CaseServiceException(73610, new Object[]{caseName}, (Throwable)e);
            new CaseExceptionUtil().localizeException((Throwable)cse, CaseServiceUtil.getLocale(ctx, null));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"invokeRule", (Throwable)cse);
            throw cse;
        }
    }

    @Override
    public void invalidateClassloader(IBPMContext ctx, String caseNamespace, String version) throws CaseServiceException {
        boolean flag = false;
        caseNamespace = this.removeProtocol(caseNamespace);
        this.debugLog("invalidateClassloader", "Invalidating classloader for case namespace = " + caseNamespace + " & Rule version = " + version);
        ClassLoader cl = ClassLoaderUtilities.findClassLoader((String)caseNamespace, (String)version, (String)version);
        if (cl != null) {
            flag = ClassLoaderUtilities.close((ClassLoader)cl);
            this.debugLog("invalidateClassloader", "Classloader invalidated " + flag);
            if (!flag) {
                // empty if block
            }
        }
    }

    @Override
    public void invalidateRuleSessionPool(IBPMContext ctx, String caseNamespace) throws CaseServiceException {
        if (this.ruleSessionPoolCache.containsKey(caseNamespace)) {
            this.ruleSessionPoolCache.remove(caseNamespace);
            this.debugLog("invalidateRuleSessionPool", "RuleSessionPool Cache invalidated for case namespace = " + caseNamespace);
        }
    }

    private List<Object> unmarshalCaseData(Map<String, String> namespaceToPackage, List<CaseData> caseDataList) {
        Document doc = null;
        Element element = null;
        JAXBContext jaxbCtx = null;
        Node node = null;
        ArrayList<Object> objects = new ArrayList<Object>();
        Object obj = null;
        for (CaseData caseData : caseDataList) {
            String xml = caseData.getData();
            this.debugLog("unmarshalCaseData", "Case Data xml " + xml);
            doc = XMLUtil.parse((String)xml, null, (boolean)true);
            element = doc.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int n = 0; n < nodeList.getLength(); ++n) {
                node = nodeList.item(n);
                if (node.getNamespaceURI() == null || node.getNamespaceURI().isEmpty()) continue;
                String packageName = namespaceToPackage.get(node.getNamespaceURI());
                this.debugLog("unmarshalCaseData", "Unmarshling case data for namespace " + node.getNamespaceURI() + " package is " + packageName);
                try {
                    jaxbCtx = JAXBContext.newInstance((String)packageName);
                    obj = jaxbCtx.createUnmarshaller().unmarshal(node);
                }
                catch (Exception e) {
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"unmarshalCaseData", (Throwable)e);
                    continue;
                }
                if (obj instanceof JAXBElement) {
                    obj = ((JAXBElement)obj).getValue();
                }
                objects.add(obj);
            }
        }
        return objects;
    }

    private void setClassLoaderForAssert(String namespace, String version, ClassLoader parentCl, File[] jaxbClassPath) {
        ClassLoader cl = ClassLoaderUtilities.findClassLoader((String)namespace, (String)version, (String)version);
        if (cl == null) {
            cl = ClassLoaderUtilities.createClassLoader((String)namespace, (String)version, (ClassLoader)parentCl, (File[])jaxbClassPath, (File[])new File[0]);
        }
        Thread.currentThread().setContextClassLoader(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List executeRule(RuleDictionary dictionary, List<Object> assertList, String namespace) throws Exception {
        RuleSessionPool sessionPool = this.ruleSessionPoolCache.get(namespace);
        if (sessionPool == null) {
            ECARuleProcessor eCARuleProcessor = this;
            synchronized (eCARuleProcessor) {
                sessionPool = this.ruleSessionPoolCache.get(namespace);
                if (sessionPool == null) {
                    sessionPool = this.createRuleSessionPool(this.generateRL(dictionary));
                    this.ruleSessionPoolCache.put(namespace, sessionPool);
                }
            }
        }
        PoolableObject po = sessionPool.getPoolableRuleSession();
        RuleSession session = (RuleSession)po.getPooledObject();
        for (int i = 0; i < assertList.size(); ++i) {
            session.callFunctionWithArgument("assertTree", assertList.get(i));
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.DEBUG, (String)("ECARuleProcessor data being asserted = " + assertList.get(i)));
        }
        List ruleSetList = dictionary.getRuleSetAliases(false);
        String[] rsStack = new String[ruleSetList.size()];
        ruleSetList.toArray(rsStack);
        session.callFunctionWithArgument("setRulesetStack", (Object)rsStack);
        session.callFunctionWithArgument("run", null);
        Iterator iter = session.getFactObjects((ObjectFilter)new CaseActionClassFilter());
        ArrayList actionList = new ArrayList();
        while (iter.hasNext()) {
            actionList.add(iter.next());
        }
        sessionPool.returnPoolableRuleSession(po);
        this.debugLog("executeRule", "Action List after executing rules = " + actionList + "For the CaseEvent = " + assertList.get(assertList.size() - 1));
        return actionList;
    }

    private RuleSessionPool createRuleSessionPool(List<String> rl) throws Exception {
        HashMap<String, Comparable<Boolean>> cfgMap = new HashMap<String, Comparable<Boolean>>();
        cfgMap.put("oracle.rules.rl.configLogging", Boolean.valueOf(true));
        cfgMap.put("oracle.rules.rl.trace.level", Integer.valueOf(2));
        RuleSessionPool ruleSessionPool = null;
        ruleSessionPool = new RuleSessionPool(rl, cfgMap);
        return ruleSessionPool;
    }

    private List<String> generateRL(RuleDictionary dict) throws Exception {
        ArrayList<String> rlList = new ArrayList<String>();
        rlList.add(dict.dataModelRL());
        for (String rsalias : dict.getRuleSetAliases(true)) {
            rlList.add(dict.ruleSetRL(rsalias));
        }
        return rlList;
    }

    private void debugLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.DEBUG, (String)("[ECARuleProcessor:" + methodName + "] " + message));
    }

    private Case getCase(IBPMContext ctx, CaseEvent caseEvent) throws CaseServiceException {
        CaseIdentifier caseIdentifier = new CaseIdentifier(caseEvent.getCaseId(), null, null);
        ArrayList<ICaseConstants.CaseInfo> additionalCaseInfo = new ArrayList<ICaseConstants.CaseInfo>();
        additionalCaseInfo.add(ICaseConstants.CaseInfo.DATA);
        return ServicesLocator.getCaseInstanceService().getCase(ctx, caseIdentifier, additionalCaseInfo);
    }

    private List<CaseData> getCaseData(IBPMContext ctx, CaseEvent caseEvent) throws CaseServiceException {
        CaseIdentifier caseIdentifier = new CaseIdentifier(caseEvent.getCaseId(), null, null);
        return ServicesLocator.getCaseInstanceService().getCaseData(ctx, caseIdentifier);
    }

    private String removeProtocol(String namespace) {
        if (namespace != null && !namespace.isEmpty()) {
            return namespace.substring(HTTP_STR.length());
        }
        return null;
    }
}

