/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.caserule;

import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.parser.XSOMParser;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpel.services.rules.fabric.MdsCompositeQuery;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.caserule.ICaseRuleMDSUtil;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.fabric.CaseManagementServiceEngine;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseData;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TData;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.fabric.common.MetadataManager;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.CompositeModel;
import oracle.integration.platform.common.MDSUtil;
import oracle.rules.sdk2.datamodel.CombinedDataModel;
import oracle.rules.sdk2.datamodel.JaxbFactType;
import oracle.rules.sdk2.dictionary.RuleDictionary;

public class CaseRuleMDSUtil
implements ICaseRuleMDSUtil {
    private static final String GET_ALL = "%";
    private static final String CLASS_NAME = "oracle.bpm.casemgmt.caserule.CaseRuleMDSUtil";

    @Override
    public List<URI> listSchemaLocationFromMDS(ComponentModel componentModel) throws CaseServiceException {
        CaseMetadata caseMetaData = CaseManagementServiceEngine.getInstance().getCaseMetadata(componentModel);
        TCaseMetadata caseMD = (TCaseMetadata)caseMetaData.getValue();
        List caseDataList = caseMD.getCaseData();
        List dataList = null;
        List<URI> xsdURIList = this.queryMDS(componentModel.getComposite(), "xsd", GET_ALL);
        ArrayList<URI> caseXsdURIList = new ArrayList<URI>();
        String schemaName = "";
        if (xsdURIList != null && !xsdURIList.isEmpty()) {
            for (TCaseData data : caseDataList) {
                dataList = data.getData();
                for (TData cData : dataList) {
                    schemaName = cData.getSchema();
                    if (schemaName == null || schemaName.trim().length() <= 0) continue;
                    caseXsdURIList.add(this.getCaseDataSchema(xsdURIList, schemaName));
                }
            }
        }
        return caseXsdURIList;
    }

    @Override
    public URL getRootSchemaPath(CompositeModel compositeModel) throws Exception {
        URL xsdBaseUrl = null;
        MetadataManager metaDataManager = compositeModel.getMetadataManager();
        try {
            xsdBaseUrl = new URI(metaDataManager.resolve("xsd/")).toURL();
        }
        catch (Exception e) {
            xsdBaseUrl = new URL("oramds:/" + MDSUtil.getMDSCompositeFolder((MetadataManager)metaDataManager, (String)compositeModel.getDN()) + "xsd/");
        }
        return xsdBaseUrl;
    }

    @Override
    public Map<String, String> getPackageNameForNamespace(ComponentModel compModel, RuleDictionary rd) throws CaseServiceException {
        String METHODNAME = "getPackageNameForNamespace";
        HashMap<String, String> nmToPackage = new HashMap<String, String>();
        List<URI> allXSDs = this.listSchemaLocationFromMDS(compModel);
        if (allXSDs != null && !allXSDs.isEmpty()) {
            for (URI uri : allXSDs) {
                String namespace = this.getSchemaNamespace(uri);
                String packageName = this.getPackageForNamespace(rd, namespace);
                this.debugLog("getPackageNameForNamespace", "Namespace for XSD " + uri.getPath() + " = " + namespace + " and package Name = " + packageName);
                if (nmToPackage.containsKey(namespace)) continue;
                nmToPackage.put(namespace, packageName);
            }
        }
        return nmToPackage;
    }

    @Override
    public List<URI> queryMDS(CompositeModel compModel, String folder, String pattern) throws CaseServiceException {
        MdsCompositeQuery mdsCompositeQuery = new MdsCompositeQuery(compModel);
        try {
            return mdsCompositeQuery.query(folder, pattern);
        }
        catch (Exception e) {
            this.logException(e, "queryMDS");
            throw new CaseServiceException(73606, new Object[]{"xsd"}, (Throwable)e);
        }
    }

    private URI getCaseDataSchema(List<URI> xsdList, String schemaName) {
        if (xsdList != null && !xsdList.isEmpty()) {
            for (URI uri : xsdList) {
                if (!uri.getPath().endsWith(schemaName)) continue;
                return uri;
            }
        }
        return null;
    }

    private String getSchemaNamespace(URI uri) throws CaseServiceException {
        String namespace;
        XSOMParser xsdParser = new XSOMParser();
        XSSchema schema = null;
        try {
            xsdParser.parse(uri.toURL());
            schema = xsdParser.getResult().getSchema(1);
            namespace = schema.getTargetNamespace();
        }
        catch (Exception e) {
            throw new CaseServiceException(73607, new Object[]{uri.getPath()}, (Throwable)e);
        }
        return namespace;
    }

    private String getPackageForNamespace(RuleDictionary rd, String namespace) {
        this.debugLog("getPackageForNamespace", "Namespace = " + namespace);
        if (namespace != null && !namespace.isEmpty()) {
            CombinedDataModel dm = rd.getDataModel().getCombinedDataModel();
            List factTypes = dm.getJaxbFactTypes();
            for (JaxbFactType factType : factTypes) {
                if (!namespace.equals(factType.getNamespace())) continue;
                return factType.getPackageName();
            }
        }
        return null;
    }

    private void debugLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)methodName, (String)message);
    }

    private void logException(Throwable t, String methodName) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.FATAL, (String)CLASS_NAME, (String)methodName, (Throwable)t);
    }
}

