/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.caserule;

import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.parser.XSOMParser;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.caserule.CaseBaseDictionaryFinder;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.CompositeModel;
import oracle.rules.sdk2.datamodel.CombinedDataModel;
import oracle.rules.sdk2.datamodel.DecisionFunction;
import oracle.rules.sdk2.datamodel.DecisionFunctionFact;
import oracle.rules.sdk2.datamodel.DecisionFunctionFactTable;
import oracle.rules.sdk2.datamodel.DecisionFunctionTable;
import oracle.rules.sdk2.datamodel.FactType;
import oracle.rules.sdk2.datamodel.JaxbFactType;
import oracle.rules.sdk2.datamodel.Node;
import oracle.rules.sdk2.datamodel.NodeTable;
import oracle.rules.sdk2.datamodel.SchemaBrowser;
import oracle.rules.sdk2.datamodel.impt.JaxbModel;
import oracle.rules.sdk2.decisionpoint.DecisionPointDictionaryFinder;
import oracle.rules.sdk2.decisionpoint.MetadataHelper;
import oracle.rules.sdk2.dictionary.DictionaryFinder;
import oracle.rules.sdk2.dictionary.DictionaryLink;
import oracle.rules.sdk2.dictionary.DictionaryObject;
import oracle.rules.sdk2.dictionary.RuleDictionary;
import oracle.rules.sdk2.exception.SDKException;
import oracle.rules.sdk2.exception.SDKWarning;

public class CaseMgmtDictionaryHandler {
    private String caseName;
    private ComponentModel componentModel;
    private CompositeModel compositeModel;
    private String homeLocation;
    private Map<String, List<String>> inputs = new HashMap<String, List<String>>();
    static final String RULE_FILE_SUFFIX = ".rules";
    static final String RULES_SUBDIRECTORY = File.separator + "oracle" + File.separator + "rules" + File.separator;
    static final String CLASS_NAME = "CaseDictionaryHandler";
    static final String DICTIONARY_PACKAGE = "";
    static final String RULES_BASE = "Base";
    static final String RULES_SUFFIX = "Rules";
    private static final String[] CASE_INPUTS = new String[]{"TCaseEvent", "TCase"};
    private static final String[] CASE_OUTPUTS = new String[]{"TCaseAction"};
    private static final List<String> COMMON_JAVA_FACT_TYPES = new ArrayList<String>();
    private static final String JAXB_GEN_CLASSES_PATH;
    private static final String JAXB_GEN_SRC_PATH;
    private static final String DEPLOYED_COMPOSITE_PATH;
    private static final String CASEMGMT = "casemgmt";

    public CaseMgmtDictionaryHandler(ComponentModel componentModel) {
        this.componentModel = componentModel;
        this.compositeModel = this.componentModel.getComposite();
        String compositeHomeDir = this.compositeModel.getHome();
        this.homeLocation = compositeHomeDir.substring(0, compositeHomeDir.lastIndexOf(DEPLOYED_COMPOSITE_PATH) + 3);
        this.caseName = componentModel.getName() + this.compositeModel.getApplicationName();
        this.debugLog(CLASS_NAME, "caseName = " + this.caseName + " homeLocation = " + this.homeLocation);
    }

    public RuleDictionary generateCaseRuleDictionary() throws CaseServiceException {
        String METHOD_NAME = "generateCaseRuleDictionary";
        RuleDictionary caseRd = null;
        try {
            File jaxbSrcDir = this.getJAXBSourceLocation();
            File jaxbClassDir = this.getJAXBClassesLocation();
            if (!jaxbSrcDir.exists()) {
                this.debugLog("generateCaseRuleDictionary", "jaxb src dir" + jaxbSrcDir.getAbsolutePath());
                jaxbSrcDir.mkdirs();
            }
            if (!jaxbClassDir.exists()) {
                this.debugLog("generateCaseRuleDictionary", "jaxb class dir " + jaxbClassDir.getAbsolutePath());
                jaxbClassDir.mkdirs();
            }
            URL xsdBaseUrl = ServicesLocator.getCaseRuleMDSUtil().getRootSchemaPath(this.compositeModel);
            this.debugLog("generateCaseRuleDictionary", "xsd base url got from MDS " + xsdBaseUrl.getFile());
            caseRd = MetadataHelper.createDictionary((String)(this.caseName + RULE_FILE_SUFFIX), (DictionaryFinder)new CaseBaseDictionaryFinder((DictionaryFinder)new DecisionPointDictionaryFinder(), null));
            caseRd.setName(this.caseName);
            caseRd.setAlias(this.caseName);
            caseRd.setPackage(DICTIONARY_PACKAGE);
            caseRd.createEmptyRuleSet(this.caseName + RULES_SUFFIX);
            DictionaryLink dictionaryLink = caseRd.createDictionaryLink("oracle.bpm.casemgmt.caserule", "CaseManagementBaseDictionary");
            dictionaryLink.setPrefixLinkedNames(false);
            this.addDictionaryArtifacts(caseRd, jaxbSrcDir.getAbsolutePath(), jaxbClassDir.getAbsolutePath(), xsdBaseUrl.toURI());
            this.resolveConflictingAliases(caseRd);
            caseRd.update(new ArrayList());
        }
        catch (Exception e) {
            throw new CaseServiceException(73608, null, (Throwable)e);
        }
        this.logDictionaryWarnings("generateCaseRuleDictionary", caseRd.getWarnings(true));
        return caseRd;
    }

    public void updateDictionaryWithNewFacts(RuleDictionary caseRd) throws CaseServiceException {
        try {
            URL xsdBaseUrl = ServicesLocator.getCaseRuleMDSUtil().getRootSchemaPath(this.compositeModel);
            List<URI> allXSDs = ServicesLocator.getCaseRuleMDSUtil().listSchemaLocationFromMDS(this.componentModel);
            SchemaBrowser sb = new SchemaBrowser(caseRd, this.getJAXBSourceLocation().getAbsolutePath(), this.getJAXBClassesLocation().getAbsolutePath(), xsdBaseUrl.toURI());
            Map map = caseRd.getFTI().getSchemaPaths();
            allXSDs = this.getNewURIs(map, allXSDs);
            for (URI uri : allXSDs) {
                this.debugLog("updateDictionaryWithNewFacts", "URI that will be imported into the dictionary = " + uri);
                this.addJaxbTypeToDictionary(sb, uri, null);
            }
            this.resolveConflictingAliases(caseRd);
            caseRd.update(new ArrayList());
        }
        catch (Exception e) {
            throw new CaseServiceException(73609, null, (Throwable)e);
        }
        this.logDictionaryWarnings("updateDictionaryWithNewFacts", caseRd.getWarnings(true));
    }

    public File getJAXBSourceLocation() {
        return new File(this.homeLocation, CASEMGMT + File.separator + this.caseName + JAXB_GEN_SRC_PATH);
    }

    public File getJAXBClassesLocation() {
        return new File(this.homeLocation, CASEMGMT + File.separator + this.caseName + JAXB_GEN_CLASSES_PATH);
    }

    public String getCaseName() {
        return this.caseName;
    }

    protected List<URI> getAllXsd() throws Exception {
        return ServicesLocator.getCaseRuleMDSUtil().listSchemaLocationFromMDS(this.componentModel);
    }

    private List<URI> getNewURIs(Map<URI, JaxbModel> map, List<URI> xsdList) throws Exception {
        Set<URI> keys = map.keySet();
        ArrayList<URI> list = new ArrayList<URI>();
        Object temp = null;
        boolean isAlreadyImported = false;
        for (URI uri : xsdList) {
            for (URI key : keys) {
                String path = key.getPath();
                int index = path.lastIndexOf("/");
                if (index != -1) {
                    path = path.substring(index + 1, path.length());
                }
                if (!uri.getPath().endsWith(path)) continue;
                isAlreadyImported = true;
                break;
            }
            if (!isAlreadyImported) {
                list.add(uri);
            }
            isAlreadyImported = false;
        }
        return list;
    }

    private void addDictionaryArtifacts(RuleDictionary dictionary, String srcDir, String classDir, URI rootURI) throws Exception {
        MetadataHelper.importJavaFactTypes((RuleDictionary)dictionary, COMMON_JAVA_FACT_TYPES);
        this.generateJaxbTypes(dictionary, srcDir, classDir, rootURI);
    }

    private void createCaseRuleDecisionPoint(RuleDictionary rd, String rulesetName, List<String> decisionFunctionInputs) throws SDKException {
        String METHODNAME = "createCaseRuleDecisionPoint";
        DecisionFunction df = this.createDecisionFunction(rd, rulesetName);
        df.setCheckRuleFlow(false);
        df.getDecisionFunctionInputTable().clear();
        df.getDecisionFunctionOutputTable().clear();
        for (String factAlias : decisionFunctionInputs) {
            this.addDecisionFunctionInput(df, factAlias, true, true);
        }
        for (String factAlias : CASE_INPUTS) {
            this.addDecisionFunctionInput(df, factAlias, true, false);
        }
        for (String factAlias : CASE_OUTPUTS) {
            this.addDecisionFunctionOutput(df, factAlias, false, true);
        }
        this.setCaseActionRuleset(rd, rulesetName);
    }

    private DecisionFunction createDecisionFunction(RuleDictionary rd, String name) {
        System.out.println("createDecisionFunction: name = " + name);
        DecisionFunctionTable dft = rd.getDataModel().getDecisionFunctionTable();
        DecisionFunction df = (DecisionFunction)dft.getByName(name);
        if (df == null) {
            df = (DecisionFunction)dft.add();
            df.setName(name);
            df.setAlias(name);
        }
        return df;
    }

    private void generateJaxbTypes(RuleDictionary rd, String srcDir, String classDir, URI rootURI) throws Exception {
        String METHODNAME = "generateJaxbTypes";
        SchemaBrowser sb = new SchemaBrowser(rd, srcDir, classDir, rootURI);
        List<URI> allXSDs = this.getAllXsd();
        this.debugLog("generateJaxbTypes", "Xsds from xsd/ folder = " + allXSDs);
        for (URI uri : allXSDs) {
            this.addJaxbTypeToDictionary(sb, uri, null);
        }
    }

    private void generateInputsForDecisionFunction() throws Exception {
        String METHODNAME = "generateInputsForDecisionFunction";
        List<URI> allXSDs = this.getAllXsd();
        if (allXSDs != null && !allXSDs.isEmpty()) {
            for (URI uri : allXSDs) {
                this.generateDecisionFunctionInput(uri);
            }
            this.debugLog("generateInputsForDecisionFunction", "Inputs size = " + this.inputs.size() + "Generated decision function inputs = " + this.inputs);
        }
    }

    private void generateDecisionFunctionInput(URI uri) throws Exception {
        XSElementDecl elemDec = null;
        List<String> typeNames = null;
        XSOMParser xsdParser = new XSOMParser();
        xsdParser.parse(uri.toURL());
        XSSchema schema = xsdParser.getResult().getSchema(1);
        Map elements = schema.getElementDecls();
        if (elements != null && !elements.isEmpty()) {
            Set element = elements.keySet();
            for (String elem : element) {
                elemDec = (XSElementDecl)elements.get(elem);
                typeNames = this.inputs.get(elemDec.getTargetNamespace());
                if (typeNames == null) {
                    typeNames = new ArrayList<String>();
                    typeNames.add(elemDec.getType().getName());
                    this.inputs.put(elemDec.getTargetNamespace(), typeNames);
                    continue;
                }
                typeNames.add(elemDec.getTargetNamespace());
            }
        }
    }

    private List<String> getCaseInputs(RuleDictionary rd) throws SDKException {
        ArrayList<String> caseInputs = new ArrayList<String>();
        if (this.inputs != null && !this.inputs.isEmpty()) {
            Set<String> namespace = this.inputs.keySet();
            CombinedDataModel dm = rd.getDataModel().getCombinedDataModel();
            List factTypes = dm.getJaxbFactTypes();
            for (String namSpace : namespace) {
                for (JaxbFactType factType : factTypes) {
                    if (!namSpace.equals(factType.getNamespace()) || !this.inputs.get(namSpace).contains(factType.getNodeName())) continue;
                    caseInputs.add(factType.getAlias());
                }
            }
        }
        this.debugLog("getCaseInputs", "Inputs being added to Decision function size = " + caseInputs.size() + " " + caseInputs);
        return caseInputs;
    }

    private void addDecisionFunctionInput(DecisionFunction df, String factAlias, boolean isTree, boolean isList) throws SDKException {
        this.addDecisionFunctionFact(df.getDecisionFunctionInputTable(), factAlias, isTree, isList);
    }

    private void addDecisionFunctionOutput(DecisionFunction df, String factAlias, boolean isTree, boolean isList) throws SDKException {
        this.addDecisionFunctionFact(df.getDecisionFunctionOutputTable(), factAlias, isTree, isList);
    }

    private void addDecisionFunctionFact(DecisionFunctionFactTable dfft, String factAlias, boolean isTree, boolean isList) throws SDKException {
        System.out.println("factAlias " + factAlias);
        FactType ft = dfft.getCombinedDataModel().getFactTypeByAlias(factAlias);
        if (ft == null) {
            throw new SDKException("05157", (DictionaryObject)dfft.getDictionary());
        }
        DecisionFunctionFact dff = (DecisionFunctionFact)dfft.add();
        String dffAlias = factAlias.replaceAll("\\.", "_");
        dff.setName(dffAlias);
        dff.setTypeID(ft.getID());
        dff.setTree(isTree);
        dff.setList(isList);
    }

    private void setCaseActionRuleset(RuleDictionary rd, String name) {
        this.addDecisionFunctionRuleset(this.createDecisionFunction(rd, name), name);
    }

    private void addDecisionFunctionRuleset(DecisionFunction df, String name) {
        MetadataHelper.ensureRuleSetIsDefined((RuleDictionary)df.getDictionary(), (String)name);
        MetadataHelper.addDecisionFunctionRuleSet((DecisionFunction)df, (String)name);
    }

    private void addJaxbTypeToDictionary(SchemaBrowser sb, URI schemaURI, String targetPackage) throws Exception {
        this.debugLog("addJaxbTypeToDictionary", "schemaURI: " + schemaURI + "\nschemaRootURI: " + sb.getSchemaPathRoot() + "\ntargetPackage: " + targetPackage + "\njaxbGenSrcPath: " + sb.getSourceOutputDir() + "\njaxbGenerationPath: " + sb.getClassOutputDir());
        sb.addSchemaPath(schemaURI, targetPackage);
        NodeTable nodes = sb.getNodeTable();
        for (int i = 0; i < nodes.size(); ++i) {
            ((Node)nodes.get(i)).load();
        }
    }

    private void resolveConflictingAliases(RuleDictionary rd) {
        CombinedDataModel dm = rd.getDataModel().getCombinedDataModel();
        List factTypes = dm.getJaxbFactTypes();
        HashMap<String, String> nameToAlias = new HashMap<String, String>();
        for (JaxbFactType factType : factTypes) {
            String factAlias;
            for (JaxbFactType factType2 : factTypes) {
                if (factType.getName().equals(factType2.getName())) continue;
                nameToAlias.put(factType2.getName(), factType2.getAlias());
            }
            int index = 1;
            String newAlias = factAlias = factType.getAlias();
            while (nameToAlias.containsValue(newAlias)) {
                newAlias = factAlias + ++index;
            }
            if (factAlias.equals(newAlias)) continue;
            factType.setAlias(newAlias);
        }
    }

    private long startTimer(String name) {
        System.out.println(name + ": starting");
        return Calendar.getInstance().getTimeInMillis();
    }

    private void stopTimer(String name, long startTime) {
        long elapsedTime = Calendar.getInstance().getTimeInMillis() - startTime;
        System.out.println(name + ": finished after: " + elapsedTime + "ms");
    }

    private void logDictionaryWarnings(String methodName, List<SDKWarning> warnings) {
        for (SDKWarning warn : warnings) {
            this.debugLog(methodName + " Dictionary warnings :", warn.toString());
        }
    }

    private void debugLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)methodName, (String)message);
    }

    static {
        COMMON_JAVA_FACT_TYPES.add(Boolean.class.getName());
        JAXB_GEN_CLASSES_PATH = File.separator + "jaxb-gen-classes";
        JAXB_GEN_SRC_PATH = File.separator + "jaxb-src";
        DEPLOYED_COMPOSITE_PATH = File.separator + "dc" + File.separator;
    }
}

