/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.caserule;

import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.parser.XSOMParser;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.rules.rpi.model.TDecisionServicePatternName;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseObjectsList;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.caserule.IECARuleProcessor;
import oracle.bpm.casemgmt.caserule.model.TCaseAction;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.fabric.CaseManagementServiceEngine;
import oracle.bpm.casemgmt.fabric.ICaseSEWrapper;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseData;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TData;
import oracle.bpm.casemgmt.metadata.event.model.TActivityEvent;
import oracle.bpm.casemgmt.metadata.event.model.TEventType;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.casemgmt.persistence.model.CaseHeader;
import oracle.bpm.casemgmt.persistence.model.CompletedCaseActivity;
import oracle.bpm.casemgmt.persistence.model.CompletedCaseActivityList;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.casemgmt.persistence.util.MOXyUtil;
import oracle.bpm.casemgmt.util.CaseUtil;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.fabric.common.MetadataManager;
import oracle.fabric.common.NormalizedMessage;
import oracle.fabric.common.NormalizedMessageImpl;
import oracle.fabric.composite.model.ComponentModel;
import oracle.xml.jaxb.JaxbNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CaseDecisionServiceHandler
implements IECARuleProcessor {
    static final String CASE_RULE_COMPONENT_SUFFIX = "Rules";
    static final String PAYLOAD_ELEMNAME = "payload";
    static final String CALLFNSTATELESS_INPUT = "parameterList";
    static final String CALLFNSTATELESS_OUTPUT = "resultList";
    static final String CLASS_NAME = "CaseDecisionServiceHandler";
    private static final String CASE_DS_NAMESPACE = "http://xmlns.oracle.com/bpm/case/caseDecision";
    private static final String FOLDER = "xsd";
    private static final String MESSAGE_TYPES = "MessageTypes.xsd";
    private static final String PARAMETER_LIST_TYPE = "parameterListType";
    private static final String CASE_ELEM_NAME = "case";
    private static final String CASE_EVENT_ELEM_NAME = "caseEvent";
    private static final String CASE_ACTION_ELEM_NAME = "tCaseAction";
    static JAXBContext jaxbCtx = null;
    private static final String RULE_PRIMITIVE_TYPE_NS = "http://xmlns.oracle.com/bpel/rules";
    private static final List<String> numberTypes = new ArrayList<String>();
    private static final List<String> simpleTypes;
    private static final List<String> dateTypes;
    private static MOXyUtil caseMoxyUtil;
    private static MOXyUtil caseEventMoxyUtil;
    static Map<String, List<XSElementDecl>> decisionInputSequenceCache;

    @Override
    public List invokeRule(IBPMContext ctx, CaseEvent caseEvent) throws CaseServiceException {
        String methodName = "invokeRule";
        String decisionPointName = null;
        Case _case = null;
        List<Object> caseActionList = new ArrayList();
        this.initMoxyUtil();
        try {
            _case = CaseDecisionServiceHandler.getCase(ctx, caseEvent);
            this.logStartOfMethod(methodName, "Case Id: " + caseEvent.getCaseId() + "\n" + "Event Type: " + caseEvent.getEventType() + "\n" + "Activity Name: " + caseEvent.getActivityName() + "\n" + "Activity Event: " + caseEvent.getActivityEvent() + "\n" + "Lifecycle Event: " + caseEvent.getLifecycleEvent() + "\n" + "Lifecycle State: " + caseEvent.getLifecycleState() + "\n" + "Milestone Event: " + caseEvent.getMilestoneEvent() + "\n" + "Milestone: " + caseEvent.getMilestone() + "\n");
            ICaseSEWrapper caseSEWrapper = ServicesLocator.getCaseSE();
            CaseDecisionServiceHandler.debugLog(methodName, "caseSEWrapper:" + caseSEWrapper);
            if (_case == null) {
                CaseDecisionServiceHandler.debugLog(methodName, "_case is null");
            } else {
                CaseDecisionServiceHandler.debugLog(methodName, "_case:" + _case);
            }
            CaseHeader caseHeader = _case.getCaseHeader();
            if (caseHeader == null) {
                CaseDecisionServiceHandler.debugLog(methodName, "caseHeader is null");
            } else {
                CaseDecisionServiceHandler.debugLog(methodName, "caseHeader:" + caseHeader);
            }
            ComponentModel compModel = caseSEWrapper.getCaseComponentModel(caseHeader.getCaseDefinitionId());
            CaseDecisionServiceHandler.debugLog(methodName, "Got componentModel " + compModel.toString() + " CaseEvent :" + caseEvent.toString());
            String serviceReferenceName = CaseDecisionServiceHandler.decisionPointServiceReference(compModel.getName(), decisionPointName);
            CaseDecisionServiceHandler.debugLog(methodName, "Got serviceReferenceName " + serviceReferenceName + " CaseEvent :" + caseEvent.toString());
            CompletedCaseActivityList completedActivityList = new CompletedCaseActivityList();
            completedActivityList.setCompletedCaseActivity(this.populateCompletedCaseActivityList(caseEvent.getCaseId(), ctx));
            _case.getCaseHeader().setCompletedCaseActivityList(completedActivityList);
            Element result = CaseDecisionServiceHandler.invokeDecisionService(caseEvent, _case, ctx, serviceReferenceName, CaseDecisionServiceHandler.createDecisionPointInputs(caseEvent, _case, ctx, serviceReferenceName, compModel));
            caseActionList = CaseDecisionServiceHandler.demarshalCaseAction(result);
            this.logEndOfMethod(methodName, "Case Id: " + caseEvent.getCaseId() + "\n" + "Event Type: " + caseEvent.getEventType() + "\n" + "Activity Name: " + caseEvent.getActivityName() + "\n" + "Activity Event: " + caseEvent.getActivityEvent() + "\n" + "Lifecycle Event: " + caseEvent.getLifecycleEvent() + "\n" + "Lifecycle State: " + caseEvent.getLifecycleState() + "\n" + "Milestone Event: " + caseEvent.getMilestoneEvent() + "\n" + "Milestone: " + caseEvent.getMilestone() + "\n" + caseActionList + "\n");
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.ERRORS, (String)e.getMessage());
            e.printStackTrace();
        }
        return caseActionList;
    }

    @Override
    public void invalidateClassloader(IBPMContext ctx, String caseNamespace, String version) throws CaseServiceException {
    }

    @Override
    public void invalidateRuleSessionPool(IBPMContext ctx, String caseNamespace) throws CaseServiceException {
    }

    private static Element invokeDecisionService(CaseEvent caseEvent, Case _case, IBPMContext ctx, String referenceName, Element input) throws CaseServiceException {
        String operationName = TDecisionServicePatternName.CALL_FUNCTION_STATELESS.value();
        CaseManagementServiceEngine caseEngine = CaseManagementServiceEngine.getInstance();
        NormalizedMessageImpl inputNM = new NormalizedMessageImpl();
        HashMap<String, Element> payload = new HashMap<String, Element>();
        Object doc = null;
        CaseDecisionServiceHandler.debugLog("invokeDecisionService", "Input Payload = " + XMLUtil.toString((Node)input));
        payload.put(PAYLOAD_ELEMNAME, input);
        inputNM.setPayload(payload);
        caseEngine.setNMProperties((NormalizedMessage)inputNM, caseEvent.getCaseId(), null, null);
        NormalizedMessage outputNM = caseEngine.requestComponent(_case.getCaseHeader().getCaseDefinitionId(), referenceName, operationName, (NormalizedMessage)inputNM);
        Element result = (Element)outputNM.getPayload().get(PAYLOAD_ELEMNAME);
        return result;
    }

    private static Element createDecisionPointInputs(CaseEvent caseEvent, Case _case, IBPMContext ctx, String serviceName, ComponentModel compModel) throws Exception {
        return CaseDecisionServiceHandler.createDecisionServiceInput(serviceName, CaseDecisionServiceHandler.createDecisionPointFactList(caseEvent, _case, ctx, serviceName, compModel));
    }

    private static Element createDecisionPointFactList(CaseEvent caseEvent, Case _case, IBPMContext ctx, String serviceName, ComponentModel compModel) throws Exception {
        String methodName = "createDecisionPointFactList";
        Document doc = CaseDecisionServiceHandler.newDocument();
        Element parmList = doc.createElementNS(CaseDecisionServiceHandler.getDSNamespace(serviceName), CALLFNSTATELESS_INPUT);
        CaseDecisionServiceHandler.debugLog(methodName, "Start of  createDecisionPointFactList CaseEvent :" + caseEvent.toString());
        String caseXml = caseMoxyUtil.marshal((Object)_case);
        CaseDecisionServiceHandler.debugLog("createDecisionPointFactList", "Case xml = " + caseXml);
        Element caseElement = XMLUtil.parseDocumentFromXMLString((String)caseXml).getDocumentElement();
        caseElement = (Element)doc.adoptNode(caseElement);
        parmList.appendChild(caseElement);
        String caseEventXml = caseEventMoxyUtil.marshal((Object)caseEvent);
        CaseDecisionServiceHandler.debugLog("createDecisionPointFactList", "CaseEvent xml = " + caseEventXml);
        Element caseEventElement = XMLUtil.parseDocumentFromXMLString((String)caseEventXml).getDocumentElement();
        caseEventElement = (Element)doc.adoptNode(caseEventElement);
        parmList.appendChild(caseEventElement);
        Element actionElem = doc.createElementNS("http://xmlns.oracle.com/bpm/case/action", CASE_ACTION_ELEM_NAME);
        parmList.appendChild(actionElem);
        List<CaseData> caseDataList = CaseDecisionServiceHandler.getCaseData(ctx, caseEvent);
        CaseDecisionServiceHandler.debugLog(methodName, "getCaseData completed CaseData:" + caseDataList + " CaseEvent:" + caseEvent.toString());
        List<TData> metaData = CaseDecisionServiceHandler.getMetaDataOfCaseData(ctx, _case.getCaseHeader().getCaseDefinitionId());
        CaseDecisionServiceHandler.debugLog(methodName, "getMetaDataOfCaseData completed getMetaDataOfCaseData:" + metaData + " CaseEvent:" + caseEvent.toString());
        CaseDecisionServiceHandler.addCaseData(serviceName, caseDataList, doc, parmList, compModel, metaData);
        return parmList;
    }

    private static Case getCase(IBPMContext ctx, CaseEvent caseEvent) throws CaseServiceException {
        CaseIdentifier caseIdentifier = new CaseIdentifier(caseEvent.getCaseId(), null, null);
        ArrayList<ICaseConstants.CaseInfo> additionalCaseInfo = new ArrayList<ICaseConstants.CaseInfo>();
        additionalCaseInfo.add(ICaseConstants.CaseInfo.ALL);
        return ServicesLocator.getCaseInstanceService().getCase(ctx, caseIdentifier, additionalCaseInfo);
    }

    private static List<CaseData> getCaseData(IBPMContext ctx, CaseEvent caseEvent) throws CaseServiceException {
        CaseIdentifier caseIdentifier = new CaseIdentifier(caseEvent.getCaseId(), null, null);
        return ServicesLocator.getCaseInstanceService().getCaseData(ctx, caseIdentifier);
    }

    private static List<TData> getMetaDataOfCaseData(IBPMContext ctx, String id) throws CaseServiceException {
        TCaseMetadata tcaseMetadata = null;
        ArrayList<TData> metaData = new ArrayList<TData>();
        List tcaseData = new ArrayList();
        CaseMetadata caseMetadata = ServicesLocator.getCaseMetadataService().getCaseMetadata(ctx, id);
        if (caseMetadata != null && (tcaseMetadata = (TCaseMetadata)caseMetadata.getValue()) != null && (tcaseData = tcaseMetadata.getCaseData()) != null && !tcaseData.isEmpty()) {
            for (TCaseData tc : tcaseData) {
                metaData.addAll(tc.getData());
            }
        }
        return metaData;
    }

    private static void addCaseData(String serviceName, List<CaseData> caseDataList, Document doc, Element paramList, ComponentModel compModel, List<TData> metaData) throws Exception {
        Document docTemp = null;
        Element element = null;
        Object node = null;
        String xml = null;
        String key = compModel.getVersion() + serviceName;
        MetadataManager metadataManager = compModel.getComposite().getMetadataManager();
        String token = null;
        ArrayList<String> processedList = new ArrayList<String>();
        try {
            token = metadataManager.initializeURLResolvers();
            List<URI> xsdTypeList = ServicesLocator.getCaseRuleMDSUtil().queryMDS(compModel.getComposite(), FOLDER, serviceName + MESSAGE_TYPES);
            List<XSElementDecl> seqList = CaseDecisionServiceHandler.getDecisionFunctionInputsInSequence(xsdTypeList.get(0));
            boolean gotNode = false;
            String name = null;
            String caseDataName = null;
            CaseData caseData = null;
            if (seqList != null && !seqList.isEmpty()) {
                for (XSElementDecl elem : seqList) {
                    name = elem.getName();
                    if (name.equals(CASE_ELEM_NAME) || name.equals(CASE_EVENT_ELEM_NAME) || name.equals(CASE_ACTION_ELEM_NAME)) continue;
                    for (int i = 0; i < caseDataList.size(); ++i) {
                        caseData = caseDataList.get(i);
                        xml = caseData.getData();
                        caseDataName = caseData.getObjectName();
                        CaseDecisionServiceHandler.debugLog("addCaseData", "Case Data XML = \n" + xml);
                        CaseDecisionServiceHandler.debugLog("addCaseData", "Case Data name = \n" + caseDataName);
                        docTemp = XMLUtil.parseDocumentFromXMLString((String)xml);
                        element = docTemp.getDocumentElement();
                        if (!processedList.contains(caseDataName) && (simpleTypes.contains(name) || numberTypes.contains(name)) && RULE_PRIMITIVE_TYPE_NS.equals(elem.getTargetNamespace())) {
                            element = CaseDecisionServiceHandler.transformSimpleCaseDataType(caseDataName, element, elem, doc, metaData);
                        }
                        CaseDecisionServiceHandler.debugLog("addCaseData", "After transforming element = \n" + XMLUtil.toString((Node)element));
                        if (name.equals(element.getLocalName()) && !processedList.contains(caseDataName)) {
                            if (CaseDecisionServiceHandler.isElementNumberTypeAndEmpty(element)) {
                                CaseDecisionServiceHandler.setDefaultValueForNumberType(element);
                            } else if (CaseDecisionServiceHandler.isElementDateTypeAndEmpty(element)) {
                                CaseDecisionServiceHandler.setDefaultValueForDateType(element);
                            } else if (CaseDecisionServiceHandler.isElementDurationTypeAndEmpty(element)) {
                                CaseDecisionServiceHandler.setDefaultValueForDurationType(element);
                            }
                            element = (Element)doc.adoptNode(element);
                            paramList.appendChild(element);
                            gotNode = true;
                            processedList.add(caseDataName);
                        }
                        if (gotNode) break;
                    }
                    if (!gotNode) {
                        Element tempElem = doc.createElementNS(elem.getTargetNamespace(), name);
                        if (CaseDecisionServiceHandler.isElementNumberTypeAndEmpty(tempElem)) {
                            CaseDecisionServiceHandler.setDefaultValueForNumberType(tempElem);
                        } else if (CaseDecisionServiceHandler.isElementDateTypeAndEmpty(tempElem)) {
                            CaseDecisionServiceHandler.setDefaultValueForDateType(tempElem);
                        } else if (CaseDecisionServiceHandler.isElementDurationTypeAndEmpty(tempElem)) {
                            CaseDecisionServiceHandler.setDefaultValueForDurationType(tempElem);
                        }
                        paramList.appendChild(tempElem);
                    }
                    gotNode = false;
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (token != null) {
                metadataManager.uninitializeURLResolvers(token);
            }
        }
    }

    private static Element transformSimpleCaseDataType(String caseDataName, Element caseData, XSElementDecl inputElem, Document doc, List<TData> metaData) {
        Element elem = null;
        if (caseData != null && metaData != null && !metaData.isEmpty()) {
            for (TData tData : metaData) {
                if (tData.getName() == null || !tData.getName().equals(caseDataName) || tData.getType() == null || !CaseDecisionServiceHandler.isSimpleType(tData.getType()) || !tData.getType().endsWith(inputElem.getType().getName())) continue;
                elem = doc.createElementNS(inputElem.getTargetNamespace(), inputElem.getName());
                elem.setTextContent(caseData.getTextContent());
            }
        }
        if (elem == null) {
            elem = caseData;
        }
        return elem;
    }

    private static boolean isSimpleType(String simpleType) {
        boolean isSimpleType = false;
        if (simpleType != null && (simpleType.endsWith("string") || simpleType.endsWith("int") || simpleType.endsWith("integer") || simpleType.endsWith("long") || simpleType.endsWith("boolean") || simpleType.endsWith("decimal") || simpleType.endsWith("double") || simpleType.endsWith("dateTime") || simpleType.endsWith("duration") || simpleType.endsWith("short"))) {
            isSimpleType = true;
        }
        return isSimpleType;
    }

    private static boolean isElementNumberTypeAndEmpty(Element element) {
        boolean isNumberTypeAndEmpty = false;
        String content = null;
        if (element != null && numberTypes.contains(element.getLocalName())) {
            content = element.getTextContent();
            isNumberTypeAndEmpty = content == null || content.trim().length() <= 0 || content.isEmpty();
        }
        return isNumberTypeAndEmpty;
    }

    private static void setDefaultValueForNumberType(Element element) {
        if (element != null) {
            element.setTextContent("0");
        }
    }

    private static boolean isElementDateTypeAndEmpty(Element element) {
        boolean isEmpty = false;
        String content = null;
        if (element != null && "dateTime".equals(element.getLocalName()) && RULE_PRIMITIVE_TYPE_NS.equals(element.getNamespaceURI())) {
            content = element.getTextContent();
            isEmpty = content == null || content.trim().length() <= 0 || content.isEmpty();
        }
        return isEmpty;
    }

    private static void setDefaultValueForDateType(Element element) throws Exception {
        XMLGregorianCalendar xmlCal;
        if (element != null && (xmlCal = CaseUtil.getXMLGregorianCalendar(Calendar.getInstance())) != null) {
            element.setTextContent(xmlCal.toXMLFormat());
        }
    }

    private static boolean isElementDurationTypeAndEmpty(Element element) {
        boolean isEmpty = false;
        String content = null;
        if (element != null && "duration".equals(element.getLocalName()) && RULE_PRIMITIVE_TYPE_NS.equals(element.getNamespaceURI())) {
            content = element.getTextContent();
            isEmpty = content == null || content.trim().length() <= 0 || content.isEmpty();
        }
        return isEmpty;
    }

    private static void setDefaultValueForDurationType(Element element) throws Exception {
        if (element != null) {
            element.setTextContent("P0D");
        }
    }

    private static List<XSElementDecl> getDecisionFunctionInputsInSequence(URI uri) throws Exception {
        XSTerm term;
        XSOMParser xsdParser = new XSOMParser();
        ArrayList<XSElementDecl> sequenceList = new ArrayList<XSElementDecl>();
        xsdParser.parse(uri.toURL());
        XSSchema schema = xsdParser.getResult().getSchema(1);
        XSComplexType xsComplexType = schema.getComplexType(PARAMETER_LIST_TYPE);
        XSContentType xsContentType = xsComplexType.getContentType();
        XSParticle particle = xsContentType.asParticle();
        if (particle != null && (term = particle.getTerm()).isModelGroup()) {
            XSParticle[] particles;
            XSModelGroup xsModelGroup = term.asModelGroup();
            for (XSParticle p : particles = xsModelGroup.getChildren()) {
                XSTerm pterm = p.getTerm();
                if (!pterm.isElementDecl()) continue;
                sequenceList.add(pterm.asElementDecl());
            }
        }
        return sequenceList;
    }

    private static Element createDecisionServiceInput(String serviceName, Element payload) throws ParserConfigurationException {
        Document doc = CaseDecisionServiceHandler.newDocument();
        String dsNamespace = CaseDecisionServiceHandler.getDSNamespace(serviceName);
        Element input = doc.createElementNS(dsNamespace, "callFunctionStateless");
        input.setAttributeNS(dsNamespace, "name", serviceName);
        input.appendChild(doc.importNode(payload, true));
        return input;
    }

    private static List<Object> demarshalCaseAction(Element element) throws Exception {
        List<Object> lists = new ArrayList();
        lists = CaseDecisionServiceHandler.unmarshallCaseAction(element, CASE_ACTION_ELEM_NAME);
        if (lists != null && !lists.isEmpty()) {
            TCaseAction caseAction = (TCaseAction)lists.get(0);
            lists = caseAction.getMilestoneOrCaseActivity();
            CaseDecisionServiceHandler.debugLog("demarshalCaseAction", "Case Action = " + lists);
        }
        return lists;
    }

    private static List<Object> unmarshallCaseAction(Element resultList, String elementName) throws Exception {
        ArrayList<Object> lists = new ArrayList<Object>();
        Object obj = null;
        Node node = null;
        NodeList nodeList = null;
        if (resultList != null && (nodeList = XMLUtil.getDescendantElementsByTag((Element)resultList, (String)elementName)) != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                node = nodeList.item(i);
                if (node.getNamespaceURI() == null || node.getNamespaceURI().isEmpty() || (obj = jaxbCtx.createUnmarshaller().unmarshal(node)) == null) continue;
                if (obj instanceof JAXBElement) {
                    obj = ((JAXBElement)obj).getValue();
                }
                lists.add(obj);
            }
        }
        return lists;
    }

    private static Element jaxbNodeToDOM(Document doc, JaxbNode node) {
        return (Element)doc.importNode((Node)node.getDOMNode(), true);
    }

    private static String decisionPointServiceReference(String componentName, String dpName) {
        String rulesComponentName = componentName + CASE_RULE_COMPONENT_SUFFIX;
        return rulesComponentName + "_" + rulesComponentName;
    }

    private static Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = XMLUtil.getDocumentBuilderFactory();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder().newDocument();
    }

    private static String getDSNamespace(String serviceName) {
        return "http://xmlns.oracle.com/bpm/case/caseDecision/" + serviceName;
    }

    private static void debugLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.DEBUG, (String)("[CaseDecisionServiceHandler:" + methodName + "] " + message));
    }

    private void logStartOfMethod(String methodName, String string) {
        String msg = "\n+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\nStart of " + methodName + "\n" + string + "\n" + "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" + "\n";
        CaseDecisionServiceHandler.debugLog(methodName, msg);
    }

    private void logEndOfMethod(String methodName, String string) {
        String msg = "\n+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\nEnd of " + methodName + "\n" + string + "\n" + "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" + "\n";
        CaseDecisionServiceHandler.debugLog(methodName, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMoxyUtil() {
        if (caseMoxyUtil == null || caseEventMoxyUtil == null) {
            CaseDecisionServiceHandler caseDecisionServiceHandler = this;
            synchronized (caseDecisionServiceHandler) {
                if (caseMoxyUtil == null) {
                    caseMoxyUtil = new MOXyUtil("moxy/caseinstance/eclipselink-oxm.xml", "oracle.bpm.casemgmt.persistence.model", Case.class);
                }
                if (caseEventMoxyUtil == null) {
                    caseEventMoxyUtil = new MOXyUtil("moxy/event/eclipselink-oxm.xml", "oracle.bpm.casemgmt.persistence.model", CaseEvent.class);
                }
            }
        }
    }

    private List<CompletedCaseActivity> populateCompletedCaseActivityList(String caseId, IBPMContext ctx) {
        ArrayList<CompletedCaseActivity> completedActivity = new ArrayList<CompletedCaseActivity>();
        try {
            String updatedBy = null;
            CaseObjectsList caseActivityList = ServicesLocator.getCaseEventService().queryCaseEvent(ctx, new CaseIdentifier(caseId, null, null), TEventType.ACTIVITY_EVENT, null, updatedBy, -1, -1, null);
            CompletedCaseActivityList completedActivityList = new CompletedCaseActivityList();
            for (CaseEvent caseActivity : caseActivityList.getCaseObjects()) {
                TActivityEvent activity_event = caseActivity.getActivityEvent();
                if (!activity_event.equals((Object)TActivityEvent.COMPLETED)) continue;
                CompletedCaseActivity completedCaseActivity = new CompletedCaseActivity();
                completedCaseActivity.setName(caseActivity.getActivityName());
                completedActivity.add(completedCaseActivity);
            }
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"populateCompletedCaseActivityList", (String)"Exception from queryCaseEvent ", (Throwable)e);
        }
        return completedActivity;
    }

    static {
        numberTypes.add("int");
        numberTypes.add("double");
        numberTypes.add("long");
        numberTypes.add("float");
        numberTypes.add("integer");
        numberTypes.add("decimal");
        simpleTypes = new ArrayList<String>();
        simpleTypes.add("string");
        simpleTypes.add("boolean");
        simpleTypes.add("byte");
        simpleTypes.add("dateTime");
        simpleTypes.add("duration");
        dateTypes = new ArrayList<String>();
        dateTypes.add("dateTime");
        dateTypes.add("duration");
        try {
            jaxbCtx = JAXBContext.newInstance((String)"oracle.bpm.casemgmt.caserule.model");
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"unmarshalCaseData", (Throwable)e);
        }
        decisionInputSequenceCache = new ConcurrentHashMap<String, List<XSElementDecl>>();
    }
}

