/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.caseactivity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpm.casemgmt.ICaseService;
import oracle.bpm.casemgmt.caseactivity.CaseActivityException;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityDefinition;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.metadata.activity.model.CaseActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TCaseActivity;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CaseActivityUtil {
    private static final String CASE_NS = "http://xmlns.oracle.com/bpm/case";

    public static String getString(boolean booleanValue) {
        if (booleanValue) {
            return "Y";
        }
        return "N";
    }

    public static boolean getBoolean(String stringValue) {
        return stringValue != null && stringValue.equalsIgnoreCase("Y");
    }

    public static String getCustomClassName(CaseActivity caseActivity) {
        String className = null;
        TActivity type = ((TCaseActivity)caseActivity.getValue()).getActivityType();
        if (type.compareTo((Enum)TActivity.CUSTOM) == 0) {
            if (((TCaseActivity)caseActivity.getValue()).isIsGlobal()) {
                if (((TCaseActivity)caseActivity.getValue()).getGlobalActivity() != null && ((TCaseActivity)caseActivity.getValue()).getGlobalActivity().getDefinition() != null) {
                    className = ((TCaseActivity)caseActivity.getValue()).getGlobalActivity().getDefinition().getClassName();
                }
            } else if (((TCaseActivity)caseActivity.getValue()).getCustomActivity() != null && ((TCaseActivity)caseActivity.getValue()).getCustomActivity().getDefinition() != null) {
                className = ((TCaseActivity)caseActivity.getValue()).getCustomActivity().getDefinition().getClassName();
            }
            return className;
        }
        return null;
    }

    public static boolean isCaseAssociated(CaseActivity caseActivity, String caseMetadataId) {
        if (caseMetadataId != null) {
            return true;
        }
        if (((TCaseActivity)caseActivity.getValue()).getCaseAssociations() != null) {
            if (((TCaseActivity)caseActivity.getValue()).getCaseAssociations().getAllCases() != null) {
                return false;
            }
            if (((TCaseActivity)caseActivity.getValue()).getCaseAssociations().getAssociations() != null) {
                List cases;
                List caseCategories;
                if (((TCaseActivity)caseActivity.getValue()).getCaseAssociations().getAssociations().getCaseCategories() != null && ((TCaseActivity)caseActivity.getValue()).getCaseAssociations().getAssociations().getCaseCategories().getCaseCategory() != null && (caseCategories = ((TCaseActivity)caseActivity.getValue()).getCaseAssociations().getAssociations().getCaseCategories().getCaseCategory()).size() > 0) {
                    return true;
                }
                if (((TCaseActivity)caseActivity.getValue()).getCaseAssociations().getAssociations().getCases() != null && ((TCaseActivity)caseActivity.getValue()).getCaseAssociations().getAssociations().getCases().getCase() != null && (cases = ((TCaseActivity)caseActivity.getValue()).getCaseAssociations().getAssociations().getCases().getCase()).size() > 0) {
                    return true;
                }
            }
        }
        return false;
    }

    public static char[] toClob(CaseActivity caseActivity) throws CaseActivityException {
        Element element = CaseActivityUtil.marshalCaseActivity(caseActivity);
        String xmlString = XMLUtil.toString((Node)element);
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("getClob():XMLString of case activity:\n" + xmlString));
        return xmlString.toCharArray();
    }

    public static CaseActivity fromClob(char[] caseActivityCharArr) throws Exception {
        String caseActivityXMLString = new String(caseActivityCharArr);
        Document doc = XMLUtil.parseDocumentFromXMLString((String)caseActivityXMLString);
        CaseActivity caseActivity = CaseActivityUtil.unmarshalCaseActivityMetadata(doc);
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("convertFromClob():Case activity:\n" + caseActivity));
        return caseActivity;
    }

    public static List<CaseActivityDefinition> excludeDuplicateCaseActivityDefinition(List<CaseActivityDefinition> caseActivities, String caseDefinitionId) {
        if (caseActivities == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CaseActivityDefinition> excludedList = new ArrayList<CaseActivityDefinition>();
        for (CaseActivityDefinition activityDefn : caseActivities) {
            if (activityDefn.getDefinitionId() == caseDefinitionId) continue;
            excludedList.add(activityDefn);
        }
        return excludedList;
    }

    public static void uploadCaseData(String caseDataName, Element data, String caseId) throws CaseActivityException {
        if (data == null) {
            return;
        }
        try {
            String methodName = "uploadCaseData";
            ICaseService caseService = ServicesLocator.getCaseService();
            IBPMContext context = InternalBPMContext.getInternalBPMContext();
            CaseData caseData = new CaseData();
            caseData.setObjectName(caseDataName);
            caseData.setObjectType(ICaseConstants.CaseObjectType.DATA.name());
            caseData.setCaseId(caseId);
            caseData.setId(CaseServiceUtil.getGUID());
            CaseActivityUtil.debugLog(methodName, "case data: " + XMLUtil.toString((Node)data));
            caseData.setData(XMLUtil.toString((Node)data));
            caseService.uploadCaseData(context, caseData);
        }
        catch (Exception e) {
            throw new CaseActivityException(74028, new Object[]{caseDataName});
        }
    }

    public static int getRelevanceEnumToInt(ICaseConstants.ActivityRelevance relevance) {
        if (relevance.compareTo((Enum)ICaseConstants.ActivityRelevance.HIGH) == 0) {
            return 5;
        }
        if (relevance.compareTo((Enum)ICaseConstants.ActivityRelevance.NORMAL) == 0) {
            return 3;
        }
        if (relevance.compareTo((Enum)ICaseConstants.ActivityRelevance.LOW) == 0) {
            return 1;
        }
        if (relevance.compareTo((Enum)ICaseConstants.ActivityRelevance.NONE) == 0) {
            return -1;
        }
        return -1;
    }

    public static ICaseConstants.ActivityRelevance getRelevanceIntToEnum(int relevance) {
        if (relevance == 5 || relevance == 4) {
            return ICaseConstants.ActivityRelevance.HIGH;
        }
        if (relevance == 3) {
            return ICaseConstants.ActivityRelevance.NORMAL;
        }
        if (relevance == 1 || relevance == 2) {
            return ICaseConstants.ActivityRelevance.LOW;
        }
        return ICaseConstants.ActivityRelevance.NONE;
    }

    private static CaseActivity unmarshalCaseActivityMetadata(Document caseActivityDocument) throws CaseActivityException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"oracle.bpm.casemgmt.metadata.activity.model");
            return (CaseActivity)jaxbContext.createUnmarshaller().unmarshal((Node)caseActivityDocument);
        }
        catch (Exception e) {
            throw new CaseActivityException(74204, new Object[0], e);
        }
    }

    private static Element marshalCaseActivity(CaseActivity caseActivity) throws CaseActivityException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"oracle.bpm.casemgmt.metadata.activity.model");
            Document doc = XMLUtil.createDocument();
            jaxbContext.createMarshaller().marshal((Object)caseActivity, (Node)doc);
            if (doc != null) {
                return doc.getDocumentElement();
            }
            return null;
        }
        catch (Exception e) {
            throw new CaseActivityException(74029, new Object[]{((TCaseActivity)caseActivity.getValue()).getName()}, e);
        }
    }

    private static void debugLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("ClassName:CaseActivityUtil\nMethodName:" + methodName + "\n" + "Message:\n" + message + "\n"));
    }
}

