/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.caseactivity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.common.WorkflowServiceLocator;
import oracle.bpel.services.workflow.metadata.ITaskMetadataService;
import oracle.bpel.services.workflow.metadata.TaskMetadataServiceException;
import oracle.bpel.services.workflow.metadata.processDocumentation.model.DocumentationAudienceEnum;
import oracle.bpel.services.workflow.metadata.processDocumentation.model.DocumentationType;
import oracle.bpel.services.workflow.metadata.processDocumentation.model.DocumentationsType;
import oracle.bpel.services.workflow.metadata.processDocumentation.model.TopicDocumentationType;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.IInternalCaseService;
import oracle.bpm.casemgmt.caseactivity.ActivityComparator;
import oracle.bpm.casemgmt.caseactivity.CaseActivityUtil;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityAttrib;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityDefinition;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityInstance;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityInstancePK;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.fabric.ICaseSEWrapper;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.metadata.activity.model.CaseActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TBpmnActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TCaseActivity;
import oracle.bpm.casemgmt.metadata.activity.model.TInputParameter;
import oracle.bpm.casemgmt.metadata.activity.model.TInputs;
import oracle.bpm.casemgmt.metadata.activity.model.TParameters;
import oracle.bpm.casemgmt.metadata.casedisplay.model.TCaseDisplayInfo;
import oracle.bpm.casemgmt.metadata.event.model.TActivityEvent;
import oracle.bpm.casemgmt.metadata.event.model.TEventType;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.persistence.ICasePersistence;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.casemgmt.persistence.model.PropertyBag;
import oracle.bpm.casemgmt.task.model.TaskInfo;
import oracle.bpm.casemgmt.util.CaseUtil;
import oracle.bpm.casemgmt.util.TaskQueryUtil;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class ActivityListingUtil {
    public static ActivityListingUtil getInstance() {
        ActivityListingUtil util = new ActivityListingUtil();
        return util;
    }

    public List<CaseActivityDefinition> findCaseActivities(IBPMContext context, Case caseInstance, ICaseConstants.ActivityFilterType filter, String orderBy, ICaseConstants.ActivitySortOrder sortOrder, List<ICaseConstants.ActivityOptionalInfo> optionalInfo, String additionalJPQLWhereClause) throws CasePersistenceException, CaseServiceException, BPMException {
        String methodName = "findCaseActivities";
        this.debugLog(methodName, "caseInstance:" + caseInstance.getCaseId() + "\n" + "filter:" + filter + "\n" + "order by:" + orderBy + "\n" + "sort order:" + sortOrder + "\n" + "optionalInfo:" + optionalInfo + "\n" + "additional where clause:" + additionalJPQLWhereClause);
        String query = this.getJPQLQuery(filter, orderBy, additionalJPQLWhereClause);
        this.debugLog(methodName, "query:" + query);
        List<CaseActivityDefinition> activityDefinitionList = this.executeQuery(context, caseInstance, filter, query, optionalInfo);
        this.setCaseActivityForm(context, caseInstance, activityDefinitionList);
        this.sortByInstanceColumn(activityDefinitionList, orderBy, sortOrder);
        this.logCaseActivities(methodName, activityDefinitionList, "Library based on filter:" + filter);
        return activityDefinitionList;
    }

    public void populateActivityAttributes(String caseId, List<CaseActivityDefinition> caseActivities) throws CasePersistenceException {
        HashMap<String, CaseActivityDefinition> map = new HashMap<String, CaseActivityDefinition>();
        ArrayList<String> list = new ArrayList<String>();
        for (CaseActivityDefinition activity : caseActivities) {
            activity.setCaseId(caseId);
            map.put(activity.getDefinitionId(), activity);
            list.add(activity.getDefinitionId());
        }
        if (list == null || list.isEmpty()) {
            return;
        }
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseId", caseId);
        parameters.put("activityIds", list);
        List attribs = persistence.findWithNamedQuery("CaseActivityAttrib.findAttributesForCaseActivities", parameters);
        for (CaseActivityAttrib attrib : attribs) {
            CaseActivityDefinition activityDefn = (CaseActivityDefinition)map.get(attrib.getActivityDefinitionId());
            activityDefn.setRelevance(CaseActivityUtil.getRelevanceIntToEnum(attrib.getActivityRating()));
        }
    }

    public void setCaseActivityForm(IBPMContext ctx, Case caseInstance, List<CaseActivityDefinition> activityList) throws CaseServiceException {
        TCaseDisplayInfo dispInfo = null;
        if (activityList != null && !activityList.isEmpty()) {
            for (CaseActivityDefinition actDefinition : activityList) {
                dispInfo = CaseUtil.getCaseFormURI(ctx, caseInstance, ICaseMetadataService.FORM_TYPE.CASEACTIVITYFORM, actDefinition.getName());
                if (dispInfo == null) continue;
                this.debugLog("setCaseActivityForm", "Case Activity Form URI for activity : " + actDefinition.getName() + "Case Activity form URI :" + dispInfo.getUri());
                actDefinition.setCaseActivityFormUrl(dispInfo.getUri());
            }
        }
    }

    private void sortByInstanceColumn(List<CaseActivityDefinition> activityDefinitionList, String orderBy, ICaseConstants.ActivitySortOrder sortOrder) {
        if (this.isJavaSort(orderBy)) {
            Collections.sort(activityDefinitionList, new ActivityComparator(orderBy, sortOrder));
        }
    }

    private List<CaseActivityDefinition> removeDefinitionsFoundInInstances(Case caseInstance, List<CaseActivityDefinition> definitionList) throws CasePersistenceException {
        if (definitionList == null || definitionList.isEmpty()) {
            return definitionList;
        }
        String caseId = caseInstance.getCaseId();
        ArrayList<CaseActivityDefinition> removeDefnList = new ArrayList<CaseActivityDefinition>();
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        for (CaseActivityDefinition definition : definitionList) {
            String definitionId = definition.getDefinitionId();
            CaseActivityInstancePK instancePK = new CaseActivityInstancePK(definitionId, caseId);
            CaseActivityInstance instance = persistence.find(CaseActivityInstance.class, instancePK);
            if (instance == null) continue;
            removeDefnList.add(definition);
        }
        definitionList.removeAll(removeDefnList);
        return definitionList;
    }

    private List<CaseActivityDefinition> executeQuery(IBPMContext context, Case caseInstance, ICaseConstants.ActivityFilterType filter, String query, List<ICaseConstants.ActivityOptionalInfo> optionalInfo) throws CasePersistenceException, CaseServiceException, BPMException {
        if (query == null || query.trim().equals("")) {
            return Collections.EMPTY_LIST;
        }
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String caseId = caseInstance.getCaseId();
        String caseDefinitionId = caseInstance.getCaseHeader().getCaseDefinitionId();
        List<Object> activityDefinitionList = new ArrayList();
        if (filter.equals((Object)ICaseConstants.ActivityFilterType.AVAILABLE)) {
            parameters.put("caseDefinitionId", caseDefinitionId);
            parameters.put("caseId", caseId);
            activityDefinitionList = persistence.findWithQuery(query, parameters);
            this.removeUninitiableActivities(context, caseId, activityDefinitionList, ICaseConstants.ActivityFilterType.AVAILABLE);
            this.setFormRequiredFlagForActivities(context, caseInstance, activityDefinitionList);
        } else if (filter.equals((Object)ICaseConstants.ActivityFilterType.UNAVAILABLE)) {
            parameters.put("caseDefinitionId", caseDefinitionId);
            parameters.put("caseId", caseId);
            activityDefinitionList = persistence.findWithQuery(query, parameters);
            this.removeUninitiableActivities(context, caseId, activityDefinitionList, ICaseConstants.ActivityFilterType.UNAVAILABLE);
        } else if (filter.equals((Object)ICaseConstants.ActivityFilterType.RUNNING)) {
            parameters.put("caseId", caseId);
            parameters.put("activityEvent", TActivityEvent.ACTIVATED);
            parameters.put("eventType", TEventType.ACTIVITY_EVENT);
            parameters.put("propertyName", "correlationId");
            List eventList = persistence.findWithQuery(query, parameters);
            activityDefinitionList = this.populateActivityEvents(caseId, eventList);
        } else if (filter.equals((Object)ICaseConstants.ActivityFilterType.COMPLETED)) {
            parameters.put("caseId", caseId);
            parameters.put("activityEvent", TActivityEvent.COMPLETED);
            parameters.put("eventType", TEventType.ACTIVITY_EVENT);
            parameters.put("propertyName", "correlationId");
            List eventList = persistence.findWithQuery(query, parameters);
            activityDefinitionList = this.populateActivityEvents(caseId, eventList);
        } else if (filter.equals((Object)ICaseConstants.ActivityFilterType.FAULTED)) {
            parameters.put("caseId", caseId);
            parameters.put("activityEvent", TActivityEvent.FAULTED);
            parameters.put("eventType", TEventType.ACTIVITY_EVENT);
            parameters.put("propertyName", "correlationId");
            List eventList = persistence.findWithQuery(query, parameters);
            activityDefinitionList = this.populateActivityEvents(caseId, eventList);
        }
        this.populateState(activityDefinitionList, filter);
        this.populateActivityAttributes(caseId, activityDefinitionList);
        this.populateOptionalInfo(context, caseInstance, activityDefinitionList, optionalInfo, filter);
        return activityDefinitionList;
    }

    private void populateOptionalInfo(IBPMContext context, Case caseInstance, List<CaseActivityDefinition> activityDefinitionList, List<ICaseConstants.ActivityOptionalInfo> optionalInfo, ICaseConstants.ActivityFilterType filter) throws CaseServiceException, BPMException {
        if (optionalInfo == null || optionalInfo.size() == 0) {
            return;
        }
        if (optionalInfo.contains(ICaseConstants.ActivityOptionalInfo.DOCUMENTATION)) {
            this.populateActivityDocumentations(context, activityDefinitionList);
        }
        if (this.isRunningCompletedFaultedQuery(filter) && optionalInfo.contains(ICaseConstants.ActivityOptionalInfo.TASK_INFO)) {
            this.populateTaskAssignees(context, activityDefinitionList);
        }
    }

    private boolean isRunningCompletedFaultedQuery(ICaseConstants.ActivityFilterType filter) {
        if (filter.equals((Object)ICaseConstants.ActivityFilterType.FAULTED)) {
            return true;
        }
        if (filter.equals((Object)ICaseConstants.ActivityFilterType.RUNNING)) {
            return true;
        }
        return filter.equals((Object)ICaseConstants.ActivityFilterType.COMPLETED);
    }

    private void populateTaskAssignees(IBPMContext context, List<CaseActivityDefinition> activityDefinitionList) {
        String methodName = "populateTaskAssignees";
        this.debugLog(methodName, "Populating assignees....");
        for (CaseActivityDefinition activity : activityDefinitionList) {
            String activityType;
            String rootTaskId = activity.getInstanceId();
            TaskInfo taskInfo = TaskQueryUtil.getTaskAssignees((IBPMContext)context, (String)rootTaskId, (String)(activityType = activity.getType()));
            if (taskInfo == null) continue;
            activity.setTaskInfo(taskInfo);
        }
    }

    private void populateActivityDocumentations(IBPMContext context, List<CaseActivityDefinition> activityDefinitionList) throws CaseServiceException, BPMException {
        String methodName = "populateActivityDocumentations";
        this.debugLog(methodName, "Populating documentations....");
        ITaskMetadataService taskMetadataService = WorkflowServiceLocator.getTaskMetadataService();
        ICaseSEWrapper caseSE = ServicesLocator.getCaseSE();
        for (CaseActivityDefinition activity : activityDefinitionList) {
            List usecaseDocumentations;
            List documentations;
            String compositeDN;
            if (activity.getType().equals("BPMN")) {
                String processName = caseSE.getProcessName(activity.getDefinitionId());
                compositeDN = caseSE.getCompositeDNFromCaseDefinitionId(activity.getDefinitionId());
                try {
                    documentations = taskMetadataService.getComponentTopicDocumentations((IWorkflowContext)context, compositeDN, processName, processName, DocumentationAudienceEnum.DOCUMENTATION, context.getLocale());
                    usecaseDocumentations = taskMetadataService.getComponentTopicDocumentations((IWorkflowContext)context, compositeDN, processName, processName, DocumentationAudienceEnum.USECASE_DOCUMENTATION, context.getLocale());
                    this.populateDocumentations(activity, documentations, DocumentationAudienceEnum.DOCUMENTATION);
                    this.populateDocumentations(activity, usecaseDocumentations, DocumentationAudienceEnum.USECASE_DOCUMENTATION);
                }
                catch (TaskMetadataServiceException e) {
                    this.warnLog(methodName, "Unable to get documentation for process:" + processName + " due to exception:" + e.getMessage());
                }
                continue;
            }
            if (!activity.getType().equals("HWF")) continue;
            String humanTaskName = caseSE.getHumanTaskName(activity.getDefinitionId());
            compositeDN = caseSE.getCompositeDNFromCaseDefinitionId(activity.getDefinitionId());
            try {
                documentations = taskMetadataService.getComponentTopicDocumentations((IWorkflowContext)context, compositeDN, humanTaskName, humanTaskName, DocumentationAudienceEnum.DOCUMENTATION, context.getLocale());
                usecaseDocumentations = taskMetadataService.getComponentTopicDocumentations((IWorkflowContext)context, compositeDN, humanTaskName, humanTaskName, DocumentationAudienceEnum.USECASE_DOCUMENTATION, context.getLocale());
                this.populateDocumentations(activity, documentations, DocumentationAudienceEnum.DOCUMENTATION);
                this.populateDocumentations(activity, usecaseDocumentations, DocumentationAudienceEnum.USECASE_DOCUMENTATION);
            }
            catch (TaskMetadataServiceException e) {
                this.warnLog(methodName, "Unable to get documentation for human task:" + humanTaskName + " due to exception:" + e.getMessage());
            }
        }
    }

    private void populateDocumentations(CaseActivityDefinition activity, List<TopicDocumentationType> topicDocumentations, DocumentationAudienceEnum documentationAudienceEnum) {
        ArrayList<DocumentationType> finalDocumentations = new ArrayList<DocumentationType>();
        if (topicDocumentations != null && !topicDocumentations.isEmpty()) {
            for (TopicDocumentationType topicDocumentation : topicDocumentations) {
                List documentationNodesList;
                DocumentationsType documentationsType;
                if (topicDocumentation == null || (documentationsType = topicDocumentation.getDocumentations()) == null || (documentationNodesList = documentationsType.getDocumentation()) == null || documentationNodesList.isEmpty()) continue;
                for (DocumentationType documentation : documentationNodesList) {
                    if (documentation == null) continue;
                    finalDocumentations.add(documentation);
                }
            }
        }
        if (documentationAudienceEnum.equals((Object)DocumentationAudienceEnum.DOCUMENTATION)) {
            activity.setDocumentations(finalDocumentations);
        } else if (documentationAudienceEnum.equals((Object)DocumentationAudienceEnum.USECASE_DOCUMENTATION)) {
            activity.setUseCaseDocumentations(finalDocumentations);
        }
    }

    private void populateState(List<CaseActivityDefinition> activityDefinitionList, ICaseConstants.ActivityFilterType filter) {
        for (CaseActivityDefinition definition : activityDefinitionList) {
            definition.setState(filter.name());
        }
    }

    private List<CaseActivityDefinition> populateActivityEvents(String caseId, List<Object[]> eventList) throws CasePersistenceException {
        ArrayList<CaseActivityDefinition> definitionList = new ArrayList<CaseActivityDefinition>();
        for (Object[] eventObject : eventList) {
            CaseActivityDefinition definition = (CaseActivityDefinition)eventObject[0];
            CaseEvent caseEvent = (CaseEvent)eventObject[1];
            PropertyBag propertyBag = (PropertyBag)eventObject[2];
            definitionList.add(this.populateActivityEventDetails(caseId, definition, caseEvent, propertyBag));
        }
        return definitionList;
    }

    private CaseActivityDefinition populateActivityEventDetails(String caseId, CaseActivityDefinition definition, CaseEvent caseEvent, PropertyBag propertyBag) throws CasePersistenceException {
        this.populateInstanceId(caseId, definition, caseEvent);
        this.populateEventInfo(caseId, definition, caseEvent);
        return definition;
    }

    private void populateEventInfo(String caseId, CaseActivityDefinition definition, CaseEvent caseEvent) {
        definition.setStartDate(caseEvent.getStartedDate());
        definition.setCompletedDate(caseEvent.getCompletedDate());
        definition.setEventId(caseEvent.getId());
    }

    private void populateInstanceId(String caseId, String activityInstanceId, CaseActivityDefinition definition, PropertyBag propertyBag) throws CasePersistenceException {
        if (activityInstanceId == null) {
            ICasePersistence persistence = ServicesLocator.getCasePersistence();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("caseId", caseId);
            parameters.put("correlationId", propertyBag.getValue());
            List instanceIdList = persistence.findWithQuery("select activityCorrelation.instanceId from CaseActivityCorrelation activityCorrelation where activityCorrelation.caseId = :caseId and  activityCorrelation.correlationId = :correlationId", parameters);
            if (instanceIdList != null && instanceIdList.size() == 1) {
                String instanceId = (String)instanceIdList.get(0);
                definition.setInstanceId(instanceId);
            }
        } else {
            definition.setInstanceId(activityInstanceId);
        }
    }

    private void populateInstanceId(String caseId, CaseActivityDefinition definition, CaseEvent event) throws CasePersistenceException {
        if (event.getActivityId() == null) {
            IInternalCaseService service = ServicesLocator.getInternalCaseService();
            String instanceId = service.getInstanceIdFromEvent(caseId, event);
            if (instanceId != null) {
                definition.setInstanceId(instanceId);
                event.setActivityId(instanceId);
            }
        } else {
            definition.setInstanceId(event.getActivityId());
        }
    }

    private String getJPQLQuery(ICaseConstants.ActivityFilterType filter, String orderBy, String additionalJPQLWhereClause) {
        String jpqlOrderBy = orderBy;
        if (this.isJavaSort(orderBy)) {
            jpqlOrderBy = "";
        }
        if (filter.equals((Object)ICaseConstants.ActivityFilterType.AVAILABLE)) {
            return this.addOrderBy(this.addWhereClause(this.getAvailableActivities(), additionalJPQLWhereClause), jpqlOrderBy);
        }
        if (filter.equals((Object)ICaseConstants.ActivityFilterType.UNAVAILABLE)) {
            return this.addOrderBy(this.addWhereClause(this.getUnavailableActivities(), additionalJPQLWhereClause), jpqlOrderBy);
        }
        if (filter.equals((Object)ICaseConstants.ActivityFilterType.RUNNING)) {
            return this.addOrderBy(this.addWhereClause(this.getEventActivities(), additionalJPQLWhereClause), jpqlOrderBy);
        }
        if (filter.equals((Object)ICaseConstants.ActivityFilterType.COMPLETED)) {
            return this.addOrderBy(this.addWhereClause(this.getEventActivities(), additionalJPQLWhereClause), jpqlOrderBy);
        }
        if (filter.equals((Object)ICaseConstants.ActivityFilterType.FAULTED)) {
            return this.addOrderBy(this.addWhereClause(this.getEventActivities(), additionalJPQLWhereClause), jpqlOrderBy);
        }
        return null;
    }

    private boolean isJavaSort(String orderBy) {
        return orderBy != null && (ICaseConstants.ActivitySortColumn.RELEVANCE.toString().equals(orderBy) || ICaseConstants.ActivitySortColumn.REQUIRED.toString().equals(orderBy));
    }

    private void removeUninitiableActivities(IBPMContext context, String caseId, List<CaseActivityDefinition> caseActivities, ICaseConstants.ActivityFilterType filter) throws CasePersistenceException, CaseServiceException, BPMException {
        ArrayList<CaseActivityDefinition> removedActivities = new ArrayList<CaseActivityDefinition>();
        IInternalCaseService service = ServicesLocator.getInternalCaseService();
        for (CaseActivityDefinition caseActDef : caseActivities) {
            if (service.canInitiateActivity(context, caseId, caseActDef.getDefinitionId(), filter)) continue;
            removedActivities.add(caseActDef);
        }
        caseActivities.removeAll(removedActivities);
    }

    private String addWhereClause(String query, String additionalJPQLWhereClause) {
        if (additionalJPQLWhereClause != null && !additionalJPQLWhereClause.trim().equals("")) {
            query = query + " AND ( " + additionalJPQLWhereClause + " )";
        }
        return query;
    }

    private String getEventActivities() {
        String query = "select activityDefinition,caseEvent,propertyBag from CaseActivityDefinition activityDefinition, CaseEvent caseEvent LEFT JOIN caseEvent.propertyBagCollection propertyBag where caseEvent.case_id = :caseId and caseEvent.activity_event = :activityEvent and caseEvent.event_type = :eventType and caseEvent.object_name = activityDefinition.definitionId and propertyBag.name = :propertyName";
        return query;
    }

    private String getAvailableActivities() {
        String query = "select activityDefinition from CaseActivityDefinition activityDefinition  where ((EXISTS (select activityInstance from CaseActivityInstance activityInstance where activityInstance.caseId = :caseId and activityDefinition.definitionId = activityInstance.activityDefinitionId and activityDefinition.isManual = 'Y'))  OR (activityDefinition.isManual = 'Y' and activityDefinition.isCaseSpecific = 'N' and activityDefinition.isConditional = 'N' ) OR (EXISTS (select caseAssociation from activityDefinition.caseActivityInCaseDefinitionList caseAssociation where caseAssociation.caseDefinitionId = :caseDefinitionId and activityDefinition.isManual = 'Y' and activityDefinition.isConditional = 'N')))";
        return query;
    }

    private String getUnavailableActivities() {
        String query = "select activityDefinition from CaseActivityDefinition activityDefinition where (EXISTS (select caseAssociation from activityDefinition.caseActivityInCaseDefinitionList caseAssociation where caseAssociation.caseDefinitionId = :caseDefinitionId and activityDefinition.isManual = 'Y' and activityDefinition.isConditional = 'Y' and activityDefinition.isCaseSpecific = 'Y')) AND (NOT EXISTS (select activityInstance from CaseActivityInstance activityInstance where activityInstance.caseId = :caseId and activityDefinition.definitionId = activityInstance.activityDefinitionId))";
        return query;
    }

    private String addOrderBy(String query, String orderBy) {
        if (orderBy == null || orderBy.trim().equals("") || query == null || query.trim().equals("")) {
            return query;
        }
        StringBuffer queryBuffer = new StringBuffer(query);
        queryBuffer.append(" ORDER BY ").append(orderBy);
        return queryBuffer.toString();
    }

    private void warnLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.WARNING, (String)("ClassName:" + this.getClass().getName() + "\n" + "MethodName:" + methodName + "\n" + "Message:\n" + message + "\n"));
    }

    private void debugLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("ClassName:" + this.getClass().getName() + "\n" + "MethodName:" + methodName + "\n" + "Message:\n" + message + "\n"));
    }

    private void logCaseActivities(String methodName, List<CaseActivityDefinition> caseActivities, String message) {
        if (caseActivities == null) {
            return;
        }
        this.debugLog(methodName, message);
        this.debugLog(methodName, "Case Activity List count:" + caseActivities.size());
        for (CaseActivityDefinition caseActivity : caseActivities) {
            this.logCaseActivity(methodName, caseActivity, null);
        }
    }

    private void logCaseActivity(String methodName, CaseActivityDefinition caseActivity, String message) {
        String msg = message + "\n" + "CaseActivityDefinition for :" + caseActivity.getName() + "\n" + "Definition Id:" + caseActivity.getDefinitionId() + "\n" + "Is custom activity:" + caseActivity.getIsCustom() + "\n" + "Is global:" + caseActivity.getIsGlobal() + "\n" + "Is case specific:" + caseActivity.getIsCaseSpecific() + "\n" + "Is conditional:" + caseActivity.getIsConditional() + "\n" + "Required:" + caseActivity.getIsRequired() + "\n" + "Repeatable:" + caseActivity.getIsRepeatable() + "\n" + "Manual:" + caseActivity.getIsManual() + "\n" + "State:" + caseActivity.getState() + "\n" + "Class Name:" + caseActivity.getClassName() + "\n" + "Type: " + caseActivity.getType() + "\n" + "Relevance:" + caseActivity.getRelevance().toString() + "\n";
        this.debugLog(methodName, msg);
    }

    private void setFormRequiredFlagForActivities(IBPMContext ctx, Case caseInstance, List<CaseActivityDefinition> activityDefinitionList) throws CaseServiceException {
        ICaseMetadataService caseMetadataService = ServicesLocator.getCaseMetadataService();
        block0: for (CaseActivityDefinition activityDef : activityDefinitionList) {
            List parameterList;
            TInputs inputs;
            TBpmnActivity activity;
            CaseActivity caseActivity = caseMetadataService.getCaseActivityMetadata(ctx, activityDef.getDefinitionId());
            if (caseActivity == null) continue;
            TActivity activityType = ((TCaseActivity)caseActivity.getValue()).getActivityType();
            TParameters para = null;
            if (activityType.equals((Object)TActivity.BPMN)) {
                activity = ((TCaseActivity)caseActivity.getValue()).getBpmnActivity();
                if (activity != null) {
                    para = activity.getParameters();
                }
            } else if (activityType.equals((Object)TActivity.HWF)) {
                activity = ((TCaseActivity)caseActivity.getValue()).getWorkflowActivity();
                if (activity != null) {
                    para = activity.getParameters();
                }
            } else {
                activity = ((TCaseActivity)caseActivity.getValue()).getCustomActivity();
                if (activity != null) {
                    para = activity.getParameters();
                }
            }
            if (para == null || (inputs = para.getInputs()) == null || (parameterList = inputs.getParameter()) == null) continue;
            for (TInputParameter parameter : parameterList) {
                if (parameter.getPayloadInput() == null) continue;
                activityDef.setIsFormRequired(true);
                continue block0;
            }
        }
    }
}

