/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.caseactivity;

import java.lang.reflect.Method;
import java.util.Comparator;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityDefinition;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;

public class ActivityComparator
implements Comparator<CaseActivityDefinition> {
    private String attribute;
    private ICaseConstants.ActivitySortOrder sortOrder;

    public ActivityComparator(String attribute, ICaseConstants.ActivitySortOrder sortOrder) {
        this.attribute = attribute;
        if (sortOrder == null) {
            sortOrder = ICaseConstants.ActivitySortOrder.ASCENDING;
        }
        this.sortOrder = sortOrder;
    }

    @Override
    public int compare(CaseActivityDefinition o1, CaseActivityDefinition o2) {
        Object object1 = null;
        Object object2 = null;
        String getterMethod = "get" + ICaseConstants.ActivitySortColumn.valueOf((String)this.attribute).columnName();
        try {
            Method method = o1.getClass().getMethod(getterMethod, new Class[0]);
            object1 = method.invoke((Object)o1, new Object[0]);
            object2 = method.invoke((Object)o2, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        object1 = this.mapValue(object1, this.attribute);
        object2 = this.mapValue(object2, this.attribute);
        return this.compareObjects(object1, object2, this.sortOrder);
    }

    private Object mapValue(Object object, String attributeName) {
        if (object != null && ICaseConstants.ActivitySortColumn.RELEVANCE.toString().equals(attributeName)) {
            ICaseConstants.ActivityRelevance relevance = (ICaseConstants.ActivityRelevance)object;
            if (ICaseConstants.ActivityRelevance.NONE.compareTo((Enum)relevance) == 0) {
                return -1;
            }
            if (ICaseConstants.ActivityRelevance.LOW.compareTo((Enum)relevance) == 0) {
                return 1;
            }
            if (ICaseConstants.ActivityRelevance.NORMAL.compareTo((Enum)relevance) == 0) {
                return 3;
            }
            if (ICaseConstants.ActivityRelevance.HIGH.compareTo((Enum)relevance) == 0) {
                return 5;
            }
        }
        return object;
    }

    private int compareInt(int integer1, int integer2, ICaseConstants.ActivitySortOrder sortOrder) {
        int multiplier = this.getMultiplier(sortOrder);
        if (integer1 < integer2) {
            return multiplier * -1;
        }
        if (integer1 == integer2) {
            return 0;
        }
        return multiplier * 1;
    }

    private int compareBoolean(boolean boolean1, boolean boolean2, ICaseConstants.ActivitySortOrder sortOrder) {
        int multiplier = this.getMultiplier(sortOrder);
        if (boolean1 == boolean2) {
            return 0;
        }
        if (boolean1 && !boolean2) {
            return multiplier * 1;
        }
        return multiplier * -1;
    }

    private int compareString(String string1, String string2, ICaseConstants.ActivitySortOrder sortOrder) {
        int multiplier = this.getMultiplier(sortOrder);
        if (string1 == null && string2 == null) {
            return 0;
        }
        if (string1 == null && string2 != null) {
            return multiplier * -1;
        }
        if (string1 != null && string2 == null) {
            return multiplier * 1;
        }
        return multiplier * string1.compareTo(string2);
    }

    private int compareObjects(Object object1, Object object2, ICaseConstants.ActivitySortOrder sortOrder) {
        if (object1 instanceof Integer) {
            return this.compareInt((Integer)object1, (Integer)object2, sortOrder);
        }
        if (object1 instanceof Boolean) {
            return this.compareBoolean((Boolean)object1, (Boolean)object2, sortOrder);
        }
        if (object1 instanceof String) {
            return this.compareString((String)object1, (String)object2, sortOrder);
        }
        return 0;
    }

    private int getMultiplier(ICaseConstants.ActivitySortOrder sortOrder) {
        if (sortOrder.equals((Object)ICaseConstants.ActivitySortOrder.ASCENDING)) {
            return 1;
        }
        return -1;
    }
}

