/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.bam.chartviewer.ChartManager;
import oracle.bpm.bam.chartviewer.IndicatorSelections;
import oracle.bpm.bam.model.SimulationDataModel;
import oracle.bpm.bam.msg.BamMsg;
import oracle.bpm.bamdata.ActivityInfo;
import oracle.bpm.bamdata.BAMActivityInfo;
import oracle.bpm.bamdata.BAMProcessInfo;
import oracle.bpm.bamdata.BAMResourceRunningInfo;
import oracle.bpm.bamdata.BAMRunningInfo;
import oracle.bpm.bamdata.CostIndicator;
import oracle.bpm.bamdata.Indicator;
import oracle.bpm.bamdata.ResourceInfo;
import oracle.bpm.bamdata.TimeIndicator;
import oracle.bpm.bamdata.UnitIndicator;
import oracle.bpm.chart.BasicChartComponent;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Literals;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.Priority;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.utils.ImageExtension;
import oracle.bpm.ui.utils.ImageIOFacade;
import oracle.bpm.util.ProgressMonitor;
import org.jetbrains.annotations.NotNull;

public class ReportGenerator {
    StringBuffer htmlBuffer;
    private String baseFileName;
    private File dataDir;
    private File outputDir;
    private ProgressMonitor progressMonitor;
    private Writer writer;
    private Writer writerResources;
    private SimulationDataModel dataModel;
    private List<ReportGenerationInfo> reports;

    public ReportGenerator(SimulationDataModel dataModel, List<ReportGenerationInfo> reports) {
        this.dataModel = dataModel;
        this.reports = reports;
    }

    public void doIt() throws IOException {
        SimulationDataModel simulationDataModel = this.dataModel;
        for (Process process : simulationDataModel.getProcesses()) {
            this.generateSimulationImages(process);
            this.generateCsv(process);
        }
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setBaseFileName(String baseFileName) {
        this.baseFileName = baseFileName;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    private void checkDataDir() {
        if (this.dataDir == null) {
            this.dataDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "report-data");
        }
        if (!this.dataDir.exists()) {
            this.dataDir.mkdir();
        }
    }

    private void createHtmlEnd() {
        this.htmlBuffer.append("</table></body></html>");
    }

    private void createHtmlHeader(String processId) {
        this.htmlBuffer = new StringBuffer();
        this.htmlBuffer.append("<html><head>");
        this.htmlBuffer.append("<title>").append(BamMsg.SIMULATION_REPORT.getString()).append("</title>\n");
        this.htmlBuffer.append("<meta http-equiv=\"content-type\" content=\"application/xhtml+xml; charset=UTF-8\" />\n");
        this.htmlBuffer.append("<style type=\"text/css\">");
        this.htmlBuffer.append("<!--\na {\n\tfont-weight: bold;\n\ttext-decoration: none;\n}\nbody {\n\tbackground: #FFFFFF;\n\tcolor: #000000;\n\tfont-family: Verdana, Arial, sans-serif;\n\tfont-size: 80%;\n\tmargin: 0px;\n}\nimg {\n\tborder: 0px;\n}\ntd {\n\tfont-family: Verdana, Arial, sans-serif;\n\tfont-size: 80%;\n}\ntable#header {\n\twidth: 100%;\n}\ntable#header td {\n\tcolor: #00000;\n\tbackground-color: #FFFFFF;\n\tfont-weight: bold;\n\tfont-size: 110%;\n\tpadding-right: 2px;\n}\ntd.category {\n\tbackground: #C2D1DC;\n\tcolor: Black;\n\tborder: 1px solid #000000;\n\tfont-weight: bold;\n\tmargin: 2px;\n\tpadding: 2px;\n}\ntd.data {\n\tbackground: #E1E1E1;\n\tcolor: Black;\n\tborder: 1px solid #000000;\n\tfont-weight: bold;\n\tmargin: 2px;\n\tpadding: 2px;\n}-->");
        this.htmlBuffer.append("</style></head><body>");
        this.htmlBuffer.append("<table align\"center\" cellpadding=\"0\">");
        String csvFileName = this.createCsvFile(processId).getName();
        String csvResFileName = this.createCsvResourcesFile(processId).getName();
        this.htmlBuffer.append("\t<tr>\n\t\t<td>\n\t\t\t<table id=\"header\" cellpadding=\"0\" cellspacing=\"0\" height=\"70\">\n\t\t\t<tr>\n\t\t\t\t<td valign=\"top\">\n\t\t\t\t\t<a href=\"http://www.fuego.com\"><img src=\"http://www.bea.com/content/images/logo_bea_tl.gif\" border=\"0\"></a>\n\t\t\t\t</td>\n\t\t\t\t<td align=\"right\" valign=\"bottom\">").append(BamMsg.SIMULATION_REPORT.getString()).append(":").append(this.baseFileName).append("</td>\n\t\t\t</tr>\n\t\t\t</table>\n\t\t</td>\n\t</tr>\t<tr>\n\t\t<td class=\"data\" colspan=\"2\">").append(BamMsg.SIMULATION_DATA.getString()).append(": <a href=\"").append(csvFileName).append("\">").append(csvFileName).append("</a></td>\n\t</tr>\n\t<tr>\n\t\t<td class=\"data\" colspan=\"2\">").append(BamMsg.SIMULATION_RESOURCE_DATA.getString()).append(": <a href=\"").append(csvResFileName).append("\">").append(csvResFileName).append("</a></td>\n\t</tr>");
    }

    private Object format(Object obj) {
        Object result = obj;
        if (obj instanceof Double) {
            Double value = (Double)obj;
            result = (double)Math.round(value * 100.0) / 100.0;
        } else if (obj instanceof Interval) {
            Interval value = (Interval)obj;
            result = value.getSeconds() + "," + CoreMsg.SECONDS;
        }
        return result;
    }

    private void generateActivityDetailedCharts(ReportGenerationInfo info, @NotNull Process process) {
        Info<String> activityInfo = info.getActivityInfo();
        ChartManager chartManager = info.getChartManager();
        List<String> originals = chartManager.getSelectedActivitiesOfSelectedProcess();
        List<String> activities = activityInfo.getData();
        for (int i = 0; i < activities.size(); ++i) {
            chartManager.setSelectedActivities(activities.subList(i, i + 1));
            String activityId = activities.get(i);
            FlowNode flowNode = ModelUtils.findFlowNode((Process)process, (String)activityId);
            if (flowNode == null) continue;
            String defaultLabel = flowNode.getDefaultLabel();
            this.generateSnapshot("activityId-" + activityId, ProjectModelMsg.ACTIVITY.getString() + ": " + defaultLabel, info);
        }
        chartManager.setSelectedActivities(originals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCsv(Process process) throws IOException {
        String processLabel = process.getDefaultLabel();
        this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.createCsvFile(processLabel)), Literals.DEFAULT_ENCODING);
        this.writerResources = new OutputStreamWriter((OutputStream)new FileOutputStream(this.createCsvResourcesFile(processLabel)), Literals.DEFAULT_ENCODING);
        try {
            this.writer.write(BamMsg.ACTIVITIES + "," + BamMsg.INDICATORS + "," + BamMsg.VALUES + "\n");
            this.writerResources.write(BamMsg.ACTIVITIES + "," + BamMsg.RESOURCES + "," + BamMsg.INDICATORS + "," + BamMsg.VALUES + "\n");
            this.generateCsvForProcess(process.getId());
        }
        finally {
            this.writer.close();
            this.writerResources.close();
        }
    }

    private void generateCsv(Indicator[] indicators, String activityLabel, BAMRunningInfo info) throws IOException {
        for (Indicator indicator : indicators) {
            if (indicator.isResourceIndicator()) continue;
            this.writer.write(activityLabel + "," + indicator.getString() + "," + this.format(indicator.get(info)) + "\n");
        }
    }

    private void generateCsv(Indicator[] indicators, String activityLabel, BAMRunningInfo info, String resource) throws IOException {
        for (Indicator indicator : indicators) {
            if (indicator.isResourceIndicator()) continue;
            this.writerResources.write(activityLabel + ",");
            this.writerResources.write(resource + ",");
            this.writerResources.write(indicator.getString() + ",");
            this.writerResources.write(this.format(indicator.get(info)) + "\n");
        }
    }

    private void generateCsvForActivity(Process content, BAMActivityInfo activityInfo) throws IOException {
        this.generateCvsForCategories(content, activityInfo);
    }

    private void generateCsvForActivity(Process content, BAMActivityInfo bamActivityInfo, BAMActivityInfo root) throws IOException {
        this.generateCsvForActivity(content, bamActivityInfo);
        for (ActivityInfo child : root.getChildren().values()) {
            this.generateCsvForActivity(content, (BAMActivityInfo)child);
        }
    }

    private void generateCsvForProcess(String processId) throws IOException {
        SimulationDataModel simulationDataModel = this.dataModel;
        BAMProcessInfo root = simulationDataModel.getProcessInfo(processId);
        Process content = (Process)simulationDataModel.getSimulationPhotoModel().getProcessContentInfoMap().get(processId);
        for (ActivityInfo child : root.getChildren().values()) {
            this.generateCsvForActivity(content, (BAMActivityInfo)child, (BAMActivityInfo)root);
        }
    }

    private void generateCsvForRunningInfo(Process content, String activityName, BAMRunningInfo info) throws IOException {
        String activityLabel = content.findNode(activityName).getDefaultLabel();
        this.generateCsv((Indicator[])UnitIndicator.values(), activityLabel, info);
        this.generateCsv((Indicator[])TimeIndicator.values(), activityLabel, info);
        this.generateCsv((Indicator[])CostIndicator.values(), activityLabel, info);
    }

    private void generateCsvForRunningInfo(Process content, String activityName, BAMResourceRunningInfo info, String resource) throws IOException {
        String activityLabel = content.findNode(activityName).getDefaultLabel();
        this.generateCsv((Indicator[])UnitIndicator.values(), activityLabel, (BAMRunningInfo)info, resource);
        this.generateCsv((Indicator[])TimeIndicator.values(), activityLabel, (BAMRunningInfo)info, resource);
        this.generateCsv((Indicator[])CostIndicator.values(), activityLabel, (BAMRunningInfo)info, resource);
    }

    private void generateCvsForCategories(Process content, BAMActivityInfo activityInfo) throws IOException {
        this.generateCsvForRunningInfo(content, activityInfo.getName(), activityInfo.getRunningInfo());
        for (ResourceInfo resourceInfo : activityInfo.getResources().values()) {
            this.generateCsvForRunningInfo(content, activityInfo.getName(), activityInfo.getResourceInfo(resourceInfo.getName()).getRunningInfo(), resourceInfo.getName());
        }
    }

    private void generateHtml(String processId) throws IOException {
        File file = new File(this.getOutputDir(), this.baseFileName + "_" + processId + ".html");
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Literals.DEFAULT_ENCODING);
        fileWriter.write(this.htmlBuffer.toString());
        ((Writer)fileWriter).flush();
        ((Writer)fileWriter).close();
    }

    private void generateIndicatorDetailedCharts(ReportGenerationInfo info) {
        Info<Indicator> indicatorInfo = info.getIndicatorInfo();
        ChartManager chartManager = info.getChartManager();
        Indicator original = chartManager.getSelectedIndicator();
        for (Indicator indicator : indicatorInfo.getData()) {
            chartManager.setSelectedIndicator(indicator);
            IndicatorSelections singleIndicator = new IndicatorSelections();
            singleIndicator.selectUnique(indicator);
            chartManager.setIndicatorProvider(singleIndicator);
            this.generateSnapshot(BamMsg.INDICATOR.getString() + "-" + indicator, BamMsg.INDICATOR.getString() + ": " + indicator, info);
        }
        chartManager.setSelectedIndicator(original);
    }

    private void generateResourceDetailedCharts(ReportGenerationInfo info) {
        ChartManager chartManager = info.getChartManager();
        Info<SimulationResource> resourceInfo = info.getResourceInfo();
        List<SimulationResource> originals = chartManager.getSelectedResources();
        List<SimulationResource> resources = resourceInfo.getData();
        for (int i = 0; i < resources.size(); ++i) {
            chartManager.setSelectedResources(resources.subList(i, i + 1));
            String resourceId = resources.get(i).getId();
            this.generateSnapshot(BamMsg.RESOURCE.getString() + "-" + resourceId, BamMsg.RESOURCE.getString() + ": " + resourceId, info);
        }
        chartManager.setSelectedResources(originals);
    }

    private void generateSimulationImages(Process process) throws IOException {
        this.createHtmlHeader(process.getDefaultLabel());
        for (ReportGenerationInfo info : this.reports) {
            ChartManager chartManager = info.getChartManager();
            String processLabel = chartManager.getProcessLabelById(process.getId());
            this.generateSnapshot("reportSummary", BamMsg.PROCESS_TITLE(processLabel).getString(), info);
            this.phase(BamMsg.RESOURCES, 0);
            Info<SimulationResource> resourceInfo = info.getResourceInfo();
            if (resourceInfo.isFree() && !resourceInfo.isSummary()) {
                this.generateResourceDetailedCharts(info);
            }
            this.phase(BamMsg.ACTIVITIES, 25);
            Info<String> activityInfo = info.getActivityInfo();
            if (activityInfo.isFree() && !activityInfo.isSummary()) {
                this.generateActivityDetailedCharts(info, process);
            }
            this.phase(BamMsg.INDICATORS, 60);
            Info<Indicator> indicatorInfo = info.getIndicatorInfo();
            if (indicatorInfo.isFree() && !indicatorInfo.isSummary()) {
                this.generateIndicatorDetailedCharts(info);
            }
            this.phase(BamMsg.AUTOREFRESH, 100);
        }
        this.createHtmlEnd();
        this.generateHtml(process.getDefaultLabel());
    }

    private void generateSnapshot(String name, String description, ReportGenerationInfo info) {
        Image image = Image.create((int)800, (int)600);
        ChartManager chartManager = info.getChartManager();
        BasicChartComponent chart = (BasicChartComponent)chartManager.getChart();
        chart.paintCanvas(image.getGraphics(), Dimension.valueOf(800, 600));
        this.checkDataDir();
        File dataDir = this.getDataDir();
        String fileName = info.getName() + "_" + name + ".jpg";
        ImageIOFacade.writeImage((Image)image, (ImageExtension)ImageExtension.JPG, (File)new File(dataDir, fileName));
        this.htmlBuffer.append("\t<tr>\n\t\t<td class=\" ").append(BamMsg.CATEGORY.getString()).append(" \">").append(description).append("</td>\n\t</tr>");
        this.htmlBuffer.append("\t<tr>\n\t\t<td><img border=\"0\" src=\"").append(dataDir.getName()).append("/").append(fileName).append("\"><br></td>\n\t</tr>");
    }

    private File createCsvFile(String processId) {
        return new File(this.getOutputDir(), this.baseFileName + "_" + processId + ".csv");
    }

    private File createCsvResourcesFile(String processId) {
        return new File(this.getOutputDir(), this.baseFileName + "_" + processId + "_" + BamMsg.RESOURCES + ".csv");
    }

    private void phase(Msg msg, int progress) {
        ProgressMonitor progressMonitor = this.getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.phase(msg);
            progressMonitor.progress(progress);
        }
    }

    public static class ReportGenerationInfo {
        private Info<String> activityInfo;
        private Info<Priority> categoryInfo;
        private String name;
        private ChartManager chartManager;
        private Info<Indicator> indicatorInfo;
        private Info<SimulationResource> resourceInfo;
        private SimulationDataModel simulationDataModel;

        public ReportGenerationInfo(String name, ChartManager chartManager, Info<Indicator> indicatorInfo, Info<String> activityInfo, Info<SimulationResource> resourceInfo, Info<Priority> categoryInfo) {
            this.name = name;
            this.chartManager = chartManager;
            this.simulationDataModel = chartManager.getDataModel();
            this.activityInfo = activityInfo;
            this.resourceInfo = resourceInfo;
            this.categoryInfo = categoryInfo;
            this.indicatorInfo = indicatorInfo;
        }

        public String getName() {
            return this.name;
        }

        public Info<String> getActivityInfo() {
            return this.activityInfo;
        }

        public Info<Priority> getCategoryInfo() {
            return this.categoryInfo;
        }

        public ChartManager getChartManager() {
            return this.chartManager;
        }

        public Info<Indicator> getIndicatorInfo() {
            return this.indicatorInfo;
        }

        public Info<SimulationResource> getResourceInfo() {
            return this.resourceInfo;
        }

        public SimulationDataModel getSimulationDataModel() {
            return this.simulationDataModel;
        }
    }

    public static class Info<T> {
        private List<T> data = new ArrayList<T>();
        private boolean isFree = false;
        @NotNull
        private DetailOption type;

        public List<T> getData() {
            return this.data;
        }

        @NotNull
        public DetailOption getType() {
            return this.type;
        }

        public boolean isFree() {
            return this.isFree;
        }

        public boolean isSummary() {
            return this.type == DetailOption.SUMMARY_ALL || this.type == DetailOption.SUMMARY;
        }

        public void setData(List<T> data) {
            this.data = data;
        }

        public void setFree(boolean free) {
            this.isFree = free;
        }

        public void setType(@NotNull DetailOption type) {
            this.type = type;
        }
    }

    public static enum DetailOption {
        SUMMARY,
        SUMMARY_ALL,
        DETAILS;

    }
}

