/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.bam.chartviewer.ActivityCheckTree;
import oracle.bpm.bam.chartviewer.ActivityTreeToolBar;
import oracle.bpm.bam.chartviewer.ChartViewer;
import oracle.bpm.bam.chartviewer.ChartViewerUtils;
import oracle.bpm.bam.chartviewer.IndicatorSelections;
import oracle.bpm.bam.msg.BamMsg;
import oracle.bpm.bamdata.Indicator;
import oracle.bpm.bamdata.UnitType;
import oracle.bpm.draw.Color;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.SplitPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.CheckSelectionChangedEvent;
import oracle.bpm.ui.event.CheckSelectionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;

public class SimulationDataChooserPanel
extends Panel {
    private Panel activitiesPanel;
    private ComboBox<Integer> axisCombo;
    private ChartViewer chartViewer;
    private ScrollPane indicatorScrollPane;
    private ComboBox<UnitType> indicatorTypeCombo;
    private boolean loading = false;
    private ComboBox principal;
    private Panel resourcesPanel;
    private List<SimulationResource> selectedResources;
    private CheckSelectionListener treeListener;
    private ActivityCheckTree activityCheckTree;
    private ActivityTreeToolBar activityTreeToolBar;
    private static final String ACTIVITIES = "Act";
    private static final String RESOURCES = "Res";

    public SimulationDataChooserPanel(UiContainer parent, ChartViewer chartViewer) {
        super(parent);
        this.chartViewer = chartViewer;
        this.init();
    }

    private void init() {
        this.setLayout((Layout)new BorderLayout());
        SplitPane split = new SplitPane((UiContainer)this, 0);
        split.setResizeWeight(0.5);
        this.add((UiComponent)split, "Center");
        split.setLeftComponent(this.buildMainPanel());
        split.setRightComponent(this.buildIndicatorsPanel());
        this.initValues();
    }

    private UiComponent buildMainPanel() {
        this.treeListener = new CheckSelectionListener(){

            public void checkedSelectionChanged(CheckSelectionChangedEvent useless) {
                SimulationDataChooserPanel.this.chartViewer.refresh();
            }
        };
        Panel mainPanel = new Panel((UiContainer)this);
        mainPanel.setLayout((Layout)new BorderLayout());
        Panel header = new Panel((UiContainer)mainPanel);
        header.setLayout((Layout)new FlowLayout(3));
        this.principal = UiFactory.createComboBox((UiContainer)header, (Object[])new Msg[]{BamMsg.ACTIVITIES, BamMsg.RESOURCES});
        this.principal.setLabelProvider((LabelProvider)new LabelProvider<Msg>(){

            public Image getIcon(Msg element) {
                Msg msg = element == BamMsg.ACTIVITIES ? BamMsg.ACTIVITIES_SELECTION : BamMsg.RESOURCES_SELECTION;
                return Image.create((Msg)msg);
            }

            public String getText(Msg element) {
                return element.toString();
            }
        });
        this.axisCombo = UiFactory.createComboBox((UiContainer)header, (Object[])new Integer[]{0, 2});
        this.axisCombo.setLabelProvider((LabelProvider)new LabelProvider<Integer>(){

            public Image getIcon(Integer element) {
                return null;
            }

            public String getText(Integer element) {
                return (element == 0 ? BamMsg.X_AXIS : BamMsg.Z_AXIS).toString();
            }
        });
        this.axisCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Integer axis = (Integer)SimulationDataChooserPanel.this.axisCombo.getSelectedItem();
                boolean showActivities = SimulationDataChooserPanel.this.principal.getSelectedItem() == BamMsg.ACTIVITIES;
                SimulationDataChooserPanel.this.chartViewer.setShowOnAxis(axis, showActivities);
            }
        });
        header.add((UiComponent)Label.create((UiContainer)header, (Msg)BamMsg.SHOW));
        header.add((UiComponent)this.principal);
        header.add(this.axisCombo);
        final Panel card = new Panel((UiContainer)mainPanel);
        card.setBorder(BorderFactory.createLineBorder((Color)mainPanel.getBackground().darker()));
        final CardLayout cardLayout = new CardLayout();
        card.setLayout((Layout)cardLayout);
        card.add(this.createActivitiesPanel(card), (Object)ACTIVITIES);
        card.add(this.createResourcesPanel(card), (Object)RESOURCES);
        mainPanel.add((UiComponent)header, (Object)"North");
        mainPanel.add((UiComponent)card, (Object)"Center");
        ItemListener listener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean showActivities = SimulationDataChooserPanel.this.principal.getSelectedItem() == BamMsg.ACTIVITIES;
                cardLayout.show((UiContainer)card, showActivities ? SimulationDataChooserPanel.ACTIVITIES : SimulationDataChooserPanel.RESOURCES);
                Integer axis = (Integer)SimulationDataChooserPanel.this.axisCombo.getSelectedItem();
                SimulationDataChooserPanel.this.chartViewer.setShowOnAxis(axis, showActivities);
                SimulationDataChooserPanel.this.rebuildIndicators();
                SimulationDataChooserPanel.this.chartViewer.refresh();
            }
        };
        this.principal.addItemListener(listener);
        return mainPanel;
    }

    private void initValues() {
        this.loading = true;
        boolean canShowResources = ChartViewerUtils.areResourcesDefined(this.chartViewer.getChartManager());
        boolean isShowingResources = canShowResources && this.chartViewer.getChartManager().isResourceView();
        boolean containsResources = this.principal.containsItem((Object)BamMsg.RESOURCES);
        if (canShowResources && !containsResources) {
            this.principal.addItem((Object)BamMsg.RESOURCES);
        }
        if (!canShowResources && containsResources) {
            this.principal.removeItem((Object)BamMsg.RESOURCES);
        }
        this.principal.setSelectedItem((Object)(isShowingResources ? BamMsg.RESOURCES : BamMsg.ACTIVITIES));
        this.axisCombo.setSelectedItem((Object)this.chartViewer.getShowingAxis());
        UnitType selectedUnitType = this.chartViewer.getCurrentIndicatorProvider().getSelectedUnitType();
        this.indicatorTypeCombo.setSelectedItem((Object)selectedUnitType);
        this.loading = false;
    }

    private UiComponent createResourcesPanel(Panel card) {
        this.resourcesPanel = new Panel((UiContainer)card);
        this.resourcesPanel.setLayout((Layout)new BorderLayout());
        this.rebuildResourcesView();
        return this.resourcesPanel;
    }

    private void rebuildResourcesView() {
        Box view = Box.createHorizontalBox((UiContainer)this.resourcesPanel);
        Panel resourcesBox = new Panel((UiContainer)view);
        resourcesBox.setLayout((Layout)new BoxLayout((UiContainer)view, 1));
        resourcesBox.setOpaque(false);
        view.setBackground(Color.WHITE);
        view.add(Box.createHorizontalStrut((UiContainer)view, (int)5));
        view.add((UiComponent)resourcesBox);
        Collection<SimulationResource> resources = this.chartViewer.getChartManager().getResources();
        this.selectedResources = this.chartViewer.getChartManager().getSelectedResources();
        for (final SimulationResource resource : resources) {
            final CheckBox check = CheckBox.create((UiContainer)resourcesBox);
            check.setOpaque(false);
            check.setText(resource.getId());
            check.setSelected(this.selectedResources.contains(resource));
            resourcesBox.add((UiComponent)check);
            check.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (check.isSelected()) {
                        SimulationDataChooserPanel.this.selectedResources.add(resource);
                    } else {
                        SimulationDataChooserPanel.this.selectedResources.remove(resource);
                    }
                    SimulationDataChooserPanel.this.chartViewer.getChartManager().setSelectedResources(SimulationDataChooserPanel.this.selectedResources);
                    SimulationDataChooserPanel.this.chartViewer.refresh();
                }
            });
        }
        this.resourcesPanel.add((UiComponent)view, (Object)"Center");
    }

    private UiComponent createActivitiesPanel(Panel card) {
        this.activitiesPanel = new Panel((UiContainer)card);
        this.activitiesPanel.setLayout((Layout)new BorderLayout());
        this.activityTreeToolBar = new ActivityTreeToolBar((UiContainer)this.activitiesPanel);
        this.activitiesPanel.add((UiComponent)this.activityTreeToolBar, (Object)"North");
        this.rebuildActivitiesPanel();
        return this.activitiesPanel;
    }

    private void rebuildActivitiesPanel() {
        ScrollPane pane = new ScrollPane((UiContainer)this.activitiesPanel);
        this.activityCheckTree = ChartViewerUtils.createActivityCheckTree((UiContainer)pane, this.chartViewer.getChartManager(), this.treeListener);
        pane.setView((UiComponent)this.activityCheckTree);
        this.activityTreeToolBar.setTree(this.activityCheckTree);
        this.activitiesPanel.add((UiComponent)pane, (Object)"Center");
    }

    private UiComponent buildIndicatorsPanel() {
        Panel indicatorsPanel = new Panel((UiContainer)this);
        indicatorsPanel.setLayout((Layout)new BorderLayout());
        Panel header = new Panel((UiContainer)indicatorsPanel);
        indicatorsPanel.add((UiComponent)header, (Object)"North");
        this.indicatorScrollPane = new ScrollPane((UiContainer)indicatorsPanel);
        this.indicatorScrollPane.setBorder(BorderFactory.createLineBorder((Color)indicatorsPanel.getBackground().darker()));
        header.setLayout((Layout)new FlowLayout(3));
        ItemListener listener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SimulationDataChooserPanel.this.rebuildIndicators();
            }
        };
        header.add((UiComponent)Label.create((UiContainer)header, (Msg)BamMsg.INDICATORS));
        this.indicatorTypeCombo = UiFactory.createComboBox((UiContainer)header, (Object[])UnitType.values());
        this.indicatorTypeCombo.addItemListener(listener);
        header.add(this.indicatorTypeCombo);
        indicatorsPanel.add((UiComponent)this.indicatorScrollPane, (Object)"Center");
        return indicatorsPanel;
    }

    private RadioButton<UnitType> initRadio(UnitType unitType, ButtonGroup<RadioButton<UnitType>> group, Panel panel, ItemListener listener) {
        RadioButton radioButton = new RadioButton((UiContainer)panel, unitType.getMsg());
        radioButton.setItem((Object)unitType);
        radioButton.addItemListener(listener);
        panel.add((UiComponent)radioButton);
        group.add((AbstractButton)radioButton);
        return radioButton;
    }

    private void rebuildIndicators() {
        UnitType indicator = (UnitType)this.indicatorTypeCombo.getSelectedItem();
        Box view = Box.createHorizontalBox((UiContainer)this.indicatorScrollPane);
        view.setBackground(Color.WHITE);
        Panel boxPanel = new Panel((UiContainer)view);
        boxPanel.setLayout((Layout)new BoxLayout((UiContainer)view, 1));
        boxPanel.setOpaque(false);
        view.add(Box.createHorizontalStrut((UiContainer)view, (int)5));
        view.add((UiComponent)boxPanel);
        IndicatorSelections currentProvider = this.chartViewer.getCurrentIndicatorProvider();
        List<Indicator> indicators = this.filter(indicator.indicators(), this.chartViewer.getChartManager().isResourceView());
        ArrayList<Indicator> selected = new ArrayList<Indicator>(currentProvider.getSelectedIndicators(indicator));
        if (selected.size() == 0) {
            selected = null;
        }
        boolean first = true;
        for (final Indicator eachIndicator : indicators) {
            final CheckBox check = CheckBox.create((UiContainer)boxPanel, (Msg)eachIndicator.getMsg());
            check.setOpaque(false);
            boxPanel.add((UiComponent)check);
            check.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (check.isSelected()) {
                        SimulationDataChooserPanel.this.chartViewer.getCurrentIndicatorProvider().select(eachIndicator);
                    } else {
                        SimulationDataChooserPanel.this.chartViewer.getCurrentIndicatorProvider().unSelect(eachIndicator);
                    }
                    SimulationDataChooserPanel.this.chartViewer.refresh();
                }
            });
            if (selected == null || selected.contains(eachIndicator)) {
                check.setSelected(true);
            }
            if (!first) continue;
            currentProvider.selectUnique(eachIndicator);
            first = false;
        }
        this.indicatorScrollPane.setView((UiComponent)view);
    }

    private List<Indicator> filter(Indicator[] indicators, boolean resourceView) {
        ArrayList<Indicator> result = new ArrayList<Indicator>();
        for (Indicator indicator : indicators) {
            if ((!resourceView || !indicator.isResourceIndicator()) && (resourceView || indicator.isResourceIndicator())) continue;
            result.add(indicator);
        }
        return result;
    }
}

