/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.bam.chartviewer.IndicatorCheckTreeNode;
import oracle.bpm.bam.chartviewer.IndicatorSelections;
import oracle.bpm.bamdata.Indicator;
import oracle.bpm.bamdata.UnitType;
import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.tree.CheckTree;
import oracle.bpm.ui.tree.CheckTreeNode;
import oracle.bpm.ui.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class IndicatorsCheckTree
extends CheckTree {
    @NotNull
    private final IndicatorSelections indicatorSelections;
    private boolean selectionReady = false;

    private IndicatorsCheckTree(UiContainer parent, IndicatorCheckTreeNode root, IndicatorSelections indicatorSelections) {
        super(parent);
        this.setRoot((TreeNode)root);
        this.setExpandsSelectedPaths(true);
        this.setExactSize(Dimension.valueOf(200, 150));
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        this.indicatorSelections = indicatorSelections;
    }

    public static IndicatorsCheckTree createIndicatorsCheckTree(UiContainer parent, IndicatorCheckTreeNode root, IndicatorSelections indicatorSelections) {
        return new IndicatorsCheckTree(parent, root, indicatorSelections);
    }

    public static IndicatorsCheckTree createIndicatorsCheckTree(UiContainer parent, IndicatorSelections indicatorSelections, boolean resourceIndicators) {
        IndicatorsCheckTree tree = null;
        IndicatorCheckTreeNode allIndicatorRoot = IndicatorCheckTreeNode.createAllRootNode(indicatorSelections, tree);
        tree = IndicatorsCheckTree.createIndicatorsCheckTree(parent, allIndicatorRoot, indicatorSelections);
        CheckTreeNode rootNode = tree.getRoot();
        UnitType[] types = UnitType.values();
        ArrayList<IndicatorCheckTreeNode> unitList = new ArrayList<IndicatorCheckTreeNode>();
        for (UnitType unitType : types) {
            IndicatorCheckTreeNode unitNode = IndicatorCheckTreeNode.createUnitRootNode(unitType, indicatorSelections, tree);
            Indicator[] indicators = unitType.indicators();
            unitList.add(unitNode);
            ArrayList<IndicatorCheckTreeNode> unitChildrenList = new ArrayList<IndicatorCheckTreeNode>();
            for (Indicator indicator : indicators) {
                if (!resourceIndicators && indicator.isResourceIndicator() || resourceIndicators && !indicator.isResourceIndicator()) continue;
                IndicatorCheckTreeNode indicatorNode = new IndicatorCheckTreeNode(indicator, null, indicatorSelections, tree, indicatorSelections.isSelected(indicator));
                unitChildrenList.add(indicatorNode);
            }
            unitNode.addAll(unitChildrenList);
        }
        rootNode.addAll(unitList);
        tree.reload();
        return tree;
    }

    public List<Indicator> getSelectedIndicators() {
        return this.indicatorSelections.getSelectedIndicators();
    }

    public void setSelectionReady(boolean selectionReady) {
        this.selectionReady = selectionReady;
    }

    public boolean isSelectionReady() {
        return this.selectionReady;
    }
}

