/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import java.util.List;
import oracle.bpm.bam.chartviewer.IndicatorMatrixEvaluator;
import oracle.bpm.bam.chartviewer.MatrixEvaluator;
import oracle.bpm.bam.chartviewer.MatrixEvaluatorImpl;
import oracle.bpm.bam.chartviewer.SingleIndicatorMatrixEvaluator;
import oracle.bpm.bamdata.Indicator;
import oracle.bpm.bamdata.RunningInfo;
import oracle.bpm.bamdata.UnitType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.table.AbstractTableModel;

class ChartTableModel
extends AbstractTableModel {
    private boolean inverColumnNames = false;
    private MatrixEvaluator matrixEvaluator = new EmptyMatrixEvaluator();
    private double multiplier = 1.0;
    private int oldIndicatorsHash;
    private boolean rotate = false;
    static final long serialVersionUID = -2367944947100523009L;
    static final long serialCheck = 1279896877870295023L;

    public void createMatrix(RunningInfo[] shown, Msg title, String[] names, List selectedIndicators, boolean rotate) {
        this.setMatrix(new IndicatorMatrixEvaluator(shown, title, names, selectedIndicators, rotate));
    }

    public void createMatrix(RunningInfo[][] shown, Msg title, Object[] rowNames, Object[] columnNames, Indicator selectedIndicator, boolean rotate) {
        this.setMatrix(new SingleIndicatorMatrixEvaluator(shown, title, rowNames, columnNames, selectedIndicator, rotate));
    }

    public Class getColumnClass(int i) {
        if (i != 0) {
            return Double.class;
        }
        return super.getColumnClass(i);
    }

    public int getColumnCount() {
        if (this.rotate) {
            return this.matrixEvaluator.getRowCount();
        }
        return this.matrixEvaluator.getColumnCount();
    }

    public Object[] getColumnData(int index) {
        Object[] c = new Object[this.getRowCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            c[i] = this.getValueAt(i, index);
        }
        return c;
    }

    public String getColumnName(int columnIndex) {
        if (this.rotate) {
            return this.matrixEvaluator.getValueAt(columnIndex, 0).toString();
        }
        return this.matrixEvaluator.getValueAt(0, columnIndex).toString();
    }

    public Object getFormatedValueAt(int rowIndex, int columnIndex) {
        Object value = this.getValueAt(rowIndex, columnIndex);
        if (value instanceof Double) {
            Double dValue = (Double)value;
            value = (double)((int)(dValue * 100.0 + 0.5)) / 100.0;
        }
        return value;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public int getRowCount() {
        if (this.rotate) {
            return this.matrixEvaluator.getColumnCount() > 0 ? this.matrixEvaluator.getColumnCount() - 1 : 0;
        }
        return this.matrixEvaluator.getRowCount() > 0 ? this.matrixEvaluator.getRowCount() - 1 : 0;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object obj;
        if (this.inverColumnNames && columnIndex == 0) {
            rowIndex = this.getRowCount() - 1 - rowIndex;
        }
        if ((obj = this.rotate ? this.matrixEvaluator.getValueAt(columnIndex, rowIndex + 1) : this.matrixEvaluator.getValueAt(rowIndex + 1, columnIndex)) instanceof Double) {
            obj = (Double)obj * this.multiplier;
        }
        return obj;
    }

    public boolean isInverColumnNames() {
        return this.inverColumnNames;
    }

    public boolean isRotate() {
        return this.rotate;
    }

    public void reset() {
        this.setMatrix(new EmptyMatrixEvaluator());
    }

    public void rotate(boolean rotate) {
        this.rotate = rotate;
    }

    public void setInverColumnNames(boolean inverColumnNames) {
        this.inverColumnNames = inverColumnNames;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public void setUnitView(UnitType unitView) {
        this.setMultiplier(unitView == UnitType.TIME ? 1000.0 : 1.0);
    }

    protected void setMatrix(MatrixEvaluator m) {
        int indicatorsHash;
        MatrixEvaluator oldMatrixEvaluator = this.matrixEvaluator;
        this.matrixEvaluator = m;
        int n = indicatorsHash = m.getSelectedIndicators() != null ? ((Object)m.getSelectedIndicators()).hashCode() : 0;
        if (this.matrixEvaluator.getColumnCount() == 0 || this.matrixEvaluator.getRowCount() == 0) {
            this.matrixEvaluator = new EmptyMatrixEvaluator();
        }
        if (this.oldIndicatorsHash != indicatorsHash || !this.matrixEvaluator.isEquivalentTo(oldMatrixEvaluator)) {
            this.fireTableStructureChanged();
        }
        this.fireTableDataChanged();
        this.oldIndicatorsHash = indicatorsHash;
    }

    MatrixEvaluator getMatrixEvaluator() {
        return this.matrixEvaluator;
    }

    private static class EmptyMatrixEvaluator
    extends MatrixEvaluatorImpl {
        private EmptyMatrixEvaluator() {
        }

        @Override
        public int getColumnCount() {
            return 0;
        }

        @Override
        public int getRowCount() {
            return 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return null;
        }

        @Override
        public List getSelectedIndicators() {
            return null;
        }
    }
}

