/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import oracle.bpm.bam.chartviewer.ChartInterface;
import oracle.bpm.bam.chartviewer.FontHelper;
import oracle.bpm.chart.BasicChartComponent;
import oracle.bpm.chart.resources.appearance.TitleAppearance;
import oracle.bpm.chart.shared.events.ChartDataEventArgs;
import oracle.bpm.chart.shared.styles.ChartType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiContainer;

public class Chart
extends BasicChartComponent
implements ChartInterface {
    private ChartType chartType;
    private Msg titleTop;

    public Chart(UiContainer parent) {
        super(parent);
    }

    @Override
    public void setToolTip(String formatString) {
        this.getTooltips().setFormat(4);
        this.getTooltips().setFormatString(formatString);
    }

    @Override
    public void setType(ChartType chartType) {
        this.chartType = chartType;
        this.setChartType(chartType);
    }

    @Override
    public ChartType getType() {
        return this.chartType;
    }

    public void dataClick() {
        ChartDataEventArgs dummy = new ChartDataEventArgs(0, 0, (Object)0, "", "");
        ChartDataEventArgs[] points = new ChartDataEventArgs[]{dummy};
        this.fireEvent(points, 0);
    }

    @Override
    public void setTitleTopMsg(Msg msg, int fontDelta) {
        this.titleTop = msg;
        TitleAppearance titleAppearance = this.getTitleTop();
        if (titleAppearance == null) {
            titleAppearance = new TitleAppearance();
        }
        titleAppearance.setText(msg == null ? "" : msg.getString());
        titleAppearance.setHorizontalAlign(2);
        titleAppearance.setFont(FontHelper.adjustFont(titleAppearance.getFont(), fontDelta));
        this.setTitleTop(titleAppearance);
    }

    @Override
    public Msg getTitleTopMsg() {
        return this.titleTop;
    }

    @Override
    public void setTitleBottomMsg(Msg msg, int fontDelta) {
        TitleAppearance titleAppearance = this.getTitleBottom();
        if (titleAppearance == null) {
            titleAppearance = new TitleAppearance();
        }
        titleAppearance.setFont(FontHelper.adjustFont(titleAppearance.getFont(), fontDelta));
        titleAppearance.setText(msg == null ? "" : msg.getString());
        titleAppearance.setHorizontalAlign(0);
        this.setTitleBottom(titleAppearance);
    }
}

