/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bam.chartviewer;

import java.util.List;
import oracle.bpm.bam.chartviewer.CategoryCheckTree;
import oracle.bpm.project.Priority;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.tree.CheckTreeNode;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;

public class CategoryCheckTreeNode
extends CheckTreeNode {
    private boolean isRoot;

    public CategoryCheckTreeNode(Object value, Image icon, CategoryCheckTree tree) {
        super(value);
        super.setIcon(icon);
        this.setTree((Tree)tree);
    }

    public static CategoryCheckTreeNode createRootNode(Object value, Image icon, CategoryCheckTree tree) {
        CategoryCheckTreeNode categoryCheckTreeNode = new CategoryCheckTreeNode(value, icon, tree);
        categoryCheckTreeNode.isRoot = true;
        return categoryCheckTreeNode;
    }

    public void setSelected(TreeNode.Selection selection) {
        super.setSelected(selection);
        if (this.isRoot) {
            if (selection == TreeNode.Selection.ALL) {
                this.getTree().selectAllCategories();
            } else if (selection == TreeNode.Selection.NONE) {
                this.getTree().getSelectedCategories().clear();
            }
        } else if (this.getUserObject() instanceof Priority) {
            List<Priority> selectedCategories = this.getTree().getSelectedCategories();
            if (selection == TreeNode.Selection.ALL) {
                if (!selectedCategories.contains(this.getUserObject())) {
                    selectedCategories.add((Priority)this.getUserObject());
                }
            } else if (selection == TreeNode.Selection.NONE) {
                selectedCategories.remove(this.getUserObject());
            }
        }
    }

    public String toString() {
        Object userObject = this.getUserObject();
        if (userObject instanceof Priority) {
            return ((Priority)userObject).getMsg().getString();
        }
        return super.toString();
    }

    public CategoryCheckTree getTree() {
        return (CategoryCheckTree)super.getTree();
    }
}

