/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.update;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.PersistenceException;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.MetadataExceptionFactory;
import oracle.bpm.metadata.history.Criteria;
import oracle.bpm.metadata.history.HistoryService;
import oracle.bpm.metadata.history.exceptions.HistoryException;
import oracle.bpm.metadata.history.file.scanner.ChangedFileHelper;
import oracle.bpm.metadata.history.model.Change;
import oracle.bpm.metadata.history.model.ChangeAction;
import oracle.bpm.metadata.history.model.ChangedFile;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.metadata.update.PropertyKeys;
import oracle.bpm.metadata.update.UpdateResult;
import oracle.bpm.metadata.update.impl.UpdateResultImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateFromBaseTemplateHelper {
    public static MetadataType writeTemplateRevisionProperties(@NotNull HistoryService historyService, @NotNull String id, @NotNull MetadataType metadata, @NotNull Date date, @Nullable String oldHumanRevisionId) throws HistoryException, PersistenceException {
        if (historyService == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/update/UpdateFromBaseTemplateHelper.writeTemplateRevisionProperties must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/update/UpdateFromBaseTemplateHelper.writeTemplateRevisionProperties must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/update/UpdateFromBaseTemplateHelper.writeTemplateRevisionProperties must not be null");
        }
        if (date == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/metadata/update/UpdateFromBaseTemplateHelper.writeTemplateRevisionProperties must not be null");
        }
        Criteria criteria = new Criteria();
        criteria.setProjectId(id);
        criteria.setFromTimestamp(date);
        List retrievedChanges = historyService.listHistoryChanges(criteria, null);
        MetadataType.Properties.Property historyRevisionIdProperty = MetadataArtifactHelper.findProperty(metadata, PropertyKeys.HISTORY_REVISION_ID.getKey());
        MetadataType.Properties.Property humanRevisionNumberProperty = MetadataArtifactHelper.findProperty(metadata, PropertyKeys.HUMAN_REVISION_ID.getKey());
        if (metadata.getProperties() == null) {
            metadata.setProperties(new MetadataType.Properties());
        }
        if (historyRevisionIdProperty == null) {
            historyRevisionIdProperty = new MetadataType.Properties.Property();
            historyRevisionIdProperty.setKey(PropertyKeys.HISTORY_REVISION_ID.getKey());
        }
        String revisionIdProperty = "";
        if (!retrievedChanges.isEmpty()) {
            revisionIdProperty = Long.valueOf(((Change)retrievedChanges.get(0)).getChangeDate().getTime()).toString();
        }
        historyRevisionIdProperty.setValue(revisionIdProperty);
        metadata.getProperties().getProperty().add(historyRevisionIdProperty);
        if (humanRevisionNumberProperty == null) {
            humanRevisionNumberProperty = new MetadataType.Properties.Property();
            humanRevisionNumberProperty.setKey(PropertyKeys.HUMAN_REVISION_ID.getKey());
        }
        int humanRevisionId = 0;
        if (oldHumanRevisionId != null) {
            humanRevisionId = Integer.valueOf(oldHumanRevisionId) + 1;
        }
        humanRevisionNumberProperty.setValue(Integer.valueOf(humanRevisionId).toString());
        metadata.getProperties().getProperty().add(humanRevisionNumberProperty);
        return metadata;
    }

    public static MetadataType writePublicShareRevisionProperties(@NotNull MetadataType metadata, @NotNull String templateHistoryRevisionId, @NotNull String templateHumanRevisionId, @Nullable String baseTemplateId) throws PersistenceException {
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/update/UpdateFromBaseTemplateHelper.writePublicShareRevisionProperties must not be null");
        }
        if (templateHistoryRevisionId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/update/UpdateFromBaseTemplateHelper.writePublicShareRevisionProperties must not be null");
        }
        if (templateHumanRevisionId == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/update/UpdateFromBaseTemplateHelper.writePublicShareRevisionProperties must not be null");
        }
        MetadataType.Properties.Property historyRevisionIdProperty = MetadataArtifactHelper.findProperty(metadata, PropertyKeys.HISTORY_REVISION_ID.getKey());
        MetadataType.Properties.Property humanRevisionNumberProperty = MetadataArtifactHelper.findProperty(metadata, PropertyKeys.HUMAN_REVISION_ID.getKey());
        if (metadata.getProperties() == null) {
            metadata.setProperties(new MetadataType.Properties());
        }
        if (historyRevisionIdProperty == null) {
            historyRevisionIdProperty = new MetadataType.Properties.Property();
            historyRevisionIdProperty.setKey(PropertyKeys.HISTORY_REVISION_ID.getKey());
        }
        historyRevisionIdProperty.setValue(templateHistoryRevisionId);
        metadata.getProperties().getProperty().add(historyRevisionIdProperty);
        if (humanRevisionNumberProperty == null) {
            humanRevisionNumberProperty = new MetadataType.Properties.Property();
            humanRevisionNumberProperty.setKey(PropertyKeys.HUMAN_REVISION_ID.getKey());
        }
        humanRevisionNumberProperty.setValue(templateHumanRevisionId);
        metadata.getProperties().getProperty().add(humanRevisionNumberProperty);
        if (baseTemplateId != null) {
            MetadataType.Properties.Property baseTemplateIdProperty = MetadataArtifactHelper.findProperty(metadata, PropertyKeys.BASE_TEMPLATE_ID.getKey());
            if (baseTemplateIdProperty == null) {
                baseTemplateIdProperty = new MetadataType.Properties.Property();
                baseTemplateIdProperty.setKey(PropertyKeys.BASE_TEMPLATE_ID.getKey());
            }
            baseTemplateIdProperty.setValue(baseTemplateId);
            metadata.getProperties().getProperty().add(baseTemplateIdProperty);
        }
        return metadata;
    }

    public static Map<String, ChangedFile> calculateFilesToBeUpdated(@NotNull Map<String, String> publicShareHashes, @NotNull Map<String, String> templateHashes, @NotNull List<Change> changes) throws HistoryException {
        if (publicShareHashes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/update/UpdateFromBaseTemplateHelper.calculateFilesToBeUpdated must not be null");
        }
        if (templateHashes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/update/UpdateFromBaseTemplateHelper.calculateFilesToBeUpdated must not be null");
        }
        if (changes == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/update/UpdateFromBaseTemplateHelper.calculateFilesToBeUpdated must not be null");
        }
        HashMap<String, ChangedFile> resultMap = new HashMap<String, ChangedFile>();
        HashMap<String, String> copyOfPublicShareHashes = new HashMap<String, String>(publicShareHashes);
        Map<String, ChangedFile> filesChangedByUser = UpdateFromBaseTemplateHelper.calculateFilesChangedByUser(templateHashes, copyOfPublicShareHashes);
        for (int i = changes.size() - 1; i >= 0; --i) {
            List changedFiles = changes.get(i).getFilesChanged();
            for (ChangedFile changedFile : changedFiles) {
                if (filesChangedByUser.containsKey(changedFile.getCanonicalPath())) continue;
                ChangedFile resultChangedFile = (ChangedFile)resultMap.get(changedFile.getCanonicalPath());
                if (resultChangedFile != null) {
                    if (resultChangedFile.getChangeAction().equals((Object)ChangeAction.ADDED) && changedFile.getChangeAction().equals((Object)ChangeAction.MODIFIED)) continue;
                    if (resultChangedFile.getChangeAction().equals((Object)ChangeAction.ADDED) && changedFile.getChangeAction().equals((Object)ChangeAction.DELETED)) {
                        resultMap.remove(resultChangedFile.getCanonicalPath());
                        continue;
                    }
                }
                resultMap.put(changedFile.getCanonicalPath(), changedFile);
            }
        }
        return resultMap;
    }

    public static Map<String, ChangedFile> calculateFilesChangedByUser(@NotNull Map<String, String> templateHashes, @NotNull Map<String, String> publicShareHashes) {
        if (templateHashes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/update/UpdateFromBaseTemplateHelper.calculateFilesChangedByUser must not be null");
        }
        if (publicShareHashes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/update/UpdateFromBaseTemplateHelper.calculateFilesChangedByUser must not be null");
        }
        HashMap<String, ChangedFile> filesChangedByUser = new HashMap<String, ChangedFile>();
        for (String templateHashKey : templateHashes.keySet()) {
            String publicShareValue = publicShareHashes.remove(templateHashKey);
            if (publicShareValue != null && publicShareValue.equals(templateHashes.get(templateHashKey))) continue;
            filesChangedByUser.put(templateHashKey, new ChangedFile(ChangeAction.NOT_UPDATED_CHANGED_BY_USER, templateHashKey));
        }
        for (String publicShareHashKey : publicShareHashes.keySet()) {
            filesChangedByUser.put(publicShareHashKey, new ChangedFile(ChangeAction.NOT_UPDATED_CHANGED_BY_USER, publicShareHashKey));
        }
        return filesChangedByUser;
    }

    public static UpdateResult calculateFilesToBeUpdated(@NotNull HistoryService historyService, @NotNull PublicShareProject publicShare) throws MetadataException {
        if (historyService == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/update/UpdateFromBaseTemplateHelper.calculateFilesToBeUpdated must not be null");
        }
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/update/UpdateFromBaseTemplateHelper.calculateFilesToBeUpdated must not be null");
        }
        UpdateResultImpl updateResult = new UpdateResultImpl();
        String actualRevisionId = publicShare.getProperty(PropertyKeys.HISTORY_REVISION_ID.getKey());
        String baseTemplateId = publicShare.getProperty(PropertyKeys.BASE_TEMPLATE_ID.getKey());
        if (actualRevisionId == null || baseTemplateId == null) {
            throw MetadataExceptionFactory.createUnableToUpdateFromBaseTemplate((String)publicShare.getName());
        }
        long actualRevisionDate = Long.parseLong(actualRevisionId);
        try {
            VFileSystem projectFileSystem = publicShare.getProject().get().getLoader().getProjectFileSystem().getDataFileSystem();
            Map<String, String> publicShareHashes = ChangedFileHelper.calculateHashes(projectFileSystem.getRoot());
            Criteria criteria = new Criteria();
            criteria.setProjectId(baseTemplateId);
            criteria.setFromTimestamp(new Date(actualRevisionDate));
            criteria.setProjectType(ProjectType.TEMPLATE.value());
            List retrievedChanges = historyService.listHistoryChanges(criteria, null);
            Change firstChange = (Change)retrievedChanges.remove(retrievedChanges.size() - 1);
            Map templateHashes = firstChange.getHistoryProjectMetadata().getFilesHashes();
            Map<String, ChangedFile> filesToBeUpdatedMap = UpdateFromBaseTemplateHelper.calculateFilesToBeUpdated(publicShareHashes, templateHashes, retrievedChanges);
            ArrayList<ChangedFile> filesToBeUpdated = new ArrayList<ChangedFile>(filesToBeUpdatedMap.values());
            updateResult.setUpdatedFiles(filesToBeUpdated);
            ArrayList<ChangedFile> filesNotToBeUpdated = new ArrayList<ChangedFile>();
            Map<String, ChangedFile> filesChangedByUser = UpdateFromBaseTemplateHelper.calculateFilesChangedByUser(templateHashes, publicShareHashes);
            filesNotToBeUpdated.addAll(filesChangedByUser.values());
            Collection vFilesNotToBeUpdated = VFileUtils.getFilesRecursively((VFile)projectFileSystem.getRoot(), (VFileFilter)new ExcludeFilesVFilter(filesToBeUpdatedMap));
            for (VFile vFile : vFilesNotToBeUpdated) {
                if (vFile.isDirectory() || filesChangedByUser.containsKey(vFile.getCanonicalPath())) continue;
                ChangedFile newChangedFile = new ChangedFile(ChangeAction.NOT_UPDATED_NO_NEW_VERSION, vFile.getCanonicalPath());
                filesNotToBeUpdated.add(newChangedFile);
            }
            updateResult.setNotUpdatedFiles(filesNotToBeUpdated);
        }
        catch (IOException e) {
            throw MetadataExceptionFactory.createUnableToUpdateFromBaseTemplate((String)publicShare.getId());
        }
        return updateResult;
    }

    public static MetadataType breakPublicShareLink(@NotNull MetadataType metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/update/UpdateFromBaseTemplateHelper.breakPublicShareLink must not be null");
        }
        List<MetadataType.Properties.Property> properties = metadata.getProperties().getProperty();
        MetadataType.Properties.Property baseTemplateIdProperty = MetadataArtifactHelper.findProperty(metadata, PropertyKeys.BASE_TEMPLATE_ID.getKey());
        properties.remove(baseTemplateIdProperty);
        MetadataType.Properties.Property historyRevisionIdProperty = MetadataArtifactHelper.findProperty(metadata, PropertyKeys.HISTORY_REVISION_ID.getKey());
        properties.remove(historyRevisionIdProperty);
        MetadataType.Properties.Property humanRevisionNumberProperty = MetadataArtifactHelper.findProperty(metadata, PropertyKeys.HUMAN_REVISION_ID.getKey());
        properties.remove(humanRevisionNumberProperty);
        return metadata;
    }

    public static class ExcludeFilesVFilter
    implements VFileFilter {
        private Map<String, ChangedFile> excludedFiles;

        public ExcludeFilesVFilter(Map<String, ChangedFile> excludedFiles) {
            this.excludedFiles = excludedFiles;
        }

        public boolean accept(@NotNull VFile pathname) {
            if (pathname == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/update/UpdateFromBaseTemplateHelper$ExcludeFilesVFilter.accept must not be null");
            }
            return this.excludedFiles.get(pathname.getCanonicalPath()) == null;
        }
    }
}

