/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.persistence;

import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.msg.MetadataMsg;
import oracle.bpm.metadata.persistence.ArtifactLocationMismatchException;
import oracle.bpm.resources.ErrorMsg;
import org.jetbrains.annotations.NotNull;

public class PersistenceException
extends MetadataException {
    private static final long serialVersionUID = -8745552375060873278L;

    public PersistenceException(Throwable exc) {
        super(MetadataMsg.METADATA_EXCEPTION, exc);
    }

    protected PersistenceException(ErrorMsg msg) {
        super(msg);
    }

    private PersistenceException(ErrorMsg msg, Throwable exc) {
        super(msg, exc);
    }

    public static PersistenceException createInvalidNamespaceException(@NotNull Throwable e, @NotNull String namespace) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createInvalidNamespaceException must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createInvalidNamespaceException must not be null");
        }
        return new PersistenceException(MetadataMsg.INVALID_NAMESPACE((String)namespace), e);
    }

    public static PersistenceException createVersioningNotSupportedException(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createVersioningNotSupportedException must not be null");
        }
        return new PersistenceException(MetadataMsg.VERSIONING_NOT_SUPPORTED, e);
    }

    public static PersistenceException createMultipleLabelsException(@NotNull Throwable e, @NotNull String namespace) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createMultipleLabelsException must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createMultipleLabelsException must not be null");
        }
        return new PersistenceException(MetadataMsg.MULTIPLE_LABELS((String)namespace), e);
    }

    public static PersistenceException createLabelNotFoundException(@NotNull Throwable e, @NotNull String label) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createLabelNotFoundException must not be null");
        }
        if (label == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createLabelNotFoundException must not be null");
        }
        return new PersistenceException(MetadataMsg.LABEL_NOT_FOUND((String)label), e);
    }

    public static PersistenceException createIOException(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createIOException must not be null");
        }
        return new PersistenceException(MetadataMsg.PML_IO_ERROR, e);
    }

    public static PersistenceException createTxRollbackedException() {
        return new PersistenceException(MetadataMsg.ROLLBACKED_TRANSACTION);
    }

    public static PersistenceException createNoActiveTransactionException() {
        return new PersistenceException(MetadataMsg.NO_ACTIVE_TRANSACTIONS);
    }

    public static PersistenceException createErrorCopyException() {
        return new PersistenceException(MetadataMsg.COPY_FILE_ERROR);
    }

    public static PersistenceException createProjectException(@NotNull String location, @NotNull Throwable e) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createProjectException must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createProjectException must not be null");
        }
        return new PersistenceException(MetadataMsg.PROJECT_NOT_FOUND((String)location), e);
    }

    public static PersistenceException createInvalidPathException(@NotNull String path, @NotNull Throwable exc) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createInvalidPathException must not be null");
        }
        if (exc == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createInvalidPathException must not be null");
        }
        return new PersistenceException(MetadataMsg.INVALID_PATH((String)path), exc);
    }

    public static PersistenceException createArtifactNotFoundException(@NotNull String path, @NotNull Throwable exc) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createArtifactNotFoundException must not be null");
        }
        if (exc == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createArtifactNotFoundException must not be null");
        }
        return new PersistenceException(MetadataMsg.ARTIFACT_NOT_FOUND((String)path), exc);
    }

    public static PersistenceException createArtifactAlreadyExistsException(@NotNull String path, @NotNull Throwable exc) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createArtifactAlreadyExistsException must not be null");
        }
        if (exc == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createArtifactAlreadyExistsException must not be null");
        }
        return new PersistenceException(MetadataMsg.ARTIFACT_ALREADY_EXISTS((String)path), exc);
    }

    public static ArtifactLocationMismatchException createArtifactLocationMismatchException(@NotNull String artifactName) {
        if (artifactName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createArtifactLocationMismatchException must not be null");
        }
        return new ArtifactLocationMismatchException(artifactName);
    }

    public static PersistenceException createMdsIOException(@NotNull String path, @NotNull Throwable exc) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createMdsIOException must not be null");
        }
        if (exc == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createMdsIOException must not be null");
        }
        return new PersistenceException(MetadataMsg.PML_FATAL_ERROR((String)path), exc);
    }

    public static PersistenceException createMdsIOException(@NotNull Throwable exc) {
        if (exc == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createMdsIOException must not be null");
        }
        return new PersistenceException(MetadataMsg.PML_IO_ERROR, exc);
    }

    public static PersistenceException createPackageAlreadyExists(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/persistence/PersistenceException.createPackageAlreadyExists must not be null");
        }
        return new PersistenceException(MetadataMsg.PACKAGE_ALREADY_EXISTS((String)path));
    }
}

