/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.mock.persistence;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.collections.Predicate;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.artifact.jaxb.Filesystem;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.artifact.jaxb.PublicShareMetadata;
import oracle.bpm.metadata.artifact.jaxb.Topology;
import oracle.bpm.metadata.entity.DraftProject;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.impl.ProjectArtifactFactory;
import oracle.bpm.metadata.lock.jaxb.LockType;
import oracle.bpm.metadata.mds.BPMLabels;
import oracle.bpm.metadata.persistence.MdPersistence;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.bpm.project.io.fs.FileProjectRepository;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockMdPersistence
implements MdPersistence {
    private FileProjectRepository templateRepository;
    private File workspace = null;

    public MockMdPersistence() {
        String workspaceDir = System.getProperty("metadata.mock.workspacedir");
        assert (workspaceDir != null) : "System property 'metadata.mock.workspacedir' is missing";
        this.workspace = new File(workspaceDir);
        File templateFolder = new File(this.workspace, BPMLabels.TEMPLATES.getLabel());
        templateFolder.mkdirs();
        this.templateRepository = FileProjectRepository.create(templateFolder);
    }

    @Override
    public <T extends MdProject> LocalRef<T> loadMdProject(@NotNull Class<T> clazz, @NotNull String projectLocation, boolean reload) throws PersistenceException {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.loadMdProject must not be null");
        }
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.loadMdProject must not be null");
        }
        if (!clazz.equals(TemplateProject.class)) {
            throw new UnsupportedOperationException("Type '" + clazz.getName() + "' not supported for Mock.");
        }
        MetadataType metadata = new MetadataType();
        metadata.setName(projectLocation);
        metadata.setProjectType(ProjectType.TEMPLATE);
        T artifact = ProjectArtifactFactory.create(clazz, projectLocation, this, metadata);
        return new LocalRef<T>(metadata.getName(), artifact);
    }

    @Override
    public void prepareProjectToDeploy(@NotNull PublicShareProject publicShare, @NotNull String workflowTicket, @NotNull ProjectFolder folder) throws PersistenceException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.prepareProjectToDeploy must not be null");
        }
        if (workflowTicket == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.prepareProjectToDeploy must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.prepareProjectToDeploy must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends MdProject, K extends ProjectArtifact> T findProjectByName(@NotNull Class<T> mdType, @Nullable LocalRef<K> parent, @NotNull String name, boolean includeFolders) throws PersistenceException {
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.findProjectByName must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.findProjectByName must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends MdProject, K extends ProjectArtifact> Collection<LocalRef<T>> find(@NotNull Class<T> type, @Nullable LocalRef<K> parent, @Nullable Predicate<T> predicate, boolean includeFolders) throws PersistenceException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.find must not be null");
        }
        if (!TemplateProject.class.equals(type)) {
            throw new UnsupportedOperationException("Type '" + type.getName() + "' not supported for Mock.");
        }
        File baseDir = this.templateRepository.getDefaultBaseDir();
        ArrayList<LocalRef<T>> ret = new ArrayList<LocalRef<T>>();
        Collection<File> files = this.listFiles(baseDir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jpr") && !pathname.getName().startsWith(".svn");
            }
        }, true);
        for (File file : files) {
            if (!file.isFile()) continue;
            File parentFile = file.getParentFile();
            String projectName = parentFile.getName();
            MetadataType metadata = new MetadataType();
            metadata.setName(projectName);
            metadata.setProjectType(ProjectType.TEMPLATE);
            Topology topology = new Topology();
            Filesystem fs = new Filesystem();
            fs.setSimpleFilesystem("/bpm/templates/");
            topology.setFilesystem(fs);
            metadata.setTopology(topology);
            T artifact = ProjectArtifactFactory.create(type, "/bpm/templates/", this, metadata);
            if (predicate != null && !predicate.check(artifact)) continue;
            ret.add(new LocalRef<T>(projectName, artifact));
        }
        return ret;
    }

    @Override
    public <T extends MdProject> LocalRef<T> getMdProject(@NotNull Class<T> type, @NotNull String projectLocation, @NotNull MetadataType metadata) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.getMdProject must not be null");
        }
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.getMdProject must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.getMdProject must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends MdProject, K extends ProjectArtifact> MdTree browse(@NotNull Class<T> type, @Nullable LocalRef<K> parent, @Nullable Predicate<T> predicate, boolean includeFolders) throws PersistenceException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.browse must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends MdProject> MdTree browseFolders(@NotNull Class<T> mdType) throws PersistenceException {
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.browseFolders must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends MdProject> MdTree browseFolders(@NotNull Class<T> mdType, @Nullable Predicate<String> predicate) throws PersistenceException {
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.browseFolders must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public LocalRef<Project> loadProject(@NotNull MetadataType metadata) throws MetadataException {
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.loadProject must not be null");
        }
        if (metadata.getProjectType() == null || metadata.getProjectType() != ProjectType.TEMPLATE) {
            throw new UnsupportedOperationException("Type '" + (Object)((Object)metadata.getProjectType()) + "' not supported for Mock.");
        }
        Project project = this.templateRepository.getProject(metadata.getName());
        if (project == null) {
            try {
                project = this.templateRepository.create(metadata.getName());
            }
            catch (ProjectException e) {
                throw new MetadataException((Throwable)e);
            }
        }
        return new LocalRef<Project>(metadata.getName(), project);
    }

    @Override
    public void saveMdProject(@NotNull MdProject mdProject, @NotNull ProjectType projectType) throws PersistenceException {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.saveMdProject must not be null");
        }
        if (projectType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.saveMdProject must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends MdProject> MetadataType saveMdProject(@NotNull Class<T> type, @NotNull String name, @Nullable String description, @NotNull String absoluteLocation, @NotNull Project sourceProject, @NotNull VFileSystem targetFs) throws PersistenceException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.saveMdProject must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.saveMdProject must not be null");
        }
        if (absoluteLocation == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.saveMdProject must not be null");
        }
        if (sourceProject == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.saveMdProject must not be null");
        }
        if (targetFs == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.saveMdProject must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public PublicShareProject createPublicShareProject(@NotNull PublicShareProject publicShare, @NotNull String absoluteLocation, @NotNull VFileSystem targetFs, @Nullable PublicShareMetadata metadataType) throws PersistenceException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.createPublicShareProject must not be null");
        }
        if (absoluteLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.createPublicShareProject must not be null");
        }
        if (targetFs == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.createPublicShareProject must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public DraftProject createDraftProject(@NotNull PublicShareProject publicShareProject, @NotNull String username) throws PersistenceException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.createDraftProject must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.createDraftProject must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends MdProject> boolean existsFolder(@NotNull Class<T> context, @NotNull ProjectFolder location) throws PersistenceException {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.existsFolder must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.existsFolder must not be null");
        }
        File templateFolder = new File(this.workspace, BPMLabels.TEMPLATES.getLabel());
        return new File(templateFolder, location.getLocation()).exists();
    }

    @Override
    public <T extends MdProject> boolean existsProject(@NotNull Class<T> context, @NotNull ProjectFolder location) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.existsProject must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.existsProject must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends MdProject> void createFolder(@NotNull Class<T> context, @NotNull ProjectFolder location) throws PersistenceException {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.createFolder must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.createFolder must not be null");
        }
        File templateFolder = new File(this.workspace, BPMLabels.TEMPLATES.getLabel());
        File newFolder = new File(templateFolder, location.getLocation());
        newFolder.mkdirs();
    }

    @Override
    public <T extends MdProject> void removeFolder(@NotNull Class<T> type, @NotNull ProjectFolder location, boolean recursive) throws PersistenceException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.removeFolder must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.removeFolder must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends MdProject> void removeProject(@NotNull Class<T> context, @NotNull ProjectFolder location, @NotNull MetadataType metadata) throws PersistenceException {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.removeProject must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.removeProject must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.removeProject must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void commitChanges(@NotNull MetadataType metadata) throws PersistenceException {
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.commitChanges must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends MdProject> MetadataType loadMetadataArtifact(@NotNull Class<T> type, @NotNull ProjectFolder location) throws PersistenceException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.loadMetadataArtifact must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.loadMetadataArtifact must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends MdProject> void saveMetadataArtifact(@NotNull Class<T> type, @NotNull VFileSystem filesystem, @NotNull MetadataType metadata) throws PersistenceException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.saveMetadataArtifact must not be null");
        }
        if (filesystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.saveMetadataArtifact must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.saveMetadataArtifact must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public LockType getLock(@NotNull VFileSystem filesystem) throws PersistenceException {
        if (filesystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.getLock must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public LockType getLock(@NotNull MetadataType metadata) throws PersistenceException {
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.getLock must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void acquireLock(@NotNull VFileSystem filesystem, @NotNull LockType lockType) throws PersistenceException {
        if (filesystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.acquireLock must not be null");
        }
        if (lockType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.acquireLock must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseLock(@NotNull PublicShareProject project) throws PersistenceException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.releaseLock must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseFromCache(@NotNull MetadataType metadata) throws PersistenceException {
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.releaseFromCache must not be null");
        }
        throw new UnsupportedOperationException();
    }

    private Collection<File> listFiles(@NotNull File directory, @Nullable FileFilter filter, boolean recurse) {
        File[] entries;
        if (directory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mock/persistence/MockMdPersistence.listFiles must not be null");
        }
        ArrayList<File> files = new ArrayList<File>();
        for (File entry : entries = directory.listFiles()) {
            if (filter == null || filter.accept(entry)) {
                files.add(entry);
            }
            if (!recurse || !entry.isDirectory()) continue;
            files.addAll(this.listFiles(entry, filter, recurse));
        }
        return files;
    }
}

