/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.mds.utils;

import java.io.IOException;
import oracle.bpm.io.fs.CopyOnWriteFS;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.io.fs.mds.MdsFileSystem;
import oracle.bpm.metadata.artifact.jaxb.CowFilesystem;
import oracle.bpm.metadata.artifact.jaxb.Filesystem;
import oracle.bpm.metadata.mds.utils.MdsFileFilter;
import oracle.bpm.metadata.mds.utils.ProjectArtifactHelper;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectLoader;
import oracle.mds.core.MDSInstance;
import org.jetbrains.annotations.NotNull;

public final class Utils {
    public static VFileSystem createVFileSystem(@NotNull MDSInstance mdsInstance, @NotNull Filesystem fs) throws IOException {
        MdsFileSystem vfilesystem;
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/Utils.createVFileSystem must not be null");
        }
        if (fs == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/Utils.createVFileSystem must not be null");
        }
        if (fs.getSimpleFilesystem() != null) {
            vfilesystem = new MdsFileSystem(mdsInstance, fs.getSimpleFilesystem());
        } else {
            CowFilesystem cowFilesystem = fs.getCowFilesystem();
            VFileSystem read = Utils.createVFileSystem(mdsInstance, cowFilesystem.getRead());
            VFileSystem write = Utils.createVFileSystem(mdsInstance, cowFilesystem.getWrite());
            vfilesystem = new CopyOnWriteFS(read, write);
        }
        return vfilesystem;
    }

    public static VFileSystem copyProjectToLocation(@NotNull MDSInstance mdsInstance, @NotNull VFileSystem sourceFileSystem, @NotNull String locationTo) throws IOException, PersistenceException {
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/Utils.copyProjectToLocation must not be null");
        }
        if (sourceFileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/Utils.copyProjectToLocation must not be null");
        }
        if (locationTo == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mds/utils/Utils.copyProjectToLocation must not be null");
        }
        String normalizedUrl = VFileUtils.getCanonicalPath((String)locationTo);
        MdsFileSystem targetFileSystem = new MdsFileSystem(mdsInstance, normalizedUrl);
        Utils.copyFs(sourceFileSystem, targetFileSystem);
        return targetFileSystem;
    }

    public static void copyFs(@NotNull VFileSystem sourceFS, @NotNull VFileSystem targetFS) throws IOException, PersistenceException {
        if (sourceFS == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/Utils.copyFs must not be null");
        }
        if (targetFS == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/Utils.copyFs must not be null");
        }
        boolean wasCopied = VFileUtils.dirCopy((VFile)sourceFS.getRoot(), (VFile)targetFS.getRoot(), (VFileFilter)MdsFileFilter.MDS_FILE_FILTER_NO_LOCK_FILE);
        if (!wasCopied) {
            throw PersistenceException.createErrorCopyException();
        }
    }

    public static void writeCompositeFile(@NotNull String projectName, @NotNull VFileSystem targetFileSystem) throws IOException {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/Utils.writeCompositeFile must not be null");
        }
        if (targetFileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/Utils.writeCompositeFile must not be null");
        }
        VFile compositeFile = targetFileSystem.createFile("composite.xml");
        if (!compositeFile.exists()) {
            ProjectArtifactHelper.writeEmptyComposite(compositeFile, projectName);
        }
    }

    public static void writeJprFile(final @NotNull Project oldProject, final @NotNull String newProjectName, @NotNull VFileSystem targetFileSystem) throws IOException {
        if (oldProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/Utils.writeJprFile must not be null");
        }
        if (newProjectName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/Utils.writeJprFile must not be null");
        }
        if (targetFileSystem == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mds/utils/Utils.writeJprFile must not be null");
        }
        ProjectLoader loader = oldProject.getLoader();
        assert (loader != null);
        VFileSystem sourceFilesystem = loader.getProjectFileSystem().getDataFileSystem();
        VFile[] jprSourceFiles = sourceFilesystem.list(sourceFilesystem.getRoot(), new VFileFilter(){

            public boolean accept(@NotNull VFile pathname) {
                return pathname.getName().endsWith(".jpr") && pathname.getName().startsWith(oldProject.getName());
            }
        });
        VFile[] jprTargetFiles = targetFileSystem.list(targetFileSystem.getRoot(), new VFileFilter(){

            public boolean accept(@NotNull VFile pathname) {
                return pathname.getName().endsWith(".jpr") && !pathname.getName().startsWith(newProjectName);
            }
        });
        VFile newJprFile = targetFileSystem.createFile(newProjectName + ".jpr");
        if (jprSourceFiles == null || jprSourceFiles.length == 0) {
            ProjectArtifactHelper.writeBaseProjectJpr(newJprFile, newProjectName);
        } else {
            VFile oldJprFile = jprSourceFiles[0];
            ProjectArtifactHelper.writeProjectJpr(oldJprFile, newJprFile);
            for (VFile jpr : jprTargetFiles) {
                jpr.delete();
            }
        }
    }

    public static void copyWriteToRead(@NotNull CopyOnWriteFS cow) throws IOException, PersistenceException {
        if (cow == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/Utils.copyWriteToRead must not be null");
        }
        VFileSystem readFileSystem = cow.getReadFileSystem();
        for (VFile deletedVFile : cow.getDeletedFiles()) {
            readFileSystem.createFile(deletedVFile.getCanonicalPath()).delete();
        }
        VFileSystem writeFileSystem = cow.getWriteFileSystem();
        writeFileSystem.copyTo(readFileSystem);
    }
}

