/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.mds.utils;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileFilter;
import org.jetbrains.annotations.NotNull;

public class MdsFileFilter
implements VFileFilter {
    private static final Pattern SCA_INF_FILES_PATTERN = Pattern.compile("^/SCA-INF(?:$|/.*)");
    private static final Pattern WINDOWS_SCA_INF_CLASSES = Pattern.compile("^/SCA-INF\\\\classes(?:$|/.*)");
    private static final Pattern MDS_UNSUPPORTED_CHARS = Pattern.compile(".*~.*");
    private static final Pattern COW_DELETED_INDEX_FILE = Pattern.compile(".*/deletedFiles[0-9]+");
    private static final List<Pattern> excludePatterns = Arrays.asList(SCA_INF_FILES_PATTERN, WINDOWS_SCA_INF_CLASSES, MDS_UNSUPPORTED_CHARS, COW_DELETED_INDEX_FILE);
    private static final String DOT_PREFIX = ".";
    public static final VFileFilter MDS_FILE_FILTER = new MdsFileFilter();
    public static VFileFilter MDS_FILE_FILTER_NO_LOCK_FILE = new MdsFileFilterNoLockFile();

    private MdsFileFilter() {
    }

    public boolean accept(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsFileFilter.accept must not be null");
        }
        for (Pattern excludePattern : excludePatterns) {
            Matcher matcher = excludePattern.matcher(vFile.getCanonicalPath());
            if (!matcher.matches()) continue;
            return false;
        }
        String fileName = vFile.getName();
        return !fileName.startsWith(DOT_PREFIX) && !"projectMetadata.xml".equals(fileName);
    }

    private static class MdsFileFilterNoLockFile
    extends MdsFileFilter {
        private MdsFileFilterNoLockFile() {
        }

        @Override
        public boolean accept(@NotNull VFile vFile) {
            if (vFile == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsFileFilter$MdsFileFilterNoLockFile.accept must not be null");
            }
            return super.accept(vFile) && !vFile.getName().endsWith("project.lock");
        }
    }
}

