/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.impl;

import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.metadata.artifact.jaxb.CowFilesystem;
import oracle.bpm.metadata.artifact.jaxb.Filesystem;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.artifact.jaxb.ObjectFactory;
import oracle.bpm.metadata.artifact.jaxb.PendingToDeployMetadata;
import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.artifact.jaxb.PublicShareMetadata;
import oracle.bpm.metadata.artifact.jaxb.Topology;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.metadata.persistence.PersistenceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MetadataArtifactBuilder {
    private static DatatypeFactory datatypeFactory = null;

    private MetadataArtifactBuilder() {
    }

    public static MetadataType create(@NotNull String projectName, @Nullable String description, @NotNull String location) {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.create must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.create must not be null");
        }
        MetadataType metadataArtifact = new MetadataType();
        Topology topology = new Topology();
        Filesystem filesystem = MetadataArtifactBuilder.createSimpleFileSystem(location);
        topology.setFilesystem(filesystem);
        metadataArtifact.setTopology(topology);
        metadataArtifact.setName(projectName);
        metadataArtifact.setDescription(description);
        metadataArtifact.setTimestamp(datatypeFactory.newXMLGregorianCalendar(new GregorianCalendar()));
        MetadataArtifactBuilder.updateTimestamp(metadataArtifact);
        return metadataArtifact;
    }

    public static void baseCopy(@NotNull MetadataType from, @NotNull MetadataType to) {
        if (from == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.baseCopy must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.baseCopy must not be null");
        }
        to.setCreator(from.getCreator());
        to.setName(from.getName());
        to.setProjectType(from.getProjectType());
        to.setProperties(from.getProperties());
        to.setTimestamp(datatypeFactory.newXMLGregorianCalendar(new GregorianCalendar()));
    }

    public static void deepCopy(@NotNull PublicShareMetadata from, @NotNull PublicShareMetadata to) {
        if (from == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.deepCopy must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.deepCopy must not be null");
        }
        MetadataArtifactBuilder.baseCopy(from, to);
        to.setAllowShare(from.isAllowShare());
        to.setWorkflowParticipants(from.getWorkflowParticipants());
        to.setWorkflowUrl(from.getWorkflowUrl());
        to.setIsFromScratch(from.isIsFromScratch());
        to.setHasWorkflowAproval(from.isHasWorkflowAproval());
    }

    public static PublicShareMetadata create(@NotNull PublicShareProject publicShare, @NotNull String location) {
        Calendar timestamp;
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.create must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.create must not be null");
        }
        PublicShareMetadata metadataArtifact = new PublicShareMetadata();
        MetadataArtifactHelper.copyMetadataAttributes(metadataArtifact, publicShare.getMetadata());
        Topology topology = new Topology();
        Filesystem filesystem = MetadataArtifactBuilder.createSimpleFileSystem(location);
        topology.setFilesystem(filesystem);
        metadataArtifact.setTopology(topology);
        metadataArtifact.setIsFromScratch(publicShare.isProjectFromScratch());
        metadataArtifact.setAllowShare(publicShare.isAllowSharing());
        metadataArtifact.setProjectType(ProjectType.PUBLIC_SHARED);
        metadataArtifact.setTimestamp(datatypeFactory.newXMLGregorianCalendar(new GregorianCalendar()));
        if (publicShare.isApprovalWorkflow()) {
            metadataArtifact.setWorkflowUrl(publicShare.getApprovalWorkflowUrl());
            MetadataArtifactHelper.setWorkflowParticipants(metadataArtifact, publicShare.getWorkflowParticipants());
        }
        if ((timestamp = publicShare.getUpdateTimestamp()) == null) {
            MetadataArtifactBuilder.updateTimestamp(metadataArtifact);
        } else {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(timestamp.getTimeInMillis());
            XMLGregorianCalendar value = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
            metadataArtifact.setUpdateTimestamp(value);
        }
        return metadataArtifact;
    }

    public static PendingToDeployMetadata create(@NotNull String projectName, @Nullable String description, @NotNull String location, @NotNull String ticket) {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.create must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.create must not be null");
        }
        if (ticket == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.create must not be null");
        }
        PendingToDeployMetadata metadataArtifact = new PendingToDeployMetadata();
        Topology topology = new Topology();
        Filesystem filesystem = MetadataArtifactBuilder.createSimpleFileSystem(location);
        topology.setFilesystem(filesystem);
        metadataArtifact.setTopology(topology);
        metadataArtifact.setName(projectName);
        metadataArtifact.setTimestamp(datatypeFactory.newXMLGregorianCalendar(new GregorianCalendar()));
        metadataArtifact.setDescription(description);
        metadataArtifact.setWorkflowTicket(ticket);
        metadataArtifact.setProjectType(ProjectType.PENDING_TO_DEPLOY);
        MetadataArtifactBuilder.updateTimestamp(metadataArtifact);
        return metadataArtifact;
    }

    public static MetadataType create(@NotNull TemplateProject templateProject, @NotNull String absoluteLocation) {
        Calendar timestamp;
        if (templateProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.create must not be null");
        }
        if (absoluteLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.create must not be null");
        }
        MetadataType metadata = MetadataArtifactBuilder.create(templateProject.getName(), templateProject.getDescription(), absoluteLocation);
        metadata.setProjectType(ProjectType.TEMPLATE);
        MetadataType.Properties properties = templateProject.getMetadata().getProperties();
        if (properties != null) {
            metadata.setProperties(templateProject.getMetadata().getProperties());
        }
        if ((timestamp = templateProject.getUpdateTimestamp()) == null) {
            MetadataArtifactBuilder.updateTimestamp(metadata);
        } else {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(timestamp.getTimeInMillis());
            XMLGregorianCalendar value = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
            metadata.setUpdateTimestamp(value);
        }
        return metadata;
    }

    public static MetadataType create(@NotNull MetadataType parent, @NotNull String childLocation) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.create must not be null");
        }
        if (childLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.create must not be null");
        }
        MetadataType metadataArtifact = new MetadataType();
        Topology topology = new Topology();
        Filesystem filesystemChild = MetadataArtifactBuilder.createSimpleFileSystem(childLocation);
        CowFilesystem cow = new CowFilesystem();
        Filesystem parentFileSystem = parent.getTopology().getFilesystem();
        cow.setRead(parentFileSystem);
        cow.setWrite(filesystemChild);
        Filesystem filesystem = new Filesystem();
        filesystem.setCowFilesystem(cow);
        topology.setFilesystem(filesystem);
        metadataArtifact.setTopology(topology);
        metadataArtifact.setTimestamp(datatypeFactory.newXMLGregorianCalendar(new GregorianCalendar()));
        MetadataArtifactHelper.copyMetadataAttributes(metadataArtifact, parent);
        XMLGregorianCalendar timestamp = parent.getUpdateTimestamp();
        if (timestamp == null) {
            MetadataArtifactBuilder.updateTimestamp(metadataArtifact);
        } else {
            metadataArtifact.setUpdateTimestamp(timestamp);
        }
        return metadataArtifact;
    }

    public static void saveMetadataArtifact(@NotNull Class mdType, @NotNull VFileSystem filesystem, @NotNull MetadataType metadata) throws PersistenceException {
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.saveMetadataArtifact must not be null");
        }
        if (filesystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.saveMetadataArtifact must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.saveMetadataArtifact must not be null");
        }
        ProjectType projectType = MetadataArtifactHelper.getProjectType(mdType);
        metadata.setProjectType(projectType);
        MetadataArtifactBuilder.updateTimestamp(metadata);
        ObjectFactory objectFactory = new ObjectFactory();
        MetadataArtifactBuilder.saveArtifact(filesystem, "projectMetadata.xml", objectFactory.createMetadata(metadata));
    }

    public static void saveArtifact(@NotNull VFileSystem filesystem, @NotNull String fileName, @NotNull Object artifact) throws PersistenceException {
        if (filesystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.saveArtifact must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.saveArtifact must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.saveArtifact must not be null");
        }
        VFile file = filesystem.createFile(fileName);
        try {
            MetadataArtifactHelper.serialize(artifact, file);
        }
        catch (IOException e) {
            throw PersistenceException.createIOException(e);
        }
    }

    public static void updateTimestamp(MetadataType metadataArtifact) {
        XMLGregorianCalendar timestamp = datatypeFactory.newXMLGregorianCalendar(new GregorianCalendar());
        metadataArtifact.setUpdateTimestamp(timestamp);
    }

    private static Filesystem createSimpleFileSystem(@NotNull String location) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MetadataArtifactBuilder.createSimpleFileSystem must not be null");
        }
        Filesystem filesystem = new Filesystem();
        filesystem.setSimpleFilesystem(VFileUtils.getCanonicalPath((String)location));
        return filesystem;
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

