/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.impl;

import java.util.Calendar;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.metadata.persistence.MdPersistence;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.bpm.pml.security.model.BasicSecuredProject;
import oracle.bpm.project.model.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MdProjectImpl<T extends ProjectArtifact>
implements MdProject<T> {
    protected MetadataType metadata;
    protected MdPersistence persistence;
    protected LocalRef<Project> projectRef;
    private String id;
    private LocalRef<ProjectFolder> projectFolderRef;
    private BasicSecuredProject securedProject;

    protected MdProjectImpl(@NotNull String name, @NotNull Project project) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.<init> must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.<init> must not be null");
        }
        this.setName(name);
        this.setProject(project);
        this.initSecuredProject();
    }

    protected MdProjectImpl(@NotNull MdPersistence mdPersistence, @NotNull String location, @Nullable MetadataType metadata) {
        if (mdPersistence == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.<init> must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.<init> must not be null");
        }
        this.persistence = mdPersistence;
        this.metadata = metadata;
        ProjectFolder projectFolder = ProjectFolder.create(location);
        this.projectFolderRef = new LocalRef<ProjectFolder>(projectFolder.getName(), projectFolder);
        this.initSecuredProject();
    }

    @Override
    public boolean isMdProject() {
        return true;
    }

    @Override
    public LocalRef<Project> getProject() throws MetadataException {
        if (this.projectRef == null && this.persistence != null) {
            this.projectRef = this.persistence.loadProject(this.getMetadata());
        }
        return this.projectRef;
    }

    public String getId() {
        if (this.id == null) {
            this.id = VFileUtils.getCanonicalPath((String)(this.getFolder() == null ? this.getName() : this.getFolder().get().getLocation()));
        }
        return this.id;
    }

    @Override
    public String getName() {
        return this.metadata != null ? this.getMetadata().getName() : this.getFolder().get().getName();
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.setName must not be null");
        }
        this.getMetadata().setName(name);
    }

    @Override
    public Calendar getUpdateTimestamp() {
        XMLGregorianCalendar timestamp = this.getMetadata().getUpdateTimestamp();
        return timestamp != null ? timestamp.toGregorianCalendar() : null;
    }

    @Override
    public void setUpdateTimestamp(XMLGregorianCalendar timestamp) {
        this.getMetadata().setUpdateTimestamp(timestamp);
    }

    @Override
    public LocalRef<ProjectFolder> getParentFolder() {
        return this.getFolder().get().getParentFolder();
    }

    @Override
    public LocalRef<ProjectFolder> getFolder() {
        return this.projectFolderRef;
    }

    @Override
    public void setFolder(@NotNull ProjectFolder folder) {
        if (folder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.setFolder must not be null");
        }
        this.projectFolderRef = new LocalRef<ProjectFolder>(folder.getName(), folder);
    }

    public void setProject(@NotNull LocalRef<Project> projectRef) {
        if (projectRef == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.setProject must not be null");
        }
        this.projectRef = projectRef;
    }

    public String getOwnerName() {
        return this.getMetadata().getCreator();
    }

    public void setOwner(@NotNull String owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.setOwner must not be null");
        }
        this.getMetadata().setCreator(owner);
    }

    public Calendar getCreationTimestamp() {
        XMLGregorianCalendar timestamp = this.getMetadata().getTimestamp();
        return timestamp != null ? timestamp.toGregorianCalendar() : null;
    }

    @Override
    public void setProperty(@NotNull String key, @NotNull String value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.setProperty must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.setProperty must not be null");
        }
        MetadataType.Properties.Property property = MetadataArtifactHelper.findProperty(this.getMetadata(), key);
        if (property == null) {
            MetadataType.Properties properties = this.getMetadata().getProperties();
            if (properties == null) {
                properties = new MetadataType.Properties();
                this.getMetadata().setProperties(properties);
            }
            property = new MetadataType.Properties.Property();
            properties.getProperty().add(property);
            property.setKey(key);
        }
        property.setValue(value);
    }

    @Override
    public String getProperty(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.getProperty must not be null");
        }
        String result = null;
        MetadataType.Properties.Property property = MetadataArtifactHelper.findProperty(this.getMetadata(), key);
        if (property != null) {
            result = property.getValue();
        }
        return result;
    }

    public boolean removeProperty(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.removeProperty must not be null");
        }
        Boolean result = false;
        MetadataType.Properties.Property property = MetadataArtifactHelper.findProperty(this.getMetadata(), key);
        if (property != null) {
            MetadataType.Properties properties = this.getMetadata().getProperties();
            result = properties.getProperty().remove(property);
        }
        return result;
    }

    @Override
    public void setSecuredProject(@NotNull BasicSecuredProject securedProject) {
        if (securedProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.setSecuredProject must not be null");
        }
        this.securedProject = securedProject;
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == null || this.getClass() != object.getClass()) {
            result = false;
        } else if (object == this) {
            result = true;
        } else {
            MdProject mdProject = (MdProject)object;
            result = this.getClass().equals(object.getClass()) && this.getId().equals(mdProject.getId());
        }
        return result;
    }

    public void setMdPersistence(@NotNull MdPersistence mdPersistence) {
        if (mdPersistence == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.setMdPersistence must not be null");
        }
        this.persistence = mdPersistence;
    }

    public boolean isEditable() {
        return this.securedProject.isEditable();
    }

    public boolean isManageable() {
        return this.securedProject.isManageable();
    }

    public boolean isShared() {
        return this.securedProject.isShared();
    }

    public boolean isOwner() {
        return this.securedProject.isOwner();
    }

    protected abstract <T extends MdProject> Class<T> getProjectType();

    protected MetadataType getMetadata() {
        if (this.metadata == null && this.persistence != null) {
            try {
                this.metadata = this.persistence.loadMetadataArtifact(this.getProjectType(), this.getFolder().get());
            }
            catch (PersistenceException persistenceException) {
                // empty catch block
            }
        }
        if (this.metadata == null) {
            this.metadata = new MetadataType();
        }
        return this.metadata;
    }

    private void initSecuredProject() {
        this.securedProject = new BasicSecuredProject(){

            public String getId() {
                return MdProjectImpl.this.getId();
            }

            public boolean isEditable() {
                return true;
            }

            public boolean isOwner() {
                return true;
            }

            public boolean isManageable() {
                return true;
            }

            public boolean isShared() {
                return false;
            }
        };
    }

    private void setProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdProjectImpl.setProject must not be null");
        }
        this.projectRef = new LocalRef<Project>(this.getName(), project);
    }
}

