/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.impl;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import oracle.bpel.services.workflow.metadata.taskdefinition.TaskDefinitionUtil;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.bpm.collections.Predicate;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.CopyOnWriteFS;
import oracle.bpm.io.fs.MdsProjectWriter;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileOutputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.io.fs.mds.MdsFileSystem;
import oracle.bpm.lang.Cast;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.MdDomain;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.artifact.jaxb.CowFilesystem;
import oracle.bpm.metadata.artifact.jaxb.Filesystem;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.artifact.jaxb.ObjectFactory;
import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.artifact.jaxb.PublicShareMetadata;
import oracle.bpm.metadata.artifact.jaxb.Topology;
import oracle.bpm.metadata.entity.DeployedProject;
import oracle.bpm.metadata.entity.DraftProject;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.SnapshotProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.AbortedOperationMetadataException;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.MetadataExceptionFactory;
import oracle.bpm.metadata.exception.ProjectNotFoundException;
import oracle.bpm.metadata.history.Criteria;
import oracle.bpm.metadata.history.HistoryService;
import oracle.bpm.metadata.history.LogicalArtifactRecognizer;
import oracle.bpm.metadata.history.exceptions.HistoryException;
import oracle.bpm.metadata.history.file.scanner.ChangedFileHelper;
import oracle.bpm.metadata.history.impl.HistoryServiceDummyMockImpl;
import oracle.bpm.metadata.history.item.recognizer.LogicalArtifactRecognizerImpl;
import oracle.bpm.metadata.history.model.Change;
import oracle.bpm.metadata.history.model.ChangedFile;
import oracle.bpm.metadata.history.model.HistoryProjectMetadata;
import oracle.bpm.metadata.impl.DeployedProjectExt;
import oracle.bpm.metadata.impl.MdProjectImpl;
import oracle.bpm.metadata.impl.MetadataArtifactBuilder;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.metadata.impl.PublicShareInfo;
import oracle.bpm.metadata.impl.PublicShareProjectExt;
import oracle.bpm.metadata.impl.TemplateProjectExt;
import oracle.bpm.metadata.impl.Utils;
import oracle.bpm.metadata.lock.jaxb.ApplicationType;
import oracle.bpm.metadata.lock.jaxb.LockType;
import oracle.bpm.metadata.mds.MdsInstanceInitializer;
import oracle.bpm.metadata.mds.MdsTransaction;
import oracle.bpm.metadata.mds.Namespace;
import oracle.bpm.metadata.mds.persistence.MdsMdPersistence;
import oracle.bpm.metadata.mds.utils.MdsTransactionUtil;
import oracle.bpm.metadata.mock.persistence.MockMdPersistence;
import oracle.bpm.metadata.msg.MetadataMsg;
import oracle.bpm.metadata.persistence.MdPersistence;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.bpm.metadata.update.PropertyKeys;
import oracle.bpm.metadata.update.UpdateFromBaseTemplateHelper;
import oracle.bpm.metadata.update.UpdateResult;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.catalog.composite.jaxb.JaxbScaController;
import oracle.bpm.project.io.fs.FileProjectRepository;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.util.HashUtils;
import oracle.mds.core.MDSInstance;
import oracle.mds.exception.MDSException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MdDomainImpl
implements MdDomain {
    private ApplicationType applicationType;
    private HistoryService historyService;
    private boolean isAdmin;
    private LogicalArtifactRecognizer logicalArtifactRecognizer;
    private MdPersistence mdPersistence;
    private MDSInstance mdsInstance;
    private static final DatatypeFactory datatypeFactory;
    private static final String STUDIO_USER = "BPM Studio";
    public static final String METADATA_MOCK_WORKSPACEDIR = "metadata.mock.workspacedir";

    public MdDomainImpl() throws MetadataException {
        this.init(null);
        this.applicationType = ApplicationType.GENERIC_APPLICATION;
    }

    public MdDomainImpl(@NotNull MDSInstance instance, @NotNull ApplicationType applicationType) {
        if (instance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.<init> must not be null");
        }
        if (applicationType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.<init> must not be null");
        }
        this.mdsInstance = instance;
        this.applicationType = applicationType;
        this.historyService = new HistoryServiceDummyMockImpl();
        this.logicalArtifactRecognizer = new LogicalArtifactRecognizerImpl();
        String userMock = System.getProperty(METADATA_MOCK_WORKSPACEDIR);
        this.mdPersistence = userMock != null ? new MockMdPersistence() : new MdsMdPersistence(instance);
    }

    public MdDomainImpl(@NotNull MDSInstance instance, @NotNull HistoryService historyService, @NotNull ApplicationType applicationType) {
        if (instance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.<init> must not be null");
        }
        if (historyService == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.<init> must not be null");
        }
        if (applicationType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.<init> must not be null");
        }
        this.mdsInstance = instance;
        this.applicationType = applicationType;
        this.historyService = historyService;
        this.logicalArtifactRecognizer = new LogicalArtifactRecognizerImpl();
        String userMock = System.getProperty(METADATA_MOCK_WORKSPACEDIR);
        this.mdPersistence = userMock != null ? new MockMdPersistence() : new MdsMdPersistence(instance);
    }

    @Override
    public <T extends MdProject<?>> MdTree browseFolders(@NotNull Class<T> mdType, @Nullable Predicate<String> predicate) throws PersistenceException {
        if (mdType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.browseFolders must not be null");
        }
        return this.mdPersistence.browseFolders(mdType, predicate);
    }

    @Override
    public <T extends MdProject<?>, K extends ProjectArtifact<?>> MdTree browseProject(@NotNull Class<T> type, @Nullable Predicate<T> predicate, @Nullable LocalRef<K> parent) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.browseProject must not be null");
        }
        return this.mdPersistence.browse(type, parent, predicate, true);
    }

    @Override
    public <T extends MdProject<?>> LocalRef<T> loadProject(@NotNull Class<T> clazz, @NotNull String projectLocation, boolean reload) throws MetadataException {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.loadProject must not be null");
        }
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.loadProject must not be null");
        }
        if (clazz.equals(DeployedProject.class) || clazz.equals(DeployedProjectExt.class)) {
            throw new IllegalArgumentException("The class DeployedProject is not allowed");
        }
        return this.mdPersistence.loadMdProject(clazz, projectLocation, reload);
    }

    @Override
    public <T extends MdProject<?>> boolean existsProject(@NotNull Class<T> type, @NotNull ProjectFolder location) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.existsProject must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.existsProject must not be null");
        }
        return this.mdPersistence.existsProject(type, location);
    }

    @Override
    public LocalRef<DraftProject> loadDraftProject(@NotNull String projectLocation, @NotNull String username) throws MetadataException {
        LocalRef<DraftProject> result;
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.loadDraftProject must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.loadDraftProject must not be null");
        }
        String draftLocation = projectLocation + "/" + HashUtils.generateMd5((String)username);
        try {
            result = this.mdPersistence.loadMdProject(DraftProject.class, draftLocation, false);
        }
        catch (ProjectNotFoundException e) {
            draftLocation = projectLocation + "/" + username;
            result = this.mdPersistence.loadMdProject(DraftProject.class, draftLocation, false);
        }
        return result;
    }

    @Override
    public void removePublicShare(@NotNull PublicShareProject publicShare) throws MetadataException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.removePublicShare must not be null");
        }
        ProjectFolder folder = publicShare.getFolder().get();
        if (!this.mdPersistence.existsFolder(PublicShareProject.class, folder)) {
            throw new MetadataException(MetadataMsg.FOLDER_NOT_EXISTS((String)folder.getLocation()));
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            LocalRef<ProjectFolder> folderRef = new LocalRef<ProjectFolder>(folder.getName(), folder);
            Collection<LocalRef<DraftProject>> refCollection = this.mdPersistence.find(DraftProject.class, folderRef, null, true);
            if (!refCollection.isEmpty()) {
                for (LocalRef<DraftProject> draftProjectLocalRef : refCollection) {
                    DraftProject project = draftProjectLocalRef.get();
                    ProjectFolder draftFolder = project.getFolder().get();
                    this.releaseLock(draftFolder.getLocation());
                }
            }
            MetadataType metadata = this.mdPersistence.loadMetadataArtifact(PublicShareProject.class, folder);
            String id = new PublicShareProjectExt(this.mdPersistence, folder.getLocation(), metadata).getId();
            this.historyService.removeChanges(id);
            this.removeProject(PublicShareProject.class, publicShare);
            tx.commit();
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public <T extends MdProject<?>> void removeProject(@NotNull Class<T> type, @NotNull MdProject<?> mdProject) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.removeProject must not be null");
        }
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.removeProject must not be null");
        }
        ProjectFolder folder = (ProjectFolder)Cast.force((Object)mdProject.getFolder().get());
        if (!this.mdPersistence.existsFolder(type, folder)) {
            throw new MetadataException(MetadataMsg.FOLDER_NOT_EXISTS((String)folder.getLocation()));
        }
        MetadataType metadata = this.mdPersistence.loadMetadataArtifact(type, folder);
        if (metadata == null) {
            throw MetadataExceptionFactory.createProjectNotFound((String)folder.getLocation());
        }
        this.mdPersistence.removeProject(type, folder, metadata);
    }

    @Override
    public void removeTemplate(@NotNull TemplateProject template, boolean breakLinks) throws MetadataException {
        if (template == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.removeTemplate must not be null");
        }
        ProjectFolder folder = template.getFolder().get();
        if (!this.mdPersistence.existsFolder(TemplateProject.class, folder)) {
            throw new MetadataException(MetadataMsg.FOLDER_NOT_EXISTS((String)folder.getLocation()));
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            MdTree mdTree = this.getPublicSharesLinkedToTemplate(template);
            Collection linkedPublicShares = mdTree.toCollection(true);
            if (!breakLinks && !linkedPublicShares.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                Iterator iterator = linkedPublicShares.iterator();
                while (iterator.hasNext()) {
                    LocalRef linkedPublicShare = iterator.next();
                    sb.append(linkedPublicShare.getName());
                    if (!iterator.hasNext()) continue;
                    sb.append(", ");
                }
                throw MetadataExceptionFactory.createUnableToDeleteTemplate((String)template.getName(), (String)sb.toString());
            }
            for (LocalRef publicShareProjectRef : linkedPublicShares) {
                PublicShareProject publicShare = (PublicShareProject)publicShareProjectRef.get();
                VFileSystem targetFs = publicShare.getProject().get().getLoader().getProjectFileSystem().getDataFileSystem();
                MetadataType psMetadata = this.mdPersistence.loadMetadataArtifact(PublicShareProject.class, publicShare.getFolder().get());
                psMetadata = UpdateFromBaseTemplateHelper.breakPublicShareLink(psMetadata);
                this.mdPersistence.saveMetadataArtifact(PublicShareProject.class, targetFs, psMetadata);
            }
            String id = template.getId();
            this.historyService.removeChanges(id);
            this.removeProject(TemplateProject.class, template);
            tx.commit();
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        catch (Throwable e) {
            tx.rollback();
            throw new AbortedOperationMetadataException(e);
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public MdTree getPublicSharesLinkedToTemplate(final @NotNull TemplateProject template) throws MetadataException {
        if (template == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.getPublicSharesLinkedToTemplate must not be null");
        }
        LocalRef<ProjectFolder> folderRef = template.getFolder();
        if (!this.mdPersistence.existsFolder(TemplateProject.class, folderRef.get())) {
            throw new MetadataException(MetadataMsg.FOLDER_NOT_EXISTS((String)folderRef.get().getLocation()));
        }
        MdTree mdTree = this.browseProject(PublicShareProject.class, new Predicate<PublicShareProject>(){

            public boolean check(@Nullable PublicShareProject publicShare) {
                try {
                    String baseTemplateId;
                    MetadataType psMetadata = MdDomainImpl.this.mdPersistence.loadMetadataArtifact(PublicShareProject.class, publicShare.getFolder().get());
                    MetadataType.Properties.Property baseTemplateIdProperty = MetadataArtifactHelper.findProperty(psMetadata, PropertyKeys.BASE_TEMPLATE_ID.getKey());
                    if (baseTemplateIdProperty != null && (baseTemplateId = baseTemplateIdProperty.getValue()).equals(template.getId())) {
                        return true;
                    }
                }
                catch (PersistenceException e) {
                    return false;
                }
                return false;
            }
        }, null);
        return mdTree;
    }

    @Override
    public TemplateProject createTemplateProject(@NotNull ProjectFolder location, @NotNull TemplateProject mdTemplateProject, @NotNull String username, boolean overwrite, boolean checkVersion) throws MetadataException {
        TemplateProject result;
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createTemplateProject must not be null");
        }
        if (mdTemplateProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createTemplateProject must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createTemplateProject must not be null");
        }
        mdTemplateProject.setOwner(username);
        if (mdTemplateProject.getProject() == null) {
            throw MetadataExceptionFactory.createInvalidProjectException();
        }
        String projectName = mdTemplateProject.getName();
        String relativeProjectLocation = location.getLocation() + "/" + projectName;
        ProjectFolder projectFolder = ProjectFolder.create(relativeProjectLocation);
        mdTemplateProject.setFolder(projectFolder);
        ProjectFolder foundProject = this.findProjectByName(TemplateProject.class, projectName);
        boolean foundFolder = this.existsFolder(TemplateProject.class, projectFolder);
        String oldHumanRevisionId = null;
        if (foundProject != null && !foundProject.equals(projectFolder)) {
            throw PersistenceException.createArtifactLocationMismatchException(projectName);
        }
        if (foundFolder && foundProject == null) {
            throw MetadataExceptionFactory.createArtifactAlreadyExists((String)projectFolder.getLocation());
        }
        Project sourceProject = mdTemplateProject.getProject().get();
        if (!sourceProject.getPreferences().isTemplate()) {
            throw MetadataExceptionFactory.createProjectIsNotTemplate();
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            List<ChangedFile> changedFiles;
            boolean newTemplate;
            MdsFileSystem targetFs;
            tx.begin();
            String absoluteLocation = Utils.getAbsoluteLocation(TemplateProject.class, location, projectName);
            if (foundProject != null) {
                if (!overwrite) {
                    throw new MetadataException(MetadataMsg.PROJECT_ALREADY_EXISTS((String)projectName, (String)location.getLocation()));
                }
                TemplateProject loadedTemplate = this.loadProject(TemplateProject.class, projectFolder.getLocation(), false).get();
                Project loadedProject = loadedTemplate.getProject().get();
                VFileSystem loadedFilesystem = loadedProject.getLoader().getProjectFileSystem().getDataFileSystem();
                targetFs = loadedFilesystem;
                ProjectLoader loader = sourceProject.getLoader();
                assert (loader != null);
                VFileSystem sourceFilesystem = loader.getProjectFileSystem().getDataFileSystem();
                if (!loadedFilesystem.equals(sourceFilesystem)) {
                    if (checkVersion) {
                        Utils.checkTimestamp(loadedTemplate.getMetadata(), mdTemplateProject.getMetadata());
                    }
                    this.removeProject(loadedFilesystem);
                }
                oldHumanRevisionId = loadedTemplate.getProperty(PropertyKeys.HUMAN_REVISION_ID.getKey());
                newTemplate = false;
            } else {
                targetFs = new MdsFileSystem(this.mdsInstance, absoluteLocation);
                newTemplate = true;
            }
            String templateDescription = mdTemplateProject.getDescription();
            MetadataType metadata = this.mdPersistence.saveMdProject(TemplateProject.class, projectName, templateDescription, absoluteLocation, sourceProject, targetFs);
            result = TemplateProjectExt.create(this.mdPersistence, relativeProjectLocation, null);
            Map<String, String> newHashes = ChangedFileHelper.calculateHashes(targetFs.getRoot());
            HistoryProjectMetadata historyProjectMetadata = new HistoryProjectMetadata(newHashes);
            historyProjectMetadata.setHumanRevisionId(this.calculateNewHumanId(metadata));
            historyProjectMetadata.setInitialChange(newTemplate);
            if (foundProject != null) {
                Criteria criteria = new Criteria();
                criteria.setProjectType(ProjectType.TEMPLATE.value());
                criteria.setProjectId(result.getId());
                List changes = this.historyService.listHistoryChanges(criteria, null);
                Map<String, String> oldHashes = new HashMap<String, String>();
                if (!changes.isEmpty()) {
                    oldHashes = ((Change)changes.get(0)).getHistoryProjectMetadata().getFilesHashes();
                }
                changedFiles = ChangedFileHelper.compareHashes(oldHashes, newHashes);
            } else {
                changedFiles = ChangedFileHelper.processChangedFilesScratchProject(targetFs.getRoot());
            }
            Date date = Calendar.getInstance().getTime();
            Change change = new Change(username, changedFiles, result.getId(), date, this.logicalArtifactRecognizer.recognize(changedFiles), historyProjectMetadata, ProjectType.TEMPLATE.value());
            this.historyService.saveChange(change);
            metadata = UpdateFromBaseTemplateHelper.writeTemplateRevisionProperties(this.historyService, result.getId(), metadata, date, oldHumanRevisionId);
            this.mdPersistence.saveMetadataArtifact(TemplateProject.class, targetFs, metadata);
            targetFs.flush();
            tx.commit();
            this.flushProjectWriter(result.getProject().get(), projectName, true);
            this.releaseFromCache(TemplateProject.class, relativeProjectLocation);
        }
        catch (IOException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        catch (ProjectException e) {
            tx.rollback();
            throw new MetadataException((Throwable)e);
        }
        catch (Throwable e) {
            tx.rollback();
            throw new AbortedOperationMetadataException(e);
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
        return result;
    }

    @Override
    public void prepareProjectToDeploy(@NotNull PublicShareProject publicShare, @NotNull String workflowTicket) throws MetadataException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.prepareProjectToDeploy must not be null");
        }
        if (workflowTicket == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.prepareProjectToDeploy must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            ProjectFolder folder = ProjectFolder.create(publicShare.getName() + "/" + workflowTicket);
            this.mdPersistence.prepareProjectToDeploy(publicShare, workflowTicket, folder);
            tx.commit();
        }
        catch (PersistenceException e) {
            tx.rollback();
            throw e;
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public void updateDraft(@NotNull DraftProject draftProject) throws MetadataException {
        if (draftProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.updateDraft must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            if (!this.existsProject(DraftProject.class, draftProject.getFolder().get())) {
                ProjectFolder projectFolder = draftProject.getParentFolder().get();
                throw MetadataExceptionFactory.createProjectNotFound((String)projectFolder.getLocation());
            }
            CopyOnWriteFS projectCow = (CopyOnWriteFS)draftProject.getProject().get().getWriter().getProjectFileSystem().getDataFileSystem();
            this.setHumanTaskNamespaceSuffix((VFileSystem)projectCow);
            VFileSystem memoryFS = projectCow.getWriteFileSystem();
            CopyOnWriteFS read = (CopyOnWriteFS)projectCow.getReadFileSystem();
            Collection projectCowDeletedFiles = projectCow.getDeletedFiles();
            for (VFile deletedVFile : projectCowDeletedFiles) {
                read.createFile(deletedVFile.getCanonicalPath()).delete();
            }
            memoryFS.copyTo((VFileSystem)read);
            this.mdPersistence.saveMdProject(draftProject, ProjectType.DRAFT);
            this.mdPersistence.saveMetadataArtifact(DraftProject.class, (VFileSystem)read, ((MdProjectImpl)((Object)draftProject)).getMetadata());
            read.flush();
            tx.commit();
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        catch (JAXBException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
        catch (Throwable e) {
            tx.rollback();
            throw new AbortedOperationMetadataException(e);
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public void updatePublicShare(@NotNull PublicShareProject publicShare) throws MetadataException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.updatePublicShare must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            ProjectFolder folder = publicShare.getFolder().get();
            if (!this.existsProject(PublicShareProject.class, folder)) {
                throw MetadataExceptionFactory.createProjectNotFound((String)folder.getLocation());
            }
            this.mdPersistence.saveMdProject(publicShare, ProjectType.PUBLIC_SHARED);
            tx.commit();
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public PublicShareProject savePublicShare(@NotNull ProjectFolder location, @NotNull PublicShareProject mdPublicShare, @NotNull String userName, boolean checkVersion, boolean keepLock) throws MetadataException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.savePublicShare must not be null");
        }
        if (mdPublicShare == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.savePublicShare must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.savePublicShare must not be null");
        }
        mdPublicShare.setProjectFromScratch(true);
        PublicShareInfo publicShareInfo = PublicShareInfo.checkAndLockPublicShare(this, this.mdsInstance, location, mdPublicShare, this.mdPersistence, userName, checkVersion);
        this.doSavePublicShare(publicShareInfo, mdPublicShare);
        PublicShareProject result = this.manageLock(publicShareInfo, keepLock);
        result.setProjectFromScratch(true);
        return result;
    }

    @Override
    public PublicShareProject createPublicShare(@NotNull ProjectFolder location, @NotNull PublicShareProject publicShareProject, @NotNull TemplateProject templateProject, @NotNull String userName, boolean checkVersion, boolean keepLock) throws MetadataException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createPublicShare must not be null");
        }
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createPublicShare must not be null");
        }
        if (templateProject == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createPublicShare must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createPublicShare must not be null");
        }
        if (templateProject.getProject() == null) {
            throw MetadataExceptionFactory.createInvalidProjectException();
        }
        if (!this.existsProject(TemplateProject.class, templateProject.getFolder().get())) {
            throw MetadataExceptionFactory.createProjectNotFound((String)templateProject.getParentFolder().get().getLocation());
        }
        String publicShareName = publicShareProject.getName();
        Project template = templateProject.getProject().get();
        PublicShareProject ps = new PublicShareProject(publicShareName, template);
        MetadataArtifactHelper.copyPublicShare(ps, publicShareProject);
        ps.setProjectFromScratch(false);
        PublicShareInfo publicShareInfo = PublicShareInfo.checkAndLockPublicShare(this, this.mdsInstance, location, ps, this.mdPersistence, userName, checkVersion);
        if (publicShareInfo.exists()) {
            throw MetadataExceptionFactory.createProjectAlreadyExists((String)publicShareInfo.getProjectId());
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            PublicShareProject result = this.doSavePublicShare(publicShareInfo, ps);
            result.setProjectFromScratch(false);
            String templateHumanRevisionId = templateProject.getProperty(PropertyKeys.HUMAN_REVISION_ID.getKey());
            String templateHistoryRevisionId = templateProject.getProperty(PropertyKeys.HISTORY_REVISION_ID.getKey());
            if (templateHistoryRevisionId == null || templateHumanRevisionId == null) {
                String templateOwner = templateProject.getOwnerName();
                if (templateOwner == null) {
                    templateOwner = STUDIO_USER;
                }
                VFileSystem templateFs = template.getLoader().getProjectFileSystem().getDataFileSystem();
                MetadataType templateMetadata = this.mdPersistence.loadMetadataArtifact(TemplateProject.class, ProjectFolder.create(templateProject.getId()));
                List<ChangedFile> changedFiles = ChangedFileHelper.processChangedFilesScratchProject(templateFs.getRoot());
                Date date = Calendar.getInstance().getTime();
                Map<String, String> hashes = ChangedFileHelper.calculateHashes(templateFs.getRoot());
                HistoryProjectMetadata historyProjectMetadata = new HistoryProjectMetadata(hashes);
                historyProjectMetadata.setHumanRevisionId(this.calculateNewHumanId(templateMetadata));
                historyProjectMetadata.setInitialChange(true);
                Change change = new Change(templateOwner, changedFiles, templateProject.getId(), date, this.logicalArtifactRecognizer.recognize(changedFiles), historyProjectMetadata, ProjectType.PUBLIC_SHARED.value());
                this.historyService.saveChange(change);
                templateMetadata = UpdateFromBaseTemplateHelper.writeTemplateRevisionProperties(this.historyService, templateProject.getId(), templateMetadata, date, null);
                templateMetadata.setCreator(templateOwner);
                this.mdPersistence.saveMetadataArtifact(TemplateProject.class, templateFs, templateMetadata);
                templateMetadata = this.mdPersistence.loadMetadataArtifact(TemplateProject.class, ProjectFolder.create(templateProject.getId()));
                templateHumanRevisionId = MetadataArtifactHelper.findProperty(templateMetadata, PropertyKeys.HUMAN_REVISION_ID.getKey()).getValue();
                templateHistoryRevisionId = MetadataArtifactHelper.findProperty(templateMetadata, PropertyKeys.HISTORY_REVISION_ID.getKey()).getValue();
            }
            MetadataType metadata = UpdateFromBaseTemplateHelper.writePublicShareRevisionProperties(result.getMetadata(), templateHistoryRevisionId, templateHumanRevisionId, templateProject.getId());
            this.mdPersistence.saveMetadataArtifact(PublicShareProject.class, result.getProject().get().getLoader().getProjectFileSystem().getDataFileSystem(), metadata);
            tx.commit();
            String templateName = templateProject.getProject().get().getName();
            Project loadedProject = this.loadProject(PublicShareProject.class, location.getLocation() + "/" + publicShareName, true).get().getProject().get();
            if (!templateName.equals(publicShareName)) {
                FuegoProject fuegoProject = (FuegoProject)result.getProject().get();
                JaxbScaController jaxbScaController = new JaxbScaController((Project)fuegoProject);
                jaxbScaController.commitChanges();
                MdsProjectWriter writer = (MdsProjectWriter)loadedProject.getWriter();
                writer.write(new ProjectObject[]{loadedProject.getOrganization()});
                writer.flushChanges();
            }
            this.flushProjectWriter(result.getProject().get(), templateProject.getName(), false);
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        catch (ProjectException e) {
            tx.rollback();
            throw new MetadataException((Throwable)e);
        }
        catch (IOException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
        return this.manageLock(publicShareInfo, keepLock);
    }

    @Override
    public boolean isPublicShareUpToDate(@NotNull ProjectFolder folder, @NotNull PublicShareProject publicShareProject) throws MetadataException {
        boolean result;
        if (folder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.isPublicShareUpToDate must not be null");
        }
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.isPublicShareUpToDate must not be null");
        }
        String projectName = publicShareProject.getName();
        String relativeProjectLocation = folder.getLocation() + "/" + projectName;
        ProjectFolder projectFolder = ProjectFolder.create(relativeProjectLocation);
        try {
            MetadataType metadata = this.mdPersistence.loadMetadataArtifact(PublicShareProject.class, projectFolder);
            try {
                result = true;
                Utils.checkTimestamp(metadata, publicShareProject.getMetadata());
            }
            catch (MetadataException e) {
                result = false;
            }
        }
        catch (MetadataException e) {
            throw MetadataExceptionFactory.createProjectNotFound((String)folder.getLocation());
        }
        return result;
    }

    @Override
    public void commitChanges(@NotNull String location, @NotNull String userName) throws MetadataException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.commitChanges must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.commitChanges must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            MetadataType metadata = this.mdPersistence.loadMetadataArtifact(DraftProject.class, ProjectFolder.create(location));
            if (metadata == null) {
                throw MetadataExceptionFactory.createProjectNotFound((String)location);
            }
            Filesystem filesystem = metadata.getTopology().getFilesystem();
            CowFilesystem cowFilesystem = filesystem.getCowFilesystem();
            Filesystem read = cowFilesystem.getRead();
            String basePathPublicShare = MetadataArtifactHelper.getRelativePathFrom(ProjectType.PUBLIC_SHARED);
            String publicShareLocation = read.getSimpleFilesystem().substring(basePathPublicShare.length());
            CopyOnWriteFS copyOnWriteFs = (CopyOnWriteFS)Cast.force((Object)MetadataArtifactHelper.convertToVFileSystem(this.mdsInstance, filesystem));
            List<ChangedFile> changedFiles = ChangedFileHelper.processChangedFiles(copyOnWriteFs);
            Map<String, String> sourceHashes = ChangedFileHelper.calculateHashes(copyOnWriteFs.getRoot());
            this.mdPersistence.commitChanges(metadata);
            this.releaseLock(location);
            String publicShareCannonicalPath = VFileUtils.getCanonicalPath((String)publicShareLocation);
            ProjectFolder folder = ProjectFolder.create(publicShareCannonicalPath);
            MetadataType publicShareMetadata = this.mdPersistence.loadMetadataArtifact(PublicShareProject.class, folder);
            publicShareMetadata.setUpdateTimestamp(datatypeFactory.newXMLGregorianCalendar(new GregorianCalendar()));
            publicShareMetadata.setDescription(metadata.getDescription());
            MdsFileSystem fileSystem = new MdsFileSystem(this.mdsInstance, basePathPublicShare + publicShareCannonicalPath);
            this.mdPersistence.saveMetadataArtifact(PublicShareProject.class, fileSystem, publicShareMetadata);
            fileSystem.flush();
            this.mdPersistence.releaseFromCache(metadata);
            this.mdPersistence.releaseFromCache(publicShareMetadata);
            if (!changedFiles.isEmpty()) {
                HistoryProjectMetadata historyProjectMetadata = new HistoryProjectMetadata(sourceHashes);
                historyProjectMetadata.setInitialChange(false);
                String id = new PublicShareProjectExt(this.mdPersistence, publicShareLocation, metadata).getId();
                Change change = new Change(userName, changedFiles, id, Calendar.getInstance().getTime(), this.logicalArtifactRecognizer.recognize(changedFiles), historyProjectMetadata, ProjectType.PUBLIC_SHARED.value());
                this.historyService.saveChange(change);
            }
            tx.commit();
            this.mdPersistence.releaseFromCache(publicShareMetadata);
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        catch (IOException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
        catch (Throwable e) {
            tx.rollback();
            throw new AbortedOperationMetadataException(e);
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public <T extends MdProject<?>> void createFolder(@NotNull Class<T> context, @NotNull ProjectFolder folder) throws MetadataException {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createFolder must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createFolder must not be null");
        }
        this.mdPersistence.createFolder(context, folder);
    }

    @Override
    public <T extends MdProject<?>> boolean existsFolder(@NotNull Class<T> type, @NotNull ProjectFolder folder) throws PersistenceException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.existsFolder must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.existsFolder must not be null");
        }
        return this.mdPersistence.existsFolder(type, folder);
    }

    @Override
    public <T extends MdProject<?>> void removeFolder(@NotNull Class<T> context, @NotNull ProjectFolder folder, boolean recursive) throws MetadataException {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.removeFolder must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.removeFolder must not be null");
        }
        if (!this.mdPersistence.existsFolder(context, folder)) {
            throw MetadataExceptionFactory.createProjectNotFound((String)folder.getLocation());
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            Collection<LocalRef<T>> refCollection = this.mdPersistence.find(context, folder.getLocalRef(), null, true);
            if (!refCollection.isEmpty()) {
                if (recursive) {
                    for (LocalRef<T> localRef : refCollection) {
                        MdProject project = (MdProject)localRef.get();
                        ProjectFolder projectFolder = project.getFolder().get();
                        if (project instanceof PublicShareProject) {
                            this.removePublicShare((PublicShareProject)project);
                            continue;
                        }
                        if (project instanceof DraftProject) {
                            this.releaseLock(projectFolder.getLocation());
                            continue;
                        }
                        if (!(project instanceof TemplateProject)) continue;
                        this.removeTemplate((TemplateProject)project, true);
                    }
                } else {
                    throw new MetadataException(MetadataMsg.FOLDER_NOT_EMPTY((String)folder.getLocation()));
                }
            }
            this.mdPersistence.removeFolder(context, folder, recursive);
            tx.commit();
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public void releaseLock(@NotNull PublicShareProject publicShareProject) throws MetadataException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.releaseLock must not be null");
        }
        String projectLocation = publicShareProject.getFolder().get().getLocation();
        LocalRef<PublicShareProject> loadedProject = this.loadProject(PublicShareProject.class, projectLocation, false);
        PublicShareProject shareProject = loadedProject.get();
        if (shareProject.isLocked() && shareProject.getUserLock() != null) {
            StringBuilder location = new StringBuilder(projectLocation);
            location.append("/").append(HashUtils.generateMd5((String)shareProject.getUserLock()));
            try {
                this.releaseLock(location.toString());
            }
            catch (ProjectNotFoundException e) {
                StringBuilder compatibilityLocation = new StringBuilder(projectLocation);
                compatibilityLocation.append("/").append(shareProject.getUserLock());
                this.releaseLock(compatibilityLocation.toString());
            }
        }
    }

    @Override
    public void releaseLock(@NotNull String draftLocation) throws MetadataException {
        if (draftLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.releaseLock must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            ProjectFolder folder = ProjectFolder.create(draftLocation);
            int index = draftLocation.lastIndexOf(47);
            String publicShareLocation = draftLocation.substring(0, index);
            String userName = draftLocation.substring(index + 1);
            PublicShareProject loadedProject = this.loadProject(PublicShareProject.class, publicShareLocation, false).get();
            if (!loadedProject.isLocked()) {
                tx.rollback();
                return;
            }
            this.checkLockedProject(loadedProject, userName);
            DraftProject draftProject = this.loadProject(DraftProject.class, draftLocation, true).get();
            this.removeProject(DraftProject.class, draftProject);
            folder = folder.getParentFolder().get();
            LocalRef<PublicShareProject> projectLocalRef = this.loadProject(PublicShareProject.class, folder.getLocation(), false);
            PublicShareProject publicShareProject = projectLocalRef.get();
            this.mdPersistence.releaseLock(publicShareProject);
            ProjectFolder rootFolder = ProjectFolder.create("/");
            try {
                while (!rootFolder.equals(folder)) {
                    this.mdPersistence.removeFolder(DraftProject.class, folder, false);
                    folder = folder.getParentFolder().get();
                }
            }
            catch (PersistenceException ignore) {
                // empty catch block
            }
            tx.commit();
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public <T extends MdProject<?>> void releaseFromCache(@NotNull Class<T> type, @NotNull String projectLocation) throws MetadataException {
        MetadataType metadataType;
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.releaseFromCache must not be null");
        }
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.releaseFromCache must not be null");
        }
        if (DeployedProject.class.isAssignableFrom(type)) {
            String mountPoint = Namespace.SOAINFRA.getMdsNamespace().getPath() + "/" + projectLocation;
            metadataType = MetadataArtifactBuilder.create(projectLocation, "", projectLocation);
            Topology topology = new Topology();
            Filesystem filesystem = new Filesystem();
            filesystem.setSimpleFilesystem(mountPoint);
            topology.setFilesystem(filesystem);
            metadataType.setTopology(topology);
            metadataType.setName(projectLocation);
            metadataType.setProjectType(ProjectType.DEPLOY);
        } else {
            metadataType = this.mdPersistence.loadMetadataArtifact(type, ProjectFolder.create(projectLocation));
        }
        if (metadataType != null) {
            this.mdPersistence.releaseFromCache(metadataType);
        }
    }

    @Override
    public void updatePublicShareProperties(@NotNull String publicShareId, boolean allowSharing, @Nullable String workflow, @Nullable List<String> participantIds) throws MetadataException {
        if (publicShareId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.updatePublicShareProperties must not be null");
        }
        LocalRef<PublicShareProject> publicShareProjectLocalRef = this.loadProject(PublicShareProject.class, publicShareId, false);
        PublicShareProject publicShareProject = publicShareProjectLocalRef.get();
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            PublicShareMetadata type = (PublicShareMetadata)publicShareProject.getMetadata();
            type.setAllowShare(allowSharing);
            type.setWorkflowUrl(workflow);
            PublicShareMetadata.WorkflowParticipants wp = new PublicShareMetadata.WorkflowParticipants();
            if (participantIds != null) {
                wp.getParticipantId().addAll(participantIds);
            }
            type.setWorkflowParticipants(wp);
            LocalRef<Project> projectLocalRef = publicShareProject.getProject();
            Project project = projectLocalRef.get();
            ProjectLoader loader = project.getLoader();
            assert (loader != null);
            VFileSystem system = loader.getProjectFileSystem().getDataFileSystem();
            this.mdPersistence.saveMetadataArtifact(PublicShareProject.class, system, type);
            tx.commit();
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public LocalRef<DeployedProject> getDeployedProject(@NotNull String projectLocation) throws MetadataException {
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.getDeployedProject must not be null");
        }
        String mountPoint = Namespace.SOAINFRA.getMdsNamespace().getPath() + "/" + projectLocation;
        MetadataType metadata = MetadataArtifactBuilder.create(projectLocation, "", projectLocation);
        String fullPath = VFileUtils.getCanonicalPath((String)projectLocation);
        LinkedList parts = VFileUtils.canonicalDecomposition((String)fullPath);
        Topology topology = new Topology();
        Filesystem filesystem = new Filesystem();
        filesystem.setSimpleFilesystem(mountPoint);
        topology.setFilesystem(filesystem);
        metadata.setTopology(topology);
        metadata.setName((String)parts.get(parts.size() - 1));
        metadata.setProjectType(ProjectType.DEPLOY);
        return this.mdPersistence.getMdProject(DeployedProject.class, projectLocation, metadata);
    }

    @Override
    public <T extends MdProject<?>> void importProject(@NotNull File sourceFolder, @NotNull Class<T> type, @NotNull ProjectFolder destination, @NotNull String userName, @NotNull String projectName, @Nullable String description) throws MetadataException {
        if (sourceFolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.importProject must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.importProject must not be null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.importProject must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.importProject must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.importProject must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            String absoluteLocation = Utils.getAbsoluteLocation(type, destination, projectName);
            ProjectFolder projectFolder = ProjectFolder.create(destination, projectName);
            if (this.existsProject(type, projectFolder)) {
                throw MetadataExceptionFactory.createProjectAlreadyExists((String)projectName, (String)absoluteLocation);
            }
            if (this.existsFolder(type, projectFolder)) {
                throw MetadataExceptionFactory.createArtifactAlreadyExists((String)projectFolder.getLocation());
            }
            MdsFileSystem target = new MdsFileSystem(this.mdsInstance, absoluteLocation);
            tx.begin();
            FileProjectRepository projectRepository = FileProjectRepository.create(sourceFolder.getParentFile());
            Project project = projectRepository.create(sourceFolder.getName());
            ProjectType projectType = MetadataArtifactHelper.getProjectType(type);
            if (projectType.equals((Object)ProjectType.TEMPLATE)) {
                if (!project.isTemplate()) {
                    ProjectPreferences preferences = project.getPreferences();
                    preferences.setTemplate(true);
                    preferences.setTemplateName(projectName);
                    ProjectWriter writer = project.getWriter();
                    writer.write(new ProjectObject[]{preferences});
                }
            } else if (project.isTemplate()) {
                throw MetadataExceptionFactory.createProjectIsNotPublicShare();
            }
            MetadataType metadata = this.mdPersistence.saveMdProject(type, projectName, description, absoluteLocation, project, target);
            String id = new PublicShareProjectExt(this.mdPersistence, projectFolder.getLocation(), metadata).getId();
            Date date = Calendar.getInstance().getTime();
            List<ChangedFile> changedFiles = ChangedFileHelper.processChangedFilesScratchProject(target.getRoot());
            HistoryProjectMetadata historyProjectMetadata = new HistoryProjectMetadata(ChangedFileHelper.calculateHashes(target.getRoot()));
            historyProjectMetadata.setHumanRevisionId(this.calculateNewHumanId(metadata));
            historyProjectMetadata.setInitialChange(true);
            Change change = new Change(userName, changedFiles, id, date, this.logicalArtifactRecognizer.recognize(changedFiles), historyProjectMetadata, projectType.value());
            this.historyService.saveChange(change);
            if (projectType.equals((Object)ProjectType.TEMPLATE)) {
                metadata = UpdateFromBaseTemplateHelper.writeTemplateRevisionProperties(this.historyService, id, metadata, date, null);
                metadata.setCreator(userName);
                this.mdPersistence.saveMetadataArtifact(TemplateProject.class, target, metadata);
            } else {
                PublicShareMetadata publicShareMetadata = (PublicShareMetadata)MetadataArtifactHelper.getMetadataArtifact(target, PublicShareProject.class, "/");
                publicShareMetadata.setCreator(userName);
                publicShareMetadata.setIsFromScratch(true);
                this.mdPersistence.saveMetadataArtifact(PublicShareProject.class, target, publicShareMetadata);
                this.setHumanTaskNamespaceSuffix(target);
            }
            tx.commit();
            String projectLocation = destination.getLocation() + "/" + projectName;
            Project importedProject = ((MdProject)this.loadProject(type, projectLocation, true).get()).getProject().get();
            if (!projectName.equals(project.getName())) {
                ((FuegoProject)importedProject).setName(projectName);
                JaxbScaController jaxbScaController = new JaxbScaController(importedProject);
                jaxbScaController.commitChanges();
                MdsProjectWriter writer = (MdsProjectWriter)importedProject.getWriter();
                writer.write(new ProjectObject[]{importedProject.getOrganization()});
                writer.flushChanges();
            }
        }
        catch (ProjectException e) {
            tx.rollback();
            throw new MetadataException((Throwable)e);
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        catch (JAXBException e) {
            tx.rollback();
            throw PersistenceException.createIOException(e);
        }
        catch (IOException e) {
            tx.rollback();
            throw new MetadataException((Throwable)e);
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public <T extends MdProject<?>> void updateProperties(@NotNull Class<T> type, @NotNull String projectLocation, @NotNull HashMap<String, String> newProperties) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.updateProperties must not be null");
        }
        if (projectLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.updateProperties must not be null");
        }
        if (newProperties == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.updateProperties must not be null");
        }
        LocalRef<T> tLocalRef = this.mdPersistence.loadMdProject(type, projectLocation, false);
        if (tLocalRef == null) {
            throw MetadataExceptionFactory.createProjectNotFound((String)projectLocation);
        }
        LocalRef<Project> projectRef = ((MdProject)tLocalRef.get()).getProject();
        Project project = projectRef.get();
        ProjectLoader loader = project.getLoader();
        assert (loader != null);
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            VFileSystem dataFileSystem = loader.getProjectFileSystem().getDataFileSystem();
            MetadataType metadataType = this.mdPersistence.loadMetadataArtifact(type, ProjectFolder.create(projectLocation));
            MetadataType.Properties oldProperties = metadataType.getProperties();
            if (oldProperties == null) {
                oldProperties = new MetadataType.Properties();
                metadataType.setProperties(oldProperties);
            }
            List<MetadataType.Properties.Property> propertyList = oldProperties.getProperty();
            for (String name : newProperties.keySet()) {
                String value = newProperties.get(name);
                MetadataType.Properties.Property property = MetadataArtifactHelper.findProperty(metadataType, name);
                if (property == null && value != null) {
                    property = new MetadataType.Properties.Property();
                    property.setKey(name);
                    property.setValue(value);
                    propertyList.add(property);
                    continue;
                }
                if (property != null && value == null) {
                    propertyList.remove(property);
                    continue;
                }
                if (property == null) continue;
                property.setValue(value);
            }
            this.mdPersistence.saveMetadataArtifact(type, dataFileSystem, metadataType);
            tx.commit();
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public DraftProject getLock(@NotNull PublicShareProject publicShareProject, @NotNull String username) throws MetadataException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.getLock must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.getLock must not be null");
        }
        DraftProject result = null;
        String location = publicShareProject.getFolder().get().getLocation();
        LocalRef<PublicShareProject> projectLocalRef = this.loadProject(PublicShareProject.class, location, false);
        PublicShareProject savedPublicShare = projectLocalRef.get();
        if (!savedPublicShare.isLocked()) {
            MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
            tx.setAutoCommit(false);
            try {
                tx.begin();
                LockType lock = new LockType();
                lock.setUsername(username);
                lock.setApplicationType(this.applicationType);
                lock.setTimestamp(datatypeFactory.newXMLGregorianCalendar(new GregorianCalendar()));
                ProjectLoader loader = savedPublicShare.getProject().get().getLoader();
                assert (loader != null);
                ProjectFileSystem projectFileSystem = loader.getProjectFileSystem();
                VFileSystem dataFileSystem = projectFileSystem.getDataFileSystem();
                this.mdPersistence.acquireLock(dataFileSystem, lock);
                result = this.mdPersistence.createDraftProject(savedPublicShare, username);
                dataFileSystem.flush();
                tx.commit();
                DraftProject draftProject = result;
                return draftProject;
            }
            catch (MetadataException e) {
                tx.rollback();
                throw e;
            }
            catch (IOException e) {
                tx.rollback();
                throw new MetadataException((Throwable)e);
            }
            finally {
                MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
            }
        }
        this.checkLockedProject(savedPublicShare, username);
        result = this.loadDraftProject(savedPublicShare.getFolder().get().getLocation(), username).get();
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void createSnapshot(@NotNull PublicShareProject publicShareProject, @NotNull String versionName, @Nullable String description, @NotNull String userName) throws MetadataException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createSnapshot must not be null");
        }
        if (versionName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createSnapshot must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.createSnapshot must not be null");
        }
        ProjectFolder projectByName = this.findProjectByName(PublicShareProject.class, publicShareProject.getName());
        if (projectByName == null) {
            throw MetadataExceptionFactory.createProjectNotFound((String)publicShareProject.getName());
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        Object outputStream = null;
        try {
            tx.begin();
            Project fromProject = publicShareProject.getProject().get();
            String absoluteLocation = Utils.getAbsoluteLocation(SnapshotProject.class, publicShareProject.getFolder().get(), versionName);
            ProjectFolder projectFolder = ProjectFolder.create(publicShareProject.getFolder().get(), versionName);
            if (this.existsProject(SnapshotProject.class, projectFolder)) {
                throw MetadataExceptionFactory.createProjectAlreadyExists((String)versionName, (String)absoluteLocation);
            }
            MdsFileSystem targetFs = new MdsFileSystem(this.mdsInstance, absoluteLocation);
            VFile publicShareMetadataOnSnapshot = targetFs.createFile("/projectMetadata.xml.snapshot");
            ObjectFactory objectFactory = new ObjectFactory();
            MetadataArtifactHelper.serialize(objectFactory.createMetadata(publicShareProject.getMetadata()), publicShareMetadataOnSnapshot);
            MetadataType snapshotMetadata = this.mdPersistence.saveMdProject(SnapshotProject.class, versionName, description, absoluteLocation, fromProject, targetFs);
            snapshotMetadata.setCreator(userName);
            this.mdPersistence.saveMetadataArtifact(SnapshotProject.class, targetFs, snapshotMetadata);
            tx.commit();
        }
        catch (MetadataException e) {
            try {
                tx.rollback();
                throw e;
                catch (IOException e2) {
                    tx.rollback();
                    throw new MetadataException((Throwable)e2);
                }
                catch (Throwable e3) {
                    tx.rollback();
                    throw new AbortedOperationMetadataException(e3);
                }
            }
            catch (Throwable throwable) {
                MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
                StreamUtils.close((Closeable[])new Closeable[]{outputStream});
                throw throwable;
            }
        }
        MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        StreamUtils.close((Closeable[])new Closeable[]{outputStream});
    }

    @Override
    public List<LocalRef<SnapshotProject>> listSnapshots(@NotNull String publicshareId) throws MetadataException {
        if (publicshareId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.listSnapshots must not be null");
        }
        MdTree mdTree = this.browseProject(SnapshotProject.class, null, ProjectFolder.create(publicshareId).getLocalRef());
        Collection snapshotsCollection = mdTree.toCollection(true);
        return new ArrayList<LocalRef<SnapshotProject>>(snapshotsCollection);
    }

    @Override
    public void deleteSnapshot(@NotNull String snapshotId) throws MetadataException {
        if (snapshotId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.deleteSnapshot must not be null");
        }
        ProjectFolder projectFolder = ProjectFolder.create(snapshotId);
        this.removeFolder(SnapshotProject.class, projectFolder, true);
    }

    @Override
    public void deleteAllSnapshotsFromPublicShare(@NotNull String publicShareId) throws MetadataException {
        if (publicShareId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.deleteAllSnapshotsFromPublicShare must not be null");
        }
        ProjectFolder projectFolder = ProjectFolder.create(publicShareId);
        this.removeFolder(SnapshotProject.class, projectFolder, true);
    }

    @Override
    public LocalRef<SnapshotProject> getSnapshot(@NotNull String publicshareId, @NotNull String versionName) throws MetadataException {
        if (publicshareId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.getSnapshot must not be null");
        }
        if (versionName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.getSnapshot must not be null");
        }
        String location = publicshareId + "/" + versionName;
        return this.loadProject(SnapshotProject.class, location, false);
    }

    @Override
    public <T extends MdProject<?>> ProjectFolder findProjectByName(@NotNull Class<T> type, @NotNull String projectName) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.findProjectByName must not be null");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.findProjectByName must not be null");
        }
        ProjectFolder result = null;
        T project = this.mdPersistence.findProjectByName(type, null, projectName, true);
        if (project != null) {
            result = (ProjectFolder)Cast.force((Object)project.getFolder().get());
        }
        return result;
    }

    @Override
    public UpdateResult updatePublicShareFromBaseTemplate(@NotNull PublicShareProject publicShare, @NotNull String userName) throws MetadataException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.updatePublicShareFromBaseTemplate must not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.updatePublicShareFromBaseTemplate must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            tx.begin();
            UpdateResult updateResult = this.calculateFilesToBeUpdated(publicShare);
            List filesToBeUpdated = updateResult.getUpdatedFiles();
            String baseTemplateId = publicShare.getProperty(PropertyKeys.BASE_TEMPLATE_ID.getKey());
            TemplateProject templateProject = this.loadProject(TemplateProject.class, baseTemplateId, true).get();
            VFileSystem sourceFileSystem = templateProject.getProject().get().getLoader().getProjectFileSystem().getDataFileSystem();
            VFileSystem targetFileSystem = publicShare.getProject().get().getLoader().getProjectFileSystem().getDataFileSystem();
            for (ChangedFile fileToBeUpdated : filesToBeUpdated) {
                VFile sourceVFile = sourceFileSystem.createFile(fileToBeUpdated.getCanonicalPath());
                VFile targetVFile = targetFileSystem.createFile(fileToBeUpdated.getCanonicalPath());
                VFileUtils.fileCopy((VFile)sourceVFile, (VFile)targetVFile);
            }
            String templateHistoryRevisionId = templateProject.getProperty(PropertyKeys.HISTORY_REVISION_ID.getKey());
            String templateHumanRevisionId = templateProject.getProperty(PropertyKeys.HUMAN_REVISION_ID.getKey());
            MetadataType publicShareMetadata = UpdateFromBaseTemplateHelper.writePublicShareRevisionProperties(publicShare.getMetadata(), templateHistoryRevisionId, templateHumanRevisionId, null);
            this.mdPersistence.saveMetadataArtifact(PublicShareProject.class, targetFileSystem, publicShareMetadata);
            if (!filesToBeUpdated.isEmpty()) {
                Map<String, String> hashes = ChangedFileHelper.calculateHashes(sourceFileSystem.getRoot());
                HistoryProjectMetadata historyProjectMetadata = new HistoryProjectMetadata(hashes);
                historyProjectMetadata.setHumanRevisionId(templateHumanRevisionId);
                Change change = new Change(userName, filesToBeUpdated, publicShare.getId(), Calendar.getInstance().getTime(), this.logicalArtifactRecognizer.recognize(filesToBeUpdated), historyProjectMetadata, ProjectType.PUBLIC_SHARED.value());
                this.historyService.saveChange(change);
            }
            tx.commit();
            UpdateResult updateResult2 = updateResult;
            return updateResult2;
        }
        catch (MetadataException e) {
            tx.rollback();
            throw e;
        }
        catch (IOException e) {
            tx.rollback();
            throw MetadataExceptionFactory.createUnableToUpdateFromBaseTemplate((String)publicShare.getId());
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    @Override
    public UpdateResult calculateFilesToBeUpdated(@NotNull PublicShareProject publicShare) throws MetadataException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.calculateFilesToBeUpdated must not be null");
        }
        return UpdateFromBaseTemplateHelper.calculateFilesToBeUpdated(this.historyService, publicShare);
    }

    @Override
    public boolean isAdmin() {
        return this.isAdmin;
    }

    @Override
    public void setIsAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    private void checkLockedProject(@NotNull PublicShareProject publicShare, @NotNull String usernameKey) throws MetadataException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.checkLockedProject must not be null");
        }
        if (usernameKey == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.checkLockedProject must not be null");
        }
        String applicationName = "";
        if (publicShare.isLocked()) {
            String username = publicShare.getUserLock();
            String hashedUserName = HashUtils.generateMd5((String)username);
            ApplicationType applicationLock = publicShare.getApplicationLock();
            if (!this.isAdmin()) {
                boolean isLocked = false;
                boolean isLockedFromSameApp = this.applicationType.equals((Object)applicationLock);
                if (!isLockedFromSameApp) {
                    isLocked = true;
                } else if (!hashedUserName.equals(usernameKey) && !HashUtils.generateMd5((String)usernameKey).equals(hashedUserName)) {
                    isLocked = true;
                }
                if (isLocked) {
                    if (ApplicationType.COMPOSER.equals((Object)applicationLock)) {
                        applicationName = MetadataMsg.APPLICATION_COMPOSER.getString();
                    } else if (ApplicationType.STUDIO.equals((Object)applicationLock)) {
                        applicationName = MetadataMsg.APPLICATION_STUDIO.getString();
                    }
                    throw MetadataExceptionFactory.createProjectLockedException((String)usernameKey, (String)applicationName);
                }
            }
        }
    }

    private void flushProjectWriter(Project project, String templateName, boolean isTemplate) throws ProjectException {
        ProjectPreferences preferences = project.getPreferences();
        preferences.setTemplate(isTemplate);
        preferences.setTemplateName(templateName);
        MdsProjectWriter writer = (MdsProjectWriter)project.getWriter();
        writer.write(new ProjectObject[]{preferences});
        writer.flushChanges();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PublicShareProject doSavePublicShare(@NotNull PublicShareInfo publicShareInfo, @NotNull PublicShareProject mdPublicShare) throws MetadataException {
        if (publicShareInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.doSavePublicShare must not be null");
        }
        if (mdPublicShare == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.doSavePublicShare must not be null");
        }
        boolean exceptionThrown = false;
        PublicShareProject result = null;
        PublicShareMetadata metadataType = null;
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance);
        tx.setAutoCommit(false);
        try {
            HashMap<String, String> oldHashes;
            block18: {
                block17: {
                    tx.begin();
                    if (!publicShareInfo.exists()) break block17;
                    oldHashes = ChangedFileHelper.getRemoteHashes(this.historyService, publicShareInfo.getProjectId());
                    if (!publicShareInfo.sameFileSystem()) {
                        try {
                            this.removeProject(publicShareInfo.getTargetFs());
                        }
                        catch (IOException e) {
                            throw PersistenceException.createIOException(e);
                        }
                        metadataType = (PublicShareMetadata)MetadataArtifactHelper.getMetadataArtifact(publicShareInfo.getTargetFs(), PublicShareProject.class, "/");
                    }
                    break block18;
                }
                oldHashes = new HashMap();
            }
            if (metadataType == null) {
                metadataType = (PublicShareMetadata)mdPublicShare.getMetadata();
            }
            result = this.mdPersistence.createPublicShareProject(mdPublicShare, publicShareInfo.getAbsoluteLocation(), publicShareInfo.getTargetFs(), metadataType);
            this.setHumanTaskNamespaceSuffix(publicShareInfo.getTargetFs());
            Map<String, String> newHashes = ChangedFileHelper.calculateHashes(publicShareInfo.getSourceFs().getRoot());
            this.saveHistory(publicShareInfo, oldHashes, newHashes);
            tx.commit();
            result.setUpToDateFromBaseTemplate(true);
        }
        catch (MetadataException e) {
            try {
                tx.rollback();
                exceptionThrown = true;
                throw e;
                catch (JAXBException e2) {
                    tx.rollback();
                    exceptionThrown = true;
                    throw PersistenceException.createIOException(e2);
                }
                catch (Throwable e3) {
                    tx.rollback();
                    exceptionThrown = true;
                    throw new AbortedOperationMetadataException(e3);
                }
            }
            catch (Throwable throwable) {
                MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
                if (!exceptionThrown) throw throwable;
                if (publicShareInfo.wasOriginallyLocked()) throw throwable;
                if (result == null) throw throwable;
                try {
                    this.releaseLock(result);
                    throw throwable;
                }
                catch (MetadataException exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        if (exceptionThrown && !publicShareInfo.wasOriginallyLocked() && result != null) {
            try {
                this.releaseLock(result);
            }
            catch (MetadataException exception) {}
        }
        publicShareInfo.setLoadedPublicShare(result);
        return result;
    }

    private PublicShareProject manageLock(@NotNull PublicShareInfo publicShareInfo, boolean keepLock) throws MetadataException {
        if (publicShareInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.manageLock must not be null");
        }
        if (keepLock) {
            if (!publicShareInfo.exists()) {
                this.getLock(publicShareInfo.getLoadedPublicShare(), publicShareInfo.getUserName());
            }
        } else if (publicShareInfo.exists()) {
            this.releaseLock(publicShareInfo.getLoadedPublicShare());
        } else {
            this.removeLockFile(publicShareInfo.getTargetFs());
        }
        return this.loadProject(PublicShareProject.class, publicShareInfo.getProjectId(), true).get();
    }

    private void saveHistory(@NotNull PublicShareInfo publicShareInfo, @NotNull Map<String, String> oldHashes, @NotNull Map<String, String> newHashes) throws HistoryException {
        if (publicShareInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.saveHistory must not be null");
        }
        if (oldHashes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.saveHistory must not be null");
        }
        if (newHashes == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.saveHistory must not be null");
        }
        List<ChangedFile> changedFiles = ChangedFileHelper.compareHashes(oldHashes, newHashes);
        if (!changedFiles.isEmpty()) {
            HistoryProjectMetadata historyProjectMetadata = new HistoryProjectMetadata(newHashes);
            historyProjectMetadata.setInitialChange(!publicShareInfo.exists());
            Change change = new Change(publicShareInfo.getUserName(), changedFiles, publicShareInfo.getProjectId(), Calendar.getInstance().getTime(), this.logicalArtifactRecognizer.recognize(changedFiles), historyProjectMetadata, ProjectType.PUBLIC_SHARED.value());
            this.historyService.saveChange(change);
        }
    }

    private void removeLockFile(@NotNull VFileSystem vFileSystem) throws MetadataException {
        if (vFileSystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.removeLockFile must not be null");
        }
        VFile file = vFileSystem.createFile("project.lock");
        if (file.exists()) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHumanTaskNamespaceSuffix(VFileSystem system) throws IOException, JAXBException {
        block3: {
            VFile[] files = system.getRoot().listFiles(new VFileFilter(){

                public boolean accept(@NotNull VFile pathname) {
                    return pathname.getCanonicalPath().endsWith(".task");
                }
            });
            if (files == null) break block3;
            for (VFile file : files) {
                TaskDefinitionUtil instance = TaskDefinitionUtil.getInstance();
                VFileInputStream vFileInputStream = null;
                VFileOutputStream vFileOutputStream = null;
                try {
                    vFileInputStream = new VFileInputStream(file);
                    vFileOutputStream = new VFileOutputStream(file);
                    TaskDefinition definition = (TaskDefinition)instance.unmarshal((InputStream)vFileInputStream);
                    definition.setSuffixNamespace(true);
                    instance.marshal((Object)definition, (OutputStream)new BufferedOutputStream((OutputStream)vFileOutputStream));
                }
                catch (Throwable throwable) {
                    StreamUtils.close((Closeable[])new Closeable[]{vFileInputStream});
                    StreamUtils.close((Closeable[])new Closeable[]{vFileOutputStream});
                    throw throwable;
                }
                StreamUtils.close((Closeable[])new Closeable[]{vFileInputStream});
                StreamUtils.close((Closeable[])new Closeable[]{vFileOutputStream});
            }
        }
    }

    private void removeProject(@NotNull VFileSystem filesystem) throws IOException {
        VFile[] files;
        if (filesystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/MdDomainImpl.removeProject must not be null");
        }
        for (VFile file : files = filesystem.list(filesystem.getRoot(), new VFileFilter(){

            public boolean accept(@NotNull VFile file) {
                return !"project.lock".equals(file.getName());
            }
        })) {
            file.delete();
        }
    }

    private String calculateNewHumanId(MetadataType metadataType) {
        MetadataType.Properties.Property oldHumanRevisionIdProperty = MetadataArtifactHelper.findProperty(metadataType, PropertyKeys.HUMAN_REVISION_ID.getKey());
        int humanRevisionId = 0;
        if (oldHumanRevisionIdProperty != null) {
            humanRevisionId = Integer.valueOf(oldHumanRevisionIdProperty.getValue()) + 1;
        }
        return Integer.valueOf(humanRevisionId).toString();
    }

    private void init(@Nullable URL resource) throws MetadataException {
        String userMock = System.getProperty(METADATA_MOCK_WORKSPACEDIR);
        try {
            if (userMock != null) {
                this.mdPersistence = new MockMdPersistence();
            } else {
                assert (resource != null) : "Null resource URL should only be used for the mock";
                this.mdsInstance = MdsInstanceInitializer.getMDSInstance(resource);
                this.mdPersistence = new MdsMdPersistence(this.mdsInstance);
            }
        }
        catch (MDSException e) {
            throw new MetadataException((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

