/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.history.item.recognizer.processors;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.metadata.history.item.recognizer.processors.LogicalArtifactProcessor;
import oracle.bpm.metadata.history.model.ChangedFile;
import oracle.bpm.metadata.history.model.LogicalArtifactType;
import org.jetbrains.annotations.NotNull;

public class BusinessObjectProcessor
extends LogicalArtifactProcessor {
    private static final String[] RELATED_FILES_ENDINGS = new String[]{".xsd", ".wsdl"};
    private static final String BUSINESS_CATALOG_PATH = "/businessCatalog/";

    public BusinessObjectProcessor() {
        super(LogicalArtifactType.BUSINESS_OBJECT);
    }

    @Override
    public void removeRelatedFiles(@NotNull String fileNameWithoutExtension, @NotNull Collection<ChangedFile> filesNotYetProcessed) {
        if (fileNameWithoutExtension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/item/recognizer/processors/BusinessObjectProcessor.removeRelatedFiles must not be null");
        }
        if (filesNotYetProcessed == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/history/item/recognizer/processors/BusinessObjectProcessor.removeRelatedFiles must not be null");
        }
        ArrayList<String> filesToBeRemoved = new ArrayList<String>();
        for (String ending : RELATED_FILES_ENDINGS) {
            filesToBeRemoved.add(fileNameWithoutExtension + ending);
        }
        ArrayList<ChangedFile> filesNotYetProcessedCopy = new ArrayList<ChangedFile>(filesNotYetProcessed);
        block1: for (ChangedFile changedFile : filesNotYetProcessedCopy) {
            for (String filePath : filesToBeRemoved) {
                String changedFilePath = changedFile.getCanonicalPath();
                if (!changedFilePath.startsWith(BUSINESS_CATALOG_PATH) || !changedFilePath.endsWith(filePath)) continue;
                filesNotYetProcessed.remove(changedFile);
                continue block1;
            }
        }
    }
}

