/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.history.item.recognizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.metadata.history.LogicalArtifactRecognizer;
import oracle.bpm.metadata.history.item.recognizer.HistoryItemFileFilter;
import oracle.bpm.metadata.history.item.recognizer.processors.ActivityGuideProcessor;
import oracle.bpm.metadata.history.item.recognizer.processors.BusinessObjectProcessor;
import oracle.bpm.metadata.history.item.recognizer.processors.LogicalArtifactProcessor;
import oracle.bpm.metadata.history.item.recognizer.processors.MeasurementsProcessor;
import oracle.bpm.metadata.history.model.ChangedFile;
import oracle.bpm.metadata.history.model.ChangedItem;
import oracle.bpm.metadata.history.model.LogicalArtifactType;
import org.jetbrains.annotations.NotNull;

public class LogicalArtifactRecognizerImpl
implements LogicalArtifactRecognizer {
    private ArrayList<LogicalArtifactProcessor> processors = new ArrayList();

    public LogicalArtifactRecognizerImpl() {
        this.processors.add(new LogicalArtifactProcessor(LogicalArtifactType.BPMN));
        this.processors.add(new LogicalArtifactProcessor(LogicalArtifactType.BPEL));
        this.processors.add(new LogicalArtifactProcessor(LogicalArtifactType.HUMAN_TASK));
        this.processors.add(new LogicalArtifactProcessor(LogicalArtifactType.BUSINESS_RULE));
        this.processors.add(new BusinessObjectProcessor());
        this.processors.add(new MeasurementsProcessor());
        this.processors.add(new ActivityGuideProcessor());
        this.processors.add(new LogicalArtifactProcessor(LogicalArtifactType.FORM));
        this.processors.add(new LogicalArtifactProcessor(LogicalArtifactType.ORGANIZATION));
        this.processors.add(new LogicalArtifactProcessor(LogicalArtifactType.RESOURCE));
    }

    public List<ChangedItem> recognize(@NotNull List<ChangedFile> changedFiles) {
        if (changedFiles == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/item/recognizer/LogicalArtifactRecognizerImpl.recognize must not be null");
        }
        Collection filteredFiles = CollectionUtils.createFilteredCollection(changedFiles, (Predicate)new HistoryItemFileFilter());
        ArrayList<ChangedItem> changedItems = new ArrayList<ChangedItem>();
        ArrayList<ChangedFile> filesNotYetProcessed = new ArrayList<ChangedFile>(filteredFiles);
        Iterator<LogicalArtifactProcessor> lapIterator = this.processors.iterator();
        while (lapIterator.hasNext() && !filesNotYetProcessed.isEmpty()) {
            LogicalArtifactProcessor processor = lapIterator.next();
            for (ChangedFile changedFile : filteredFiles) {
                if (!filesNotYetProcessed.contains(changedFile)) continue;
                processor.process(changedFile, changedItems, filesNotYetProcessed);
            }
        }
        return changedItems;
    }

    public LogicalArtifactType recognizeLogicalArtifactType(@NotNull ChangedFile changedFile) {
        if (changedFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/item/recognizer/LogicalArtifactRecognizerImpl.recognizeLogicalArtifactType must not be null");
        }
        ArrayList<ChangedItem> changedItems = new ArrayList<ChangedItem>();
        ArrayList<ChangedFile> filesNotYetProcessed = new ArrayList<ChangedFile>();
        for (LogicalArtifactProcessor processor : this.processors) {
            if (!processor.process(changedFile, changedItems, filesNotYetProcessed)) continue;
            return ((ChangedItem)changedItems.get(0)).getType();
        }
        return LogicalArtifactType.RESOURCE;
    }
}

