/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.history.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import oracle.bpm.metadata.history.Criteria;
import oracle.bpm.metadata.history.HistoryService;
import oracle.bpm.metadata.history.PageContext;
import oracle.bpm.metadata.history.exceptions.HistoryException;
import oracle.bpm.metadata.history.impl.EntityManagerUtil;
import oracle.bpm.metadata.history.impl.HistoryServiceImpl;
import oracle.bpm.metadata.history.model.Change;
import oracle.bpm.metadata.history.model.ChangedItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HistoryServiceTransactionalWrapper
implements HistoryService {
    private EntityManagerFactory emf;
    private HistoryServiceImpl hoc;

    public HistoryServiceTransactionalWrapper(@NotNull String persistenceUnit) {
        if (persistenceUnit == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceTransactionalWrapper.<init> must not be null");
        }
        this.emf = EntityManagerUtil.getEMF(persistenceUnit);
        this.hoc = new HistoryServiceImpl(this.emf);
    }

    public void setEntityManagerFactory(EntityManagerFactory em) {
        this.emf = em;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChange(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceTransactionalWrapper.saveChange must not be null");
        }
        EntityManager em = null;
        try {
            em = this.emf.createEntityManager();
            EntityTransaction transaction = em.getTransaction();
            transaction.begin();
            this.hoc.saveChange(change, em);
            transaction.commit();
        }
        finally {
            EntityManagerUtil.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChanges(@NotNull String projectName) {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceTransactionalWrapper.removeChanges must not be null");
        }
        EntityManager em = null;
        try {
            em = this.emf.createEntityManager();
            EntityTransaction transaction = em.getTransaction();
            transaction.begin();
            this.hoc.removeChanges(projectName, em);
            transaction.commit();
        }
        finally {
            EntityManagerUtil.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Change> listHistoryChanges(@NotNull Criteria criteria, @Nullable PageContext pageContext) throws HistoryException {
        if (criteria == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceTransactionalWrapper.listHistoryChanges must not be null");
        }
        EntityManager em = null;
        List<Change> changes = null;
        try {
            em = this.emf.createEntityManager();
            EntityTransaction transaction = em.getTransaction();
            transaction.begin();
            changes = this.hoc.listHistoryChanges(criteria, pageContext, em);
            transaction.commit();
            List<Change> list = changes;
            return list;
        }
        finally {
            EntityManagerUtil.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChangedItem> getRecentlyChangedItems(@NotNull String projectId, int qty) throws HistoryException {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceTransactionalWrapper.getRecentlyChangedItems must not be null");
        }
        List<ChangedItem> changedItems = null;
        EntityManager em = null;
        try {
            em = this.emf.createEntityManager();
            EntityTransaction transaction = em.getTransaction();
            transaction.begin();
            changedItems = this.hoc.getRecentlyChangedItems(projectId, qty, em);
            transaction.commit();
            List<ChangedItem> list = changedItems;
            return list;
        }
        finally {
            EntityManagerUtil.closeEntityManager(em);
        }
    }
}

