/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.history.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import oracle.bpm.lang.Cast;
import oracle.bpm.metadata.history.Criteria;
import oracle.bpm.metadata.history.HistoryService;
import oracle.bpm.metadata.history.PageContext;
import oracle.bpm.metadata.history.exceptions.HistoryException;
import oracle.bpm.metadata.history.exceptions.HistoryExceptionFactory;
import oracle.bpm.metadata.history.impl.EntityManagerUtil;
import oracle.bpm.metadata.history.model.Change;
import oracle.bpm.metadata.history.model.ChangedItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HistoryServiceImpl
implements HistoryService {
    private EntityManagerFactory emf;
    private static final Logger logger = Logger.getLogger("historyOfService");

    public HistoryServiceImpl(@NotNull EntityManagerFactory em) {
        if (em == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.<init> must not be null");
        }
        this.emf = em;
    }

    public void setEntityManagerFactory(EntityManagerFactory em) {
        this.emf = em;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChange(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.saveChange must not be null");
        }
        EntityManager em = this.emf.createEntityManager();
        try {
            this.saveChange(change, em);
        }
        finally {
            EntityManagerUtil.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChanges(@NotNull String projectId) {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.removeChanges must not be null");
        }
        EntityManager em = this.emf.createEntityManager();
        try {
            this.removeChanges(projectId, em);
        }
        finally {
            EntityManagerUtil.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Change> listHistoryChanges(@NotNull Criteria criteria, @Nullable PageContext pageContext) throws HistoryException {
        if (criteria == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.listHistoryChanges must not be null");
        }
        EntityManager em = this.emf.createEntityManager();
        try {
            List<Change> list = this.listHistoryChanges(criteria, pageContext, em);
            return list;
        }
        finally {
            EntityManagerUtil.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChangedItem> getRecentlyChangedItems(@NotNull String projectId, int qty) throws HistoryException {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.getRecentlyChangedItems must not be null");
        }
        EntityManager em = this.emf.createEntityManager();
        try {
            List<ChangedItem> list = this.getRecentlyChangedItems(projectId, qty, em);
            return list;
        }
        finally {
            EntityManagerUtil.closeEntityManager(em);
        }
    }

    void saveChange(@NotNull Change change, @NotNull EntityManager em) {
        if (change == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.saveChange must not be null");
        }
        if (em == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.saveChange must not be null");
        }
        em.persist((Object)change);
        logger.info("Change by " + change.getAuthor() + " " + change.getChangeDate() + " saved");
    }

    void removeChanges(@NotNull String projectId, @NotNull EntityManager em) {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.removeChanges must not be null");
        }
        if (em == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.removeChanges must not be null");
        }
        Query query = em.createQuery("SELECT c FROM Change c WHERE c.projectName = :projectId");
        query.setParameter("projectId", (Object)projectId);
        List changesToBeRemoved = (List)Cast.force((Object)query.getResultList());
        if (!changesToBeRemoved.isEmpty()) {
            for (Change change : changesToBeRemoved) {
                em.remove((Object)change);
            }
            logger.info("All changes of project " + projectId + " were deleted");
        }
    }

    List<Change> listHistoryChanges(@NotNull Criteria criteria, @Nullable PageContext pageContext, @NotNull EntityManager em) throws HistoryException {
        if (criteria == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.listHistoryChanges must not be null");
        }
        if (em == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.listHistoryChanges must not be null");
        }
        criteria.validateCriteria();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT c FROM Change c");
        boolean firstClause = true;
        if (criteria.getProjectId() != null) {
            String projectClause = "c.projectName = '" + criteria.getProjectId() + "'";
            firstClause = this.appendClause(sb, projectClause, firstClause);
        }
        if (criteria.getAuthor() != null) {
            String authorClause = "c.author = '" + criteria.getAuthor() + "'";
            firstClause = this.appendClause(sb, authorClause, firstClause);
        }
        if (criteria.getProjectType() != null) {
            String projectTypeClause = "c.projectType = '" + criteria.getProjectType() + "'";
            firstClause = this.appendClause(sb, projectTypeClause, firstClause);
        }
        if (criteria.getFromTimestamp() != null) {
            String fromTimestampClause = "c.changeDate >= :dateFrom";
            firstClause = this.appendClause(sb, "c.changeDate >= :dateFrom", firstClause);
        }
        if (criteria.getToTimestamp() != null) {
            String toTimestampClause = "c.changeDate < :dateTo";
            this.appendClause(sb, "c.changeDate < :dateTo", firstClause);
        }
        em = this.emf.createEntityManager();
        sb.append(" ORDER BY c.changeDate DESC");
        Query query = em.createQuery(sb.toString());
        if (criteria.getFromTimestamp() != null) {
            query.setParameter("dateFrom", (Object)criteria.getFromTimestamp());
        }
        if (criteria.getToTimestamp() != null) {
            query.setParameter("dateTo", (Object)criteria.getToTimestamp());
        }
        if (pageContext != null) {
            query.setFirstResult(pageContext.getMaxRowsPerPage() * pageContext.getFromPage());
            query.setMaxResults(pageContext.getMaxRowsPerPage() * pageContext.getToPage() + 1);
        }
        query.setHint("eclipselink.read-only", (Object)"True");
        List changes = (List)Cast.force((Object)query.getResultList());
        logger.info(changes.size() + " changes retrieved");
        for (Change change : changes) {
            change.getChangedItems().size();
        }
        return changes;
    }

    List<ChangedItem> getRecentlyChangedItems(@NotNull String projectId, int qty, @NotNull EntityManager em) throws HistoryException {
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.getRecentlyChangedItems must not be null");
        }
        if (em == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.getRecentlyChangedItems must not be null");
        }
        if (qty < 0) {
            throw HistoryExceptionFactory.createRecentlyChangedItemsNegativeQty((int)qty);
        }
        if (qty == 0) {
            return new ArrayList<ChangedItem>();
        }
        em = this.emf.createEntityManager();
        Query query = em.createNativeQuery("SELECT ci.id as id, ci.logicalName as logicalName, ci.action as action, ci.artifact as artifact, ch.CHANGE_DATE as CHANGEDATE FROM BPM_PML_HS_ITEM ci INNER JOIN BPM_PML_HS_BPM_PML_HS_ITEM cc \nON ci.id = cc.changeditems_id INNER JOIN BPM_PML_HS ch\nON cc.author = ch.author AND cc.projectName = ch.projectName AND cc.change_date = ch.change_date\nWHERE ch.projectName = ? ORDER BY ch.change_date DESC", "ChangedItemWithDate");
        query.setParameter(1, (Object)projectId);
        query.setMaxResults(qty);
        List list = (List)Cast.force((Object)query.getResultList());
        ArrayList<ChangedItem> retrievedChangedItems = new ArrayList<ChangedItem>();
        for (Object[] object : list) {
            ChangedItem ci = (ChangedItem)Cast.force((Object)object[0]);
            ci.setChangeDate((Date)Cast.force((Object)object[1]));
            retrievedChangedItems.add(ci);
        }
        return retrievedChangedItems;
    }

    List<ChangedItem> listChangedItems(@NotNull String projectName, @NotNull String author, @NotNull Date timestamp, @NotNull EntityManager em) {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.listChangedItems must not be null");
        }
        if (author == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.listChangedItems must not be null");
        }
        if (timestamp == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.listChangedItems must not be null");
        }
        if (em == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.listChangedItems must not be null");
        }
        em = this.emf.createEntityManager();
        Query query = em.createNativeQuery("SELECT ci.* FROM BPM_PML_HS_ITEM ci INNER JOIN BPM_PML_HS_BPM_PML_HS_ITEM cc \nON ci.id = cc.changeditems_id INNER JOIN CHANGE ch\nON cc.author = ch.author AND cc.projectname = ch.projectname AND cc.change_date = ch.change_date\nWHERE ch.projectName = ? AND ch.author = ? AND ch.change_date = ? ORDER BY ch.change_date DESC", ChangedItem.class);
        query.setParameter(1, (Object)projectName);
        query.setParameter(2, (Object)author);
        query.setParameter(3, (Object)timestamp);
        query.setHint("eclipselink.read-only", (Object)"True");
        return (List)Cast.force((Object)query.getResultList());
    }

    private boolean appendClause(@NotNull StringBuffer sb, @NotNull String projectClause, boolean firstClause) {
        if (sb == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.appendClause must not be null");
        }
        if (projectClause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/history/impl/HistoryServiceImpl.appendClause must not be null");
        }
        if (firstClause) {
            sb.append(" WHERE ").append(projectClause);
            return false;
        }
        sb.append(" AND ").append(projectClause);
        return false;
    }
}

