/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.history.file.scanner;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.CopyOnWriteFS;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.history.Criteria;
import oracle.bpm.metadata.history.HistoryService;
import oracle.bpm.metadata.history.exceptions.HistoryException;
import oracle.bpm.metadata.history.model.Change;
import oracle.bpm.metadata.history.model.ChangeAction;
import oracle.bpm.metadata.history.model.ChangedFile;
import oracle.bpm.metadata.mds.utils.MdsFileFilter;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.bpm.util.Base64;
import org.jetbrains.annotations.NotNull;

public class ChangedFileHelper {
    public static List<ChangedFile> processChangedFiles(CopyOnWriteFS copyOnWriteFs) throws IOException {
        ArrayList<ChangedFile> changedFiles = new ArrayList<ChangedFile>();
        for (VFile vFile : copyOnWriteFs.getDeletedFiles()) {
            if (!vFile.isFile()) continue;
            ChangedFile changedFile = new ChangedFile(ChangeAction.DELETED, vFile.getCanonicalPath());
            changedFiles.add(changedFile);
        }
        VFileSystem readFileSystem = copyOnWriteFs.getReadFileSystem();
        VFileSystem writeFileSystem = copyOnWriteFs.getWriteFileSystem();
        ChangedFileHelper.addChangedFile(writeFileSystem.getRoot(), changedFiles, readFileSystem);
        return changedFiles;
    }

    public static void addChangedFile(@NotNull VFile vFile, @NotNull List<ChangedFile> changedFiles, @NotNull VFileSystem readFileSystem) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/file/scanner/ChangedFileHelper.addChangedFile must not be null");
        }
        if (changedFiles == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/history/file/scanner/ChangedFileHelper.addChangedFile must not be null");
        }
        if (readFileSystem == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/history/file/scanner/ChangedFileHelper.addChangedFile must not be null");
        }
        if (vFile.isFile()) {
            VFile createdFile = readFileSystem.createFile(vFile.getCanonicalPath());
            ChangedFile changedFile = createdFile.exists() ? new ChangedFile(ChangeAction.MODIFIED, vFile.getCanonicalPath()) : new ChangedFile(ChangeAction.ADDED, vFile.getCanonicalPath());
            changedFiles.add(changedFile);
        } else {
            for (VFile child : vFile.listFiles(MdsFileFilter.MDS_FILE_FILTER_NO_LOCK_FILE)) {
                ChangedFileHelper.addChangedFile(child, changedFiles, readFileSystem);
            }
        }
    }

    public static Map<String, String> calculateHashes(@NotNull VFile file) throws IOException, PersistenceException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/file/scanner/ChangedFileHelper.calculateHashes must not be null");
        }
        return ChangedFileHelper.calculateHashes(file, new HashMap<String, String>());
    }

    public static List<ChangedFile> compareHashes(@NotNull Map<String, String> remoteHashes, @NotNull Map<String, String> localHashes) {
        if (remoteHashes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/file/scanner/ChangedFileHelper.compareHashes must not be null");
        }
        if (localHashes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/history/file/scanner/ChangedFileHelper.compareHashes must not be null");
        }
        ArrayList<ChangedFile> changedFiles = new ArrayList<ChangedFile>();
        for (String canonicalPath : localHashes.keySet()) {
            ChangedFile changedFile;
            String hash = localHashes.get(canonicalPath);
            if (remoteHashes.containsKey(canonicalPath)) {
                if (!remoteHashes.containsValue(hash)) {
                    changedFile = new ChangedFile(ChangeAction.MODIFIED, canonicalPath);
                    changedFiles.add(changedFile);
                }
            } else {
                changedFile = new ChangedFile(ChangeAction.ADDED, canonicalPath);
                changedFiles.add(changedFile);
            }
            remoteHashes.remove(canonicalPath);
        }
        for (String canonicalPath : remoteHashes.keySet()) {
            ChangedFile changedFile = new ChangedFile(ChangeAction.DELETED, canonicalPath);
            changedFiles.add(changedFile);
        }
        return changedFiles;
    }

    public static List<ChangedFile> processChangedFilesScratchProject(@NotNull VFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/file/scanner/ChangedFileHelper.processChangedFilesScratchProject must not be null");
        }
        return ChangedFileHelper.processChangedFilesScratchProject(root, new ArrayList<ChangedFile>());
    }

    public static Map<String, String> getRemoteHashes(@NotNull HistoryService historyService, @NotNull String projectId) throws HistoryException {
        if (historyService == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/file/scanner/ChangedFileHelper.getRemoteHashes must not be null");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/history/file/scanner/ChangedFileHelper.getRemoteHashes must not be null");
        }
        Criteria criteria = new Criteria();
        criteria.setProjectType(ProjectType.PUBLIC_SHARED.value());
        criteria.setProjectId(projectId);
        List changes = historyService.listHistoryChanges(criteria, null);
        Change mostRecentChange = (Change)changes.get(0);
        return mostRecentChange.getHistoryProjectMetadata().getFilesHashes();
    }

    private static Map<String, String> calculateHashes(@NotNull VFile file, @NotNull Map<String, String> hashesMap) throws PersistenceException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/file/scanner/ChangedFileHelper.calculateHashes must not be null");
        }
        if (hashesMap == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/history/file/scanner/ChangedFileHelper.calculateHashes must not be null");
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            for (VFile child : file.listFiles(MdsFileFilter.MDS_FILE_FILTER_NO_LOCK_FILE)) {
                hashesMap = child.isDirectory() ? ChangedFileHelper.calculateHashes(child, hashesMap) : ChangedFileHelper.calculateHash(messageDigest, child, hashesMap);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw PersistenceException.createIOException(e);
        }
        return hashesMap;
    }

    private static Map<String, String> calculateHash(@NotNull MessageDigest messageDigest, @NotNull VFile file, @NotNull Map<String, String> hashesMap) throws IOException {
        if (messageDigest == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/file/scanner/ChangedFileHelper.calculateHash must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/history/file/scanner/ChangedFileHelper.calculateHash must not be null");
        }
        if (hashesMap == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/history/file/scanner/ChangedFileHelper.calculateHash must not be null");
        }
        byte[] bytes = StreamUtils.readBytes((InputStream)new VFileInputStream(file));
        messageDigest.update(bytes);
        messageDigest.update(file.getCanonicalPath().getBytes());
        messageDigest.update(file.getName().getBytes());
        String hash = Base64.encode((byte[])messageDigest.digest());
        hashesMap.put(file.getCanonicalPath(), hash);
        return hashesMap;
    }

    private static List<ChangedFile> processChangedFilesScratchProject(@NotNull VFile root, List<ChangedFile> changedFiles) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/file/scanner/ChangedFileHelper.processChangedFilesScratchProject must not be null");
        }
        for (VFile vFile : root.listFiles(MdsFileFilter.MDS_FILE_FILTER_NO_LOCK_FILE)) {
            if (vFile.isFile()) {
                ChangedFile changedFile = new ChangedFile(ChangeAction.ADDED, vFile.getCanonicalPath());
                changedFiles.add(changedFile);
                continue;
            }
            ChangedFileHelper.processChangedFilesScratchProject(vFile, changedFiles);
        }
        return changedFiles;
    }
}

