/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.entity;

import java.util.Calendar;
import java.util.List;
import oracle.bpm.lang.Cast;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.artifact.jaxb.PublicShareMetadata;
import oracle.bpm.metadata.entity.DraftProject;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.impl.MdProjectImpl;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.metadata.lock.jaxb.ApplicationType;
import oracle.bpm.metadata.lock.jaxb.LockType;
import oracle.bpm.metadata.persistence.MdPersistence;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.bpm.metadata.update.PropertyKeys;
import oracle.bpm.project.model.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicShareProject
extends MdProjectImpl<PublicShareProject> {
    protected Boolean hasDraft;
    protected boolean isLocked;
    protected LockType lockType;
    private boolean upToDateFromBaseTemplate;

    public PublicShareProject(@NotNull String name, @NotNull Project project) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/entity/PublicShareProject.<init> must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/entity/PublicShareProject.<init> must not be null");
        }
        this(name, null, project);
    }

    public PublicShareProject(@NotNull String name, @Nullable String description, @NotNull Project project) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/entity/PublicShareProject.<init> must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/entity/PublicShareProject.<init> must not be null");
        }
        super(name, project);
        this.metadata = new PublicShareMetadata();
        this.setDescription(description);
        this.setName(name);
    }

    protected PublicShareProject(@NotNull MdPersistence persistence, @NotNull String location, @Nullable MetadataType metadata) {
        if (persistence == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/entity/PublicShareProject.<init> must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/entity/PublicShareProject.<init> must not be null");
        }
        super(persistence, location, metadata);
    }

    public String getDescription() {
        return this.getMetadata().getDescription();
    }

    public void setDescription(@Nullable String description) {
        this.getMetadata().setDescription(description);
    }

    @Override
    public LocalRef<PublicShareProject> getLocalRef() {
        return new LocalRef<PublicShareProject>(this.getName(), this);
    }

    public boolean hasDraft() {
        if (this.hasDraft == null) {
            try {
                this.hasDraft = this.persistence.existsFolder(DraftProject.class, this.getFolder().get());
            }
            catch (PersistenceException e) {
                e.printStackTrace();
            }
        }
        return this.hasDraft;
    }

    public boolean isAllowSharing() {
        return ((PublicShareMetadata)this.getMetadata()).isAllowShare();
    }

    public void setAllowSharing(boolean share) {
        ((PublicShareMetadata)this.getMetadata()).setAllowShare(share);
    }

    public boolean isProjectFromScratch() {
        return ((PublicShareMetadata)this.getMetadata()).isIsFromScratch();
    }

    public void setProjectFromScratch(boolean share) {
        ((PublicShareMetadata)this.getMetadata()).setIsFromScratch(share);
    }

    public boolean isApprovalWorkflow() {
        return this.getApprovalWorkflowUrl() != null;
    }

    public String getApprovalWorkflowUrl() {
        return ((PublicShareMetadata)this.getMetadata()).getWorkflowUrl();
    }

    public void setApprovalWorkflowUrl(@Nullable String url) {
        ((PublicShareMetadata)this.getMetadata()).setWorkflowUrl(url);
    }

    public void setWorkflowParticipants(@NotNull List<String> participantIds) {
        if (participantIds == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/entity/PublicShareProject.setWorkflowParticipants must not be null");
        }
        MetadataArtifactHelper.setWorkflowParticipants((PublicShareMetadata)this.getMetadata(), participantIds);
    }

    public List<String> getWorkflowParticipants() {
        PublicShareMetadata.WorkflowParticipants participants = MetadataArtifactHelper.getWorkflowParticipants((PublicShareMetadata)this.getMetadata());
        return participants.getParticipantId();
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public String getUserLock() {
        this.loadLock();
        return this.isLocked ? this.lockType.getUsername() : null;
    }

    public ApplicationType getApplicationLock() {
        this.loadLock();
        return this.isLocked ? this.lockType.getApplicationType() : null;
    }

    public Calendar getTimestampLock() {
        this.loadLock();
        return this.lockType != null ? this.lockType.getTimestamp().toGregorianCalendar() : null;
    }

    public boolean isLinkedToTemplate() {
        return !this.isProjectFromScratch() && this.getProperty(PropertyKeys.BASE_TEMPLATE_ID.getKey()) != null;
    }

    public boolean isUpToDateFromBaseTemplate() {
        return this.upToDateFromBaseTemplate;
    }

    public void setUpToDateFromBaseTemplate(boolean upToDateFromBaseTemplate) {
        this.upToDateFromBaseTemplate = upToDateFromBaseTemplate;
    }

    @Override
    public boolean isTemplate() {
        return false;
    }

    @Override
    public boolean isPublicShare() {
        return true;
    }

    @Override
    protected <T extends MdProject> Class<T> getProjectType() {
        return (Class)Cast.force(PublicShareProject.class);
    }

    private void loadLock() {
        if (this.lockType == null) {
            try {
                this.lockType = this.persistence.getLock(this.getMetadata());
                this.isLocked = this.lockType != null;
            }
            catch (PersistenceException e) {
                e.printStackTrace();
            }
        }
    }
}

