/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.metadata.entity.ProjectArtifact;
import org.jetbrains.annotations.NotNull;

public class MdTreeNode<T extends ProjectArtifact> {
    public List<MdTreeNode<T>> children;
    public T object;

    public MdTreeNode() {
        this.children = new ArrayList<MdTreeNode<T>>();
    }

    public MdTreeNode(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/MdTreeNode.<init> must not be null");
        }
        this.children = new ArrayList<MdTreeNode<T>>();
        this.object = object;
    }

    public static <K extends ProjectArtifact> MdTreeNode<K> create(K object) {
        return new MdTreeNode<K>(object);
    }

    public String getId() {
        return this.object.toString();
    }

    public T getObject() {
        return this.object;
    }

    public void addChild(MdTreeNode<T> node) {
        this.children.add(node);
    }

    public List<MdTreeNode<T>> getChildren() {
        return this.children;
    }

    public MdTreeNode<T> find(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/MdTreeNode.find must not be null");
        }
        MdTreeNode<T> node = null;
        for (MdTreeNode<T> child : this.children) {
            if (!child.getObject().equals(object)) continue;
            node = child;
            break;
        }
        return node;
    }
}

