/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io.fs.mds;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.bpm.io.fs.VEventType;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileEvent;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.mds.MdsTransaction;
import oracle.bpm.metadata.mds.utils.MdsTransactionUtil;
import oracle.bpm.metadata.mds.utils.MdsUtils;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.mds.config.ContentConfig;
import oracle.mds.config.ContentOptions;
import oracle.mds.config.PConfig;
import oracle.mds.core.MDSInstance;
import oracle.mds.core.MDSObject;
import oracle.mds.core.MetadataObject;
import oracle.mds.core.StreamedObject;
import oracle.mds.persistence.PPackage;
import oracle.mds.query.Condition;
import oracle.mds.query.ConditionFactory;
import oracle.mds.query.NameCondition;
import oracle.mds.query.Query;
import oracle.mds.query.QueryResult;
import oracle.mds.query.ResourceQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MdsFileSystem
extends VFileSystem {
    private final Set<VFile> deletedFiles;
    private final Map<VFile, CachedOutputStream> fileCache;
    private final String label;
    private final MDSInstance mdsInstance;
    private final Set<VFile> packagesCreated;
    private final String rootFileSystem;
    private static final Object lock = new Object();

    public MdsFileSystem(@NotNull MDSInstance mdsInstance, @NotNull String rootFileSystem) {
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.<init> must not be null");
        }
        if (rootFileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.<init> must not be null");
        }
        this(mdsInstance, rootFileSystem, null);
    }

    public MdsFileSystem(@NotNull MDSInstance mdsInstance, @NotNull String rootFileSystem, @Nullable String label) {
        if (mdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.<init> must not be null");
        }
        if (rootFileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.<init> must not be null");
        }
        this.fileCache = new HashMap<VFile, CachedOutputStream>();
        this.mdsInstance = mdsInstance;
        this.label = label;
        this.rootFileSystem = rootFileSystem;
        this.deletedFiles = new HashSet<VFile>();
        this.packagesCreated = new HashSet<VFile>();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof MdsFileSystem)) {
            return false;
        }
        MdsFileSystem mdsFilesystem = (MdsFileSystem)((Object)object);
        return this.mdsInstance.equals(mdsFilesystem.mdsInstance) && this.rootFileSystem.equals(mdsFilesystem.rootFileSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        MdsTransaction mdsTransaction = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance, this.label);
        try {
            String mdsPath;
            HashSet<VFile> copiedPackagesCreated;
            HashSet<VFile> copiedDeletedFiles;
            HashMap<VFile, CachedOutputStream> copiedCache;
            Object object = lock;
            synchronized (object) {
                copiedCache = new HashMap<VFile, CachedOutputStream>(this.fileCache);
                this.fileCache.clear();
                copiedDeletedFiles = new HashSet<VFile>(this.deletedFiles);
                this.deletedFiles.clear();
                copiedPackagesCreated = new HashSet<VFile>(this.packagesCreated);
                this.packagesCreated.clear();
            }
            Set vFileSet = copiedCache.keySet();
            mdsTransaction.setAutoCommit(false);
            mdsTransaction.begin();
            for (VFile vFile : copiedPackagesCreated) {
                mdsPath = this.toMDSLocation(vFile);
                if (mdsTransaction.existsPackage(mdsPath)) continue;
                mdsTransaction.createPackage(mdsPath);
            }
            for (VFile vFile : copiedDeletedFiles) {
                mdsPath = this.toMDSLocation(vFile);
                if (this.isDirectory(vFile)) {
                    mdsTransaction.deletePackage(mdsPath, true);
                    continue;
                }
                mdsTransaction.deleteDocument(mdsPath);
            }
            if (!vFileSet.isEmpty()) {
                for (VFile vFile : vFileSet) {
                    CachedOutputStream cachedOutputStream = (CachedOutputStream)copiedCache.get(vFile);
                    this.doFlush(mdsTransaction, cachedOutputStream, vFile);
                }
            }
            mdsTransaction.commit();
        }
        catch (MetadataException e) {
            try {
                mdsTransaction.rollback();
            }
            catch (PersistenceException exc) {
                throw new IOException((Throwable)((Object)exc));
            }
            throw new IOException(e);
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    public long lastModified(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.lastModified must not be null");
        }
        long lastModified = 0L;
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance, this.label);
        String mdsPath = this.toMDSLocation(vFile);
        try {
            if (tx.existsResource(mdsPath)) {
                PPackage aPackage;
                MDSObject mdsObject = tx.getMutableMDSObject(mdsPath);
                lastModified = mdsObject != null ? mdsObject.lastModified() : ((aPackage = tx.getPackage(mdsPath)) != null ? aPackage.getLastModifiedTime() : lastModified);
            }
        }
        catch (PersistenceException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
        return lastModified;
    }

    public boolean isZeroLength(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.isZeroLength must not be null");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VFile[] list(@NotNull VFile vFile, @Nullable VFileFilter filter) {
        TreeSet<VFile> ret;
        block19: {
            if (vFile == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.list must not be null");
            }
            ResourceQuery resourceQuery = null;
            ret = new TreeSet<VFile>();
            if (!this.getRoot().equals((Object)vFile) && vFile.isFile()) {
                return new VFile[0];
            }
            MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance, this.label);
            try {
                HashMap<VFile, CachedOutputStream> copiedFilesCreated;
                HashSet<VFile> copiedPackagesCreated;
                tx.begin();
                String mdsPath = this.toMDSLocation(vFile);
                NameCondition condition = ConditionFactory.createNameCondition((String)mdsPath, (String)"%", (boolean)false);
                resourceQuery = tx.createResourceQuery((Condition)condition);
                Iterator queryResultIterator = resourceQuery.execute();
                while (queryResultIterator.hasNext()) {
                    boolean isDeleted;
                    QueryResult queryResult = (QueryResult)queryResultIterator.next();
                    VFile file = this.createFile(vFile, queryResult.getResourceName().getLocalName());
                    file.setIsFolder(Boolean.valueOf(!queryResult.isDocument()));
                    Object object = lock;
                    synchronized (object) {
                        isDeleted = this.deletedFiles.contains(file);
                    }
                    if (filter != null && (isDeleted || !filter.accept(file))) continue;
                    ret.add(file);
                }
                Object isDeleted = lock;
                synchronized (isDeleted) {
                    copiedPackagesCreated = new HashSet<VFile>(this.packagesCreated);
                    copiedFilesCreated = new HashMap<VFile, CachedOutputStream>(this.fileCache);
                }
                for (VFile file : copiedPackagesCreated) {
                    if (!vFile.equals((Object)file.getParentFile()) || filter != null && !filter.accept(file)) continue;
                    ret.add(file);
                }
                Set<VFile> vFileSet = copiedFilesCreated.keySet();
                if (vFileSet != null) {
                    for (VFile file : vFileSet) {
                        if (!vFile.equals((Object)file.getParentFile()) || filter != null && !filter.accept(file)) continue;
                        ret.add(file);
                    }
                }
                tx.commit();
                MdsUtils.closeQuery((Query)resourceQuery);
            }
            catch (PersistenceException e) {
                try {
                    e.printStackTrace();
                    this.rollbackTx(tx);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                break block19;
            }
            finally {
                MdsUtils.closeQuery(resourceQuery);
                MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
            }
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
        return !ret.isEmpty() ? ret.toArray(new VFile[ret.size()]) : new VFile[]{};
    }

    public void closeOutputStream(@NotNull VFile vFile, @NotNull OutputStream out) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.closeOutputStream must not be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.closeOutputStream must not be null");
        }
        super.closeOutputStream(vFile, out);
        this.flush(vFile);
    }

    public int hashCode() {
        int result = this.mdsInstance != null ? this.mdsInstance.hashCode() : 0;
        result = 31 * result + (this.rootFileSystem != null ? this.rootFileSystem.hashCode() : 0);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected String getUniqueID() {
        String string = this.rootFileSystem;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/mds/MdsFileSystem.getUniqueID must not return null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fireEventInternal(@NotNull VFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.fireEventInternal must not be null");
        }
        try {
            MdsTransaction mdsTransaction = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance, this.label);
            mdsTransaction.addTransactionAction(new FSMdsTransaction(event));
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean delete(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.delete must not be null");
        }
        if (this.isRoot(vFile)) {
            return false;
        }
        boolean isOk = false;
        Object object = lock;
        synchronized (object) {
            if (this.exists(vFile)) {
                if (vFile.isDirectory()) {
                    VFile[] files;
                    for (VFile file : files = vFile.listFiles(null)) {
                        file.delete();
                    }
                } else {
                    this.fileCache.remove(vFile);
                }
                this.deletedFiles.add(vFile);
                this.packagesCreated.remove(vFile);
                isOk = true;
            }
        }
        if (isOk) {
            this.fireEvent(new VFileEvent(VEventType.REMOVE, vFile));
        }
        return isOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean mkdirs(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.mkdirs must not be null");
        }
        boolean isOk = false;
        Object object = lock;
        synchronized (object) {
            if (!this.exists(vFile)) {
                this.packagesCreated.add(vFile);
                this.deletedFiles.remove(vFile);
                isOk = true;
            }
        }
        if (isOk) {
            this.fireEvent(new VFileEvent(VEventType.ADD, vFile));
        }
        return isOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean exists(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.exists must not be null");
        }
        Object object = lock;
        synchronized (object) {
            boolean ret = this.isRoot(vFile);
            if (!ret && !this.deletedFiles.contains(vFile)) {
                MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance, this.label);
                try {
                    String mdsPath = this.toMDSLocation(vFile);
                    ret = this.fileCache.get(vFile) != null || this.packagesCreated.contains(vFile) || tx.existsResource(mdsPath);
                }
                catch (PersistenceException e) {
                }
                finally {
                    MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isFile(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.isFile must not be null");
        }
        Object object = lock;
        synchronized (object) {
            boolean isFile = false;
            if (!this.isRoot(vFile) && !this.deletedFiles.contains(vFile)) {
                String vFileName = vFile.getName();
                String mdsPath = this.toMDSLocation(vFile.getParentFile());
                MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance, this.label);
                String filePath = mdsPath + "/" + vFileName;
                try {
                    isFile = this.fileCache.get(vFile) != null || tx.existsFile(filePath);
                }
                catch (MetadataException e) {
                }
                finally {
                    MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
                }
            }
            return isFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isDirectory(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.isDirectory must not be null");
        }
        Object object = lock;
        synchronized (object) {
            boolean isDirectory = this.isRoot(vFile);
            if (!isDirectory && !this.deletedFiles.contains(vFile)) {
                String vFileName = vFile.getName();
                String mdsPath = this.toMDSLocation(vFile.getParentFile());
                MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance, this.label);
                String filePath = mdsPath + "/" + vFileName;
                try {
                    isDirectory = this.packagesCreated.contains(vFile) || tx.existsPackage(filePath);
                }
                catch (MetadataException e) {
                }
                finally {
                    MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
                }
            }
            return isDirectory;
        }
    }

    protected boolean canWrite(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.canWrite must not be null");
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream openInputStream(@NotNull VFile vFile) throws IOException {
        InputStream inputStream;
        CachedOutputStream cachedOutputStream;
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.openInputStream must not be null");
        }
        Object object = lock;
        synchronized (object) {
            cachedOutputStream = this.fileCache.get(vFile);
        }
        if (cachedOutputStream != null) {
            inputStream = cachedOutputStream.openInputStream();
        } else {
            MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance, this.label);
            try {
                String mdsPath = this.toMDSLocation(vFile);
                inputStream = tx.openInputStream(mdsPath);
            }
            catch (PersistenceException e) {
                throw new IOException((Throwable)((Object)e));
            }
            finally {
                MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputStream openOutputStream(@NotNull VFile vFile) throws IOException {
        CachedOutputStream cachedOutputStream;
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.openOutputStream must not be null");
        }
        if (vFile.isDirectory() || !vFile.getParentFile().exists()) {
            throw new FileNotFoundException(vFile.getCanonicalPath());
        }
        MdsTransaction currentTx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance, this.label);
        String mdsPath = this.toMDSLocation(vFile);
        try {
            MDSObject mdsObject = currentTx.getMutableMDSObject(mdsPath);
            Object object = lock;
            synchronized (object) {
                boolean exists;
                cachedOutputStream = this.fileCache.get(vFile);
                this.deletedFiles.remove(vFile);
                boolean bl = exists = mdsObject != null || cachedOutputStream != null;
                if (cachedOutputStream == null) {
                    cachedOutputStream = new CachedOutputStream();
                    this.fileCache.put(vFile, cachedOutputStream);
                } else {
                    cachedOutputStream.clear();
                }
                vFile.setCreated(!exists);
            }
        }
        catch (PersistenceException e) {
            throw new IOException((Throwable)((Object)e));
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
        return cachedOutputStream;
    }

    protected boolean isHidden(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.isHidden must not be null");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(@NotNull VFile vFile) throws IOException {
        CachedOutputStream cachedOutputStream;
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.flush must not be null");
        }
        MdsTransaction tx = MdsTransactionUtil.getCurrentTransaction(this.mdsInstance, this.label);
        Object object = lock;
        synchronized (object) {
            cachedOutputStream = this.fileCache.get(vFile);
        }
        try {
            tx.setAutoCommit(false);
            tx.begin();
            if (cachedOutputStream != null) {
                this.doFlush(tx, cachedOutputStream, vFile);
            }
            tx.commit();
        }
        catch (PersistenceException e) {
            this.rollbackTx(tx);
            throw new IOException((Throwable)((Object)e));
        }
        finally {
            MdsTransactionUtil.releaseCurrentTransaction(this.mdsInstance);
        }
    }

    private void doFlush(@NotNull MdsTransaction currentTx, @NotNull CachedOutputStream cachedOutputStream, @NotNull VFile vFile) throws PersistenceException, IOException {
        if (currentTx == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.doFlush must not be null");
        }
        if (cachedOutputStream == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.doFlush must not be null");
        }
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.doFlush must not be null");
        }
        InputStream inputStream = cachedOutputStream.openInputStream();
        assert (inputStream.markSupported()) : " mark should be supported";
        inputStream.mark(-1);
        String mdsPath = this.toMDSLocation(vFile);
        MDSObject mdsObject = currentTx.getMutableMDSObject(mdsPath);
        if (mdsObject == null) {
            boolean isBinary = false;
            boolean isStreamed = this.isStreamed(mdsPath);
            if (!isStreamed) {
                try {
                    Document document = this.toDocument(inputStream);
                    inputStream.reset();
                    inputStream.mark(-1);
                    currentTx.createDocument(mdsPath, document);
                }
                catch (IOException exc) {
                    isBinary = true;
                }
            }
            if (isStreamed || isBinary) {
                currentTx.createStreamedObject(mdsPath, inputStream);
            }
        } else if (mdsObject instanceof MetadataObject) {
            MetadataObject metadataObject = (MetadataObject)mdsObject;
            Document currentDocument = metadataObject.getDocument();
            currentDocument.removeChild(currentDocument.getDocumentElement());
            Document document = this.toDocument(inputStream);
            Node node = currentDocument.importNode(document.getDocumentElement(), true);
            currentDocument.appendChild(node);
        } else {
            StreamedObject streamedObject = (StreamedObject)mdsObject;
            streamedObject.setContents(inputStream);
        }
    }

    private boolean isStreamed(@NotNull String mdsPath) {
        VFile parent;
        ContentOptions contentOptions;
        ContentConfig contentConfig;
        if (mdsPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.isStreamed must not be null");
        }
        boolean result = false;
        PConfig pconfig = this.mdsInstance.getMDSConfig().getPConfig();
        if (pconfig != null && (contentConfig = pconfig.getContentConfig()) != null && (contentOptions = contentConfig.findMapping((parent = this.createFile(mdsPath)).getParentFile().getCanonicalPath(), null)) != null) {
            result = contentOptions.isStreamed();
        }
        return result;
    }

    private String toMDSLocation(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.toMDSLocation must not be null");
        }
        String mdsPath = this.rootFileSystem + "/" + vFile.getCanonicalPath();
        VFile tmpVFile = this.createFile(mdsPath);
        return tmpVFile.getCanonicalPath();
    }

    private boolean isRoot(VFile vFile) {
        return this.getRoot().equals((Object)vFile);
    }

    private void rollbackTx(MdsTransaction tx) throws IOException {
        try {
            tx.rollback();
        }
        catch (PersistenceException e) {
            throw new IOException((Throwable)((Object)e));
        }
    }

    private Document toDocument(@NotNull InputStream content) throws IOException {
        Document document;
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem.toDocument must not be null");
        }
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            document = documentBuilder.parse(content);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        return document;
    }

    private class FSMdsTransaction
    implements MdsTransaction.CommitTransactionAction {
        private VFileEvent eventType;

        FSMdsTransaction(VFileEvent eventType) {
            if (MdsFileSystem.this == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/mds/MdsFileSystem$FSMdsTransaction.<init> must not be null");
            }
            this.eventType = eventType;
        }

        @Override
        public void postCommit() {
            MdsFileSystem.this.dispatchEvent(this.eventType);
        }

        @Override
        public void preCommit() {
            VFileSystem fileSystem = this.eventType.getSource().getFileSystem();
            try {
                fileSystem.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static class CachedOutputStream
    extends ByteArrayOutputStream {
        CachedOutputStream() {
        }

        public InputStream openInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }

        void clear() {
            this.count = 0;
        }
    }
}

