/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util.dump;

import java.io.File;
import oracle.bpm.util.FuegoDirectories;
import oracle.bpm.util.dump.Dumper;
import org.jetbrains.annotations.NonNls;

class WindowsDumper
extends Dumper {
    @NonNls
    private static final String FUEGO_DLL = "fuego.dll";
    @NonNls
    private static final String DUMP_DONE = "dump done";

    WindowsDumper() {
    }

    @Override
    public boolean doThreadDump() {
        if (!this.appropriateIntervalBetweenDumps()) {
            return false;
        }
        try {
            System.load(new File(FuegoDirectories.binDir(), FUEGO_DLL).getPath());
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            return false;
        }
        if (this.initLibrary()) {
            this.fullThreadDump();
            System.out.println(DUMP_DONE);
            return true;
        }
        return false;
    }

    private native void fullThreadDump();

    private native boolean initLibrary();
}

