/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.util.Locale;
import java.util.TimeZone;

public final class TimeZoneItem {
    private String displayName;
    private final Locale locale;
    private final TimeZone timeZone;

    TimeZoneItem(TimeZone timeZone, Locale locale) {
        this.timeZone = timeZone;
        this.locale = locale;
    }

    public synchronized String toString() {
        String result = this.displayName;
        if (result == null) {
            this.displayName = result = this.makeDisplayName();
        }
        return result;
    }

    public String getID() {
        return this.timeZone.getID();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    int getRawOffset() {
        return this.timeZone.getRawOffset();
    }

    private boolean isDisplayNameUnique(String thisName) {
        TimeZone thisZone = this.timeZone;
        String thisZoneID = thisZone.getID();
        String[] similarZoneIDs = TimeZone.getAvailableIDs(thisZone.getRawOffset());
        if (similarZoneIDs != null) {
            Locale thisLocale = this.locale;
            for (String similarZoneID : similarZoneIDs) {
                TimeZone similarZone;
                if (similarZoneID.equals(thisZoneID) || !thisName.equals((similarZone = TimeZone.getTimeZone(similarZoneID)).getDisplayName(thisLocale))) continue;
                return false;
            }
        }
        return true;
    }

    private String makeDisplayName() {
        char c3;
        int offset = this.timeZone.getRawOffset();
        int hour = offset / 3600000;
        int minutes = Math.abs(offset - hour * 3600000) / 60000;
        StringBuilder result = new StringBuilder().append("(GMT");
        if (hour >= 0) {
            result.append('+');
        }
        result.append(hour).append(':');
        if (minutes < 10) {
            result.append('0');
        }
        result.append(minutes).append(") ");
        String displayName = this.timeZone.getDisplayName(this.locale);
        result.append(displayName);
        if (this.isDisplayNameUnique(displayName)) {
            return result.toString();
        }
        if (displayName.startsWith("GMT") && displayName.length() > 3 && ((c3 = displayName.charAt(3)) == '+' || c3 == '-')) {
            return result.toString();
        }
        String tzID = this.timeZone.getID();
        int pos = tzID.lastIndexOf(47);
        String city = tzID.substring(pos + 1).replace('_', ' ');
        return result.append(" (").append(city).append(')').toString();
    }
}

