/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.collections.maps.BiMap;
import oracle.bpm.collections.maps.HashBiMap;
import org.jetbrains.annotations.NonNls;

public class PrimitiveTypeUtils {
    public static final char BYTE_SIGNATURE = 'B';
    public static final char VOID_SIGNATURE = 'V';
    public static final char BOOLEAN_SIGNATURE = 'Z';
    public static final char CHAR_SIGNATURE = 'C';
    public static final char SHORT_SIGNATURE = 'S';
    public static final char INT_SIGNATURE = 'I';
    public static final char LONG_SIGNATURE = 'J';
    public static final char FLOAT_SIGNATURE = 'F';
    public static final char DOUBLE_SIGNATURE = 'D';
    @NonNls
    private static final Map<String, Class<?>> primitiveClasses = new HashMap();
    private static final Map<Class<?>, Character> signatures;
    private static final BiMap<Class<?>, Class<?>> boxedTypes;

    private PrimitiveTypeUtils() {
    }

    public static Class<?> classForName(String name) {
        return primitiveClasses.get(name);
    }

    public static boolean isPrimitive(String name) {
        return primitiveClasses.containsKey(name);
    }

    public static Class<?> box(Class<?> clazz) {
        return clazz.isPrimitive() ? (Class)boxedTypes.get(clazz) : clazz;
    }

    public static Class<?> unbox(Class<?> clazz) {
        return (Class)boxedTypes.inverse().get(clazz);
    }

    public static char signature(Class<?> clazz) {
        Character c = signatures.get(clazz);
        return c == null ? (char)'\u0000' : c.charValue();
    }

    public static Class<?> classFromSignature(String signature) {
        char first = signature.charAt(0);
        if (first == 'L') {
            try {
                return Class.forName(signature.substring(1));
            }
            catch (ClassNotFoundException e) {
                return Object.class;
            }
        }
        if (first == '[') {
            return Array.newInstance(PrimitiveTypeUtils.classFromSignature(signature.substring(1)), 0).getClass();
        }
        for (Map.Entry<Class<?>, Character> entry : signatures.entrySet()) {
            if (entry.getValue().charValue() != first) continue;
            return entry.getKey();
        }
        return Object.class;
    }

    static {
        primitiveClasses.put("void", Void.TYPE);
        primitiveClasses.put("boolean", Boolean.TYPE);
        primitiveClasses.put("char", Character.TYPE);
        primitiveClasses.put("byte", Byte.TYPE);
        primitiveClasses.put("short", Short.TYPE);
        primitiveClasses.put("int", Integer.TYPE);
        primitiveClasses.put("long", Long.TYPE);
        primitiveClasses.put("float", Float.TYPE);
        primitiveClasses.put("double", Double.TYPE);
        signatures = new HashMap();
        signatures.put(Void.TYPE, Character.valueOf('V'));
        signatures.put(Boolean.TYPE, Character.valueOf('Z'));
        signatures.put(Character.TYPE, Character.valueOf('C'));
        signatures.put(Byte.TYPE, Character.valueOf('B'));
        signatures.put(Short.TYPE, Character.valueOf('S'));
        signatures.put(Integer.TYPE, Character.valueOf('I'));
        signatures.put(Long.TYPE, Character.valueOf('J'));
        signatures.put(Float.TYPE, Character.valueOf('F'));
        signatures.put(Double.TYPE, Character.valueOf('D'));
        boxedTypes = new HashBiMap();
        BiMap<Class<?>, Class<?>> map = boxedTypes;
        map.put(Void.TYPE, Void.class);
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Character.TYPE, Character.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Short.TYPE, Short.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Float.TYPE, Float.class);
        map.put(Double.TYPE, Double.class);
    }
}

