/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

public final class NumberFormatter {
    private static final NumberFormat decimalFormat;
    private static final NumberFormat formatter;
    private static final NumberFormat moneyFormatter;

    public static String format(Object o) {
        String result = o instanceof BigDecimal ? NumberFormatter.format((BigDecimal)o) : formatter.format(o);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(BigDecimal o) {
        String result;
        NumberFormat numberFormat = decimalFormat;
        synchronized (numberFormat) {
            decimalFormat.setMinimumFractionDigits(o.scale());
            result = decimalFormat.format(o);
        }
        return result;
    }

    public static String format(double d) {
        return formatter.format(d);
    }

    public static String format(long l) {
        return formatter.format(l);
    }

    public static String formatMoney(Object o) {
        return moneyFormatter.format(o);
    }

    public static String formatMoney(double d) {
        return moneyFormatter.format(d);
    }

    public static String formatMoney(long l) {
        return moneyFormatter.format(l);
    }

    public static Number parse(String s) throws NumberFormatException {
        try {
            return formatter.parse(s);
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getMessage());
        }
    }

    static {
        formatter = NumberFormat.getInstance();
        moneyFormatter = DecimalFormat.getCurrencyInstance();
        formatter.setMaximumFractionDigits(256);
        decimalFormat = (NumberFormat)formatter.clone();
    }
}

