/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.MalformedInputException;
import oracle.bpm.io.StreamUtils;

public class I18NUtils {
    public static String readStreamLegacy(InputStream istream) throws IOException {
        String result;
        byte[] fileContents = StreamUtils.readBytes(istream);
        try {
            result = I18NUtils.readContents(fileContents, "UTF-8");
        }
        catch (MalformedInputException mie) {
            result = I18NUtils.readContents(fileContents, "ISO8859_1");
        }
        return result;
    }

    public static String readFileLegacy(File file) throws IOException {
        return I18NUtils.readStreamLegacy(new FileInputStream(file));
    }

    public static String readContents(byte[] fileContents, String charsetName) throws IOException {
        CharsetDecoder decoder = Charset.forName(charsetName).newDecoder();
        ByteBuffer byteBuffer = ByteBuffer.wrap(fileContents);
        CharBuffer charBuffer = decoder.decode(byteBuffer);
        return charBuffer.toString();
    }
}

