/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.File;
import java.util.LinkedList;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;

public class FileFilter
extends javax.swing.filechooser.FileFilter {
    private final String baseDescription;
    private final String description;
    private final LinkedList<String> extensions = new LinkedList();
    private boolean matchAll;
    public static final FileFilter ALL_FILES = FileFilter.create(CoreMsg.ALL_FILES, "*");

    private FileFilter(Msg msg, String ... extensions) {
        this.baseDescription = msg.getString().trim();
        StringBuilder description = new StringBuilder();
        description.append(this.baseDescription);
        description.append(" (");
        for (int i = 0; i < extensions.length; ++i) {
            String ext = extensions[i];
            if (i != 0) {
                description.append(",");
            }
            if (ext.equals("*.*") || ext.equals("*") || ext.equals(".*")) {
                this.matchAll = true;
                description.append("*.*");
                continue;
            }
            if (!ext.startsWith(".")) {
                ext = "." + ext;
            }
            this.extensions.add(ext);
            description.append('*');
            description.append(ext);
        }
        description.append(")");
        this.description = description.toString();
    }

    public static FileFilter create(Msg description, String ... extensions) {
        return new FileFilter(description, extensions);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public final Iterable<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public boolean accept(File f) {
        return f != null && (f.isDirectory() || this.matchAll || this.match(f.getName()));
    }

    public String getDescription(String ext) {
        return this.baseDescription + " (*" + ext + ")";
    }

    private boolean match(String fileName) {
        for (String ext : this.extensions) {
            if (!fileName.endsWith(ext)) continue;
            return true;
        }
        return false;
    }
}

