/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.Str;
import org.jetbrains.annotations.NonNls;

public final class DateFormatSymbolUtils {
    @NonNls
    private static final String YYYY_PATTERN = "yyyy";
    @NonNls
    private static final String M_PATTERN = "M";
    @NonNls
    private static final String D_PATTERN = "d";
    private static final Map<Locale, Symbols> symbolsMap = new HashMap<Locale, Symbols>();

    public static String[] getLocalizedShortWeekDays(Locale locale) {
        return DateFormatSymbolUtils.getSymbolsInstance((Locale)locale).shortWeekDays;
    }

    public static String[] getLocalizedAmPm(Locale locale) {
        return DateFormatSymbolUtils.getSymbolsInstance((Locale)locale).amPm;
    }

    public static int getLocalizedFirstDayOfWeek(Locale locale) {
        return Calendar.getInstance(locale).getFirstDayOfWeek();
    }

    public static String[] getLocalizedHeaderDayNames(Locale locale) {
        String[] days = DateFormatSymbolUtils.getSymbolsInstance((Locale)locale).weekDays;
        StringList headerDayList = StringList.create();
        for (String day : days) {
            if (day == null || day.length() <= 0) continue;
            headerDayList.add(day.substring(0, 1).toUpperCase());
        }
        return headerDayList.toArray();
    }

    public static String[][] getLocalizedHours(Locale locale) {
        boolean hasAmPm = DateFormatSymbolUtils.isAmPmTime(locale);
        String am = ' ' + DateFormatSymbolUtils.getLocalizedAmPm(locale)[0].toLowerCase();
        String pm = ' ' + DateFormatSymbolUtils.getLocalizedAmPm(locale)[1].toLowerCase();
        String[][] result = new String[24][2];
        String amPm = "";
        for (int i = 0; i < result.length; ++i) {
            int hour = i;
            if (hasAmPm) {
                amPm = hour < 12 ? am : pm;
                hour = (hour + 11) % 12 + 1;
            }
            char[] data = new char[]{Character.forDigit(hour / 10, 10), Character.forDigit(hour % 10, 10)};
            result[i][0] = String.valueOf(data) + amPm;
            result[i][1] = String.valueOf(i);
        }
        return result;
    }

    public static boolean isAmPmTime(Locale locale) {
        SimpleDateFormat dateFormat = (SimpleDateFormat)DateFormat.getTimeInstance(3, locale);
        return dateFormat.toPattern().indexOf(97) != -1;
    }

    public static int[] getLocalizedHourValues(Locale locale) {
        int[] result = DateFormatSymbolUtils.isAmPmTime(locale) ? new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12} : new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 0};
        return result;
    }

    public static String[] getLocalizedMonthNames(Locale locale) {
        return DateFormatSymbolUtils.getSymbolsInstance((Locale)locale).months;
    }

    public static String[] getLocalizedMonthShortNames(Locale locale) {
        return DateFormatSymbolUtils.getSymbolsInstance((Locale)locale).shortMonths;
    }

    public static String[] getLocalizedWeekDayNames(Locale locale) {
        return DateFormatSymbolUtils.getSymbolsInstance((Locale)locale).weekDays;
    }

    public static String getSimpleFuegoDatePattern(Locale locale) {
        return DateFormatSymbolUtils.getSimpleFuegoDatePattern(locale, true);
    }

    public static String getSimpleFuegoDatePattern(Locale locale, boolean showYear) {
        String pattern = ((SimpleDateFormat)DateFormat.getDateInstance(3, locale)).toPattern();
        int y = pattern.indexOf(121);
        int m = pattern.indexOf(77);
        int d = pattern.indexOf(100);
        int[] ind = new int[]{d, m, y};
        Arrays.sort(ind);
        StringBuffer result = new StringBuffer(10);
        int separators = ind.length - 1 - (showYear ? 0 : 1);
        for (int ix : ind) {
            if (ix == y) {
                if (!showYear) continue;
                result.append(YYYY_PATTERN);
            } else if (ix == m) {
                result.append(M_PATTERN);
                if (pattern.length() > ix + 1 && pattern.charAt(ix + 1) == 'M') {
                    result.append(M_PATTERN);
                }
            } else {
                result.append(D_PATTERN);
                if (pattern.length() > ix + 1 && pattern.charAt(ix + 1) == 'd') {
                    result.append(D_PATTERN);
                }
            }
            if (separators <= 0) continue;
            result.append('/');
            --separators;
        }
        return result.toString();
    }

    public static String getSimpleFuegoDateTimePattern(Locale locale) {
        return DateFormatSymbolUtils.getSimpleFuegoDatePattern(locale) + " " + DateFormatSymbolUtils.getSimpleFuegoTimePattern(locale);
    }

    public static String getSimpleFuegoTimePattern(Locale locale) {
        String pattern = ((SimpleDateFormat)DateFormat.getTimeInstance(2, locale)).toPattern();
        if (pattern.indexOf("mm") == -1) {
            pattern = Str.replaceString(pattern, "m", "mm");
        }
        if (pattern.indexOf("ss") == -1) {
            pattern = pattern.indexOf(115) == -1 ? pattern + "ss" : Str.replaceString(pattern, "s", "ss");
        }
        return pattern;
    }

    public static String convertToString(String[] array, boolean keepEmptyElements) {
        StringBuffer strBuffer = new StringBuffer();
        for (String s : array) {
            if (!keepEmptyElements && (s == null || s.length() <= 0)) continue;
            strBuffer.append("'");
            strBuffer.append(s);
            strBuffer.append("',");
        }
        strBuffer.deleteCharAt(strBuffer.length() - 1);
        return strBuffer.toString();
    }

    private static Symbols getSymbolsInstance(Locale locale) {
        Symbols result = symbolsMap.get(locale);
        if (result == null) {
            DateFormatSymbols formatSymbols = new DateFormatSymbols(locale);
            result = new Symbols();
            result.shortWeekDays = formatSymbols.getShortWeekdays();
            result.amPm = formatSymbols.getAmPmStrings();
            result.eras = formatSymbols.getEras();
            result.months = formatSymbols.getMonths();
            result.shortMonths = formatSymbols.getShortMonths();
            result.weekDays = formatSymbols.getWeekdays();
            symbolsMap.put(locale, result);
        }
        return result;
    }

    private static final class Symbols {
        String[] amPm;
        String[] eras;
        String[] months;
        String[] shortMonths;
        String[] shortWeekDays;
        String[] weekDays;

        private Symbols() {
        }
    }
}

