/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.bpm.lang.Binary;
import oracle.bpm.lang.Bool;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.Char;
import oracle.bpm.lang.Decimal;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.lang.Int;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.JavaObject;
import oracle.bpm.lang.Real;
import oracle.bpm.lang.RegExp;
import oracle.bpm.lang.RuntimeCILExecutionException;
import oracle.bpm.lang.Str;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.sql.BlobImpl;
import oracle.bpm.sql.ClobImpl;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.NumberFormat;
import org.jetbrains.annotations.NonNls;

public final class Conversion {
    @NonNls
    private static final String DELEGATE_FIELD = "_delegate";
    @NonNls
    private static final String TO_OBJECT_METHOD = "toObject";
    private static final Map<String, Method> resolved = Collections.synchronizedMap(new HashMap());

    private Conversion() {
    }

    public static <T> T cast(Object instance, Class<T> targetType) {
        if (instance instanceof RuntimeCILExecutionException) {
            instance = ((RuntimeCILExecutionException)instance).getObject();
        }
        if (instance != null && !targetType.isInstance(instance)) {
            Field[] allFields;
            Object delegate = null;
            JavaClass<?> javaClass = JavaClass.fromClass(instance.getClass());
            for (Field field : allFields = javaClass.getAllFields()) {
                String name = field.getName();
                Class<?> type = field.getType();
                if (!name.startsWith("__") || !name.endsWith(DELEGATE_FIELD) || !targetType.isAssignableFrom(type)) continue;
                field.setAccessible(true);
                try {
                    Object fieldValue = field.get(instance);
                    if (fieldValue == null) continue;
                    delegate = fieldValue;
                    break;
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
            if (delegate != null) {
                instance = delegate;
            } else {
                throw new ClassCastException("Cannot convert an object with type " + instance.getClass().getName() + " to " + targetType);
            }
        }
        return targetType.cast(instance);
    }

    public static void checkElementType(Object object, Class elementType) {
        if (object != null && object.getClass().isArray() && !object.getClass().getComponentType().isAssignableFrom(elementType)) {
            throw new ClassCastException("Cannot convert an object with type " + object.getClass().getName() + " to an array of " + elementType);
        }
    }

    public static <T> T convertTo(Object value, Class<T> targetType) throws IllegalConversionException {
        if (value == null) {
            return null;
        }
        if (targetType.isArray() && value instanceof List) {
            return targetType.cast(ArrayUtils.toArray(value, targetType.getComponentType()));
        }
        Class<?> sourceType = value.getClass();
        Method conversor = Conversion.getMethod(sourceType, targetType);
        if (conversor == null) {
            throw new IllegalConversionException(sourceType.getName(), targetType.getName());
        }
        return Conversion.convertTo(value, targetType, conversor);
    }

    public static <T> T convertTo(Object value, Class<T> targetType, Method method) throws IllegalConversionException {
        if (targetType == null) {
            throw new IllegalArgumentException("Null target type");
        }
        if (method == null) {
            throw new IllegalArgumentException("Null method");
        }
        assert (targetType.isAssignableFrom(method.getReturnType())) : "Invalid method for targetType. Cannot assign a " + method.getReturnType() + " to " + targetType;
        Object result = null;
        if (value != null) {
            try {
                result = Cast.forceTo(result, method.invoke(null, value));
            }
            catch (IllegalAccessException e) {
                throw new IllegalConversionException(value, targetType.getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalConversionException(value, targetType.getName(), e.getTargetException());
            }
        }
        return result;
    }

    public static void convertTo(Object value, Object target, Field field) throws IllegalConversionException {
        try {
            Class<?> targetType = field.getType();
            value = Conversion.convertTo(value, targetType);
            if (value == null) {
                if (!targetType.isPrimitive()) {
                    field.set(target, null);
                }
                return;
            }
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalConversionException(value, field.getType().getName(), e.toString());
        }
    }

    public static Object convertTo(Object value, Class targetType, Method method, int scale, int length) throws IllegalConversionException {
        try {
            return value == null ? null : Conversion.invokeConversion(value, targetType, method, scale, length);
        }
        catch (InvocationTargetException e) {
            String message = "value: [" + value + "], exception: [" + e.getTargetException() + "], method: [" + method + "]";
            IllegalConversionException e2 = new IllegalConversionException(value, targetType.getName(), message);
            e2.initCause(e);
            throw e2;
        }
        catch (Exception e) {
            String message = "value: [" + value + "], exception: [" + e + "], method: [" + method + "]";
            IllegalConversionException e2 = new IllegalConversionException(value, targetType.getName(), message);
            e2.initCause(e);
            throw e2;
        }
    }

    public static Method getMethod(Class source, String targetJavaType) {
        return Conversion.getMethod(source, targetJavaType, -1, -1);
    }

    public static Method getMethod(Class source, Class target) {
        String targetJavaType = target.getName();
        Method method = Conversion.getMethod(source, targetJavaType, -1, -1);
        if (method == null) {
            String methodName = Conversion.getMethodName(source.getName(), "from");
            String signature = targetJavaType + "$" + methodName;
            method = resolved.get(signature);
            if (method == null) {
                method = Conversion.findMethod(target, methodName, source);
                resolved.put(signature, method);
            }
        }
        return method;
    }

    public static Method getMethod(Class source, String targetJavaType, int scale, int length) {
        if (Enum.class.isAssignableFrom(source)) {
            source = Enum.class;
        }
        String methodName = Conversion.getMethodName(targetJavaType);
        StringBuilder signBldr = new StringBuilder().append(methodName).append("$").append(source.getName());
        if (scale != -1) {
            signBldr.append("$scale");
        }
        if (length != -1) {
            signBldr.append("$length");
        }
        String signature = signBldr.toString();
        Method method = resolved.get(signature);
        for (Class currentSource = source; currentSource != null && method == null; currentSource = currentSource.getSuperclass()) {
            if (scale != -1 && length != -1) {
                method = Conversion.findMethod(Conversion.class, methodName, currentSource, Integer.TYPE, Integer.TYPE);
            }
            if (method == null && (scale != -1 || length != -1)) {
                method = Conversion.findMethod(Conversion.class, methodName, currentSource, Integer.TYPE);
            }
            if (method == null) {
                method = Conversion.findMethod(Conversion.class, methodName, currentSource);
            }
            if (method == null) continue;
            resolved.put(signature, method);
            break;
        }
        if (method == null && source.equals(byte[].class)) {
            method = Conversion.findMethod(Conversion.class, TO_OBJECT_METHOD, byte[].class);
        }
        return method;
    }

    public static byte[] toBinary(Object value) {
        return Binary.serialize(value);
    }

    public static boolean toboolean(String value) {
        return Bool.parseBoolean(value);
    }

    public static boolean toboolean(Boolean value) {
        return value != null && value != false;
    }

    public static boolean toboolean(Object value) {
        return Bool.booleanValue(value);
    }

    public static byte tobyte(String value) {
        return (byte)Int.longValue(value);
    }

    public static byte tobyte(double value) {
        return (byte)value;
    }

    public static byte tobyte(int value) {
        return (byte)value;
    }

    public static byte tobyte(long value) {
        return (byte)value;
    }

    public static byte tobyte(Number value) {
        return (byte)Int.longValue(value);
    }

    public static byte tobyte(Interval value) {
        return (byte)Int.longValue(value);
    }

    public static byte tobyte(oracle.bpm.lang.Time value) {
        return (byte)Int.longValue(value);
    }

    public static byte tobyte(Object value) {
        return (byte)Int.longValue(value);
    }

    public static char tochar(String value) {
        return Char.charValue(value);
    }

    public static char tochar(double value) {
        return (char)value;
    }

    public static char tochar(Number value) {
        return (char)Int.longValue(value);
    }

    public static char tochar(Interval value) {
        return (char)Int.longValue(value);
    }

    public static char tochar(oracle.bpm.lang.Time value) {
        return (char)Int.longValue(value);
    }

    public static char tochar(Object value) {
        return Char.charValue(value);
    }

    public static double todouble(String value) {
        return Real.doubleValue(value);
    }

    public static double todouble(double value) {
        return value;
    }

    public static double todouble(float value) {
        return value;
    }

    public static double todouble(long value) {
        return value;
    }

    public static double todouble(Number value) {
        return Real.doubleValue(value);
    }

    public static double todouble(oracle.bpm.lang.Time value) {
        return Int.longValue(value);
    }

    public static double todouble(Interval value) {
        return Int.longValue(value);
    }

    public static double todouble(Object value) {
        return Real.doubleValue(value);
    }

    public static int toenum(String text, Map labelsToEnum) {
        Integer value = (Integer)labelsToEnum.get(text);
        if (value == null) {
            Collection enumValues = labelsToEnum.values();
            value = Int.ZERO;
            while (enumValues.contains(value)) {
                value = value - 1;
            }
        }
        return value;
    }

    public static int toenum(int value, String enumName, int maxValue) {
        if (value < 0 || value > maxValue) {
            throw new IllegalConversionException(String.valueOf(value), enumName);
        }
        return value;
    }

    public static int toenum(int value, String enumName, Map enumsToLabel) {
        if (!enumsToLabel.containsKey(value)) {
            throw new IllegalConversionException((Object)value, enumName);
        }
        return value;
    }

    public static int toenum(Object value, String enumName, Map enumsToLabel) {
        if (value instanceof Number) {
            return Conversion.toenum(((Number)value).intValue(), enumName, enumsToLabel);
        }
        throw new IllegalConversionException(String.valueOf(value), enumName);
    }

    public static float tofloat(double value) {
        return (float)value;
    }

    public static float tofloat(long value) {
        return value;
    }

    public static float tofloat(Interval value) {
        return Int.longValue(value);
    }

    public static float tofloat(oracle.bpm.lang.Time value) {
        return Int.longValue(value);
    }

    public static float tofloat(Object value) {
        return (float)Real.doubleValue(value);
    }

    public static float tofloat(String value) {
        return (float)Real.doubleValue(value);
    }

    public static float tofloat(Number value) {
        return (float)Real.doubleValue(value);
    }

    public static Interval tooracle_bpm_lang_Interval(long value) {
        return Interval.valueOf(value);
    }

    public static Interval tooracle_bpm_lang_Interval(double value) {
        return Interval.valueOf((long)value);
    }

    public static Interval tooracle_bpm_lang_Interval(String value) {
        return Interval.valueOf(value);
    }

    public static Interval tooracle_bpm_lang_Interval(Number value) {
        return Interval.valueOf(value);
    }

    public static Interval tooracle_bpm_lang_Interval(Object value) {
        return Interval.valueOf(value);
    }

    public static Invokeable tooracle_bpm_lang_Invokeable(Object any) {
        if (any == null || any instanceof Invokeable) {
            return (Invokeable)any;
        }
        return new JavaObject<Object>(any);
    }

    public static RegExp tooracle_bpm_lang_RegExp(RegExp regexp) {
        return regexp;
    }

    public static oracle.bpm.lang.Time tooracle_bpm_lang_Time(String value) {
        return oracle.bpm.lang.Time.valueOf(value);
    }

    public static oracle.bpm.lang.Time tooracle_bpm_lang_Time(long value) {
        return oracle.bpm.lang.Time.valueOf(value);
    }

    public static oracle.bpm.lang.Time tooracle_bpm_lang_Time(double value) {
        return oracle.bpm.lang.Time.valueOf((long)value);
    }

    public static oracle.bpm.lang.Time tooracle_bpm_lang_Time(java.util.Date date) {
        return Conversion.tooracle_bpm_lang_Time((Object)date);
    }

    public static oracle.bpm.lang.Time tooracle_bpm_lang_Time(Object value) {
        return oracle.bpm.lang.Time.valueOf(value);
    }

    public static oracle.bpm.lang.Time tooracle_bpm_lang_Time(Number value) {
        return oracle.bpm.lang.Time.valueOf(value);
    }

    public static HashMap toHashMap(Object map) {
        return ArrayUtils.toHashMap(map);
    }

    public static int toint(String value) {
        return (int)Int.longValue(value);
    }

    public static int toint(Enum value) {
        return value != null ? value.ordinal() : 0;
    }

    public static int toint(double value) {
        return (int)value;
    }

    public static int toint(long value) {
        return (int)value;
    }

    public static int toint(Number value) {
        return (int)Int.longValue(value);
    }

    public static int toint(Interval value) {
        return (int)Int.longValue(value);
    }

    public static int toint(oracle.bpm.lang.Time value) {
        return (int)Int.longValue(value);
    }

    public static int toint(Object value) {
        return (int)Int.longValue(value);
    }

    public static Boolean tojava_lang_Boolean(boolean value) {
        return value;
    }

    public static Boolean tojava_lang_Boolean(String value) {
        return Boolean.valueOf(value);
    }

    public static Boolean tojava_lang_Boolean(Object value) {
        if (value == null || value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf(value.toString());
        }
        if (value instanceof byte[]) {
            return Conversion.tojava_lang_Boolean(Conversion.toObject((byte[])value));
        }
        throw new IllegalConversionException(value, "Bool");
    }

    public static Byte tojava_lang_Byte(String value) {
        return value != null ? Byte.valueOf(value) : null;
    }

    public static Byte tojava_lang_Byte(double value) {
        return (byte)value;
    }

    public static Byte tojava_lang_Byte(int value) {
        return (byte)value;
    }

    public static Byte tojava_lang_Byte(long value) {
        return (byte)value;
    }

    public static Byte tojava_lang_Byte(Number value) {
        return value != null ? Byte.valueOf(value.byteValue()) : null;
    }

    public static Byte tojava_lang_Byte(Interval value) {
        return value != null ? Byte.valueOf((byte)value.getTotalMicroseconds()) : null;
    }

    public static Byte tojava_lang_Byte(oracle.bpm.lang.Time value) {
        return value != null ? Byte.valueOf((byte)value.getMicroSeconds()) : null;
    }

    public static Byte tojava_lang_Byte(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof Interval) {
            return (byte)((Interval)value).getTotalMicroseconds();
        }
        if (value instanceof oracle.bpm.lang.Time) {
            return (byte)((oracle.bpm.lang.Time)value).getMicroSeconds();
        }
        if (value instanceof String) {
            return (byte)Long.parseLong(value.toString());
        }
        if (value instanceof byte[]) {
            return Conversion.tojava_lang_Byte(Conversion.toObject((byte[])value));
        }
        throw new IllegalConversionException(value, "Int");
    }

    public static Character tojava_lang_Character(String value) {
        return Char.valueOf(value);
    }

    public static Character tojava_lang_Character(double value) {
        return Char.valueOf((char)value);
    }

    public static Character tojava_lang_Character(Number value) {
        return value == null ? null : Char.valueOf((char)value.intValue());
    }

    public static Character tojava_lang_Character(Interval value) {
        return value == null ? null : Char.valueOf((char)value.getTotalMicroseconds());
    }

    public static Character tojava_lang_Character(oracle.bpm.lang.Time value) {
        return value == null ? null : Char.valueOf((char)value.getMicroSeconds());
    }

    public static Character tojava_lang_Character(Object value) {
        return Char.valueOf(value);
    }

    public static Double tojava_lang_Double(String value) {
        return value != null ? Double.valueOf(value) : null;
    }

    public static Double tojava_lang_Double(Number value) {
        return value != null ? Double.valueOf(value.doubleValue()) : null;
    }

    public static Double tojava_lang_Double(double value) {
        return value;
    }

    public static Double tojava_lang_Double(long value) {
        return value;
    }

    public static Double tojava_lang_Double(Interval value) {
        return value != null ? Double.valueOf(value.getTotalMicroseconds()) : null;
    }

    public static Double tojava_lang_Double(oracle.bpm.lang.Time value) {
        return value != null ? Double.valueOf(value.getMicroSeconds()) : null;
    }

    public static Double tojava_lang_Double(String value, Locale locale) {
        if (Str.isEmpty(value)) {
            return null;
        }
        try {
            NumberFormat fmt = NumberFormat.getInstance(locale);
            Number decimalValue = fmt.parse(value);
            return Conversion.tojava_lang_Double((Object)decimalValue);
        }
        catch (ParseException ex) {
            throw new NumberFormatException();
        }
        catch (IllegalConversionException ex) {
            throw new NumberFormatException();
        }
    }

    public static Double tojava_lang_Double(Object value) {
        if (value == null || value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.valueOf(value.toString());
        }
        if (value instanceof oracle.bpm.lang.Time) {
            return ((oracle.bpm.lang.Time)value).getMicroSeconds();
        }
        if (value instanceof Interval) {
            return ((Interval)value).getTotalMicroseconds();
        }
        if (value instanceof byte[]) {
            return Conversion.tojava_lang_Double(Conversion.toObject((byte[])value));
        }
        throw new IllegalConversionException(value, "Real");
    }

    public static Float tojava_lang_Float(String value) {
        return value != null ? Float.valueOf(value) : null;
    }

    public static Float tojava_lang_Float(Number value) {
        return value != null ? Float.valueOf(value.floatValue()) : null;
    }

    public static Float tojava_lang_Float(double value) {
        return Float.valueOf((float)value);
    }

    public static Float tojava_lang_Float(long value) {
        return Float.valueOf(value);
    }

    public static Float tojava_lang_Float(Interval value) {
        return value != null ? Float.valueOf(value.getTotalMicroseconds()) : null;
    }

    public static Float tojava_lang_Float(oracle.bpm.lang.Time value) {
        return value != null ? Float.valueOf(value.getMicroSeconds()) : null;
    }

    public static Float tojava_lang_Float(Object value) {
        if (value == null || value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            return Float.valueOf(value.toString());
        }
        if (value instanceof oracle.bpm.lang.Time) {
            return Float.valueOf(((oracle.bpm.lang.Time)value).getMicroSeconds());
        }
        if (value instanceof Interval) {
            return Float.valueOf(((Interval)value).getTotalMicroseconds());
        }
        if (value instanceof byte[]) {
            return Conversion.tojava_lang_Float(Conversion.toObject((byte[])value));
        }
        throw new IllegalConversionException(value, "Real");
    }

    public static Integer tojava_lang_Integer(String value) {
        return value != null ? Integer.valueOf(value) : null;
    }

    public static Integer tojava_lang_Integer(double value) {
        return (int)value;
    }

    public static Integer tojava_lang_Integer(long value) {
        return (int)value;
    }

    public static Integer tojava_lang_Integer(Number value) {
        return value != null ? Integer.valueOf(value.intValue()) : null;
    }

    public static Integer tojava_lang_Integer(Interval value) {
        return value == null ? null : Integer.valueOf((int)value.getTotalMicroseconds());
    }

    public static Integer tojava_lang_Integer(oracle.bpm.lang.Time value) {
        return value == null ? null : Integer.valueOf((int)value.getMicroSeconds());
    }

    public static Integer tojava_lang_Integer(Object value) {
        if (value == null || value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Conversion.tojava_lang_Integer((String)value);
        }
        if (value instanceof Interval) {
            return (int)((Interval)value).getTotalMicroseconds();
        }
        if (value instanceof oracle.bpm.lang.Time) {
            return (int)((oracle.bpm.lang.Time)value).getMicroSeconds();
        }
        if (value instanceof byte[]) {
            return Conversion.tojava_lang_Integer(Conversion.toObject((byte[])value));
        }
        throw new IllegalConversionException(value, "Int");
    }

    public static Long tojava_lang_Long(String value) {
        return value != null ? Long.valueOf(value) : null;
    }

    public static Long tojava_lang_Long(Number value) {
        return value != null ? Long.valueOf(value.longValue()) : null;
    }

    public static Long tojava_lang_Long(long value) {
        return value;
    }

    public static Long tojava_lang_Long(double value) {
        return (long)value;
    }

    public static Long tojava_lang_Long(Interval value) {
        return value != null ? Long.valueOf(value.getTotalMicroseconds()) : null;
    }

    public static Long tojava_lang_Long(oracle.bpm.lang.Time value) {
        return value != null ? Long.valueOf(value.getMicroSeconds()) : null;
    }

    public static Long tojava_lang_Long(Object value) {
        if (value == null || value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.valueOf(value.toString());
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof byte[]) {
            return Conversion.tojava_lang_Long(Conversion.toObject((byte[])value));
        }
        if (value instanceof Enum) {
            return ((Enum)value).ordinal();
        }
        throw new IllegalConversionException(value, "Int");
    }

    public static Object tojava_lang_Object(Object value) {
        return value;
    }

    public static Short tojava_lang_Short(String value) {
        return value != null ? Short.valueOf(value) : null;
    }

    public static Short tojava_lang_Short(Number value) {
        return value != null ? Short.valueOf(value.shortValue()) : null;
    }

    public static Short tojava_lang_Short(long value) {
        return (short)value;
    }

    public static Short tojava_lang_Short(int value) {
        return (short)value;
    }

    public static Short tojava_lang_Short(double value) {
        return (short)value;
    }

    public static Short tojava_lang_Short(Interval value) {
        return value != null ? Short.valueOf((short)value.getTotalMicroseconds()) : null;
    }

    public static Short tojava_lang_Short(oracle.bpm.lang.Time value) {
        return value != null ? Short.valueOf((short)value.getMicroSeconds()) : null;
    }

    public static Short tojava_lang_Short(Object value) {
        if (value == null || value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            return Short.valueOf(value.toString());
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof byte[]) {
            return Conversion.tojava_lang_Short(Conversion.toObject((byte[])value));
        }
        throw new IllegalConversionException(value, "Int");
    }

    public static String tojava_lang_String(Object value) {
        return value == null ? null : Str.valueOf(value, -1);
    }

    public static String tojava_lang_String(Number value) {
        return value == null ? null : value.toString();
    }

    public static String tojava_lang_String(Interval value) {
        return value == null ? null : value.toString();
    }

    public static String tojava_lang_String(oracle.bpm.lang.Time value) {
        return value == null ? null : value.toString();
    }

    public static String tojava_lang_String(long value) {
        return String.valueOf(value);
    }

    public static String tojava_lang_String(double value) {
        return String.valueOf(value);
    }

    public static String tojava_lang_String(char value) {
        return String.valueOf(value);
    }

    public static String tojava_lang_String(boolean value) {
        return String.valueOf(value);
    }

    public static String tojava_lang_String(Clob clob) {
        return clob == null ? null : Str.valueOf(clob);
    }

    public static String tojava_lang_String(Object value, int length) {
        return Str.valueOf(value, length);
    }

    public static BigDecimal tojava_math_BigDecimal(long value) {
        return Decimal.valueOf(value);
    }

    public static BigDecimal tojava_math_BigDecimal(double value) {
        return Decimal.valueOf(value);
    }

    public static BigDecimal tojava_math_BigDecimal(Number value) {
        return Decimal.valueOf(value);
    }

    public static BigDecimal tojava_math_BigDecimal(String value) {
        return Decimal.valueOf(value);
    }

    public static BigDecimal tojava_math_BigDecimal(oracle.bpm.lang.Time value) {
        return Decimal.valueOf(value);
    }

    public static BigDecimal tojava_math_BigDecimal(Interval value) {
        return Decimal.valueOf(value);
    }

    public static BigDecimal tojava_math_BigDecimal(String value, Locale locale) {
        Number decimalValue;
        if (Str.isEmpty(value)) {
            return null;
        }
        try {
            NumberFormat fmt = NumberFormat.getInstance(locale);
            decimalValue = fmt.parse(value);
        }
        catch (ParseException ex) {
            throw new NumberFormatException();
        }
        catch (IllegalConversionException ex) {
            throw new NumberFormatException();
        }
        return Decimal.valueOf(decimalValue);
    }

    public static BigDecimal tojava_math_BigDecimal(Object value) {
        return Decimal.valueOf(value);
    }

    public static BigDecimal tojava_math_BigDecimal(Object value, int scale) {
        return Conversion.tojava_math_BigDecimal(value, scale, -1);
    }

    public static BigDecimal tojava_math_BigDecimal(long value, int scale, int length) {
        return Conversion.tojava_math_BigDecimal(Conversion.tojava_math_BigDecimal(value), scale, length);
    }

    public static BigDecimal tojava_math_BigDecimal(double value, int scale, int length) {
        return Conversion.tojava_math_BigDecimal(Conversion.tojava_math_BigDecimal(value), scale, length);
    }

    public static BigDecimal tojava_math_BigDecimal(Number value, int scale, int length) {
        return Conversion.tojava_math_BigDecimal(Conversion.tojava_math_BigDecimal(value), scale, length);
    }

    public static BigDecimal tojava_math_BigDecimal(String value, int scale, int length) {
        return Conversion.tojava_math_BigDecimal(Conversion.tojava_math_BigDecimal(value), scale, length);
    }

    public static BigDecimal tojava_math_BigDecimal(oracle.bpm.lang.Time value, int scale, int length) {
        return Conversion.tojava_math_BigDecimal(Conversion.tojava_math_BigDecimal(value), scale, length);
    }

    public static BigDecimal tojava_math_BigDecimal(Interval value, int scale, int length) {
        return Conversion.tojava_math_BigDecimal(Conversion.tojava_math_BigDecimal(value), scale, length);
    }

    public static BigDecimal tojava_math_BigDecimal(Object value, int scale, int length) {
        return Conversion.tojava_math_BigDecimal(Conversion.tojava_math_BigDecimal(value), scale, length);
    }

    public static Blob tojava_sql_Blob(byte[] b) {
        if (b == null) {
            return null;
        }
        return new BlobImpl(b);
    }

    public static Clob tojava_sql_Clob(String text) {
        if (text == null) {
            return null;
        }
        return new ClobImpl(text);
    }

    public static Date tojava_sql_Date(oracle.bpm.lang.Time time) {
        return time != null ? new Date(time.getMilliSeconds()) : null;
    }

    public static Date tojava_sql_Date(java.util.Date date) {
        return date != null ? new Date(date.getTime()) : null;
    }

    public static Time tojava_sql_Time(java.util.Date date) {
        return date != null ? new Time(date.getTime()) : null;
    }

    public static Time tojava_sql_Time(oracle.bpm.lang.Time time) {
        return time != null ? new Time(time.getMilliSeconds()) : null;
    }

    public static Timestamp tojava_sql_Timestamp(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof oracle.bpm.lang.Time) {
            return Conversion.tojava_sql_Timestamp((oracle.bpm.lang.Time)value);
        }
        if (value instanceof java.util.Date) {
            return Conversion.tojava_sql_Timestamp((java.util.Date)value);
        }
        if (value instanceof byte[]) {
            return Conversion.tojava_sql_Timestamp(Conversion.toObject((byte[])value));
        }
        throw new IllegalConversionException(value, "Time");
    }

    public static Timestamp tojava_sql_Timestamp(java.util.Date date) {
        return date != null ? new Timestamp(date.getTime()) : null;
    }

    public static Timestamp tojava_sql_Timestamp(oracle.bpm.lang.Time time) {
        return time != null ? time.sqlTimestampValue() : null;
    }

    public static ArrayList tojava_util_ArrayList(Object object) {
        List result = Conversion.toList(object);
        if (result == null || result instanceof ArrayList) {
            return (ArrayList)result;
        }
        ArrayList objects = new ArrayList();
        for (Object o : result) {
            objects.add(o);
        }
        return objects;
    }

    public static ArrayList tojava_util_ArrayList(Object object, Class elementType) {
        Conversion.checkElementType(object, elementType);
        return Conversion.tojava_util_ArrayList(object);
    }

    public static java.util.Date tojava_util_Date(Object value) {
        if (value == null || value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        if (value instanceof oracle.bpm.lang.Time) {
            return Conversion.tojava_util_Date((oracle.bpm.lang.Time)value);
        }
        if (value instanceof String) {
            return Conversion.tojava_util_Date(oracle.bpm.lang.Time.valueOf(value.toString()));
        }
        if (value instanceof byte[]) {
            return Conversion.tojava_util_Date(Conversion.toObject((byte[])value));
        }
        throw new IllegalConversionException(value, "Time");
    }

    public static java.util.Date tojava_util_Date(oracle.bpm.lang.Time time) {
        return time != null ? new java.util.Date(time.getMilliSeconds()) : null;
    }

    public static java.util.Date tojava_util_Date(java.util.Date date) {
        return date;
    }

    public static HashMap tojava_util_HashMap(Object object) {
        return ArrayUtils.toHashMap(object);
    }

    public static Iterator tojava_util_Iterator(Object value) {
        return ArrayUtils.toIterator(value);
    }

    public static Iterator tojava_util_Iterator(Iterator value) {
        return value;
    }

    public static Iterator tojava_util_Iterator(List value) {
        return value == null ? null : value.iterator();
    }

    public static Iterator tojava_util_Iterator(Map value) {
        return value == null ? null : value.values().iterator();
    }

    public static LinkedHashMap tojava_util_LinkedHashMap(Object object) {
        return ArrayUtils.toLinkedHashMap(object);
    }

    public static List tojava_util_List(Object object) {
        return Conversion.toList(object);
    }

    public static List tojava_util_List(Object object, Class elementType) {
        Conversion.checkElementType(object, elementType);
        return Conversion.tojava_util_List(object);
    }

    public static Map tojava_util_Map(Object object) {
        return ArrayUtils.toHashMap(object);
    }

    public static LinkedHashMap toLinkedHashMap(Object collection) {
        return ArrayUtils.toLinkedHashMap(collection);
    }

    public static List toList(Object objs) {
        if (objs == null || objs instanceof List) {
            return (List)objs;
        }
        if (objs instanceof Collection) {
            ArrayList result = new ArrayList();
            for (Object o : (Collection)objs) {
                result.add(o);
            }
            return result;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(objs);
        return result;
    }

    public static Object toList(Object array, Class targetType) throws InstantiationException, IllegalAccessException {
        Object result = Iterator.class.isAssignableFrom(targetType) ? ArrayUtils.toIterator(array) : Conversion.toList(array, targetType, null);
        return result;
    }

    public static List toList(Object array, Class targetType, Class targetElementType) throws InstantiationException, IllegalAccessException {
        return Conversion.toList(array, targetType, targetElementType, -1, -1);
    }

    public static List toList(Object array, Class targetType, Class targetElementType, int scale, int length) throws InstantiationException, IllegalAccessException {
        return ArrayUtils.toListSL(array, targetType, targetElementType, scale, length);
    }

    public static long tolong(String value) {
        return Int.longValue(value);
    }

    public static long tolong(double value) {
        return (long)value;
    }

    public static long tolong(Number value) {
        return Int.longValue(value);
    }

    public static long tolong(Interval value) {
        return Int.longValue(value);
    }

    public static long tolong(oracle.bpm.lang.Time value) {
        return Int.longValue(value);
    }

    public static long tolong(Object value) {
        return Int.longValue(value);
    }

    public static Map toMap(Object object, Class<?> targetType) throws InstantiationException, IllegalAccessException {
        Map result;
        if (object == null) {
            return null;
        }
        if (!Map.class.isAssignableFrom(targetType)) {
            throw new IllegalArgumentException(targetType.getName() + " is not a subtype of java.util.List");
        }
        Class<?> sourceType = object.getClass();
        if (targetType.isAssignableFrom(sourceType)) {
            result = (AbstractMap)Cast.force(object);
        } else {
            result = targetType.isInterface() ? (SortedMap.class.isAssignableFrom(targetType) ? new TreeMap() : new HashMap()) : (Map)Cast.force(targetType.newInstance());
            if (!(object instanceof Map)) {
                throw new IllegalConversionException(object, targetType);
            }
            Map map = (Map)Cast.force(object);
            result.putAll(map);
        }
        return result;
    }

    public static Object toObject(byte[] value) {
        return Binary.deserialize(value);
    }

    public static short toshort(String value) {
        return (short)Int.longValue(value);
    }

    public static short toshort(Number value) {
        return (short)Int.longValue(value);
    }

    public static short toshort(long value) {
        return (short)value;
    }

    public static short toshort(int value) {
        return (short)value;
    }

    public static short toshort(double value) {
        return (short)value;
    }

    public static short toshort(Interval value) {
        return (short)Int.longValue(value);
    }

    public static short toshort(oracle.bpm.lang.Time value) {
        return (short)Int.longValue(value);
    }

    public static short toshort(Object value) {
        return (short)Int.longValue(value);
    }

    static String getMethodName(Class targetType) {
        String targetJavaType = targetType.getName();
        return Conversion.getMethodName(targetJavaType);
    }

    static String getMethodName(String targetJavaType) {
        return Conversion.getMethodName(targetJavaType, "to");
    }

    private static Object invokeConversion(Object value, Class targetType, Method method, int scale, int length) throws Exception {
        Object result = null;
        if (method == null) {
            CoreMsg.NOT_SUCH_METHOD(Conversion.getMethodName(targetType), value.getClass()).logSevere();
        } else {
            int argc = method.getParameterTypes().length;
            if (argc == 1) {
                result = method.invoke(null, value);
            } else if (argc == 2) {
                result = method.invoke(null, value, scale != -1 ? scale : length);
            } else if (argc == 3) {
                result = method.invoke(null, value, scale, length);
            } else {
                throw new IllegalAccessException("Invalid method: " + method.toString());
            }
        }
        return result;
    }

    private static BigDecimal tojava_math_BigDecimal(BigDecimal value, int scale, int length) {
        return Decimal.checkLength61(Decimal.scale(value, scale), length);
    }

    private static String getMethodName(String targetJavaType, String prefix) {
        String methodName = !targetJavaType.equals(byte[].class.getName()) ? prefix + targetJavaType.replace('.', '_') : prefix + "Binary";
        return methodName;
    }

    private static Method findMethod(Class<?> converter, String methodName, Class ... argTypes) {
        Method method;
        try {
            method = converter.getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        return method;
    }
}

