/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

public class ClassLoaderUtils {
    public static String getClassLoadersDebugingInfo(String classname) {
        String result = "";
        try {
            return ClassLoaderUtils.getClassLoadersDebugingInfo(Class.forName(classname));
        }
        catch (ClassNotFoundException e) {
            result = result + "==============================\nCannot load class: " + e.getMessage();
            return result + ClassLoaderUtils.getClassLoadersDebugingInfo((Class)null);
        }
    }

    public static String getClassLoadersDebugingInfo(Class c) {
        StringBuffer sb = new StringBuffer();
        if (c != null) {
            ClassLoaderUtils.appendClassLoaderInfo(sb, c.getClassLoader(), "ClassLoader for: " + c);
        }
        ClassLoaderUtils.appendClassLoaderInfo(sb, ClassLoader.getSystemClassLoader(), "System class Loader");
        ClassLoaderUtils.appendClassLoaderInfo(sb, Thread.currentThread().getContextClassLoader(), "Thread Context Class loader");
        ClassLoaderUtils.appendClassLoaderInfo(sb, ClassLoaderUtils.class.getClassLoader(), "Classloader for " + ClassLoaderUtils.class);
        sb.append("\n");
        sb.append("\n");
        return sb.toString();
    }

    private static void appendClassLoaderInfo(StringBuffer sb, ClassLoader classLoader, String message) {
        sb.append("============== ClassLoaderInfo ============== : ").append(message);
        sb.append("\n");
        sb.append("classLoader = ").append(classLoader);
        sb.append("\n");
        sb.append("classLoader.getClass().getName() = ").append(classLoader.getClass().getName());
        sb.append("\n");
        String indent = "  |___";
        for (classLoader = classLoader.getParent(); classLoader != null; classLoader = classLoader.getParent()) {
            sb.append(indent).append(classLoader);
            sb.append("\n");
            indent = "  " + indent;
        }
        sb.append("==============================================================");
        sb.append("\n");
    }
}

