/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.resources;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.log.ErrorRange;
import oracle.bpm.log.LogComponent;
import oracle.bpm.resources.BaseMsg;
import oracle.bpm.resources.ErrorMsg;
import oracle.bpm.resources.InvalidMessageException;
import oracle.bpm.resources.Msg;
import oracle.bpm.resources.MsgType;
import oracle.bpm.resources.TErrorMsg;
import oracle.bpm.resources.TMsg;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MsgBundle {
    private static Map<Class<? extends MsgBundle>, ErrorCodeBundle> errorCodeByBundleClass = new HashMap<Class<? extends MsgBundle>, ErrorCodeBundle>();
    protected static final int NO_CODE_RANGE = -1;

    public static int getErrorCode(@NotNull Class<? extends MsgBundle> bundle, @NotNull String msgCode) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle.getErrorCode must not be null");
        }
        if (msgCode == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/resources/MsgBundle.getErrorCode must not be null");
        }
        int result = 0;
        ErrorCodeBundle codeId = errorCodeByBundleClass.get(bundle);
        if (codeId != null) {
            result = codeId.getErrorCode(msgCode);
        }
        return result;
    }

    protected static ErrorMsg errorMsg(@NonNls @NotNull String msg, @NotNull String cause, @NotNull String action) {
        if (msg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle.errorMsg must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/resources/MsgBundle.errorMsg must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/resources/MsgBundle.errorMsg must not be null");
        }
        return new ErrorMsg(MsgType.buildMsgMap(msg, cause, action));
    }

    protected static ErrorMsg errorMsg(@NonNls @NotNull String msg, @NotNull String cause, @NotNull String action, @NotNull String severity) {
        if (msg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle.errorMsg must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/resources/MsgBundle.errorMsg must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/resources/MsgBundle.errorMsg must not be null");
        }
        if (severity == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/resources/MsgBundle.errorMsg must not be null");
        }
        return new ErrorMsg(MsgType.buildMsgMap(msg, cause, action, severity));
    }

    protected static TErrorMsg tErrorMsg(@NonNls @NotNull String msg, @NotNull String cause, @NotNull String action) {
        if (msg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle.tErrorMsg must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/resources/MsgBundle.tErrorMsg must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/resources/MsgBundle.tErrorMsg must not be null");
        }
        return new TErrorMsg(msg, cause, action);
    }

    protected static TMsg tmsg(@NonNls @NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle.tmsg must not be null");
        }
        return new TMsg(msg, null, null);
    }

    protected static TMsg tmsg(@NonNls @NotNull String msg, @NonNls String detail, @NonNls String img) {
        if (msg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle.tmsg must not be null");
        }
        return new TMsg(msg, detail, img);
    }

    protected static TMsg tmsg(@NonNls @NotNull String defaultText, @NonNls String detail) {
        if (defaultText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle.tmsg must not be null");
        }
        return new TMsg(defaultText, detail, null);
    }

    protected static Msg msg(@NonNls @NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle.msg must not be null");
        }
        return new Msg(MsgType.buildMsgMap(msg, null, null, '\u0000'));
    }

    protected static Msg msg(@NonNls @NotNull String msg, @NonNls String detail) {
        if (msg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle.msg must not be null");
        }
        return new Msg(MsgType.buildMsgMap(msg, detail, null, '\u0000'));
    }

    protected static Msg msg(@NonNls @NotNull String msg, @NonNls String detail, @NonNls String img) {
        if (msg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle.msg must not be null");
        }
        return new Msg(MsgType.buildMsgMap(msg, detail, img, '\u0000'));
    }

    protected static Msg msg(@NonNls @NotNull String defaultText, @NonNls String detail, @NonNls String img, char accelerator) {
        if (defaultText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle.msg must not be null");
        }
        return new Msg(MsgType.buildMsgMap(defaultText, detail, img, accelerator));
    }

    protected static void init(@NotNull Class<? extends MsgBundle> bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle.init must not be null");
        }
        MsgBundle.init(bundle, LogComponent.DEFAULT, ErrorRange.DEFAULT, -1, -1);
    }

    protected static void init(@NotNull Class<? extends MsgBundle> bundle, @NotNull LogComponent log) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle.init must not be null");
        }
        if (log == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/resources/MsgBundle.init must not be null");
        }
        MsgBundle.init(bundle, log, ErrorRange.DEFAULT, -1, -1);
    }

    protected static void init(@NotNull Class<? extends MsgBundle> bundle, @NotNull LogComponent log, @NotNull ErrorRange errorRange) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle.init must not be null");
        }
        if (log == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/resources/MsgBundle.init must not be null");
        }
        if (errorRange == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/resources/MsgBundle.init must not be null");
        }
        MsgBundle.init(bundle, log, errorRange, errorRange.lower(), errorRange.upper());
    }

    protected static void init(@NotNull Class<? extends MsgBundle> bundle, @NotNull LogComponent log, @NotNull ErrorRange errorRange, int subRangeLow, int subRangeHigh) {
        Field[] fields;
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle.init must not be null");
        }
        if (log == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/resources/MsgBundle.init must not be null");
        }
        if (errorRange == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/resources/MsgBundle.init must not be null");
        }
        ErrorCodeBundle errorCodeBundle = new ErrorCodeBundle(bundle, subRangeLow, subRangeHigh);
        errorCodeByBundleClass.put(bundle, errorCodeBundle);
        for (Field field : fields = bundle.getDeclaredFields()) {
            boolean isTMsg;
            boolean bl = isTMsg = TMsg.class.isAssignableFrom(field.getType()) || TErrorMsg.class.isAssignableFrom(field.getType());
            if (!BaseMsg.class.isAssignableFrom(field.getType()) && !isTMsg) continue;
            try {
                field.setAccessible(true);
                BaseMsg msg = (BaseMsg)field.get(null);
                msg.init(field.getName(), bundle, isTMsg, log);
                if (!ErrorMsg.class.isAssignableFrom(field.getType())) continue;
                ErrorMsg exceptionMsg = (ErrorMsg)msg;
                exceptionMsg.setErrorCode(errorCodeBundle.getErrorCode(field.getName()));
            }
            catch (InvalidMessageException e2) {
                e2.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private static class ErrorCodeBundle {
        final int maxRange;
        final int minRange;
        final Properties msgCodeToErrorCode;
        private static final String ERROR_CODE_FILE_EXTENSION = ".ecodes";
        private static final String DEFAULT_CODE_VALUE = "0";

        public ErrorCodeBundle(@NotNull Class<? extends MsgBundle> bundleClass, int minExceptionRange, int maxExceptionRange) {
            if (bundleClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle$ErrorCodeBundle.<init> must not be null");
            }
            this.msgCodeToErrorCode = new Properties();
            this.minRange = minExceptionRange;
            this.maxRange = maxExceptionRange;
            this.init(bundleClass);
        }

        public int getErrorCode(@NotNull String msgCode) {
            if (msgCode == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle$ErrorCodeBundle.getErrorCode must not be null");
            }
            String codeValue = this.msgCodeToErrorCode.getProperty(msgCode, DEFAULT_CODE_VALUE);
            int result = 0;
            try {
                result = Integer.parseInt(codeValue);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void init(@NotNull Class<? extends MsgBundle> bundleClass) {
            if (bundleClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle$ErrorCodeBundle.init must not be null");
            }
            InputStream is = this.openErrorCodeFile(bundleClass);
            if (is != null) {
                try {
                    this.msgCodeToErrorCode.load(is);
                }
                catch (IOException iOException) {
                    StreamUtils.close(is);
                    catch (Throwable throwable) {
                        StreamUtils.close(is);
                        throw throwable;
                    }
                }
                StreamUtils.close(is);
            }
        }

        @Nullable
        private InputStream openErrorCodeFile(@NotNull Class<? extends MsgBundle> bundleClass) {
            if (bundleClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgBundle$ErrorCodeBundle.openErrorCodeFile must not be null");
            }
            String bundleClassName = bundleClass.getName();
            String resourceName = bundleClassName.replace('.', '/') + ERROR_CODE_FILE_EXTENSION;
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
            if (stream == null) {
                stream = bundleClass.getResourceAsStream(resourceName);
            }
            return stream;
        }
    }
}

