/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.resources;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.lang.Platform;
import oracle.bpm.locale.LocaleSupport;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.MessageParser;
import oracle.bpm.resources.MsgType;
import oracle.bpm.resources.TMsg;
import oracle.bpm.resources.UIMsg;
import org.jetbrains.annotations.NotNull;

public class Msg
extends UIMsg
implements Comparable<Msg>,
I18nProvider,
Serializable {
    transient Msg colonMsg;
    private static ThreadLocal<LocaleSupport> threadLocale;
    private static final String ENGLISH_LANGUAGE;
    private static final Map<Key, String> messageCache;
    static final long serialVersionUID = 7984174114862224126L;
    static final long serialCheck = -4348541538919521990L;

    protected Msg(@NotNull EnumMap<MsgType, String> message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/Msg.<init> must not be null");
        }
        super(message);
    }

    protected Msg(@NotNull EnumMap<MsgType, String> message, @NotNull Object[] arguments) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/Msg.<init> must not be null");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/resources/Msg.<init> must not be null");
        }
        super(message, arguments);
    }

    public static Locale getThreadLocale() {
        return Msg.getThreadLocaleSupport().asJavaLocale();
    }

    public static LocaleSupport getThreadLocaleSupport() {
        LocaleSupport locale = threadLocale == null ? null : threadLocale.get();
        return locale == null ? Platform.getLocaleService().getDefaultLocale() : locale;
    }

    public static void setThreadLocale(Locale locale) {
        Msg.setThreadLocale(Platform.getLocaleService().getSupportForLocale(locale));
    }

    public static void setThreadLocale(LocaleSupport locale) {
        if (threadLocale == null) {
            threadLocale = new ThreadLocal();
        }
        threadLocale.set(locale);
    }

    public static Msg QUOTE(String s) {
        return TMsg.QUOTE.args(s);
    }

    public LocaleStringMap getAllAvailableTranslationsForProjectLanguages() {
        LocaleStringMap result = LocaleStringMap.create();
        for (LocaleSupport locale : Platform.getLocaleService().getSupportedLocales()) {
            result.put(locale.asJavaLocale(), this.getString(null, locale));
        }
        return result;
    }

    @Override
    public final boolean equals(Object o) {
        return o instanceof Msg && this.equals((Msg)o);
    }

    @Override
    public final int hashCode() {
        return 29 * super.hashCode();
    }

    @Override
    public String getString() {
        return this.getString(MsgType.DEFAULT, Msg.getThreadLocaleSupport());
    }

    @Override
    public String getString(Locale locale) {
        return this.getString(Platform.getLocaleService().getSupportForLocale(locale));
    }

    public String getString(LocaleSupport locale) {
        return this.getString(MsgType.DEFAULT, locale);
    }

    public final String getDetail() {
        return this.getString(MsgType.DETAIL, Platform.getLocaleService().getDefaultLocale());
    }

    public String getDetail(Locale locale) {
        return this.getString(MsgType.DETAIL, Platform.getLocaleService().getSupportForLocale(locale));
    }

    public String getDetail(LocaleSupport locale) {
        return this.getString(MsgType.DETAIL, locale);
    }

    public char getMnemonic() {
        String result = this.getString(MsgType.MNEMONIC, Msg.getThreadLocaleSupport());
        return Msg.empty(result) ? (char)'\u0000' : result.charAt(0);
    }

    public String getString(MsgType type, LocaleSupport locale) {
        String message;
        if (type == null) {
            type = MsgType.DEFAULT;
        }
        return (message = this.getByLocale(type, locale)) == null || this.args.length == 0 ? message : String.format(message, this.args);
    }

    public String toString() {
        String str = this.getString(Msg.getThreadLocale());
        return str == null ? this.getCode() : str;
    }

    public String getLocalizedLogMessage() {
        String logStr;
        Locale locale = Msg.getThreadLocale();
        if ("en".equalsIgnoreCase(locale.getLanguage())) {
            logStr = this.getString(locale);
            if (logStr == null) {
                logStr = this.getCode();
            }
        } else {
            logStr = this.getCode() + " " + this.getString(locale);
        }
        return logStr;
    }

    public final boolean logDebug() {
        if (Log.isDebugging()) {
            Log.logDebug(this);
        }
        return true;
    }

    public void logInfo() {
        Log.logInfo(this);
    }

    public void logSevere() {
        Log.logSevere(this);
    }

    public void logWarning() {
        Log.logWarning(this);
    }

    @Override
    public int compareTo(Msg msg) {
        return super.compareTo(msg);
    }

    public Msg withColon() {
        if (this.colonMsg == null) {
            this.colonMsg = new ColonMsg(this);
        }
        return this.colonMsg;
    }

    protected static boolean empty(String str) {
        return str == null || str.length() == 0;
    }

    private String getByLocale(MsgType type, LocaleSupport locale) {
        Key k = new Key(this.code, type, this.getBundleName(), locale);
        String result = messageCache.get(k);
        if (result == null) {
            result = this.getMessage(type, locale);
            messageCache.put(k, result);
        }
        return result;
    }

    private String getMessage(@NotNull MsgType type, LocaleSupport locale) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/Msg.getMessage must not be null");
        }
        String result = null;
        ResourceBundle resourceBundle = locale.resolveBundle(this.bundle);
        if (resourceBundle != null) {
            try {
                result = resourceBundle.getString(this.code + type.getExtension());
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            if (result != null) {
                MessageParser p = new MessageParser();
                result = p.parse(result);
                if (!p.isValid()) {
                    Log.logWarning(CoreMsg.INVALID_MSG(this.bundle.getSimpleName(), this.code, result));
                }
            }
        }
        if (result == null && (result = this.getMsgByType(type)) == null) {
            result = "";
        }
        return result;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.args == null) {
            s.writeInt(0);
        } else {
            s.writeInt(this.args.length);
            for (Object arg : this.args) {
                s.writeObject(arg == null ? "" : arg.toString());
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int n = stream.readInt();
        this.args = new Object[n];
        for (int i = 0; i < n; ++i) {
            this.args[i] = stream.readObject();
        }
    }

    static {
        ENGLISH_LANGUAGE = Locale.ENGLISH.getLanguage();
        messageCache = new ConcurrentHashMap<Key, String>();
    }

    private static final class Key {
        private String bundleName;
        private String code;
        private LocaleSupport locale;
        private MsgType type;

        Key(String code, MsgType type, String bundleName, LocaleSupport locale) {
            this.code = code;
            this.type = type;
            this.bundleName = bundleName;
            this.locale = locale;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Key && this.eq((Key)o);
        }

        public int hashCode() {
            int result = this.code.hashCode();
            result = 29 * result + this.type.hashCode();
            result = 29 * result + this.bundleName.hashCode();
            return 29 * result + this.locale.hashCode();
        }

        private boolean eq(Key that) {
            return this.type == that.type && this.code.equals(that.code) && this.bundleName.equals(that.bundleName) && this.locale.equals(that.locale);
        }
    }

    protected static class ColonMsg
    extends Msg {
        static final long serialVersionUID = 7984174114862224126L;
        static final long serialCheck = -4348541538919521990L;

        ColonMsg(Msg source) {
            super(source.getMessagesByType(), source.args);
            this.init(source.code, source.bundle, false, source.getLogComponent());
            this.colonMsg = this;
        }

        @Override
        public String getString(MsgType type, LocaleSupport locale) {
            String message = super.getString(type, locale);
            return type == MsgType.DEFAULT ? CoreMsg.COLON(message).getString(locale) : message;
        }
    }
}

