/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.resources;

import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MessageParser {
    private int argCount;
    private boolean valid;
    @NonNls
    private static final String GLOSSARY = "GLOSSARY";
    @NonNls
    private static final String STRARG = "$s";

    public boolean isValid() {
        return this.valid;
    }

    public int getArgCount() {
        return this.argCount;
    }

    public String parse(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MessageParser.parse must not be null");
        }
        return this.parse(message, true);
    }

    String parse(@NotNull String message, boolean allowArguments) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MessageParser.parse must not be null");
        }
        String result = message;
        this.argCount = 0;
        this.valid = true;
        int first = message.indexOf(37);
        if (first != -1) {
            result = this.doParse(message, first);
            if (!allowArguments || this.valid && this.argCount == 0) {
                result = result.replace("%%", "%");
            }
        }
        return result;
    }

    private static void log(Msg lm, MissingResourceException e) {
        Log.logWarning(lm);
        Log.logWarning(lm, e);
    }

    private String doParse(@NotNull String message, int from) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MessageParser.doParse must not be null");
        }
        StringBuilder result = new StringBuilder();
        result.append(message, 0, from);
        int len = message.length();
        for (int i = from; i < len; ++i) {
            char c = message.charAt(i);
            if (c != '%') {
                result.append(c);
                continue;
            }
            if (++i == len) {
                result.append("%%");
                this.valid = false;
                continue;
            }
            c = message.charAt(i);
            if (c == '(') {
                int closeParent = message.indexOf(41, i);
                if (closeParent == -1) {
                    this.valid = false;
                    continue;
                }
                result.append(this.glossarySearch(message.substring(i + 1, closeParent)));
                i = closeParent;
                continue;
            }
            if (c == '%') {
                result.append("%%");
                continue;
            }
            if (Character.isDigit(c)) {
                i = this.extractArg(message, i, len, result);
                continue;
            }
            if ((i = message.indexOf(58, i)) != -1) {
                i = message.indexOf(58, i + 1);
            }
            int n = i = i == -1 ? len : i + 1;
            if (i != len && Character.isDigit(message.charAt(i))) {
                i = this.extractArg(message, i, len, result);
                continue;
            }
            this.valid = false;
        }
        return result.toString();
    }

    private String glossarySearch(String glossaryTerm) {
        String result = glossaryTerm;
        ResourceBundle bundle = null;
        try {
            bundle = PropertyResourceBundle.getBundle(GLOSSARY);
            result = bundle.getString(glossaryTerm);
        }
        catch (MissingResourceException e) {
            this.valid = false;
            MessageParser.log(bundle == null ? CoreMsg.GLOSSARY_NOTFOUND : CoreMsg.GLOSSARY_TERM_NOT_FOUND(glossaryTerm), e);
        }
        return result;
    }

    private int extractArg(String message, int i, int len, StringBuilder result) {
        int argno = 0;
        char c = message.charAt(i);
        do {
            argno = argno * 10 + Character.digit(c, 10);
        } while (Character.isDigit(c = ++i < len ? message.charAt(i) : (char)'\u0000'));
        --i;
        result.append('%');
        result.append(++argno);
        result.append(STRARG);
        if (argno > this.argCount) {
            this.argCount = argno;
        }
        return i;
    }
}

