/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.resources;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EnumMap;
import oracle.bpm.lang.Cast;
import oracle.bpm.log.LogComponent;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.MsgBundle;
import oracle.bpm.resources.MsgType;
import org.jetbrains.annotations.NotNull;

public abstract class BaseMsg
implements Serializable {
    protected Class<? extends MsgBundle> bundle;
    protected String code;
    @NotNull
    private LogComponent logComponent;
    private EnumMap<MsgType, String> msgsByType;
    protected static final String NO_CODE = "";
    static final long serialCheck = -4327445406973011357L;
    static final long serialVersionUID = 7984174114862224126L;

    protected BaseMsg(@NotNull EnumMap<MsgType, String> message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/BaseMsg.<init> must not be null");
        }
        this.msgsByType = message;
        this.code = NO_CODE;
        this.logComponent = LogComponent.DEFAULT;
    }

    public boolean equals(Object o) {
        return o instanceof BaseMsg && this.equals((BaseMsg)o);
    }

    public boolean equals(BaseMsg that) {
        return that != null && this.code.equals(that.code) && this.bundle == that.bundle;
    }

    public final String getBundleName() {
        return this.bundle.getName();
    }

    public LogComponent getLogComponent() {
        return this.logComponent;
    }

    public final String getBundleShortName() {
        String result = this.bundle.getName();
        int last = result.lastIndexOf(46);
        if ((result = result.substring(last + 1)).endsWith("Msg")) {
            result = result.substring(0, result.length() - 3);
        }
        return result;
    }

    public final String getCode() {
        return this.code;
    }

    public int hashCode() {
        int result = 63;
        if (this.bundle != null) {
            result += this.bundle.getName().hashCode();
        }
        return 29 * result + this.code.hashCode();
    }

    public final boolean hasDetail() {
        return this.msgsByType.containsKey((Object)MsgType.DETAIL);
    }

    public int compareTo(BaseMsg that) {
        int cmp = this.bundle == that.bundle ? 0 : (this.bundle == null ? -1 : (that.bundle == null ? 1 : this.bundle.getName().compareTo(that.bundle.getName())));
        return cmp != 0 ? cmp : this.code.compareTo(that.code);
    }

    protected abstract void parseMsg(boolean var1);

    protected boolean hasMsgType(MsgType type) {
        return this.msgsByType.containsKey((Object)type);
    }

    protected String getMsgByType(MsgType type) {
        return this.msgsByType.get((Object)type);
    }

    protected void setMsgByType(@NotNull MsgType type, @NotNull String value) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/BaseMsg.setMsgByType must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/resources/BaseMsg.setMsgByType must not be null");
        }
        if (value.length() > 0) {
            this.msgsByType.put(type, value);
        }
    }

    protected EnumMap<MsgType, String> getMessagesByType() {
        return this.msgsByType.clone();
    }

    protected void clearMsgType(@NotNull MsgType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/BaseMsg.clearMsgType must not be null");
        }
        this.msgsByType.remove((Object)type);
    }

    protected void resolveBundle(String bundleName) {
        this.bundle = CoreMsg.class;
        if (bundleName != null) {
            try {
                this.bundle = (Class)Cast.force(Class.forName(bundleName));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    protected void checkState() {
        if (NO_CODE.equals(this.code) || this.bundle == null) {
            throw new IllegalStateException("Msg not initialized: " + this.msgsByType);
        }
    }

    protected final void init(String msgCode, Class<? extends MsgBundle> msgBundle, boolean allowArguments, @NotNull LogComponent log) {
        if (log == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/resources/BaseMsg.init must not be null");
        }
        if (NO_CODE.equals(this.code)) {
            this.code = msgCode;
            this.bundle = msgBundle;
            this.logComponent = log;
            this.parseMsg(allowArguments);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.code);
        s.writeObject(this.bundle.getName());
        s.writeObject(this.msgsByType);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.code = (String)s.readObject();
        String bundleName = (String)s.readObject();
        this.msgsByType = (EnumMap)Cast.force(s.readObject());
        this.resolveBundle(bundleName);
    }
}

