/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pool;

import java.util.Properties;
import oracle.bpm.pool.Cache;

public class PoolUtils {
    public static boolean getBoolParameter(String parameter, Properties properties, Properties defaults) {
        String value = properties.getProperty(parameter);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        value = defaults.getProperty(parameter);
        return Boolean.valueOf(value);
    }

    public static Properties getDefaults() {
        Properties result = new Properties();
        result.setProperty("fuego.cache.maxentrysize", String.valueOf(10));
        result.setProperty("fuego.cache.maxsize", String.valueOf(10));
        result.setProperty("fuego.cache.minsize", String.valueOf(0));
        result.setProperty("fuego.cache.timeout", String.valueOf(5));
        result.setProperty("fuego.cache.minnodisposable", String.valueOf(0));
        result.setProperty("fuego.cache.wait", String.valueOf(false));
        result.setProperty("fuego.cache.maxretries", String.valueOf(5));
        result.setProperty("fuego.cache.retrytimeout", String.valueOf(500L));
        result.setProperty("fuego.cache.multiplelocks", String.valueOf(true));
        result.setProperty("fuego.cache.statistics", Cache.STATISTICS_ENABLED_DEFAULT);
        return result;
    }

    public static int getIntParameter(String parameter, Properties properties, Properties defaults) {
        String value = properties.getProperty(parameter);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        value = defaults.getProperty(parameter);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static long getLongParameter(String parameter, Properties properties, Properties defaults) {
        String value = properties.getProperty(parameter);
        if (value != null) {
            return Long.valueOf(value);
        }
        value = defaults.getProperty(parameter);
        return Long.valueOf(value);
    }
}

