/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pool;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.bpm.pool.CacheStatistic;
import oracle.bpm.pool.ConnectionPoolMonitorUpdateListener;
import oracle.bpm.pool.LockOwner;
import oracle.bpm.pool.TimedMultiValuatedCache;

public class DefaultCacheStatistic
implements CacheStatistic {
    private int alreadyLocked_d;
    private int cacheAccess_d = 0;
    private int capacity_d;
    private int clear_d;
    private ConnectionPoolMonitorUpdateListener connectionPoolMonitorUpdateListener;
    private int connectionsLocked;
    private int create_d = 0;
    private int disposeByUser_d = 0;
    private int disposeCacheStrategy_d = 0;
    private int disposeTimeout_d = 0;
    private int distinctConnections_d;
    private TimedMultiValuatedCache.Entry[] elements_d;
    private int empty;
    private int entryCapacity_d;
    private int hitsLockedSlot_d = 0;
    private int hitsUnlockedSlot_d = 0;
    private int lock_d;
    private int locked;
    private Map<LockOwner, EntryInfo> lockInfoByOwner_d;
    private Map<LockOwner, LockOwnerInfo> lockOwnersInfo_d;
    private int minNoDisposable_d;
    private int miss_d = 0;
    private int noDisposableEntries_d;
    private int notLocked;
    private int totalConnections_d;
    private int ttl_d;
    private int unlock_d;
    private int waitQueueSize;

    public DefaultCacheStatistic(int rows, int columns, int ttl, int minNoDisposable, TimedMultiValuatedCache.Entry[] elements) {
        this.capacity_d = rows;
        this.entryCapacity_d = columns;
        this.noDisposableEntries_d = 0;
        this.alreadyLocked_d = 0;
        this.clear_d = 0;
        this.lock_d = 0;
        this.unlock_d = 0;
        this.totalConnections_d = 0;
        this.distinctConnections_d = 0;
        this.ttl_d = ttl;
        this.minNoDisposable_d = minNoDisposable;
        this.locked = 0;
        this.notLocked = 0;
        this.empty = columns;
        this.connectionsLocked = 0;
        this.lockInfoByOwner_d = new ConcurrentHashMap<LockOwner, EntryInfo>();
        this.lockOwnersInfo_d = new ConcurrentHashMap<LockOwner, LockOwnerInfo>();
        this.elements_d = elements;
        this.waitQueueSize = 0;
    }

    @Override
    public void setConnectionPoolMonitorUpdateListener(ConnectionPoolMonitorUpdateListener connectionPoolMonitorUpdateListener) {
        this.connectionPoolMonitorUpdateListener = connectionPoolMonitorUpdateListener;
    }

    @Override
    public int getCapacity() {
        return this.capacity_d;
    }

    @Override
    public int getEmpty() {
        return this.empty;
    }

    @Override
    public int getEntryCapacity() {
        return this.entryCapacity_d;
    }

    @Override
    public int getLocked() {
        return this.locked;
    }

    @Override
    public int getMinNoDisposable() {
        return this.minNoDisposable_d;
    }

    @Override
    public int getNotLocked() {
        return this.notLocked;
    }

    @Override
    public void setSize(int size) {
        this.totalConnections_d = size;
    }

    @Override
    public int getTTL() {
        return this.ttl_d;
    }

    @Override
    public int getTotalLocked() {
        return this.lock_d;
    }

    @Override
    public int getTotalUnLocked() {
        return this.unlock_d;
    }

    @Override
    public void addDistinctConnection() {
        ++this.distinctConnections_d;
    }

    @Override
    public void alreadyLocked() {
        ++this.alreadyLocked_d;
    }

    @Override
    public void clear() {
        ++this.clear_d;
        this.totalConnections_d = 0;
    }

    @Override
    public void create() {
        ++this.create_d;
        ++this.totalConnections_d;
        ++this.notLocked;
        --this.empty;
    }

    @Override
    public void dispose(int type) {
        this.dispose(type, 1);
    }

    @Override
    public void dispose(int type, int size) {
        if (type == 0) {
            this.disposeCacheStrategy_d += size;
        } else if (type == 1) {
            this.disposeTimeout_d += size;
        } else if (type == 2) {
            this.disposeByUser_d += size;
        }
        this.totalConnections_d -= size;
        this.notLocked -= size;
        this.empty += size;
    }

    @Override
    public void hit(int type, LockOwner owner) {
        this.addCacheAccess();
        if (type == 0) {
            ++this.hitsUnlockedSlot_d;
        } else if (type == 1) {
            ++this.hitsLockedSlot_d;
        }
        if (owner != null) {
            LockOwnerInfo info = this.lockOwnersInfo_d.get(owner);
            if (info == null) {
                info = new LockOwnerInfo();
            }
            info.hit();
            this.lockOwnersInfo_d.put(owner, info);
        }
    }

    @Override
    public void incSize() {
        ++this.totalConnections_d;
    }

    @Override
    public void lock(Object o, LockOwner owner) {
        EntryInfo info = this.lockInfoByOwner_d.get(owner);
        if (info == null) {
            info = new EntryInfo();
        }
        info.lock();
        this.lockInfoByOwner_d.put(owner, info);
        ++this.lock_d;
        ++this.locked;
        if (this.connectionPoolMonitorUpdateListener != null) {
            this.connectionPoolMonitorUpdateListener.notifyDBConnections();
        }
    }

    @Override
    public void miss() {
        this.miss(null);
    }

    @Override
    public void miss(LockOwner owner) {
        this.addCacheAccess();
        ++this.miss_d;
        if (owner != null) {
            LockOwnerInfo info = this.lockOwnersInfo_d.get(owner);
            if (info == null) {
                info = new LockOwnerInfo();
            }
            info.miss();
            this.lockOwnersInfo_d.put(owner, info);
        }
    }

    @Override
    public void noDisposableEntries() {
        ++this.noDisposableEntries_d;
    }

    @Override
    public void subDistinctConnection() {
        --this.distinctConnections_d;
    }

    @Override
    public void unlock(Object o, LockOwner owner) {
        EntryInfo info = this.lockInfoByOwner_d.get(owner);
        if (info == null) {
            info = new EntryInfo();
        }
        info.unlock();
        this.lockInfoByOwner_d.put(owner, info);
        ++this.unlock_d;
        --this.locked;
        if (this.connectionPoolMonitorUpdateListener != null) {
            this.connectionPoolMonitorUpdateListener.notifyDBConnections();
        }
    }

    @Override
    public int getMissCount() {
        return this.miss_d;
    }

    @Override
    public void incrementWaitQueueSize() {
        ++this.waitQueueSize;
    }

    @Override
    public void decrementWaitQueueSize() {
        --this.waitQueueSize;
    }

    @Override
    public void newLock() {
        ++this.connectionsLocked;
    }

    @Override
    public void removeLock() {
        --this.connectionsLocked;
    }

    @Override
    public int getConnectionsLocked() {
        return this.connectionsLocked;
    }

    private void addCacheAccess() {
        ++this.cacheAccess_d;
    }

    private static class LockOwnerInfo {
        private int access_d = 0;
        private int hits_d = 0;
        private int miss_d = 0;

        public void hit() {
            this.cacheAccess();
            ++this.hits_d;
        }

        public void miss() {
            this.cacheAccess();
            ++this.miss_d;
        }

        private void cacheAccess() {
            ++this.access_d;
        }
    }

    private static class EntryInfo {
        private int locked_d = 0;
        private int totalLocked_d = 0;

        public void lock() {
            ++this.locked_d;
            ++this.totalLocked_d;
        }

        public void unlock() {
            --this.locked_d;
        }
    }
}

