/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.oparser;

import oracle.bpm.oparser.OptionParser;
import org.jetbrains.annotations.NonNls;

public class Option<T> {
    private final String description;
    private final char letter;
    private final String name;
    private final OptionParser optionParser;
    private final Class<T> type;
    private T value;
    @NonNls
    static final String HELP = "help";

    Option(OptionParser optionParser, Class<T> type, char letter, String name, String description, T defaultValue) {
        this.optionParser = optionParser;
        this.letter = letter;
        this.name = name;
        this.type = type;
        this.description = description;
        this.value = defaultValue;
    }

    public char getLetter() {
        return this.letter;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public final T getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    void execute(boolean negated) {
        if (!negated && this.name.equals(HELP)) {
            this.optionParser.printHelp();
        }
        if (this.isBoolean()) {
            this.value = this.type.cast(!negated);
        }
    }

    void execute(boolean negated, String str) {
        Object newValue;
        if (this.isBoolean()) {
            Boolean b = Boolean.valueOf(str);
            if (negated) {
                b = b == false;
            }
            newValue = b;
        } else {
            newValue = this.isInteger() ? Integer.valueOf(str) : str;
        }
        this.value = this.type.cast(newValue);
    }

    boolean isString() {
        return String.class.equals(this.type);
    }

    boolean isBoolean() {
        return Boolean.class.equals(this.type);
    }

    boolean isInteger() {
        return Integer.class.equals(this.type);
    }
}

